/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import com.aelitis.azureus.core.peermanager.unchoker.Unchoker;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.gudy.azureus2.core3.peer.PEPeer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadingUnchoker
implements Unchoker {
    private ArrayList<PEPeer> chokes = new ArrayList();
    private ArrayList<PEPeer> unchokes = new ArrayList();

    protected DownloadingUnchoker() {
    }

    @Override
    public boolean isSeedingUnchoker() {
        return false;
    }

    @Override
    public ArrayList<PEPeer> getImmediateUnchokes(int max_to_unchoke, ArrayList<PEPeer> all_peers) {
        ArrayList<PEPeer> to_unchoke = new ArrayList<PEPeer>();
        int num_unchoked = 0;
        for (int i = 0; i < all_peers.size(); ++i) {
            PEPeer peer = all_peers.get(i);
            if (peer.isChokedByMe()) continue;
            ++num_unchoked;
        }
        int needed = max_to_unchoke - num_unchoked;
        if (needed > 0) {
            PEPeer peer;
            for (int i = 0; i < needed && (peer = UnchokerUtil.getNextOptimisticPeer(all_peers, true, true)) != null; ++i) {
                to_unchoke.add(peer);
                peer.setOptimisticUnchoke(true);
            }
        }
        return to_unchoke;
    }

    @Override
    public void calculateUnchokes(int max_to_unchoke, ArrayList<PEPeer> all_peers, boolean force_refresh, boolean check_priority_connections) {
        PEPeer peer;
        PEPeer peer2;
        int i;
        PEPeer peer3;
        int i2;
        int max_optimistic = (max_to_unchoke - 1) / 10 + 1;
        ArrayList<PEPeer> optimistic_unchokes = new ArrayList<PEPeer>();
        ArrayList<PEPeer> best_peers = new ArrayList<PEPeer>();
        long[] bests = new long[max_to_unchoke];
        for (i2 = 0; i2 < all_peers.size(); ++i2) {
            peer3 = all_peers.get(i2);
            if (peer3.isChokedByMe()) continue;
            if (UnchokerUtil.isUnchokable(peer3, true)) {
                this.unchokes.add(peer3);
                if (!peer3.isOptimisticUnchoke()) continue;
                optimistic_unchokes.add(peer3);
                continue;
            }
            this.chokes.add(peer3);
        }
        if (!force_refresh) {
            for (i2 = 0; i2 < optimistic_unchokes.size(); ++i2) {
                peer3 = (PEPeer)optimistic_unchokes.get(i2);
                if (i2 < max_optimistic) {
                    best_peers.add(peer3);
                    continue;
                }
                peer3.setOptimisticUnchoke(false);
            }
        }
        int start_pos = best_peers.size();
        for (i = 0; i < all_peers.size(); ++i) {
            long rate;
            peer2 = all_peers.get(i);
            if (!peer2.isInteresting() || !UnchokerUtil.isUnchokable(peer2, false) || best_peers.contains(peer2) || (rate = peer2.getStats().getSmoothDataReceiveRate()) <= 256L) continue;
            UnchokerUtil.updateLargestValueFirstSort(rate, bests, peer2, best_peers, start_pos);
        }
        if (best_peers.size() < max_to_unchoke) {
            start_pos = best_peers.size();
            for (i = 0; i < all_peers.size(); ++i) {
                long uploaded_ratio;
                peer2 = all_peers.get(i);
                if (!peer2.isInteresting() || !UnchokerUtil.isUnchokable(peer2, false) || best_peers.contains(peer2) || (uploaded_ratio = peer2.getStats().getTotalDataBytesSent() / (peer2.getStats().getTotalDataBytesReceived() + 16383L)) >= 3L) continue;
                UnchokerUtil.updateLargestValueFirstSort(peer2.getStats().getTotalDataBytesReceived(), bests, peer2, best_peers, start_pos);
            }
        }
        if (force_refresh) {
            while (best_peers.size() > max_to_unchoke - max_optimistic) {
                best_peers.remove(best_peers.size() - 1);
            }
        }
        while (best_peers.size() < max_to_unchoke && (peer = UnchokerUtil.getNextOptimisticPeer(all_peers, true, true)) != null) {
            if (!best_peers.contains(peer)) {
                best_peers.add(peer);
                peer.setOptimisticUnchoke(true);
                continue;
            }
            peer.sendUnChoke();
        }
        Iterator<PEPeer> it = this.unchokes.iterator();
        while (it.hasNext()) {
            peer2 = it.next();
            if (best_peers.contains(peer2)) continue;
            if (best_peers.size() < max_to_unchoke) {
                best_peers.add(peer2);
                continue;
            }
            this.chokes.add(peer2);
            it.remove();
        }
        for (int i3 = 0; i3 < best_peers.size(); ++i3) {
            peer2 = (PEPeer)best_peers.get(i3);
            if (this.unchokes.contains(peer2)) continue;
            this.unchokes.add(peer2);
        }
    }

    @Override
    public ArrayList<PEPeer> getChokes() {
        ArrayList<PEPeer> to_choke = this.chokes;
        this.chokes = new ArrayList();
        return to_choke;
    }

    @Override
    public ArrayList<PEPeer> getUnchokes() {
        ArrayList<PEPeer> to_unchoke = this.unchokes;
        this.unchokes = new ArrayList();
        return to_unchoke;
    }
}

