/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep;

import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTLTMessage;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageFactory;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTHandshake;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTMessage;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;

public class LTMessageEncoder
implements MessageStreamEncoder {
    protected static final LogIDs LOGID = LogIDs.PEER;
    private Object log_object;
    private HashMap extension_map;

    public LTMessageEncoder(Object log_object) {
        this.log_object = log_object;
        this.extension_map = null;
    }

    public RawMessage[] encodeMessage(Message message) {
        Byte ext_id;
        if (!(message instanceof LTMessage)) {
            return new RawMessage[]{BTMessageFactory.createBTRawMessage(message)};
        }
        if (message instanceof LTHandshake) {
            return new RawMessage[]{BTMessageFactory.createBTRawMessage(new BTLTMessage(message, 0))};
        }
        if (this.extension_map != null && (ext_id = (Byte)this.extension_map.get(message.getID())) != null) {
            return new RawMessage[]{BTMessageFactory.createBTRawMessage(new BTLTMessage(message, ext_id))};
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.log_object, LOGID, "Unable to send LT message of type " + message.getID() + ", not supported by peer - dropping message."));
        }
        return new RawMessage[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateSupportedExtensions(Map map) {
        try {
            for (Map.Entry extension : map.entrySet()) {
                int ext_value;
                String ext_name;
                Object ext_key = extension.getKey();
                if (ext_key instanceof byte[]) {
                    ext_name = new String((byte[])ext_key, "UTF8");
                } else {
                    if (!(ext_key instanceof String)) throw new RuntimeException("unexpected type for extension name: " + ext_key.getClass());
                    ext_name = (String)ext_key;
                }
                Object ext_value_obj = extension.getValue();
                if (ext_value_obj instanceof Long) {
                    ext_value = ((Long)extension.getValue()).intValue();
                } else {
                    if (!(ext_value_obj instanceof byte[])) throw new RuntimeException("unsupported extension id type: " + ext_value_obj.getClass().getName());
                    byte[] ext_value_bytes = (byte[])ext_value_obj;
                    if (ext_value_bytes.length != 1) throw new RuntimeException("extension id byte array format length != 1: " + ext_value_bytes.length);
                    ext_value = ext_value_bytes[0];
                }
                if (this.extension_map == null) {
                    this.extension_map = new HashMap();
                }
                if (ext_value == 0) {
                    this.extension_map.remove(ext_name);
                    continue;
                }
                this.extension_map.put(ext_name, new Byte((byte)ext_value));
            }
            return;
        }
        catch (Exception e) {
            if (!Logger.isEnabled()) return;
            Logger.log(new LogEvent(this.log_object, LOGID, "Unable to update LT extension list for peer", (Throwable)e));
        }
    }

    public boolean supportsUTPEX() {
        if (this.extension_map == null) {
            return false;
        }
        return this.extension_map.containsKey("ut_pex");
    }
}

