/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class AZBadPiece
implements AZMessage {
    private final byte version;
    private DirectByteBuffer buffer = null;
    private int piece_number;

    public AZBadPiece(int _piece_number, byte _version) {
        this.piece_number = _piece_number;
        this.version = _version;
    }

    public String getID() {
        return "AZ_BAD_PIECE";
    }

    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_BAD_PIECE_BYTES;
    }

    public String getFeatureID() {
        return "AZ1";
    }

    public int getFeatureSubID() {
        return 5;
    }

    public int getType() {
        return 0;
    }

    public byte getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.getID() + " " + this.piece_number;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("piece", new Long(this.piece_number));
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(map, (byte)12);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        Map payload = MessagingUtil.convertBencodedByteStreamToPayload(data, 1, this.getID());
        int piece_number = ((Long)payload.get("piece")).intValue();
        AZBadPiece message = new AZBadPiece(piece_number, version);
        return message;
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

