/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;

public class WriteController
implements AzureusCoreStatsProvider {
    private static int IDLE_SLEEP_TIME = 50;
    private static boolean AGGRESIVE_WRITE = false;
    private static int BOOSTER_GIFT = 5120;
    private volatile ArrayList<RateControlledEntity> normal_priority_entities = new ArrayList();
    private volatile ArrayList<RateControlledEntity> boosted_priority_entities = new ArrayList();
    private volatile ArrayList<RateControlledEntity> high_priority_entities = new ArrayList();
    private final AEMonitor entities_mon = new AEMonitor("WriteController:EM");
    private int next_normal_position = 0;
    private int next_boost_position = 0;
    private int next_high_position = 0;
    private long booster_process_time;
    private int booster_normal_written;
    private int booster_stat_index;
    private int[] booster_normal_writes = new int[5];
    private int[] booster_gifts = new int[5];
    private int aggressive_np_normal_priority_count;
    private int aggressive_np_high_priority_count;
    private long process_loop_time;
    private long wait_count;
    private long progress_count;
    private long non_progress_count;
    private EventWaiter write_waiter = new EventWaiter();
    private NetworkManager net_man;
    private int entity_count = 0;

    public WriteController() {
        AEThread write_processor_thread = new AEThread("WriteController:WriteProcessor"){

            public void runSupport() {
                WriteController.this.writeProcessorLoop();
            }
        };
        write_processor_thread.setDaemon(true);
        write_processor_thread.setPriority(9);
        write_processor_thread.start();
        HashSet<String> types = new HashSet<String>();
        types.add("net.write.control.wait.count");
        types.add("net.write.control.np.count");
        types.add("net.write.control.p.count");
        types.add("net.write.control.entity.count");
        types.add("net.write.control.con.count");
        types.add("net.write.control.ready.con.count");
        types.add("net.write.control.ready.byte.count");
        AzureusCoreStats.registerProvider(types, this);
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void generate(IndentWriter writer) {
                writer.println("Write Controller");
                try {
                    RateControlledEntity entity;
                    int i;
                    writer.indent();
                    ArrayList ref = WriteController.this.normal_priority_entities;
                    writer.println("normal - " + ref.size());
                    for (i = 0; i < ref.size(); ++i) {
                        entity = (RateControlledEntity)ref.get(i);
                        writer.println(entity.getString());
                    }
                    ref = WriteController.this.boosted_priority_entities;
                    writer.println("boosted - " + ref.size());
                    for (i = 0; i < ref.size(); ++i) {
                        entity = (RateControlledEntity)ref.get(i);
                        writer.println(entity.getString());
                    }
                    ref = WriteController.this.high_priority_entities;
                    writer.println("priority - " + ref.size());
                    for (i = 0; i < ref.size(); ++i) {
                        entity = (RateControlledEntity)ref.get(i);
                        writer.println(entity.getString());
                    }
                    Object var6_5 = null;
                    writer.exdent();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    writer.exdent();
                    throw throwable;
                }
            }
        });
    }

    public void updateStats(Set types, Map values) {
        if (types.contains("net.write.control.wait.count")) {
            values.put("net.write.control.wait.count", new Long(this.wait_count));
        }
        if (types.contains("net.write.control.np.count")) {
            values.put("net.write.control.np.count", new Long(this.non_progress_count));
        }
        if (types.contains("net.write.control.p.count")) {
            values.put("net.write.control.p.count", new Long(this.progress_count));
        }
        if (types.contains("net.write.control.entity.count")) {
            values.put("net.write.control.entity.count", new Long(this.high_priority_entities.size() + this.boosted_priority_entities.size() + this.normal_priority_entities.size()));
        }
        if (types.contains("net.write.control.con.count") || types.contains("net.write.control.ready.con.count") || types.contains("net.write.control.ready.byte.count")) {
            long ready_bytes = 0L;
            int ready_connections = 0;
            int connections = 0;
            ArrayList[] refs = new ArrayList[]{this.normal_priority_entities, this.boosted_priority_entities, this.high_priority_entities};
            for (int i = 0; i < refs.length; ++i) {
                ArrayList ref = refs[i];
                for (int j = 0; j < ref.size(); ++j) {
                    RateControlledEntity entity = (RateControlledEntity)ref.get(j);
                    connections += entity.getConnectionCount();
                    ready_connections += entity.getReadyConnectionCount(this.write_waiter);
                    ready_bytes += entity.getBytesReadyToWrite();
                }
            }
            values.put("net.write.control.con.count", new Long(connections));
            values.put("net.write.control.ready.con.count", new Long(ready_connections));
            values.put("net.write.control.ready.byte.count", new Long(ready_bytes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProcessorLoop() {
        boolean check_high_first = true;
        long last_check = SystemTime.getMonotonousTime();
        this.net_man = NetworkManager.getSingleton();
        while (true) {
            Object var11_10;
            this.process_loop_time = SystemTime.getMonotonousTime();
            try {
                if (check_high_first) {
                    check_high_first = false;
                    if (!this.doHighPriorityWrite() && !this.doNormalPriorityWrite() && this.write_waiter.waitForEvent(IDLE_SLEEP_TIME)) {
                        ++this.wait_count;
                    }
                } else {
                    check_high_first = true;
                    if (!this.doNormalPriorityWrite() && !this.doHighPriorityWrite() && this.write_waiter.waitForEvent(IDLE_SLEEP_TIME)) {
                        ++this.wait_count;
                    }
                }
            }
            catch (Throwable t) {
                Debug.out("writeProcessorLoop() EXCEPTION: ", t);
            }
            if (this.process_loop_time - last_check <= 5000L) continue;
            last_check = this.process_loop_time;
            boolean changed = false;
            ArrayList<RateControlledEntity> ref = this.normal_priority_entities;
            for (RateControlledEntity e : ref) {
                if (!e.getPriorityBoost()) continue;
                changed = true;
                break;
            }
            if (!changed) {
                ref = this.boosted_priority_entities;
                for (RateControlledEntity e : ref) {
                    if (e.getPriorityBoost()) continue;
                    changed = true;
                    break;
                }
            }
            if (!changed) continue;
            try {
                this.entities_mon.enter();
                ArrayList<RateControlledEntity> new_normal = new ArrayList<RateControlledEntity>();
                ArrayList<RateControlledEntity> new_boosted = new ArrayList<RateControlledEntity>();
                for (RateControlledEntity e : this.normal_priority_entities) {
                    if (e.getPriorityBoost()) {
                        new_boosted.add(e);
                        continue;
                    }
                    new_normal.add(e);
                }
                for (RateControlledEntity e : this.boosted_priority_entities) {
                    if (e.getPriorityBoost()) {
                        new_boosted.add(e);
                        continue;
                    }
                    new_normal.add(e);
                }
                this.normal_priority_entities = new_normal;
                this.boosted_priority_entities = new_boosted;
                var11_10 = null;
                this.entities_mon.exit();
            }
            catch (Throwable throwable) {
                var11_10 = null;
                this.entities_mon.exit();
                throw throwable;
            }
        }
    }

    private boolean doNormalPriorityWrite() {
        int result = this.processNextReadyNormalPriorityEntity();
        if (result > 0) {
            ++this.progress_count;
            return true;
        }
        if (result == 0) {
            ++this.non_progress_count;
            if (AGGRESIVE_WRITE) {
                ++this.aggressive_np_normal_priority_count;
                if (this.aggressive_np_normal_priority_count < this.normal_priority_entities.size() + this.boosted_priority_entities.size()) {
                    return true;
                }
                this.aggressive_np_normal_priority_count = 0;
            }
        }
        return false;
    }

    private boolean doHighPriorityWrite() {
        RateControlledEntity ready_entity = this.getNextReadyHighPriorityEntity();
        if (ready_entity != null) {
            if (ready_entity.doProcessing(this.write_waiter, 0) > 0) {
                ++this.progress_count;
                return true;
            }
            ++this.non_progress_count;
            if (AGGRESIVE_WRITE) {
                ++this.aggressive_np_high_priority_count;
                if (this.aggressive_np_high_priority_count < this.high_priority_entities.size()) {
                    return true;
                }
                this.aggressive_np_high_priority_count = 0;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int processNextReadyNormalPriorityEntity() {
        int n;
        int boosted_size;
        block18: {
            int n2;
            block17: {
                ArrayList<RateControlledEntity> boosted_ref = this.boosted_priority_entities;
                boosted_size = boosted_ref.size();
                try {
                    if (boosted_size > 0) {
                        if (this.process_loop_time - this.booster_process_time >= 1000L) {
                            this.booster_process_time = this.process_loop_time;
                            this.booster_gifts[this.booster_stat_index] = BOOSTER_GIFT;
                            this.booster_normal_writes[this.booster_stat_index] = this.booster_normal_written;
                            ++this.booster_stat_index;
                            if (this.booster_stat_index >= this.booster_gifts.length) {
                                this.booster_stat_index = 0;
                            }
                            this.booster_normal_written = 0;
                        }
                        int total_gifts = 0;
                        int total_normal_writes = 0;
                        for (int i = 0; i < this.booster_gifts.length; total_gifts += this.booster_gifts[i], total_normal_writes += this.booster_normal_writes[i], ++i) {
                        }
                        int effective_gift = total_gifts - total_normal_writes;
                        if (effective_gift > 0) {
                            ArrayList<RateControlledEntity> normal_ref = this.normal_priority_entities;
                            int normal_size = normal_ref.size();
                            int position = this.next_normal_position;
                            ArrayList<RateControlledEntity> ready = new ArrayList<RateControlledEntity>();
                            for (int num_checked = 0; num_checked < normal_size; ++position, ++num_checked) {
                                position = position >= normal_size ? 0 : position;
                                RateControlledEntity entity = normal_ref.get(position);
                                if (!entity.canProcess(this.write_waiter)) continue;
                                this.next_normal_position = position;
                                ready.add(entity);
                            }
                            int num_ready = ready.size();
                            if (num_ready > 0) {
                                int gift_used = 0;
                                for (RateControlledEntity r : ready) {
                                    int done;
                                    int permitted = effective_gift / num_ready;
                                    if (permitted <= 0) {
                                        permitted = 1;
                                    }
                                    if (r.canProcess(this.write_waiter) && (done = r.doProcessing(this.write_waiter, permitted)) > 0) {
                                        this.booster_normal_written += done;
                                        gift_used += done;
                                    }
                                    --num_ready;
                                }
                                for (int i = this.booster_stat_index; gift_used > 0 && i < this.booster_stat_index + this.booster_gifts.length; ++i) {
                                    int avail = this.booster_gifts[i % this.booster_gifts.length];
                                    if (avail <= 0) continue;
                                    int temp = Math.min(avail, gift_used);
                                    gift_used -= temp;
                                    this.booster_gifts[i % this.booster_gifts.length] = avail -= temp;
                                }
                            }
                        }
                        for (int num_checked = 0; num_checked < boosted_size; ++this.next_boost_position, ++num_checked) {
                            this.next_boost_position = this.next_boost_position >= boosted_size ? 0 : this.next_boost_position;
                            RateControlledEntity entity = boosted_ref.get(this.next_boost_position);
                            if (!entity.canProcess(this.write_waiter)) continue;
                            n2 = entity.doProcessing(this.write_waiter, 0);
                            Object var18_25 = null;
                            if (boosted_size <= 0) return n2;
                            this.net_man.getUploadProcessor().setRateLimiterFreezeState(false);
                            return n2;
                        }
                        this.net_man.getUploadProcessor().setRateLimiterFreezeState(true);
                    } else {
                        this.booster_normal_written = 0;
                    }
                    ArrayList<RateControlledEntity> normal_ref = this.normal_priority_entities;
                    int normal_size = normal_ref.size();
                    for (int num_checked = 0; num_checked < normal_size; ++this.next_normal_position, ++num_checked) {
                        this.next_normal_position = this.next_normal_position >= normal_size ? 0 : this.next_normal_position;
                        RateControlledEntity entity = normal_ref.get(this.next_normal_position);
                        if (!entity.canProcess(this.write_waiter)) continue;
                        int bytes = entity.doProcessing(this.write_waiter, 0);
                        if (bytes > 0) {
                            this.booster_normal_written += bytes;
                        }
                        n2 = bytes;
                        break block17;
                    }
                    n = -1;
                    break block18;
                }
                catch (Throwable throwable) {
                    Object var18_28 = null;
                    if (boosted_size <= 0) throw throwable;
                    this.net_man.getUploadProcessor().setRateLimiterFreezeState(false);
                    throw throwable;
                }
            }
            Object var18_26 = null;
            if (boosted_size <= 0) return n2;
            this.net_man.getUploadProcessor().setRateLimiterFreezeState(false);
            return n2;
        }
        Object var18_27 = null;
        if (boosted_size <= 0) return n;
        this.net_man.getUploadProcessor().setRateLimiterFreezeState(false);
        return n;
    }

    private RateControlledEntity getNextReadyHighPriorityEntity() {
        ArrayList<RateControlledEntity> ref = this.high_priority_entities;
        int size = ref.size();
        for (int num_checked = 0; num_checked < size; ++num_checked) {
            this.next_high_position = this.next_high_position >= size ? 0 : this.next_high_position;
            RateControlledEntity entity = ref.get(this.next_high_position);
            ++this.next_high_position;
            if (!entity.canProcess(this.write_waiter)) continue;
            return entity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriteEntity(RateControlledEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList<RateControlledEntity> high_new = new ArrayList<RateControlledEntity>(this.high_priority_entities.size() + 1);
                high_new.addAll(this.high_priority_entities);
                high_new.add(entity);
                this.high_priority_entities = high_new;
            } else if (entity.getPriorityBoost()) {
                ArrayList<RateControlledEntity> boost_new = new ArrayList<RateControlledEntity>(this.boosted_priority_entities.size() + 1);
                boost_new.addAll(this.boosted_priority_entities);
                boost_new.add(entity);
                this.boosted_priority_entities = boost_new;
            } else {
                ArrayList<RateControlledEntity> norm_new = new ArrayList<RateControlledEntity>(this.normal_priority_entities.size() + 1);
                norm_new.addAll(this.normal_priority_entities);
                norm_new.add(entity);
                this.normal_priority_entities = norm_new;
            }
            this.entity_count = this.normal_priority_entities.size() + this.boosted_priority_entities.size() + this.high_priority_entities.size();
            Object var4_5 = null;
            this.entities_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.entities_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriteEntity(RateControlledEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList<RateControlledEntity> high_new = new ArrayList<RateControlledEntity>(this.high_priority_entities);
                high_new.remove(entity);
                this.high_priority_entities = high_new;
            } else if (this.boosted_priority_entities.contains(entity)) {
                ArrayList<RateControlledEntity> boosted_new = new ArrayList<RateControlledEntity>(this.boosted_priority_entities);
                boosted_new.remove(entity);
                this.boosted_priority_entities = boosted_new;
            } else {
                ArrayList<RateControlledEntity> norm_new = new ArrayList<RateControlledEntity>(this.normal_priority_entities);
                norm_new.remove(entity);
                this.normal_priority_entities = norm_new;
            }
            this.entity_count = this.normal_priority_entities.size() + this.boosted_priority_entities.size() + this.high_priority_entities.size();
            Object var4_5 = null;
            this.entities_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.entities_mon.exit();
            throw throwable;
        }
    }

    public int getEntityCount() {
        return this.entity_count;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.control.write.idle.time", "network.control.write.aggressive", "Bias Upload Slack KBs"}, new ParameterListener(){

            public void parameterChanged(String name) {
                IDLE_SLEEP_TIME = COConfigurationManager.getIntParameter("network.control.write.idle.time");
                AGGRESIVE_WRITE = COConfigurationManager.getBooleanParameter("network.control.write.aggressive");
                BOOSTER_GIFT = COConfigurationManager.getIntParameter("Bias Upload Slack KBs") * 1024;
            }
        });
    }
}

