/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminASNImpl;
import com.aelitis.azureus.core.util.DNSUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class NetworkAdminASNLookupImpl {
    private static final String WHOIS_ADDRESS = "whois.cymru.com";
    private static final int WHOIS_PORT = 43;
    private static final int TIMEOUT = 30000;
    private InetAddress address;

    protected NetworkAdminASNLookupImpl(InetAddress _address) {
        this.address = _address;
    }

    protected NetworkAdminASNImpl lookup() throws NetworkAdminException {
        return this.lookupDNS(this.address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NetworkAdminASNImpl lookupTCP(InetAddress address) throws NetworkAdminException {
        try {
            NetworkAdminASNImpl networkAdminASNImpl;
            Socket socket = new Socket();
            int timeout = 30000;
            long start = SystemTime.getCurrentTime();
            socket.connect(new InetSocketAddress(WHOIS_ADDRESS, 43), timeout);
            long end = SystemTime.getCurrentTime();
            timeout = (int)((long)timeout - (end - start));
            if (timeout <= 0) {
                throw new NetworkAdminException("Timeout on connect");
            }
            if (timeout > 30000) {
                timeout = 30000;
            }
            socket.setSoTimeout(timeout);
            try {
                OutputStream os = socket.getOutputStream();
                String command = "-u -p " + address.getHostAddress() + "\r\n";
                os.write(command.getBytes());
                os.flush();
                InputStream is = socket.getInputStream();
                byte[] buffer = new byte[1024];
                String result = "";
                while (true) {
                    int len;
                    if ((len = is.read(buffer)) <= 0) {
                        networkAdminASNImpl = this.processResult(result);
                        Object var15_14 = null;
                        break;
                    }
                    result = result + new String(buffer, 0, len);
                }
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                socket.close();
                throw throwable;
            }
            socket.close();
            return networkAdminASNImpl;
        }
        catch (Throwable e) {
            throw new NetworkAdminException("whois connection failed", e);
        }
    }

    protected NetworkAdminASNImpl lookupDNS(InetAddress address) throws NetworkAdminException {
        byte[] bytes = address.getAddress();
        String ip_query = "origin.asn.cymru.com";
        for (int i = 0; i < 4; ++i) {
            ip_query = (bytes[i] & 0xFF) + "." + ip_query;
        }
        String ip_result = this.lookupDNS(ip_query);
        NetworkAdminASNImpl result = this.processResult("AS | BGP Prefix | CC | Reg | Date | AS Name\n" + ip_result + " | n/a");
        String as = result.getAS();
        if (as.length() > 0) {
            String asn_query = "AS" + as + ".asn.cymru.com";
            try {
                int pos;
                String asn_result = this.lookupDNS(asn_query);
                if (asn_result != null && (pos = asn_result.lastIndexOf(124)) != -1) {
                    String asn = asn_result.substring(pos + 1).trim();
                    result.setASName(asn);
                }
            }
            catch (Throwable e) {
                Debug.outNoStack("ASN lookup for '" + asn_query + "' failed: " + e.getMessage());
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String lookupDNS(String query) throws NetworkAdminException {
        DirContext context2 = null;
        try {
            try {
                String attribute;
                context2 = DNSUtils.getInitialDirContext();
                Attributes attrs = context2.getAttributes(query, new String[]{"TXT"});
                NamingEnumeration<? extends Attribute> n_enum = attrs.getAll();
                block7: while (true) {
                    if (!n_enum.hasMoreElements()) throw new NetworkAdminException("DNS query returned no results");
                    Attribute attr = n_enum.next();
                    NamingEnumeration<?> n_enum2 = attr.getAll();
                    while (true) {
                        if (!n_enum2.hasMoreElements()) continue block7;
                        attribute = (String)n_enum2.nextElement();
                        if (attribute == null) continue;
                        if ((attribute = attribute.trim()).startsWith("\"")) {
                            attribute = attribute.substring(1);
                        }
                        if (attribute.endsWith("\"")) {
                            attribute = attribute.substring(0, attribute.length() - 1);
                        }
                        if (attribute.length() > 0) break block7;
                    }
                    break;
                }
                String string = attribute;
                Object var10_10 = null;
                if (context2 == null) return string;
                try {
                    context2.close();
                    return string;
                }
                catch (Throwable e) {
                    // empty catch block
                }
                return string;
            }
            catch (Throwable e) {
                throw new NetworkAdminException("DNS query failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (context2 == null) throw throwable;
            try {}
            catch (Throwable e) {
                throw throwable;
            }
            context2.close();
            throw throwable;
        }
    }

    protected NetworkAdminASNImpl processResult(String result) {
        StringTokenizer lines = new StringTokenizer(result, "\n");
        int line_number = 0;
        ArrayList<String> keywords = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        block0: while (lines.hasMoreTokens()) {
            String line = lines.nextToken().trim();
            if (++line_number > 2) break;
            StringTokenizer tok = new StringTokenizer(line, "|");
            int token_number = 0;
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken().trim();
                if (line_number == 1) {
                    keywords.add(token.toLowerCase(MessageText.LOCALE_ENGLISH));
                } else {
                    if (token_number >= keywords.size()) continue block0;
                    String kw = (String)keywords.get(token_number);
                    map.put(kw, token);
                }
                ++token_number;
            }
        }
        String as = (String)map.get("as");
        String asn = (String)map.get("as name");
        String bgp_prefix = (String)map.get("bgp prefix");
        if (bgp_prefix != null) {
            int pos = bgp_prefix.indexOf(32);
            if (pos != -1) {
                bgp_prefix = bgp_prefix.substring(pos + 1).trim();
            }
            if (bgp_prefix.indexOf(47) == -1) {
                bgp_prefix = null;
            }
        }
        return new NetworkAdminASNImpl(as, asn, bgp_prefix);
    }

    public static void main(String[] args) {
        try {
            NetworkAdminASNLookupImpl lookup = new NetworkAdminASNLookupImpl(InetAddress.getByName("64.71.8.82"));
            System.out.println(lookup.lookup().getString());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

