/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import java.net.InetAddress;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.util.Debug;

public class NetworkAdminASNImpl
implements NetworkAdminASN {
    private String as;
    private String asn;
    private String bgp_prefix;

    protected NetworkAdminASNImpl(String _as, String _asn, String _bgp) {
        this.as = _as;
        this.asn = _asn;
        this.bgp_prefix = _bgp;
    }

    public String getAS() {
        return this.as == null ? "" : this.as;
    }

    public String getASName() {
        return this.asn == null ? "" : this.asn;
    }

    protected void setASName(String s) {
        this.asn = s;
    }

    public String getBGPPrefix() {
        return this.bgp_prefix == null ? "" : this.bgp_prefix;
    }

    public InetAddress getBGPStartAddress() {
        if (this.bgp_prefix == null) {
            return null;
        }
        try {
            return this.getCIDRStartAddress();
        }
        catch (NetworkAdminException e) {
            Debug.out(e);
            return null;
        }
    }

    protected InetAddress getCIDRStartAddress() throws NetworkAdminException {
        int pos = this.bgp_prefix.indexOf(47);
        try {
            return InetAddress.getByName(this.bgp_prefix.substring(0, pos));
        }
        catch (Throwable e) {
            throw new NetworkAdminException("Parse failure for '" + this.bgp_prefix + "'", e);
        }
    }

    protected InetAddress getCIDREndAddress() throws NetworkAdminException {
        int pos = this.bgp_prefix.indexOf(47);
        try {
            InetAddress start = InetAddress.getByName(this.bgp_prefix.substring(0, pos));
            int cidr_mask = Integer.parseInt(this.bgp_prefix.substring(pos + 1));
            int rev_mask = 0;
            for (int i = 0; i < 32 - cidr_mask; ++i) {
                rev_mask = rev_mask << 1 | 1;
            }
            byte[] bytes = start.getAddress();
            bytes[0] = (byte)(bytes[0] | rev_mask >> 24 & 0xFF);
            bytes[1] = (byte)(bytes[1] | rev_mask >> 16 & 0xFF);
            bytes[2] = (byte)(bytes[2] | rev_mask >> 8 & 0xFF);
            bytes[3] = (byte)(bytes[3] | rev_mask & 0xFF);
            return InetAddress.getByAddress(bytes);
        }
        catch (Throwable e) {
            throw new NetworkAdminException("Parse failure for '" + this.bgp_prefix + "'", e);
        }
    }

    public boolean matchesCIDR(InetAddress address) {
        if (this.bgp_prefix == null || this.bgp_prefix.length() == 0) {
            return false;
        }
        try {
            InetAddress start = this.getCIDRStartAddress();
            InetAddress end = this.getCIDREndAddress();
            long l_start = PRHelpers.addressToLong(start);
            long l_end = PRHelpers.addressToLong(end);
            long test = PRHelpers.addressToLong(address);
            return test >= l_start && test <= l_end;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    public InetAddress getBGPEndAddress() {
        if (this.bgp_prefix == null) {
            return null;
        }
        try {
            return this.getCIDREndAddress();
        }
        catch (NetworkAdminException e) {
            Debug.out(e);
            return null;
        }
    }

    public boolean sameAs(NetworkAdminASN other) {
        return this.getAS().equals(other.getAS());
    }

    public String getString() {
        return "as=" + this.getAS() + ",asn=" + this.getASName() + ", bgp_prefx=" + this.getBGPPrefix() + "[" + this.getBGPStartAddress() + "-" + this.getBGPEndAddress() + "]";
    }
}

