/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.NetworkManager;

public abstract class NetworkConnectionHelper
implements NetworkConnectionBase {
    private int upload_limit;
    private final LimitedRateGroup upload_limiter = new LimitedRateGroup(){

        public String getName() {
            return "per_con_up: " + NetworkConnectionHelper.this.getString();
        }

        public int getRateLimitBytesPerSecond() {
            return NetworkConnectionHelper.this.upload_limit;
        }
    };
    private int download_limit;
    private final LimitedRateGroup download_limiter = new LimitedRateGroup(){

        public String getName() {
            return "per_con_down: " + NetworkConnectionHelper.this.getString();
        }

        public int getRateLimitBytesPerSecond() {
            return NetworkConnectionHelper.this.download_limit;
        }
    };
    private LimitedRateGroup[] upload_limiters = new LimitedRateGroup[]{this.upload_limiter};
    private LimitedRateGroup[] download_limiters = new LimitedRateGroup[]{this.download_limiter};

    public int getUploadLimit() {
        return this.upload_limit;
    }

    public int getDownloadLimit() {
        return this.download_limit;
    }

    public void setUploadLimit(int limit) {
        this.upload_limit = limit;
    }

    public void setDownloadLimit(int limit) {
        this.download_limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRateLimiter(LimitedRateGroup limiter, boolean upload) {
        NetworkConnectionHelper networkConnectionHelper = this;
        synchronized (networkConnectionHelper) {
            if (upload) {
                for (int i = 0; i < this.upload_limiters.length; ++i) {
                    if (this.upload_limiters[i] != limiter) continue;
                    return;
                }
                LimitedRateGroup[] new_upload_limiters = new LimitedRateGroup[this.upload_limiters.length + 1];
                System.arraycopy(this.upload_limiters, 0, new_upload_limiters, 0, this.upload_limiters.length);
                new_upload_limiters[this.upload_limiters.length] = limiter;
                this.upload_limiters = new_upload_limiters;
            } else {
                for (int i = 0; i < this.download_limiters.length; ++i) {
                    if (this.download_limiters[i] != limiter) continue;
                    return;
                }
                LimitedRateGroup[] new_download_limiters = new LimitedRateGroup[this.download_limiters.length + 1];
                System.arraycopy(this.download_limiters, 0, new_download_limiters, 0, this.download_limiters.length);
                new_download_limiters[this.download_limiters.length] = limiter;
                this.download_limiters = new_download_limiters;
            }
        }
        NetworkManager.getSingleton().addRateLimiter(this, limiter, upload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRateLimiter(LimitedRateGroup limiter, boolean upload) {
        NetworkConnectionHelper networkConnectionHelper = this;
        synchronized (networkConnectionHelper) {
            if (upload) {
                if (this.upload_limiters.length == 0) {
                    return;
                }
                int pos = 0;
                LimitedRateGroup[] new_upload_limiters = new LimitedRateGroup[this.upload_limiters.length - 1];
                for (int i = 0; i < this.upload_limiters.length; ++i) {
                    if (this.upload_limiters[i] == limiter) continue;
                    if (pos == new_upload_limiters.length) {
                        return;
                    }
                    new_upload_limiters[pos++] = this.upload_limiters[i];
                }
                this.upload_limiters = new_upload_limiters;
            } else {
                if (this.download_limiters.length == 0) {
                    return;
                }
                int pos = 0;
                LimitedRateGroup[] new_download_limiters = new LimitedRateGroup[this.download_limiters.length - 1];
                for (int i = 0; i < this.download_limiters.length; ++i) {
                    if (this.download_limiters[i] == limiter) continue;
                    if (pos == new_download_limiters.length) {
                        return;
                    }
                    new_download_limiters[pos++] = this.download_limiters[i];
                }
                this.download_limiters = new_download_limiters;
            }
        }
        NetworkManager.getSingleton().removeRateLimiter(this, limiter, upload);
    }

    public LimitedRateGroup[] getRateLimiters(boolean upload) {
        if (upload) {
            return this.upload_limiters;
        }
        return this.download_limiters;
    }
}

