/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger;

import com.aelitis.azureus.util.JSONUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class PlatformMessage {
    private final String messageID;
    private final String listenerID;
    private final String operationID;
    private final Map parameters;
    private final long fireBeforeDate;
    private final long messageCreatedOn;
    private long lSequenceNo = -1L;
    private boolean requiresAuthorization = false;
    private boolean loginAndRetry = false;
    private boolean sendAZID = true;
    private long contentNetworkID;

    public PlatformMessage(String messageID, String listenerID, String operationID, Map parameters, long maxDelayMS) {
        this.messageID = messageID;
        this.listenerID = listenerID;
        this.operationID = operationID;
        this.parameters = JSONUtils.encodeToJSONObject(parameters);
        this.contentNetworkID = 1L;
        this.messageCreatedOn = SystemTime.getCurrentTime();
        this.fireBeforeDate = this.messageCreatedOn + maxDelayMS;
    }

    public PlatformMessage(String messageID, String listenerID, String operationID, Object[] parameters, long maxDelayMS) {
        this.messageID = messageID;
        this.listenerID = listenerID;
        this.operationID = operationID;
        this.parameters = JSONUtils.encodeToJSONObject(PlatformMessage.parseParams(parameters));
        this.contentNetworkID = 1L;
        this.messageCreatedOn = SystemTime.getCurrentTime();
        this.fireBeforeDate = this.messageCreatedOn + maxDelayMS;
    }

    public static Map parseParams(Object[] parameters) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < parameters.length - 1; i += 2) {
            try {
                if (!(parameters[i] instanceof String)) continue;
                if (parameters[i + 1] instanceof String[]) {
                    List<String> list = Arrays.asList((String[])parameters[i + 1]);
                    result.put((String)parameters[i], list);
                    continue;
                }
                if (parameters[i + 1] instanceof Object[]) {
                    result.put((String)parameters[i], PlatformMessage.parseParams((Object[])parameters[i + 1]));
                    continue;
                }
                if (parameters[i + 1] instanceof Map) {
                    result.put((String)parameters[i], (Map)parameters[i + 1]);
                    continue;
                }
                result.put((String)parameters[i], parameters[i + 1]);
                continue;
            }
            catch (Exception e) {
                Debug.out("making JSONObject out of parsedParams", e);
            }
        }
        return result;
    }

    public long getFireBefore() {
        return this.fireBeforeDate;
    }

    public long getMessageCreated() {
        return this.messageCreatedOn;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public String getListenerID() {
        return this.listenerID;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String getOperationID() {
        return this.operationID;
    }

    protected long getSequenceNo() {
        return this.lSequenceNo;
    }

    protected void setSequenceNo(long sequenceNo) {
        this.lSequenceNo = sequenceNo;
    }

    public String toString() {
        String paramString = this.parameters.toString();
        return "PlaformMessage {cn" + this.contentNetworkID + ", " + this.lSequenceNo + ", " + this.messageID + ", " + this.listenerID + ", " + this.operationID + ", " + (paramString.length() > Short.MAX_VALUE ? paramString.substring(0, Short.MAX_VALUE) : paramString) + "}";
    }

    public String toShortString() {
        return (this.requiresAuthorization ? "AUTH: " : "") + this.getMessageID() + "." + this.getListenerID() + "." + this.getOperationID();
    }

    public boolean sendAZID() {
        return this.sendAZID;
    }

    public void setSendAZID(boolean send) {
        this.sendAZID = send;
        if (send && this.requiresAuthorization) {
            System.err.println("requiresAuthorization overrides sendAZID disabling");
        }
    }

    public long getContentNetworkID() {
        return this.contentNetworkID;
    }

    public void setContentNetworkID(long contentNetworkID) {
        this.contentNetworkID = contentNetworkID;
    }
}

