/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManagerFile;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PieceRTAProvider;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.PlayUtils;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.RealTimeInfo;
import org.gudy.azureus2.core3.util.SystemTime;

public class EnhancedDownloadManager {
    public static int DEFAULT_MINIMUM_INITIAL_BUFFER_SECS_FOR_ETA = 30;
    public static int MINIMUM_INITIAL_BUFFER_SECS;
    public static final int REACTIVATE_PROVIDER_PERIOD = 5000;
    public static final int REACTIVATE_PROVIDER_PERIOD_TICKS = 5;
    public static final int LOG_PROG_STATS_PERIOD = 10000;
    public static final int LOG_PROG_STATS_TICKS = 10;
    private static final int content_stream_bps_min_increase_ratio = 5;
    private static final int content_stream_bps_max_increase_ratio = 8;
    private DownloadManagerEnhancer enhancer;
    private DownloadManager download_manager;
    private boolean explicit_progressive;
    private volatile PiecePicker current_piece_pickler;
    private volatile boolean progressive_active = false;
    private long content_min_delivery_bps;
    private int minimum_initial_buffer_secs_for_eta;
    private bufferETAProvider buffer_provider = new bufferETAProvider();
    private progressiveStats progressive_stats;
    private boolean marked_active;
    private boolean destroyed;
    private DownloadManagerListener dmListener;
    private EnhancedDownloadManagerFile[] enhanced_files;
    private EnhancedDownloadManagerFile primary_file;

    protected EnhancedDownloadManager(DownloadManagerEnhancer _enhancer, DownloadManager _download_manager) {
        this.enhancer = _enhancer;
        this.download_manager = _download_manager;
        DiskManagerFileInfo[] files = this.download_manager.getDiskManagerFileInfo();
        this.minimum_initial_buffer_secs_for_eta = DEFAULT_MINIMUM_INITIAL_BUFFER_SECS_FOR_ETA;
        this.enhanced_files = new EnhancedDownloadManagerFile[files.length];
        long offset = 0L;
        for (int i = 0; i < files.length; ++i) {
            DiskManagerFileInfo f = files[i];
            this.enhanced_files[i] = new EnhancedDownloadManagerFile(f, offset);
            offset += f.getLength();
        }
        int primary_index = PlayUtils.getPrimaryFileIndex(this.download_manager);
        this.primary_file = this.enhanced_files[primary_index == -1 ? 0 : primary_index];
        this.progressive_stats = this.createProgressiveStats(this.download_manager, this.primary_file);
        this.download_manager.addPeerListener(new DownloadManagerPeerListener(){

            public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void peerManagerAdded(PEPeerManager manager) {
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    EnhancedDownloadManager.this.current_piece_pickler = manager.getPiecePicker();
                    if (EnhancedDownloadManager.this.progressive_active && EnhancedDownloadManager.this.current_piece_pickler != null) {
                        EnhancedDownloadManager.this.buffer_provider.activate(EnhancedDownloadManager.this.current_piece_pickler);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void peerManagerRemoved(PEPeerManager manager) {
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    EnhancedDownloadManager.this.progressive_active = false;
                    if (EnhancedDownloadManager.this.current_piece_pickler != null) {
                        EnhancedDownloadManager.this.buffer_provider.deactivate(EnhancedDownloadManager.this.current_piece_pickler);
                        EnhancedDownloadManager.this.current_piece_pickler = null;
                    }
                }
            }

            public void peerAdded(PEPeer peer) {
            }

            public void peerRemoved(PEPeer peer) {
            }
        });
    }

    public void setExplicitProgressive(int min_initial_buffer_secs, long min_bps, int file_index) {
        if (file_index >= 0 && file_index < this.enhanced_files.length) {
            this.explicit_progressive = true;
            this.minimum_initial_buffer_secs_for_eta = min_initial_buffer_secs;
            this.content_min_delivery_bps = min_bps;
            this.primary_file = this.enhanced_files[file_index];
            this.progressive_stats = this.createProgressiveStats(this.download_manager, this.primary_file);
        }
    }

    public String getName() {
        return this.download_manager.getDisplayName();
    }

    public byte[] getHash() {
        TOTorrent t = this.download_manager.getTorrent();
        if (t == null) {
            return null;
        }
        try {
            return t.getHash();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public boolean isPlatform() {
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent != null) {
            return PlatformTorrentUtils.isContent(torrent, true);
        }
        return false;
    }

    public EnhancedDownloadManagerFile[] getFiles() {
        return this.enhanced_files;
    }

    protected long getTargetSpeed() {
        long target_speed;
        long l = target_speed = this.progressive_active ? this.progressive_stats.getStreamBytesPerSecondMax() : this.content_min_delivery_bps;
        if (target_speed < this.content_min_delivery_bps) {
            target_speed = this.content_min_delivery_bps;
        }
        return target_speed;
    }

    protected boolean updateStats(int tick_count) {
        return this.updateProgressiveStats(tick_count);
    }

    public boolean supportsProgressiveMode() {
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent == null) {
            return false;
        }
        return this.enhancer.isProgressiveAvailable() && (PlatformTorrentUtils.isContentProgressive(torrent) || this.explicit_progressive);
    }

    public void prepareForProgressiveMode(boolean active) {
        this.enhancer.prepareForProgressiveMode(this.download_manager, active);
    }

    public boolean setProgressiveMode(boolean active) {
        return this.setProgressiveMode(active, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setProgressiveMode(boolean active, boolean switching_progressive_downloads) {
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent == null || this.primary_file == null) {
            return false;
        }
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            if (this.progressive_active == active) {
                return true;
            }
            if (active && !this.supportsProgressiveMode()) {
                Debug.out("Attempt to set progress mode on non-progressible content - " + this.getName());
                return false;
            }
            this.log("Progressive mode changed to " + active);
            GlobalManager gm = this.download_manager.getGlobalManager();
            if (active) {
                if (this.dmListener == null) {
                    this.dmListener = new DownloadManagerAdapter(){

                        public void downloadComplete(DownloadManager manager) {
                            EnhancedDownloadManager.this.enhancer.resume();
                        }
                    };
                }
                this.download_manager.addListener(this.dmListener);
                Object[] dms = gm.getDownloadManagers().toArray();
                for (int i = 0; i < dms.length; ++i) {
                    EnhancedDownloadManager edmCheck;
                    DownloadManager dmCheck = (DownloadManager)dms[i];
                    if (dmCheck.equals(this.download_manager) || dmCheck.isDownloadComplete(false)) continue;
                    int state = dmCheck.getState();
                    if (state == 50 || state == 75) {
                        this.enhancer.pause(dmCheck);
                    }
                    if ((edmCheck = this.enhancer.getEnhancedDownload(dmCheck)) == null || !edmCheck.getProgressiveMode()) continue;
                    edmCheck.setProgressiveMode(false, true);
                }
                if (this.download_manager.isPaused()) {
                    this.enhancer.resume(this.download_manager);
                }
                if (this.download_manager.getState() == 70) {
                    this.download_manager.setStateWaiting();
                }
                if (this.download_manager.getPosition() != 1) {
                    this.download_manager.getGlobalManager().moveTo(this.download_manager, 1);
                }
            } else {
                this.download_manager.removeListener(this.dmListener);
                if (!switching_progressive_downloads) {
                    this.enhancer.resume();
                }
            }
            this.progressive_active = active;
            if (this.progressive_active) {
                this.enhancer.progressiveActivated();
            }
            if (this.current_piece_pickler != null) {
                if (this.progressive_active) {
                    this.buffer_provider.activate(this.current_piece_pickler);
                    this.progressive_stats.update(0);
                } else {
                    this.buffer_provider.deactivate(this.current_piece_pickler);
                    this.progressive_stats = this.createProgressiveStats(this.download_manager, this.primary_file);
                }
            } else {
                this.progressive_stats = this.createProgressiveStats(this.download_manager, this.primary_file);
            }
            if (!switching_progressive_downloads) {
                if (active) {
                    RealTimeInfo.setProgressiveActive(this.progressive_stats.getStreamBytesPerSecondMax());
                } else {
                    RealTimeInfo.setProgressiveInactive();
                }
            }
        }
        return true;
    }

    public boolean getProgressiveMode() {
        return this.progressive_active;
    }

    public long getProgressivePlayETA() {
        progressiveStats stats2 = this.getProgressiveStats();
        if (stats2 == null) {
            return Long.MAX_VALUE;
        }
        long eta = stats2.getETA();
        return eta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected progressiveStats getProgressiveStats() {
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            if (this.progressive_stats == null) {
                return null;
            }
            return this.progressive_stats.getCopy();
        }
    }

    protected progressiveStats createProgressiveStats(DownloadManager dm, EnhancedDownloadManagerFile file) {
        return new progressiveStatsCommon(dm, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateProgressiveStats(int tick_count) {
        if (!this.progressive_active) {
            return false;
        }
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            PiecePicker piece_picker;
            if (!this.progressive_active || this.progressive_stats == null) {
                return false;
            }
            if (tick_count % 5 == 0 && (piece_picker = this.current_piece_pickler) != null) {
                this.buffer_provider.checkActivation(piece_picker);
            }
            this.progressive_stats.update(tick_count);
            long current_max = this.progressive_stats.getStreamBytesPerSecondMax();
            if (RealTimeInfo.getProgressiveActiveBytesPerSec() != current_max) {
                RealTimeInfo.setProgressiveActive(current_max);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRTA(boolean active) {
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            if (this.marked_active && !active) {
                this.marked_active = false;
                RealTimeInfo.removeRealTimeTask();
            }
            if (this.destroyed) {
                return;
            }
            if (!this.marked_active && active) {
                this.marked_active = true;
                RealTimeInfo.addRealTimeTask();
            }
        }
    }

    public DiskManagerFileInfo getPrimaryFile() {
        return this.primary_file.getFile();
    }

    public long getContiguousAvailableBytes(int file_index, long file_start_offset, long stop_counting_after) {
        long max_available;
        if (file_index < 0 || file_index >= this.enhanced_files.length) {
            return -1L;
        }
        EnhancedDownloadManagerFile efile = this.enhanced_files[file_index];
        DiskManagerFileInfo file = efile.getFile();
        DiskManager dm = this.download_manager.getDiskManager();
        if (dm == null) {
            if (file.getDownloaded() == file.getLength()) {
                return file.getLength() - file_start_offset;
            }
            return -1L;
        }
        int piece_size = dm.getPieceLength();
        DiskManagerFileInfo[] files = dm.getFiles();
        long start_index = efile.getByteOffestInTorrent() + file_start_offset;
        int first_piece_index = (int)(start_index / (long)piece_size);
        int first_piece_offset = (int)(start_index % (long)piece_size);
        int last_piece_index = file.getLastPieceNumber();
        DiskManagerPiece[] pieces = dm.getPieces();
        DiskManagerPiece first_piece = pieces[first_piece_index];
        long available = 0L;
        if (!first_piece.isDone()) {
            boolean[] blocks = first_piece.getWritten();
            if (blocks == null) {
                if (first_piece.isDone()) {
                    available = first_piece.getLength() - first_piece_offset;
                }
            } else {
                int piece_offset = 0;
                for (int j = 0; j < blocks.length && blocks[j]; ++j) {
                    int block_size = first_piece.getBlockSize(j);
                    piece_offset += block_size;
                    if (available == 0L) {
                        if (piece_offset <= first_piece_offset) continue;
                        available = piece_offset - first_piece_offset;
                        continue;
                    }
                    available += (long)block_size;
                }
            }
        } else {
            DiskManagerPiece piece;
            available = first_piece.getLength() - first_piece_offset;
            for (int i = first_piece_index + 1; i <= last_piece_index && (stop_counting_after <= 0L || available < stop_counting_after); available += (long)piece.getLength(), ++i) {
                piece = pieces[i];
                if (piece.isDone()) {
                    continue;
                }
                boolean[] blocks = piece.getWritten();
                if (blocks == null) {
                    if (!piece.isDone()) break;
                    available += (long)piece.getLength();
                    break;
                }
                for (int j = 0; j < blocks.length && blocks[j]; ++j) {
                    available += (long)piece.getBlockSize(j);
                }
                break;
            }
        }
        if (available > (max_available = file.getLength() - file_start_offset)) {
            available = max_available;
        }
        return available;
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            this.setRTA(false);
            this.destroyed = true;
        }
    }

    protected void log(String str) {
        this.log(str, true);
    }

    protected void log(String str, boolean to_file) {
        this.log(this.download_manager, str, to_file);
    }

    protected void log(DownloadManager dm, String str, boolean to_file) {
        str = dm.getDisplayName() + ": " + str;
        if (to_file) {
            AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.Stream");
            diag_logger.log(str);
        }
        if (ConstantsVuze.DIAG_TO_STDOUT) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + str);
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"filechannel.rt.buffer.millis"}, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                int channel_buffer_millis = COConfigurationManager.getIntParameter("filechannel.rt.buffer.millis");
                MINIMUM_INITIAL_BUFFER_SECS = 2 * channel_buffer_millis / 1000;
            }
        });
    }

    protected class bufferETAProvider
    implements PieceRTAProvider {
        private boolean is_buffering = true;
        private long[] piece_rtas;
        private long last_buffer_size;
        private long last_buffer_size_time;
        private boolean active;
        private long last_recalc;

        protected bufferETAProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void activate(PiecePicker picker) {
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                if (!this.active) {
                    EnhancedDownloadManager.this.log("Activating RTA provider");
                    this.active = true;
                    picker.addRTAProvider(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deactivate(PiecePicker picker) {
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                if (this.active) {
                    EnhancedDownloadManager.this.log("Deactivating RTA provider");
                    picker.removeRTAProvider(this);
                }
                this.piece_rtas = null;
                this.active = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkActivation(PiecePicker picker) {
            if (EnhancedDownloadManager.this.getProgressivePlayETA() > 0L) {
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    if (this.piece_rtas == null) {
                        this.activate(picker);
                    }
                }
            }
        }

        public long[] updateRTAs(PiecePicker picker) {
            block14: {
                long now;
                int end_piece;
                long piece_size;
                long buffer_bytes;
                progressiveStats stats2;
                block12: {
                    DiskManagerPiece[] pieces;
                    long block_time;
                    long buffer_size;
                    long abs_provider_pos;
                    DiskManager disk_manager;
                    block15: {
                        block13: {
                            long buffer_size2;
                            boolean buffering;
                            long mono_now = SystemTime.getMonotonousTime();
                            if (mono_now - this.last_recalc < 500L) {
                                return this.piece_rtas;
                            }
                            this.last_recalc = mono_now;
                            disk_manager = EnhancedDownloadManager.this.download_manager.getDiskManager();
                            stats2 = EnhancedDownloadManager.this.progressive_stats;
                            EnhancedDownloadManagerFile file = stats2.getFile();
                            if (disk_manager == null || stats2 == null || file.isComplete()) {
                                this.deactivate(picker);
                                return null;
                            }
                            abs_provider_pos = stats2.getCurrentProviderPosition(true);
                            long rel_provider_pos = stats2.getCurrentProviderPosition(false);
                            buffer_bytes = stats2.getBufferBytes();
                            boolean bl = buffering = EnhancedDownloadManager.this.getProgressivePlayETA() >= 0L;
                            if (buffering && (buffer_size2 = EnhancedDownloadManager.this.getContiguousAvailableBytes(file.getIndex(), rel_provider_pos, buffer_bytes)) == buffer_bytes) {
                                buffering = false;
                            }
                            if (buffering != this.is_buffering) {
                                if (buffering) {
                                    EnhancedDownloadManager.this.log("Switching to buffer mode");
                                } else {
                                    EnhancedDownloadManager.this.log("Switching to RTA mode");
                                }
                                this.is_buffering = buffering;
                            }
                            piece_size = disk_manager.getPieceLength();
                            int start_piece = (int)(abs_provider_pos / piece_size);
                            end_piece = file.getFile().getLastPieceNumber();
                            this.piece_rtas = new long[picker.getNumberOfPieces()];
                            now = SystemTime.getCurrentTime();
                            if (!this.is_buffering) break block12;
                            for (int i = start_piece; i <= end_piece; ++i) {
                                this.piece_rtas[i] = now + (long)(i * 60000);
                            }
                            buffer_size = EnhancedDownloadManager.this.getContiguousAvailableBytes(file.getIndex(), rel_provider_pos, 0L);
                            if (this.last_buffer_size == buffer_size) break block13;
                            this.last_buffer_size = buffer_size;
                            this.last_buffer_size_time = now;
                            break block14;
                        }
                        if (now >= this.last_buffer_size_time) break block15;
                        this.last_buffer_size_time = now;
                        break block14;
                    }
                    long stalled_for = now - this.last_buffer_size_time;
                    long dl_speed = EnhancedDownloadManager.this.progressive_stats.getDownloadBytesPerSecond();
                    if (dl_speed <= 0L || stalled_for <= Math.max(5000L, 5L * (block_time = 0xFA0000L / dl_speed))) break block14;
                    long target_rta = now + block_time;
                    int blocked_piece_index = (int)((abs_provider_pos + buffer_size) / (long)disk_manager.getPieceLength());
                    if (blocked_piece_index < (pieces = disk_manager.getPieces()).length && pieces[blocked_piece_index].isDone()) {
                        if (++blocked_piece_index < pieces.length) {
                            if (pieces[blocked_piece_index].isDone()) {
                                blocked_piece_index = -1;
                            }
                        } else {
                            blocked_piece_index = -1;
                        }
                    }
                    if (blocked_piece_index < 0) break block14;
                    this.piece_rtas[blocked_piece_index] = target_rta;
                    EnhancedDownloadManager.this.log("Buffer provider: reprioritising lagging piece " + blocked_piece_index + " with rta " + block_time);
                    break block14;
                }
                long bytes_offset = 0L;
                long max_bps = stats2.getStreamBytesPerSecondMax();
                for (int i = start_piece; i <= end_piece; ++i) {
                    this.piece_rtas[i] = now + 1000L * (bytes_offset / max_bps);
                    if ((bytes_offset += piece_size) > buffer_bytes) break;
                }
            }
            return this.piece_rtas;
        }

        public long getCurrentPosition() {
            return 0L;
        }

        public long getStartTime() {
            return 0L;
        }

        public long getStartPosition() {
            return 0L;
        }

        public long getBlockingPosition() {
            return 0L;
        }

        public void setBufferMillis(long millis, long delay_millis) {
        }

        public String getUserAgent() {
            return null;
        }
    }

    protected abstract class progressiveStats
    implements Cloneable {
        protected progressiveStats() {
        }

        protected abstract EnhancedDownloadManagerFile getFile();

        protected abstract boolean isProviderActive();

        protected abstract long getCurrentProviderPosition(boolean var1);

        protected abstract long getStreamBytesPerSecondMax();

        protected abstract long getStreamBytesPerSecondMin();

        protected abstract long getDownloadBytesPerSecond();

        protected abstract long getETA();

        public abstract long getBufferBytes();

        protected abstract long getSecondsToDownload();

        protected abstract long getSecondsToWatch();

        protected abstract void update(int var1);

        protected progressiveStats getCopy() {
            try {
                return (progressiveStats)this.clone();
            }
            catch (CloneNotSupportedException e) {
                Debug.printStackTrace(e);
                return null;
            }
        }

        protected String formatBytes(long l) {
            return DisplayFormatters.formatByteCountToKiBEtc(l);
        }

        protected String formatSpeed(long l) {
            return DisplayFormatters.formatByteCountToKiBEtcPerSec(l);
        }
    }

    protected class progressiveStatsCommon
    extends progressiveStats {
        private EnhancedDownloadManagerFile primary_file;
        private PieceRTAProvider current_provider;
        private String current_user_agent;
        private long content_stream_bps_min;
        private long content_stream_bps_max;
        private Average capped_download_rate_average = AverageFactory.MovingImmediateAverage(10);
        private Average discard_rate_average = AverageFactory.MovingImmediateAverage(10);
        private long last_discard_bytes = EnhancedDownloadManager.access$400(EnhancedDownloadManager.this).getStats().getDiscarded();
        private long actual_bytes_to_download;
        private long weighted_bytes_to_download;
        private long provider_life_secs;
        private long provider_initial_position;
        private long provider_byte_position;
        private long provider_last_byte_position = -1L;
        private long provider_blocking_byte_position;
        private Average provider_speed_average = AverageFactory.MovingImmediateAverage(10);

        protected progressiveStatsCommon(DownloadManager _dm, EnhancedDownloadManagerFile _primary_file) {
            this.primary_file = _primary_file;
            TOTorrent torrent = EnhancedDownloadManager.this.download_manager.getTorrent();
            long l = this.content_stream_bps_min = EnhancedDownloadManager.this.explicit_progressive ? EnhancedDownloadManager.this.content_min_delivery_bps : PlatformTorrentUtils.getContentStreamSpeedBps(torrent);
            if (this.content_stream_bps_min == 0L) {
                long size = torrent.getSize();
                this.content_stream_bps_min = size < 0xC800000L ? 30720L : (size < 1048576000L ? 204800L : 409600L);
            }
            this.content_stream_bps_min += this.content_stream_bps_min / 5L;
            this.content_stream_bps_max = this.content_stream_bps_min + this.content_stream_bps_min / 8L;
            EnhancedDownloadManager.this.setRTA(false);
            EnhancedDownloadManager.this.log(EnhancedDownloadManager.this.download_manager, "content_stream_bps=" + this.getStreamBytesPerSecondMin() + ",primary=" + this.primary_file.getFile().getIndex(), true);
        }

        protected void updateCurrentProvider(PieceRTAProvider provider2) {
            long file_start = this.primary_file.getByteOffestInTorrent();
            if (this.current_provider != provider2 || provider2 == null) {
                this.current_provider = provider2;
                this.current_user_agent = null;
                this.provider_speed_average = AverageFactory.MovingImmediateAverage(10);
                if (this.current_provider == null) {
                    this.provider_life_secs = 0L;
                    this.provider_initial_position = file_start;
                    this.provider_byte_position = file_start;
                    this.provider_blocking_byte_position = -1L;
                    this.provider_last_byte_position = -1L;
                } else {
                    this.provider_byte_position = this.provider_initial_position = Math.max(file_start, this.current_provider.getStartPosition());
                    this.provider_last_byte_position = this.provider_initial_position;
                    this.provider_blocking_byte_position = this.current_provider.getBlockingPosition();
                    this.provider_life_secs = (SystemTime.getCurrentTime() - this.current_provider.getStartTime()) / 1000L;
                    if (this.provider_life_secs < 0L) {
                        this.provider_life_secs = 0L;
                    }
                }
                EnhancedDownloadManager.this.setRTA(this.current_provider != null);
            } else {
                ++this.provider_life_secs;
                if (this.current_user_agent == null) {
                    this.current_user_agent = this.current_provider.getUserAgent();
                    if (this.current_user_agent != null) {
                        EnhancedDownloadManager.this.log("Provider user agent = " + this.current_user_agent);
                    }
                }
                this.provider_byte_position = Math.max(file_start, this.current_provider.getCurrentPosition());
                this.provider_blocking_byte_position = this.current_provider.getBlockingPosition();
                long bytes_read = this.provider_byte_position - this.provider_last_byte_position;
                this.provider_speed_average.update(bytes_read);
                this.provider_last_byte_position = this.provider_byte_position;
            }
        }

        protected boolean isProviderActive() {
            return this.current_provider != null;
        }

        protected long getInitialProviderPosition() {
            return this.provider_initial_position;
        }

        protected long getCurrentProviderPosition(boolean absolute) {
            long res = this.provider_byte_position;
            if (absolute) {
                if (res == 0L) {
                    res = this.primary_file.getByteOffestInTorrent();
                }
            } else if ((res -= this.primary_file.getByteOffestInTorrent()) < 0L) {
                res = 0L;
            }
            return res;
        }

        protected long getProviderLifeSecs() {
            return this.provider_life_secs;
        }

        protected void update(int tick_count) {
            long download_rate = EnhancedDownloadManager.this.download_manager.getStats().getDataReceiveRate();
            this.capped_download_rate_average.update(download_rate);
            long discards = EnhancedDownloadManager.this.download_manager.getStats().getDiscarded();
            this.discard_rate_average.update(discards - this.last_discard_bytes);
            this.last_discard_bytes = discards;
            DiskManager disk_manager = EnhancedDownloadManager.this.download_manager.getDiskManager();
            PiecePicker picker = EnhancedDownloadManager.this.current_piece_pickler;
            if (this.getStreamBytesPerSecondMin() > 0L && disk_manager != null && picker != null) {
                List providers = picker.getRTAProviders();
                long max_cp = 0L;
                PieceRTAProvider best_provider = null;
                for (int i = 0; i < providers.size(); ++i) {
                    long cp;
                    PieceRTAProvider provider2 = (PieceRTAProvider)providers.get(i);
                    if (provider2.getStartTime() <= 0L || (cp = provider2.getCurrentPosition()) < max_cp) continue;
                    best_provider = provider2;
                    max_cp = cp;
                }
                this.updateCurrentProvider(best_provider);
                if (best_provider != null) {
                    long relative_pos = this.getCurrentProviderPosition(false);
                    long buffer_bytes = EnhancedDownloadManager.this.getContiguousAvailableBytes(this.primary_file.getIndex(), relative_pos, this.getStreamBytesPerSecondMin() * 60L);
                    long buffer_secs = buffer_bytes / this.getStreamBytesPerSecondMin();
                    buffer_secs = Math.max(10L, buffer_secs);
                    best_provider.setBufferMillis(15000L, buffer_secs * 1000L);
                }
                DiskManagerPiece[] pieces = disk_manager.getPieces();
                this.actual_bytes_to_download = 0L;
                this.weighted_bytes_to_download = 0L;
                int first_incomplete_piece = -1;
                int piece_size = disk_manager.getPieceLength();
                int last_piece_number = this.primary_file.getFile().getLastPieceNumber();
                for (int i = (int)(this.provider_byte_position / (long)piece_size); i <= last_piece_number; ++i) {
                    DiskManagerPiece piece = pieces[i];
                    if (piece.isDone()) continue;
                    if (first_incomplete_piece == -1) {
                        first_incomplete_piece = i;
                    }
                    boolean[] blocks = piece.getWritten();
                    int bytes_this_piece = 0;
                    if (blocks == null) {
                        bytes_this_piece = piece.getLength();
                    } else {
                        for (int j = 0; j < blocks.length; ++j) {
                            if (blocks[j]) continue;
                            bytes_this_piece += piece.getBlockSize(j);
                        }
                    }
                    if (bytes_this_piece <= 0) continue;
                    this.actual_bytes_to_download += (long)bytes_this_piece;
                    int diff = i - first_incomplete_piece;
                    if (diff == 0) {
                        this.weighted_bytes_to_download += (long)bytes_this_piece;
                        continue;
                    }
                    int weighted_bytes_done = piece.getLength() - bytes_this_piece;
                    weighted_bytes_done = weighted_bytes_done * (pieces.length - i) / (pieces.length - first_incomplete_piece);
                    this.weighted_bytes_to_download += (long)(piece.getLength() - weighted_bytes_done);
                }
            }
            EnhancedDownloadManager.this.log(this.getString(), tick_count % 10 == 0);
        }

        protected long getETA() {
            long secs_to_watch;
            long secs_to_download;
            long eta;
            long buffer_done;
            DiskManagerFileInfo file = this.primary_file.getFile();
            if (file.getLength() == file.getDownloaded()) {
                return 0L;
            }
            long download_rate = this.getDownloadBytesPerSecond();
            if (download_rate <= 0L) {
                return Long.MAX_VALUE;
            }
            long buffer_bytes = this.getBufferBytes();
            long rem_buffer = buffer_bytes - (buffer_done = EnhancedDownloadManager.this.getContiguousAvailableBytes(file.getIndex(), this.getCurrentProviderPosition(false), buffer_bytes));
            long rem_secs = rem_buffer <= 0L ? 0L : rem_buffer / download_rate;
            if (rem_secs > (eta = (secs_to_download = this.getSecondsToDownload()) - (secs_to_watch = this.getSecondsToWatch())) && rem_secs > 0L) {
                eta = rem_secs;
            }
            return eta;
        }

        protected long getStreamBytesPerSecondMax() {
            return this.content_stream_bps_max;
        }

        protected long getStreamBytesPerSecondMin() {
            return this.content_stream_bps_min;
        }

        public long getBufferBytes() {
            long min_dl = (long)EnhancedDownloadManager.this.minimum_initial_buffer_secs_for_eta * this.getStreamBytesPerSecondMax();
            return min_dl;
        }

        protected EnhancedDownloadManagerFile getFile() {
            return this.primary_file;
        }

        protected long getDownloadBytesPerSecond() {
            int global_limit;
            long original;
            long current = original = (long)this.capped_download_rate_average.getAverage();
            int dl_limit = EnhancedDownloadManager.this.download_manager.getStats().getDownloadRateLimitBytesPerSecond();
            if (dl_limit > 0) {
                current = Math.min(current, (long)dl_limit);
            }
            if ((global_limit = TransferSpeedValidator.getGlobalDownloadRateLimitBytesPerSecond()) > 0) {
                current = Math.min(current, (long)global_limit);
            }
            return current;
        }

        protected long getSecondsToDownload() {
            long download_rate = this.getDownloadBytesPerSecond();
            if (download_rate == 0L) {
                return Long.MAX_VALUE;
            }
            return this.weighted_bytes_to_download / download_rate;
        }

        public long getSecondsToWatch() {
            return (this.primary_file.getLength() - this.getCurrentProviderPosition(false)) / this.getStreamBytesPerSecondMin();
        }

        protected String getString() {
            long dl_rate = this.getDownloadBytesPerSecond();
            long buffer_bytes = this.getBufferBytes();
            long buffer_done = EnhancedDownloadManager.this.getContiguousAvailableBytes(this.primary_file.getIndex(), this.getCurrentProviderPosition(false), buffer_bytes);
            return "play_eta=" + this.getETA() + "/d=" + this.getSecondsToDownload() + "/w=" + this.getSecondsToWatch() + ", dl_rate=" + this.formatSpeed(dl_rate) + ", download_rem=" + this.formatBytes(this.weighted_bytes_to_download) + "/" + this.formatBytes(this.actual_bytes_to_download) + ", discard_rate=" + this.formatSpeed((long)this.discard_rate_average.getAverage()) + ", buffer: " + buffer_bytes + "/" + buffer_done + ", prov: byte=" + this.formatBytes(this.provider_byte_position) + " secs=" + this.provider_byte_position / this.getStreamBytesPerSecondMin() + " speed=" + this.formatSpeed((long)this.provider_speed_average.getAverage()) + " block= " + this.formatBytes(this.provider_blocking_byte_position);
        }
    }
}

