/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.test;

import com.aelitis.azureus.core.diskmanager.MemoryMappedFile;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.RandomUtils;

public class MemoryMappedFileTester {
    static long MAX_SIZE = 0x40000000L;
    static int BUFF_SIZE = 0x500000;
    static DirectByteBuffer dbb = DirectByteBufferPool.getBuffer((byte)2, BUFF_SIZE);
    static byte[] raw = new byte[BUFF_SIZE];

    public static void main(String[] args) {
        try {
            File fraf = new File("e:\\fraf.bin");
            File fchan = new File("e:\\fchan.bin");
            File fmapd = new File("e:\\fmapd.bin");
            RandomAccessFile raf = new RandomAccessFile(fraf, "rw");
            FileChannel fc = new RandomAccessFile(fchan, "rw").getChannel();
            MemoryMappedFile mmf = new MemoryMappedFile(fmapd);
            mmf.setAccessMode(1);
            long written = 0L;
            long traf = 0L;
            long tchan = 0L;
            long tmmf = 0L;
            int loop = 1;
            while (written < MAX_SIZE) {
                System.out.print("|");
                if (loop % 80 == 0) {
                    System.out.println();
                }
                MemoryMappedFileTester.refreshBuffers();
                long start_pos = new Float(RandomUtils.nextFloat() * (float)(MAX_SIZE - (long)BUFF_SIZE)).longValue();
                long start = System.currentTimeMillis();
                traf += System.currentTimeMillis() - start;
                start = System.currentTimeMillis();
                tchan += System.currentTimeMillis() - start;
                start = System.currentTimeMillis();
                mmf.write(dbb, 0, start_pos, dbb.limit((byte)2));
                tmmf += System.currentTimeMillis() - start;
                written += (long)raw.length;
                ++loop;
            }
            System.out.println();
            System.out.println("RandomAccessFile = " + traf);
            System.out.println("FileChannel = " + tchan);
            System.out.println("MemoryMappedFile = " + tmmf);
            System.out.println("Cache H: " + MemoryMappedFile.cache_hits + " M: " + MemoryMappedFile.cache_misses);
        }
        catch (Throwable t) {
            Debug.printStackTrace(t);
        }
    }

    private static void refreshBuffers() {
        RandomUtils.nextBytes(raw);
        dbb.clear((byte)2);
        dbb.put((byte)2, raw);
        dbb.flip((byte)2);
    }
}

