/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccess;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccessCompact;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccessLinear;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccessPieceReorderer;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import java.io.File;
import java.io.RandomAccessFile;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.StringInterner;

public class FMFileAccessController
implements FMFileAccess {
    private static final String REORDER_SUFFIX = ".2";
    private static final boolean TEST_PIECE_REORDER = System.getProperty("azureus.file.piece.reorder.force", "0").equals("1");
    private FMFileImpl owner;
    private int type = 1;
    private File control_dir;
    private String controlFileName;
    private FMFileAccess file_access;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected FMFileAccessController(FMFileImpl _file, int _target_type) throws FMFileManagerException {
        if (TEST_PIECE_REORDER) {
            _target_type = 3;
        }
        this.owner = _file;
        this.setControlFile();
        if (this.control_dir == null) {
            if (_target_type != 1) throw new FMFileManagerException("Compact storage not supported: no control file available");
            this.file_access = new FMFileAccessLinear(this.owner);
            return;
        } else {
            if (new File(this.control_dir, this.controlFileName).exists()) {
                this.type = 2;
            } else if (new File(this.control_dir, this.controlFileName + REORDER_SUFFIX).exists()) {
                this.type = _target_type == 3 ? 3 : 4;
            } else if (_target_type == 3 || _target_type == 4) {
                File target_file = this.owner.getLinkedFile();
                if (target_file.exists()) {
                    FMFileAccessPieceReorderer.recoverConfig(this.owner.getOwner().getTorrentFile(), target_file, new File(this.control_dir, this.controlFileName + REORDER_SUFFIX));
                }
                this.type = _target_type;
            } else {
                this.type = 1;
            }
            this.file_access = this.type == 1 ? new FMFileAccessLinear(this.owner) : (this.type == 2 ? new FMFileAccessCompact(this.owner.getOwner().getTorrentFile(), this.control_dir, this.controlFileName, new FMFileAccessLinear(this.owner)) : new FMFileAccessPieceReorderer(this.owner.getOwner().getTorrentFile(), this.control_dir, this.controlFileName + REORDER_SUFFIX, new FMFileAccessLinear(this.owner)));
            this.convert(_target_type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void convert(int target_type) throws FMFileManagerException {
        block32: {
            if (this.type == target_type) {
                return;
            }
            if (this.type == 3 || target_type == 3) {
                if (target_type == 4 || this.type == 4) {
                    this.type = target_type;
                    return;
                }
                throw new FMFileManagerException("Conversion to/from piece-reorder not supported");
            }
            File file = this.owner.getLinkedFile();
            RandomAccessFile raf = null;
            boolean ok = false;
            FMFileAccess target_access = target_type == 1 ? new FMFileAccessLinear(this.owner) : new FMFileAccessCompact(this.owner.getOwner().getTorrentFile(), this.control_dir, this.controlFileName, new FMFileAccessLinear(this.owner));
            if (file.exists()) {
                raf = new RandomAccessFile(file, "rw");
                FMFileAccessCompact compact_access = target_type == 1 ? (FMFileAccessCompact)this.file_access : (FMFileAccessCompact)target_access;
                long length = this.file_access.getLength(raf);
                long last_piece_start = compact_access.getLastPieceStart();
                long last_piece_length = compact_access.getLastPieceLength();
                if (last_piece_length > 0L && length > last_piece_start) {
                    long data_length = length - last_piece_start;
                    if (data_length > last_piece_length) {
                        Debug.out("data length inconsistent: len=" + data_length + ",limit=" + last_piece_length);
                        data_length = last_piece_length;
                    }
                    DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)25, (int)data_length);
                    try {
                        this.file_access.read(raf, new DirectByteBuffer[]{buffer}, last_piece_start);
                        if (target_type == 2) {
                            long first_piece_length = compact_access.getFirstPieceLength();
                            long physical_length = raf.length();
                            if (physical_length > first_piece_length) {
                                raf.setLength(first_piece_length);
                            }
                        }
                        buffer.flip((byte)25);
                        target_access.write(raf, new DirectByteBuffer[]{buffer}, last_piece_start);
                        Object var21_17 = null;
                        buffer.returnToPool();
                    }
                    catch (Throwable throwable) {
                        Object var21_18 = null;
                        buffer.returnToPool();
                        throw throwable;
                    }
                } else if (target_type == 2) {
                    long first_piece_length = compact_access.getFirstPieceLength();
                    long physical_length = raf.length();
                    if (physical_length > first_piece_length) {
                        raf.setLength(first_piece_length);
                    }
                }
                target_access.setLength(raf, length);
                target_access.flush();
            }
            this.type = target_type;
            this.file_access = target_access;
            ok = true;
            Object var23_20 = null;
            try {
                block31: {
                    if (raf != null) {
                        try {
                            raf.close();
                        }
                        catch (Throwable e) {
                            if (!ok) break block31;
                            ok = false;
                            throw new FMFileManagerException("convert fails", e);
                        }
                    }
                }
                Object var26_24 = null;
                if (!ok) {
                    this.type = 1;
                    this.file_access = new FMFileAccessLinear(this.owner);
                }
                if (this.type != 1) break block32;
                new File(this.control_dir, this.controlFileName).delete();
            }
            catch (Throwable throwable) {
                Object var26_25 = null;
                if (!ok) {
                    this.type = 1;
                    this.file_access = new FMFileAccessLinear(this.owner);
                }
                if (this.type == 1) {
                    new File(this.control_dir, this.controlFileName).delete();
                }
                throw throwable;
            }
            {
                break block32;
            }
            {
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    throw new FMFileManagerException("convert fails", e);
                }
            }
            catch (Throwable throwable) {
                block34: {
                    Object var23_21 = null;
                    try {
                        block33: {
                            if (raf != null) {
                                try {
                                    raf.close();
                                }
                                catch (Throwable e) {
                                    if (!ok) break block33;
                                    ok = false;
                                    throw new FMFileManagerException("convert fails", e);
                                }
                            }
                        }
                        Object var26_26 = null;
                        if (!ok) {
                            this.type = 1;
                            this.file_access = new FMFileAccessLinear(this.owner);
                        }
                        if (this.type != 1) break block34;
                        new File(this.control_dir, this.controlFileName).delete();
                    }
                    catch (Throwable throwable2) {
                        Object var26_27 = null;
                        if (!ok) {
                            this.type = 1;
                            this.file_access = new FMFileAccessLinear(this.owner);
                        }
                        if (this.type == 1) {
                            new File(this.control_dir, this.controlFileName).delete();
                        }
                        throw throwable2;
                    }
                    {
                    }
                }
                throw throwable;
            }
        }
    }

    protected void setControlFile() {
        TOTorrentFile tf = this.owner.getOwner().getTorrentFile();
        if (tf == null) {
            this.controlFileName = null;
            this.control_dir = null;
        }
        TOTorrent torrent = tf.getTorrent();
        TOTorrentFile[] files = torrent.getFiles();
        int file_index = -1;
        for (int i = 0; i < files.length; ++i) {
            if (files[i] != tf) continue;
            file_index = i;
            break;
        }
        if (file_index == -1) {
            Debug.out("File '" + this.owner.getName() + "' not found in torrent!");
            this.controlFileName = null;
            this.control_dir = null;
        } else {
            this.control_dir = this.owner.getOwner().getControlFileDir();
            this.controlFileName = StringInterner.intern("fmfile" + file_index + ".dat");
        }
    }

    public void setStorageType(int new_type) throws FMFileManagerException {
        this.convert(new_type);
    }

    public int getStorageType() {
        return this.type;
    }

    public void aboutToOpen() throws FMFileManagerException {
        this.file_access.aboutToOpen();
    }

    public long getLength(RandomAccessFile raf) throws FMFileManagerException {
        return this.file_access.getLength(raf);
    }

    public void setLength(RandomAccessFile raf, long length) throws FMFileManagerException {
        this.file_access.setLength(raf, length);
    }

    public boolean isPieceCompleteProcessingNeeded(int piece_number) {
        return this.file_access.isPieceCompleteProcessingNeeded(piece_number);
    }

    public void setPieceComplete(RandomAccessFile raf, int piece_number, DirectByteBuffer piece_data) throws FMFileManagerException {
        this.file_access.setPieceComplete(raf, piece_number, piece_data);
    }

    public void read(RandomAccessFile raf, DirectByteBuffer[] buffers, long offset) throws FMFileManagerException {
        this.file_access.read(raf, buffers, offset);
    }

    public void write(RandomAccessFile raf, DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        this.file_access.write(raf, buffers, position);
    }

    public void flush() throws FMFileManagerException {
        this.file_access.flush();
    }

    public FMFileImpl getFile() {
        return this.owner;
    }

    public String getString() {
        return "type=" + this.type + ",acc=" + this.file_access.getString();
    }

    static {
        if (TEST_PIECE_REORDER) {
            Debug.out("*** Piece reordering storage forced ***");
        }
    }
}

