/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import java.io.File;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class CacheFileWithoutCacheMT
implements CacheFile {
    private static final int MAX_CLONES = 20;
    private static int num_clones;
    private static int max_clone_depth;
    private CacheFileManagerImpl manager;
    private FMFile base_file;
    private FMFile[] files;
    private int[] files_use_count;
    private TOTorrentFile torrent_file;
    private boolean moving;

    protected CacheFileWithoutCacheMT(CacheFileManagerImpl _manager, FMFile _file, TOTorrentFile _torrent_file) {
        this.manager = _manager;
        this.base_file = _file;
        this.torrent_file = _torrent_file;
        this.files = new FMFile[]{this.base_file};
        this.files_use_count = new int[]{0};
    }

    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    public boolean exists() {
        return this.base_file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void moveFile(File new_file) throws CacheFileManagerException {
        try {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
            // MONITORENTER : cacheFileWithoutCacheMT
            this.moving = true;
            // MONITOREXIT : cacheFileWithoutCacheMT
            while (true) {
                int i;
                cacheFileWithoutCacheMT = this;
                // MONITORENTER : cacheFileWithoutCacheMT
                boolean surviving = false;
                for (i = 1; i < this.files_use_count.length; ++i) {
                    if (this.files_use_count[i] <= 0) continue;
                    surviving = true;
                    break;
                }
                if (!surviving) {
                    i = 1;
                    while (true) {
                        if (i >= this.files_use_count.length) {
                            this.files = new FMFile[]{this.base_file};
                            this.files_use_count = new int[]{this.files_use_count[0]};
                            this.base_file.moveFile(new_file);
                            // MONITOREXIT : cacheFileWithoutCacheMT
                            return;
                        }
                        FMFile file = this.files[i];
                        if (file.isClone()) {
                            Class<CacheFileWithoutCacheMT> clazz = CacheFileWithoutCacheMT.class;
                            // MONITORENTER : com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCacheMT.class
                            --num_clones;
                            // MONITOREXIT : clazz
                        }
                        file.close();
                        ++i;
                    }
                }
                // MONITOREXIT : cacheFileWithoutCacheMT
                try {
                    System.out.println("CacheFileWithoutCacheMT: waiting for clones to die");
                    Thread.sleep(250L);
                }
                catch (Throwable e) {}
            }
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
            return;
        }
        finally {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void renameFile(String new_file) throws CacheFileManagerException {
        try {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
            // MONITORENTER : cacheFileWithoutCacheMT
            this.moving = true;
            // MONITOREXIT : cacheFileWithoutCacheMT
            while (true) {
                int i;
                cacheFileWithoutCacheMT = this;
                // MONITORENTER : cacheFileWithoutCacheMT
                boolean surviving = false;
                for (i = 1; i < this.files_use_count.length; ++i) {
                    if (this.files_use_count[i] <= 0) continue;
                    surviving = true;
                    break;
                }
                if (!surviving) {
                    i = 1;
                    while (true) {
                        if (i >= this.files_use_count.length) {
                            this.files = new FMFile[]{this.base_file};
                            this.files_use_count = new int[]{this.files_use_count[0]};
                            this.base_file.renameFile(new_file);
                            // MONITOREXIT : cacheFileWithoutCacheMT
                            return;
                        }
                        FMFile file = this.files[i];
                        if (file.isClone()) {
                            Class<CacheFileWithoutCacheMT> clazz = CacheFileWithoutCacheMT.class;
                            // MONITORENTER : com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCacheMT.class
                            --num_clones;
                            // MONITOREXIT : clazz
                        }
                        file.close();
                        ++i;
                    }
                }
                // MONITOREXIT : cacheFileWithoutCacheMT
                try {
                    System.out.println("CacheFileWithoutCacheMT: waiting for clones to die");
                    Thread.sleep(250L);
                }
                catch (Throwable e) {}
            }
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
            return;
        }
        finally {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessMode(int mode) throws CacheFileManagerException {
        try {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
            synchronized (cacheFileWithoutCacheMT) {
                for (int i = 0; i < this.files.length; ++i) {
                    this.files[i].setAccessMode(mode == 1 ? 1 : 2);
                }
            }
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public int getAccessMode() {
        return this.base_file.getAccessMode() == 1 ? 1 : 2;
    }

    public void setStorageType(int type) throws CacheFileManagerException {
        throw new CacheFileManagerException(this, "Not Implemented");
    }

    public int getStorageType() {
        return CacheFileManagerImpl.convertFileToCacheType(this.base_file.getStorageType());
    }

    public long getLength() throws CacheFileManagerException {
        try {
            return this.base_file.exists() ? this.base_file.getLength() : 0L;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
            return 0L;
        }
    }

    public long compareLength(long compare_to) throws CacheFileManagerException {
        return this.getLength() - compare_to;
    }

    public void setLength(long length) throws CacheFileManagerException {
        try {
            this.base_file.setLength(length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public void setPieceComplete(int piece_number, DirectByteBuffer piece_data) throws CacheFileManagerException {
        try {
            this.base_file.setPieceComplete(piece_number, piece_data);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FMFile getFile() throws CacheFileManagerException {
        CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
        synchronized (cacheFileWithoutCacheMT) {
            if (this.moving) {
                this.files_use_count[0] = this.files_use_count[0] + 1;
                return this.files[0];
            }
            int min_index = -1;
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < this.files_use_count.length; ++i) {
                int count = this.files_use_count[i];
                if (count >= min) continue;
                min = count;
                min_index = i;
            }
            if (min == 0 || this.files_use_count.length == 20) {
                int n = min_index;
                this.files_use_count[n] = this.files_use_count[n] + 1;
                return this.files[min_index];
            }
            try {
                FMFile clone = this.base_file.createClone();
                int old_num = this.files.length;
                int new_num = old_num + 1;
                Class<CacheFileWithoutCacheMT> clazz = CacheFileWithoutCacheMT.class;
                synchronized (CacheFileWithoutCacheMT.class) {
                    if (++num_clones % 100 == 0) {
                        // empty if block
                    }
                    if (new_num == 20 || new_num > max_clone_depth) {
                        max_clone_depth = new_num;
                    }
                    // ** MonitorExit[var7_9] (shouldn't be in output)
                    FMFile[] new_files = new FMFile[new_num];
                    int[] new_files_use_count = new int[new_num];
                    System.arraycopy(this.files, 0, new_files, 0, old_num);
                    System.arraycopy(this.files_use_count, 0, new_files_use_count, 0, old_num);
                    new_files[old_num] = clone;
                    new_files_use_count[old_num] = 1;
                    this.files = new_files;
                    this.files_use_count = new_files_use_count;
                    return clone;
                }
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseFile(FMFile file) {
        CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
        synchronized (cacheFileWithoutCacheMT) {
            for (int i = 0; i < this.files_use_count.length; ++i) {
                if (this.files[i] != file) continue;
                int count = this.files_use_count[i];
                if (count > 0) {
                    // empty if block
                }
                this.files_use_count[i] = --count;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(DirectByteBuffer[] buffers, long position, short policy) throws CacheFileManagerException {
        int read_length = 0;
        for (int i = 0; i < buffers.length; ++i) {
            read_length += buffers[i].remaining((byte)3);
        }
        FMFile file = null;
        try {
            file = this.getFile();
            file.read(buffers, position);
            this.manager.fileBytesRead(read_length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
        finally {
            this.releaseFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(DirectByteBuffer buffer, long position, short policy) throws CacheFileManagerException {
        int read_length = buffer.remaining((byte)3);
        FMFile file = null;
        try {
            file = this.getFile();
            file.read(buffer, position);
            this.manager.fileBytesRead(read_length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
        finally {
            this.releaseFile(file);
        }
    }

    public void write(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        int write_length = buffer.remaining((byte)3);
        try {
            this.base_file.write(buffer, position);
            this.manager.fileBytesWritten(write_length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public void write(DirectByteBuffer[] buffers, long position) throws CacheFileManagerException {
        int write_length = 0;
        for (int i = 0; i < buffers.length; ++i) {
            write_length += buffers[i].remaining((byte)3);
        }
        try {
            this.base_file.write(buffers, position);
            this.manager.fileBytesWritten(write_length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAndHandoverBuffer(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        int write_length = buffer.remaining((byte)3);
        boolean write_ok = false;
        try {
            this.base_file.write(buffer, position);
            this.manager.fileBytesWritten(write_length);
            write_ok = true;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
        finally {
            if (write_ok) {
                buffer.returnToPool();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAndHandoverBuffers(DirectByteBuffer[] buffers, long position) throws CacheFileManagerException {
        block7: {
            int write_length = 0;
            for (int i = 0; i < buffers.length; ++i) {
                write_length += buffers[i].remaining((byte)3);
            }
            boolean write_ok = false;
            try {
                this.base_file.write(buffers, position);
                this.manager.fileBytesWritten(write_length);
                write_ok = true;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
            }
            finally {
                if (!write_ok) break block7;
                for (int i = 0; i < buffers.length; ++i) {
                    buffers[i].returnToPool();
                }
            }
        }
    }

    public void flushCache() throws CacheFileManagerException {
        try {
            this.base_file.flush();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public void clearCache() throws CacheFileManagerException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void close() throws CacheFileManagerException {
        try {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
            // MONITORENTER : cacheFileWithoutCacheMT
            int i = 0;
            while (true) {
                if (i >= this.files.length) {
                    // MONITOREXIT : cacheFileWithoutCacheMT
                    return;
                }
                FMFile file = this.files[i];
                if (file.isClone()) {
                    Class<CacheFileWithoutCacheMT> clazz = CacheFileWithoutCacheMT.class;
                    // MONITORENTER : com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCacheMT.class
                    --num_clones;
                    // MONITOREXIT : clazz
                }
                file.close();
                ++i;
            }
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public boolean isOpen() {
        return this.base_file.isOpen();
    }

    public void delete() throws CacheFileManagerException {
        try {
            this.base_file.delete();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }
}

