/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacket;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTUDPUtils {
    protected static final int CT_UDP = 1;
    private static Map<String, byte[]> node_id_history = new LinkedHashMap<String, byte[]>(128, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, byte[]> eldest) {
            return this.size() > 128;
        }
    };
    private static SHA1Simple hasher = new SHA1Simple();
    public static final int INETSOCKETADDRESS_IPV4_SIZE = 7;
    public static final int INETSOCKETADDRESS_IPV6_SIZE = 19;
    public static final int DHTTRANSPORTCONTACT_SIZE = 9;
    public static final int DHTTRANSPORTVALUE_SIZE_WITHOUT_VALUE = 26;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getNodeID(InetSocketAddress address, byte protocol_version) throws DHTTransportException {
        String key;
        InetAddress ia = address.getAddress();
        if (ia == null) {
            throw new DHTTransportException("Address '" + address + "' is unresolved");
        }
        if (protocol_version >= 50) {
            byte[] bytes = ia.getAddress();
            if (bytes.length == 4) {
                long K2 = 2500L;
                long K3 = 50L;
                long K4 = 5L;
                long result = (long)address.getPort() % 5L;
                result = ((long)bytes[3] << 8 & 0xFF00L | result) % 50L;
                result = ((long)bytes[2] << 16 & 0xFF0000L | result) % 2500L;
                result = (long)bytes[1] << 24 & 0xFF000000L | result;
                result = (long)bytes[0] << 32 & 0xFF00000000L | result;
                key = String.valueOf(result);
            } else {
                key = ia.getHostAddress() + ":" + address.getPort() % 8;
            }
        } else {
            key = protocol_version >= 33 ? ia.getHostAddress() + ":" + address.getPort() % 8 : (protocol_version >= 32 ? ia.getHostAddress() + ":" + address.getPort() % 1999 : ia.getHostAddress() + ":" + address.getPort());
        }
        Map<String, byte[]> map = node_id_history;
        synchronized (map) {
            byte[] res = node_id_history.get(key);
            if (res == null) {
                res = hasher.calculateHash(key.getBytes());
                node_id_history.put(key, res);
            }
            return res;
        }
    }

    protected static byte[] getBogusNodeID() {
        byte[] id = new byte[20];
        new Random().nextBytes(id);
        return id;
    }

    protected static void serialiseLength(DataOutputStream os, int len, int max_length) throws IOException {
        if (len > max_length) {
            throw new IOException("Invalid DHT data length: max=" + max_length + ",actual=" + len);
        }
        if (max_length < 256) {
            os.writeByte(len);
        } else if (max_length < 65536) {
            os.writeShort(len);
        } else {
            os.writeInt(len);
        }
    }

    protected static int deserialiseLength(DataInputStream is, int max_length) throws IOException {
        int len = max_length < 256 ? is.readByte() & 0xFF : (max_length < 65536 ? is.readShort() & 0xFFFF : is.readInt());
        if (len > max_length) {
            throw new IOException("Invalid DHT data length: max=" + max_length + ",actual=" + len);
        }
        return len;
    }

    protected static byte[] deserialiseByteArray(DataInputStream is, int max_length) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, max_length);
        byte[] data = new byte[len];
        is.read(data);
        return data;
    }

    protected static void serialiseByteArray(DataOutputStream os, byte[] data, int max_length) throws IOException {
        DHTUDPUtils.serialiseByteArray(os, data, 0, data.length, max_length);
    }

    protected static void serialiseByteArray(DataOutputStream os, byte[] data, int start, int length, int max_length) throws IOException {
        DHTUDPUtils.serialiseLength(os, length, max_length);
        os.write(data, start, length);
    }

    protected static void serialiseByteArrayArray(DataOutputStream os, byte[][] data, int max_length) throws IOException {
        DHTUDPUtils.serialiseLength(os, data.length, max_length);
        for (int i = 0; i < data.length; ++i) {
            DHTUDPUtils.serialiseByteArray(os, data[i], max_length);
        }
    }

    protected static byte[][] deserialiseByteArrayArray(DataInputStream is, int max_length) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, max_length);
        byte[][] data = new byte[len][];
        for (int i = 0; i < data.length; ++i) {
            data[i] = DHTUDPUtils.deserialiseByteArray(is, max_length);
        }
        return data;
    }

    protected static void serialiseAddress(DataOutputStream os, InetSocketAddress address) throws IOException, DHTTransportException {
        InetAddress ia = address.getAddress();
        if (ia == null) {
            Debug.out("Address '" + address + "' is unresolved");
            throw new DHTTransportException("Address '" + address + "' is unresolved");
        }
        DHTUDPUtils.serialiseByteArray(os, ia.getAddress(), 16);
        os.writeShort(address.getPort());
    }

    protected static InetSocketAddress deserialiseAddress(DataInputStream is) throws IOException {
        byte[] bytes = DHTUDPUtils.deserialiseByteArray(is, 16);
        int port = is.readShort() & 0xFFFF;
        return new InetSocketAddress(InetAddress.getByAddress(bytes), port);
    }

    protected static DHTTransportValue[][] deserialiseTransportValuesArray(DHTUDPPacket packet, DataInputStream is, long skew, int max_length) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, max_length);
        DHTTransportValue[][] data = new DHTTransportValue[len][];
        for (int i = 0; i < data.length; ++i) {
            data[i] = DHTUDPUtils.deserialiseTransportValues(packet, is, skew);
        }
        return data;
    }

    protected static void serialiseTransportValuesArray(DHTUDPPacket packet, DataOutputStream os, DHTTransportValue[][] values, long skew, int max_length) throws IOException, DHTTransportException {
        DHTUDPUtils.serialiseLength(os, values.length, max_length);
        for (int i = 0; i < values.length; ++i) {
            DHTUDPUtils.serialiseTransportValues(packet, os, values[i], skew);
        }
    }

    protected static void serialiseContact(DataOutputStream os, DHTTransportContact contact) throws IOException, DHTTransportException {
        if (!(contact.getTransport() instanceof DHTTransportUDP)) {
            throw new IOException("Unsupported contact type:" + contact.getClass().getName());
        }
        os.writeByte(1);
        os.writeByte(contact.getProtocolVersion());
        DHTUDPUtils.serialiseAddress(os, contact.getExternalAddress());
    }

    protected static DHTTransportUDPContactImpl deserialiseContact(DHTTransportUDPImpl transport, DataInputStream is) throws IOException, DHTTransportException {
        byte ct = is.readByte();
        if (ct != 1) {
            throw new IOException("Unsupported contact type:" + ct);
        }
        byte version = is.readByte();
        InetSocketAddress external_address = DHTUDPUtils.deserialiseAddress(is);
        return new DHTTransportUDPContactImpl(false, transport, external_address, external_address, version, 0, 0L);
    }

    protected static DHTTransportValue[] deserialiseTransportValues(DHTUDPPacket packet, DataInputStream is, long skew) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, 65535);
        ArrayList<DHTTransportValue> l = new ArrayList<DHTTransportValue>(len);
        for (int i = 0; i < len; ++i) {
            try {
                l.add(DHTUDPUtils.deserialiseTransportValue(packet, is, skew));
                continue;
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
            }
        }
        DHTTransportValue[] res = new DHTTransportValue[l.size()];
        l.toArray(res);
        return res;
    }

    protected static void serialiseTransportValues(DHTUDPPacket packet, DataOutputStream os, DHTTransportValue[] values, long skew) throws IOException, DHTTransportException {
        DHTUDPUtils.serialiseLength(os, values.length, 65535);
        for (int i = 0; i < values.length; ++i) {
            DHTUDPUtils.serialiseTransportValue(packet, os, values[i], skew);
        }
    }

    protected static DHTTransportValue deserialiseTransportValue(DHTUDPPacket packet, DataInputStream is, long skew) throws IOException, DHTTransportException {
        final int version = packet.getProtocolVersion() >= 11 ? is.readInt() : -1;
        final long created = is.readLong() + skew;
        final byte[] value_bytes = DHTUDPUtils.deserialiseByteArray(is, 512);
        final DHTTransportUDPContactImpl originator = DHTUDPUtils.deserialiseContact(packet.getTransport(), is);
        final int flags = is.readByte() & 0xFF;
        final int life_hours = packet.getProtocolVersion() >= 23 ? is.readByte() & 0xFF : 0;
        final byte rep_control = packet.getProtocolVersion() >= 24 ? (byte)is.readByte() : (byte)-1;
        DHTTransportValue value = new DHTTransportValue(){

            public boolean isLocal() {
                return false;
            }

            public long getCreationTime() {
                return created;
            }

            public byte[] getValue() {
                return value_bytes;
            }

            public int getVersion() {
                return version;
            }

            public DHTTransportContact getOriginator() {
                return originator;
            }

            public int getFlags() {
                return flags;
            }

            public int getLifeTimeHours() {
                return life_hours;
            }

            public byte getReplicationControl() {
                return rep_control;
            }

            public byte getReplicationFactor() {
                return rep_control == -1 ? (byte)-1 : (byte)(rep_control & 0xF);
            }

            public byte getReplicationFrequencyHours() {
                return rep_control == -1 ? (byte)-1 : (byte)(rep_control >> 4);
            }

            public String getString() {
                long now = SystemTime.getCurrentTime();
                return DHTLog.getString(value_bytes) + " - " + new String(value_bytes) + "{v=" + version + ",f=" + Integer.toHexString(flags) + ",l=" + life_hours + ",r=" + Integer.toHexString(this.getReplicationControl()) + ",ca=" + (now - created) + ",or=" + originator.getString() + "}";
            }
        };
        return value;
    }

    protected static void serialiseTransportValue(DHTUDPPacket packet, DataOutputStream os, DHTTransportValue value, long skew) throws IOException, DHTTransportException {
        if (packet.getProtocolVersion() >= 11) {
            int version = value.getVersion();
            os.writeInt(version);
        } else {
            os.writeInt(0);
        }
        os.writeLong(value.getCreationTime() + skew);
        DHTUDPUtils.serialiseByteArray(os, value.getValue(), 512);
        DHTUDPUtils.serialiseContact(os, value.getOriginator());
        os.writeByte(value.getFlags());
        if (packet.getProtocolVersion() >= 23) {
            os.writeByte(value.getLifeTimeHours());
        }
        if (packet.getProtocolVersion() >= 24) {
            os.writeByte(value.getReplicationControl());
        }
    }

    protected static void serialiseContacts(DataOutputStream os, DHTTransportContact[] contacts) throws IOException {
        DHTUDPUtils.serialiseLength(os, contacts.length, 65535);
        for (int i = 0; i < contacts.length; ++i) {
            try {
                DHTUDPUtils.serialiseContact(os, contacts[i]);
                continue;
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
                throw new IOException(e.getMessage());
            }
        }
    }

    protected static DHTTransportContact[] deserialiseContacts(DHTTransportUDPImpl transport, DataInputStream is) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, 65535);
        ArrayList<DHTTransportUDPContactImpl> l = new ArrayList<DHTTransportUDPContactImpl>(len);
        for (int i = 0; i < len; ++i) {
            try {
                l.add(DHTUDPUtils.deserialiseContact(transport, is));
                continue;
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
            }
        }
        DHTTransportContact[] res = new DHTTransportContact[l.size()];
        l.toArray(res);
        return res;
    }

    protected static void serialiseVivaldi(DHTUDPPacketReply reply, DataOutputStream os) throws IOException {
        DHTNetworkPosition[] nps = reply.getNetworkPositions();
        if (reply.getProtocolVersion() >= 15) {
            os.writeByte((byte)nps.length);
            boolean v1_found = false;
            for (int i = 0; i < nps.length; ++i) {
                DHTNetworkPosition np = nps[i];
                if (np.getPositionType() == 1) {
                    v1_found = true;
                }
                os.writeByte(np.getPositionType());
                os.writeByte(np.getSerialisedSize());
                np.serialise(os);
            }
            if (!v1_found) {
                Debug.out("Vivaldi V1 missing");
                throw new IOException("Vivaldi V1 missing");
            }
        } else {
            for (int i = 0; i < nps.length; ++i) {
                if (nps[i].getPositionType() != 1) continue;
                nps[i].serialise(os);
                return;
            }
            Debug.out("Vivaldi V1 missing");
            throw new IOException("Vivaldi V1 missing");
        }
    }

    protected static void deserialiseVivaldi(DHTUDPPacketReply reply, DataInputStream is) throws IOException {
        DHTNetworkPosition[] nps;
        if (reply.getProtocolVersion() >= 15) {
            int entries = is.readByte() & 0xFF;
            nps = new DHTNetworkPosition[entries];
            int skipped = 0;
            for (int i = 0; i < entries; ++i) {
                byte type = is.readByte();
                int size = is.readByte();
                DHTNetworkPosition np = DHTNetworkPositionManager.deserialise(reply.getAddress().getAddress(), type, is);
                if (np == null) {
                    ++skipped;
                    for (int j = 0; j < size; ++j) {
                        is.readByte();
                    }
                    continue;
                }
                nps[i] = np;
            }
            if (skipped > 0) {
                DHTNetworkPosition[] x = new DHTNetworkPosition[entries - skipped];
                int pos = 0;
                for (int i = 0; i < nps.length; ++i) {
                    if (nps[i] == null) continue;
                    x[pos++] = nps[i];
                }
                nps = x;
            }
        } else {
            nps = new DHTNetworkPosition[]{DHTNetworkPositionManager.deserialise(reply.getAddress().getAddress(), (byte)1, is)};
        }
        boolean v1_found = false;
        for (int i = 0; i < nps.length; ++i) {
            if (nps[i].getPositionType() != 1) continue;
            v1_found = true;
        }
        if (!v1_found) {
            throw new IOException("Vivaldi V1 missing");
        }
        reply.setNetworkPositions(nps);
    }

    protected static void serialiseStats(int version, DataOutputStream os, DHTTransportFullStats stats2) throws IOException {
        os.writeLong(stats2.getDBValuesStored());
        os.writeLong(stats2.getRouterNodes());
        os.writeLong(stats2.getRouterLeaves());
        os.writeLong(stats2.getRouterContacts());
        os.writeLong(stats2.getTotalBytesReceived());
        os.writeLong(stats2.getTotalBytesSent());
        os.writeLong(stats2.getTotalPacketsReceived());
        os.writeLong(stats2.getTotalPacketsSent());
        os.writeLong(stats2.getTotalPingsReceived());
        os.writeLong(stats2.getTotalFindNodesReceived());
        os.writeLong(stats2.getTotalFindValuesReceived());
        os.writeLong(stats2.getTotalStoresReceived());
        os.writeLong(stats2.getAverageBytesReceived());
        os.writeLong(stats2.getAverageBytesSent());
        os.writeLong(stats2.getAveragePacketsReceived());
        os.writeLong(stats2.getAveragePacketsSent());
        os.writeLong(stats2.getIncomingRequests());
        String azversion = stats2.getVersion() + "[" + version + "]";
        DHTUDPUtils.serialiseByteArray(os, azversion.getBytes(), 64);
        os.writeLong(stats2.getRouterUptime());
        os.writeInt(stats2.getRouterCount());
        if (version >= 14) {
            os.writeLong(stats2.getDBKeysBlocked());
            os.writeLong(stats2.getTotalKeyBlocksReceived());
        }
        if (version >= 20) {
            os.writeLong(stats2.getDBKeyCount());
            os.writeLong(stats2.getDBValueCount());
            os.writeLong(stats2.getDBStoreSize());
            os.writeLong(stats2.getDBKeyDivFreqCount());
            os.writeLong(stats2.getDBKeyDivSizeCount());
        }
    }

    protected static DHTTransportFullStats deserialiseStats(int version, DataInputStream is) throws IOException {
        long db_size_divs;
        long db_freq_divs;
        long db_store_size;
        long db_value_count;
        long db_key_count;
        long total_key_blocks_received;
        long db_keys_blocked;
        final long db_values_stored = is.readLong();
        final long router_nodes = is.readLong();
        final long router_leaves = is.readLong();
        final long router_contacts = is.readLong();
        final long total_bytes_received = is.readLong();
        final long total_bytes_sent = is.readLong();
        final long total_packets_received = is.readLong();
        final long total_packets_sent = is.readLong();
        final long total_pings_received = is.readLong();
        final long total_find_nodes_received = is.readLong();
        final long total_find_values_received = is.readLong();
        final long total_stores_received = is.readLong();
        final long average_bytes_received = is.readLong();
        final long average_bytes_sent = is.readLong();
        final long average_packets_received = is.readLong();
        final long average_packets_sent = is.readLong();
        final long incoming_requests = is.readLong();
        final String az_version = new String(DHTUDPUtils.deserialiseByteArray(is, 64));
        final long router_uptime = is.readLong();
        final int router_count = is.readInt();
        if (version >= 14) {
            db_keys_blocked = is.readLong();
            total_key_blocks_received = is.readLong();
        } else {
            db_keys_blocked = -1L;
            total_key_blocks_received = -1L;
        }
        if (version >= 20) {
            db_key_count = is.readLong();
            db_value_count = is.readLong();
            db_store_size = is.readLong();
            db_freq_divs = is.readLong();
            db_size_divs = is.readLong();
        } else {
            db_key_count = -1L;
            db_value_count = -1L;
            db_store_size = -1L;
            db_freq_divs = -1L;
            db_size_divs = -1L;
        }
        DHTTransportFullStats res = new DHTTransportFullStats(){

            public long getDBValuesStored() {
                return db_values_stored;
            }

            public long getDBKeysBlocked() {
                return db_keys_blocked;
            }

            public long getDBValueCount() {
                return db_value_count;
            }

            public long getDBKeyCount() {
                return db_key_count;
            }

            public long getDBKeyDivSizeCount() {
                return db_size_divs;
            }

            public long getDBKeyDivFreqCount() {
                return db_freq_divs;
            }

            public long getDBStoreSize() {
                return db_store_size;
            }

            public long getRouterNodes() {
                return router_nodes;
            }

            public long getRouterLeaves() {
                return router_leaves;
            }

            public long getRouterContacts() {
                return router_contacts;
            }

            public long getRouterUptime() {
                return router_uptime;
            }

            public int getRouterCount() {
                return router_count;
            }

            public long getTotalBytesReceived() {
                return total_bytes_received;
            }

            public long getTotalBytesSent() {
                return total_bytes_sent;
            }

            public long getTotalPacketsReceived() {
                return total_packets_received;
            }

            public long getTotalPacketsSent() {
                return total_packets_sent;
            }

            public long getTotalPingsReceived() {
                return total_pings_received;
            }

            public long getTotalFindNodesReceived() {
                return total_find_nodes_received;
            }

            public long getTotalFindValuesReceived() {
                return total_find_values_received;
            }

            public long getTotalStoresReceived() {
                return total_stores_received;
            }

            public long getTotalKeyBlocksReceived() {
                return total_key_blocks_received;
            }

            public long getAverageBytesReceived() {
                return average_bytes_received;
            }

            public long getAverageBytesSent() {
                return average_bytes_sent;
            }

            public long getAveragePacketsReceived() {
                return average_packets_received;
            }

            public long getAveragePacketsSent() {
                return average_packets_sent;
            }

            public long getIncomingRequests() {
                return incoming_requests;
            }

            public String getVersion() {
                return az_version;
            }

            public String getString() {
                return "transport:" + this.getTotalBytesReceived() + "," + this.getTotalBytesSent() + "," + this.getTotalPacketsReceived() + "," + this.getTotalPacketsSent() + "," + this.getTotalPingsReceived() + "," + this.getTotalFindNodesReceived() + "," + this.getTotalFindValuesReceived() + "," + this.getTotalStoresReceived() + "," + this.getTotalKeyBlocksReceived() + "," + this.getAverageBytesReceived() + "," + this.getAverageBytesSent() + "," + this.getAveragePacketsReceived() + "," + this.getAveragePacketsSent() + "," + this.getIncomingRequests() + ",router:" + this.getRouterNodes() + "," + this.getRouterLeaves() + "," + this.getRouterContacts() + ",database:" + this.getDBKeyCount() + "," + this.getDBValueCount() + "," + this.getDBValuesStored() + "," + this.getDBStoreSize() + "," + this.getDBKeyDivFreqCount() + "," + this.getDBKeyDivSizeCount() + "," + this.getDBKeysBlocked() + ",version:" + this.getVersion() + "," + this.getRouterUptime() + "," + this.getRouterCount();
            }
        };
        return res;
    }
}

