/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import java.io.File;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscodeProfileImpl
implements TranscodeProfile {
    private TranscodeProvider provider;
    private String uid;
    private String name;
    private Map<String, String> properties;

    protected TranscodeProfileImpl(TranscodeProvider _provider, String _uid, String _name, Map<String, String> _properties) {
        this.provider = _provider;
        this.uid = _uid;
        this.name = _name;
        this.properties = _properties;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    public String getName() {
        String displayName = this.properties.get("display-name");
        return displayName == null ? this.name : displayName;
    }

    @Override
    public TranscodeProvider getProvider() {
        return this.provider;
    }

    @Override
    public boolean isStreamable() {
        String res = this.properties.get("streamable");
        return res != null && res.equalsIgnoreCase("yes");
    }

    @Override
    public String getFileExtension() {
        return this.properties.get("file-ext");
    }

    @Override
    public String getDeviceClassification() {
        return this.properties.get("device");
    }

    @Override
    public String getDescription() {
        String res = this.properties.get("desc");
        return res == null ? "" : res;
    }

    @Override
    public String getIconURL() {
        return this.properties.get("icon-url");
    }

    @Override
    public int getIconIndex() {
        String o = this.properties.get("icon-index");
        if (o instanceof Number) {
            return ((Number)((Object)o)).intValue();
        }
        return 0;
    }

    @Override
    public File getAssetDirectory() {
        return this.provider.getAssetDirectory();
    }
}

