/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.content;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.content.ContentException;
import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.core.content.RelatedContentLookupListener;
import com.aelitis.azureus.core.content.RelatedContentManagerListener;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import com.aelitis.azureus.util.ImportExportUtils;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseException;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseProgressListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferHandler;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferType;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.utils.search.SearchException;
import org.gudy.azureus2.plugins.utils.search.SearchInstance;
import org.gudy.azureus2.plugins.utils.search.SearchObserver;
import org.gudy.azureus2.plugins.utils.search.SearchResult;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelatedContentManager
implements DistributedDatabaseTransferHandler {
    private static final boolean TRACE = false;
    public static final boolean DISABLE_ALL_UI = !Constants.isCVSVersion() && COConfigurationManager.getStringParameter("ui", "az3").equals("az3");
    private static final int MAX_HISTORY = 16;
    private static final int MAX_TITLE_LENGTH = 80;
    private static final int MAX_CONCURRENT_PUBLISH = 2;
    private static final int MAX_REMOTE_SEARCH_RESULTS = 30;
    private static final int MAX_REMOTE_SEARCH_CONTACTS = 50;
    private static final int MAX_REMOTE_SEARCH_MILLIS = 25000;
    private static final int TEMPORARY_SPACE_DELTA = 50;
    private static final int MAX_RANK = 100;
    private static final String CONFIG_FILE = "rcm.config";
    private static final String PERSIST_DEL_FILE = "rcmx.config";
    private static final String CONFIG_TOTAL_UNREAD = "rcm.numunread.cache";
    private static RelatedContentManager singleton;
    private static AzureusCore core;
    private PluginInterface plugin_interface;
    private TorrentAttribute ta_networks;
    private DHTPlugin dht_plugin;
    private long global_random_id = -1L;
    private LinkedList<DownloadInfo> download_infos1 = new LinkedList();
    private LinkedList<DownloadInfo> download_infos2 = new LinkedList();
    private ByteArrayHashMapEx<DownloadInfo> download_info_map = new ByteArrayHashMapEx();
    private Set<String> download_priv_set = new HashSet<String>();
    private final boolean enabled;
    private int max_search_level;
    private int max_results;
    private AtomicInteger temporary_space = new AtomicInteger();
    private int publishing_count = 0;
    private CopyOnWriteList<RelatedContentManagerListener> listeners = new CopyOnWriteList();
    private AESemaphore initialisation_complete_sem = new AESemaphore("RCM:init");
    private static final int TIMER_PERIOD = 30000;
    private static final int CONFIG_SAVE_PERIOD = 60000;
    private static final int CONFIG_SAVE_TICKS = 2;
    private static final int PUBLISH_CHECK_PERIOD = 30000;
    private static final int PUBLISH_CHECK_TICKS = 1;
    private static final int SECONDARY_LOOKUP_PERIOD = 900000;
    private static final int SECONDARY_LOOKUP_TICKS = 30;
    private static final int REPUBLISH_PERIOD = 28800000;
    private static final int REPUBLISH_TICKS = 960;
    private static final int INITIAL_PUBLISH_DELAY = 180000;
    private static final int INITIAL_PUBLISH_TICKS = 6;
    private static final int CONFIG_DISCARD_MILLIS = 60000;
    private ContentCache content_cache_ref;
    private WeakReference<ContentCache> content_cache;
    private boolean content_dirty;
    private long last_config_access;
    private int content_discard_ticks;
    private AtomicInteger total_unread = new AtomicInteger(COConfigurationManager.getIntParameter("rcm.numunread.cache", 0));
    private AsyncDispatcher content_change_dispatcher = new AsyncDispatcher();
    private static final int SECONDARY_LOOKUP_CACHE_MAX = 10;
    private LinkedList<SecondaryLookup> secondary_lookups = new LinkedList();
    private boolean secondary_lookup_in_progress;
    private long secondary_lookup_complete_time;
    private DistributedDatabase ddb;
    private RCMSearchXFer transfer_type = new RCMSearchXFer();
    private boolean persist;
    private static final int PD_BLOOM_INITIAL_SIZE = 1000;
    private static final int PD_BLOOM_INCREMENT_SIZE = 1000;
    private BloomFilter persist_del_bloom;

    public static synchronized void preInitialise(AzureusCore _core) {
        core = _core;
    }

    public static synchronized RelatedContentManager getSingleton() throws ContentException {
        if (singleton == null) {
            singleton = new RelatedContentManager();
        }
        return singleton;
    }

    protected RelatedContentManager() throws ContentException {
        COConfigurationManager.addAndFireParameterListener("rcm.persist", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                RelatedContentManager.this.persist = COConfigurationManager.getBooleanParameter("rcm.persist");
            }
        });
        if (!FeatureAvailability.isRCMEnabled()) {
            this.enabled = false;
            return;
        }
        this.enabled = true;
        try {
            if (core == null) {
                throw new ContentException("getSingleton called before pre-initialisation");
            }
            while (this.global_random_id == -1L) {
                this.global_random_id = COConfigurationManager.getLongParameter("rcm.random.id", -1L);
                if (this.global_random_id != -1L) continue;
                this.global_random_id = RandomUtils.nextLong();
                COConfigurationManager.setParameter("rcm.random.id", this.global_random_id);
            }
            this.plugin_interface = core.getPluginManager().getDefaultPluginInterface();
            this.ta_networks = this.plugin_interface.getTorrentManager().getAttribute("Networks");
            COConfigurationManager.addAndFireParameterListeners(new String[]{"rcm.ui.enabled", "rcm.max_search_level", "rcm.max_results"}, new ParameterListener(){

                public void parameterChanged(String name) {
                    RelatedContentManager.this.max_search_level = COConfigurationManager.getIntParameter("rcm.max_search_level", 3);
                    RelatedContentManager.this.max_results = COConfigurationManager.getIntParameter("rcm.max_results", 500);
                }
            });
            this.plugin_interface.getUtilities().createDelayedTask(new AERunnable(){

                public void runSupport() {
                    SimpleTimer.addEvent("rcm.delay.init", SystemTime.getOffsetTime(15000L), new TimerEventPerformer(){

                        public void perform(TimerEvent event2) {
                            RelatedContentManager.this.delayedInit();
                        }
                    });
                }
            }).queue();
        }
        catch (Throwable e) {
            this.initialisation_complete_sem.releaseForever();
            if (e instanceof ContentException) {
                throw (ContentException)e;
            }
            throw new ContentException("Initialisation failed", e);
        }
    }

    private void delayedInit() {
        this.plugin_interface.addListener(new PluginListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void initializationComplete() {
                if (!RelatedContentManager.this.persist) {
                    RelatedContentManager.this.deleteRelatedContent();
                }
                try {
                    PluginInterface dht_pi = RelatedContentManager.this.plugin_interface.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
                    if (dht_pi != null) {
                        RelatedContentManager.this.dht_plugin = (DHTPlugin)dht_pi.getPlugin();
                        if (!RelatedContentManager.this.dht_plugin.isEnabled()) {
                            Object var5_2 = null;
                            RelatedContentManager.this.initialisation_complete_sem.releaseForever();
                            return;
                        }
                        DownloadManager dm = RelatedContentManager.this.plugin_interface.getDownloadManager();
                        Download[] downloads = dm.getDownloads();
                        RelatedContentManager.this.addDownloads(downloads, true);
                        dm.addListener(new DownloadManagerListener(){

                            public void downloadAdded(Download download) {
                                RelatedContentManager.this.addDownloads(new Download[]{download}, false);
                            }

                            public void downloadRemoved(Download download) {
                            }
                        }, false);
                        SimpleTimer.addPeriodicEvent("RCM:publisher", 30000L, new TimerEventPerformer(){
                            private int tick_count;

                            public void perform(TimerEvent event2) {
                                ++this.tick_count;
                                if (this.tick_count == 1) {
                                    try {
                                        RelatedContentManager.this.ddb = RelatedContentManager.this.plugin_interface.getDistributedDatabase();
                                        RelatedContentManager.this.ddb.addTransferHandler(RelatedContentManager.this.transfer_type, RelatedContentManager.this);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                if (RelatedContentManager.this.enabled && this.tick_count >= 6) {
                                    if (this.tick_count % 1 == 0) {
                                        RelatedContentManager.this.publish();
                                    }
                                    if (this.tick_count % 30 == 0) {
                                        RelatedContentManager.this.secondaryLookup();
                                    }
                                    if (this.tick_count % 960 == 0) {
                                        RelatedContentManager.this.republish();
                                    }
                                    if (this.tick_count % 2 == 0) {
                                        RelatedContentManager.this.saveRelatedContent();
                                    }
                                }
                            }
                        });
                    }
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    RelatedContentManager.this.initialisation_complete_sem.releaseForever();
                    throw throwable;
                }
                Object var5_3 = null;
                RelatedContentManager.this.initialisation_complete_sem.releaseForever();
            }

            public void closedownInitiated() {
                RelatedContentManager.this.saveRelatedContent();
            }

            public void closedownComplete() {
            }
        });
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxSearchLevel() {
        return this.max_search_level;
    }

    public void setMaxSearchLevel(int _level) {
        COConfigurationManager.setParameter("rcm.max_search_level", _level);
    }

    public int getMaxResults() {
        return this.max_results;
    }

    public void setMaxResults(int _max) {
        COConfigurationManager.setParameter("rcm.max_results", _max);
        this.enforceMaxResults(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDownloads(Download[] downloads, boolean initialising) {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ArrayList<DownloadInfo> new_info = new ArrayList<DownloadInfo>(downloads.length);
            for (Download download : downloads) {
                try {
                    int seeds_leechers;
                    DownloadManagerState state;
                    String[] networks;
                    byte[] hash;
                    Torrent torrent;
                    if (!download.isPersistent() || (torrent = download.getTorrent()) == null || this.download_info_map.containsKey(hash = torrent.getHash()) || (networks = download.getListAttribute(this.ta_networks)) == null) continue;
                    boolean public_net = false;
                    for (int i = 0; i < networks.length; ++i) {
                        if (!networks[i].equalsIgnoreCase("Public")) continue;
                        public_net = true;
                        break;
                    }
                    TOTorrent to_torrent = PluginCoreUtils.unwrap(torrent);
                    if (!public_net || TorrentUtils.isReallyPrivate(to_torrent) || (state = PluginCoreUtils.unwrap(download).getDownloadState()).getFlag(16L)) continue;
                    long rand = this.global_random_id ^ state.getLongParameter("rand");
                    long cache = state.getLongAttribute("scrapecache");
                    if (cache == -1L) {
                        seeds_leechers = -1;
                    } else {
                        int seeds = (int)(cache >> 32 & 0xFFFFFFL);
                        int leechers = (int)(cache & 0xFFFFFFL);
                        seeds_leechers = seeds << 16 | leechers & 0xFFFF;
                    }
                    DownloadInfo info = new DownloadInfo(hash, hash, download.getName(), (int)rand, torrent.isPrivate() ? StringInterner.intern(torrent.getAnnounceURL().getHost()) : null, 0, false, torrent.getSize(), (int)(to_torrent.getCreationDate() / 3600L), seeds_leechers, (byte)PlatformTorrentUtils.getContentNetworkID(to_torrent));
                    new_info.add(info);
                    if (initialising || this.download_infos1.size() == 0) {
                        this.download_infos1.add(info);
                    } else {
                        this.download_infos1.add(RandomUtils.nextInt(this.download_infos1.size()), info);
                    }
                    this.download_infos2.add(info);
                    this.download_info_map.put(hash, info);
                    if (info.getTracker() == null) continue;
                    this.download_priv_set.add(this.getPrivateInfoKey(info));
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            List history = COConfigurationManager.getListParameter("rcm.dlinfo.history", new ArrayList());
            if (initialising) {
                int padd = 16 - this.download_info_map.size();
                for (int i = 0; i < history.size() && padd > 0; ++i) {
                    try {
                        DownloadInfo info = this.deserialiseDI((Map)history.get(i), null);
                        if (info == null || this.download_info_map.containsKey(info.getHash())) continue;
                        this.download_info_map.put(info.getHash(), info);
                        if (info.getTracker() != null) {
                            this.download_priv_set.add(this.getPrivateInfoKey(info));
                        }
                        this.download_infos1.add(info);
                        this.download_infos2.add(info);
                        --padd;
                        continue;
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                Collections.shuffle(this.download_infos1);
            } else if (new_info.size() > 0) {
                for (DownloadInfo info : new_info) {
                    Map<String, Object> map = this.serialiseDI(info, null);
                    if (map == null) continue;
                    history.add(map);
                }
                while (history.size() > 16) {
                    history.remove(0);
                }
                COConfigurationManager.setParameter("rcm.dlinfo.history", history);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void republish() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            if (this.publishing_count > 0) {
                return;
            }
            if (this.download_infos1.isEmpty()) {
                List list = this.download_info_map.values();
                this.download_infos1.addAll(list);
                this.download_infos2.addAll(list);
                Collections.shuffle(this.download_infos1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish() {
        while (true) {
            DownloadInfo info1 = null;
            DownloadInfo info2 = null;
            RelatedContentManager relatedContentManager = this;
            synchronized (relatedContentManager) {
                if (this.publishing_count >= 2) {
                    return;
                }
                if (this.download_infos1.isEmpty() || this.download_info_map.size() == 1) {
                    return;
                }
                info1 = this.download_infos1.removeFirst();
                Iterator it = this.download_infos2.iterator();
                while (it.hasNext()) {
                    info2 = (DownloadInfo)it.next();
                    if (info1 == info2 && this.download_infos2.size() != 1) continue;
                    it.remove();
                    break;
                }
                if (info1 == info2 && ((info2 = this.download_info_map.getRandomValueExcluding(info1)) == null || info1 == info2)) {
                    return;
                }
                ++this.publishing_count;
            }
            try {
                this.publish(info1, info2);
                continue;
            }
            catch (Throwable e) {
                RelatedContentManager relatedContentManager2 = this;
                synchronized (relatedContentManager2) {
                    --this.publishing_count;
                }
                Debug.out(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishNext() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            --this.publishing_count;
            if (this.publishing_count < 0) {
                this.publishing_count = 0;
            }
        }
        this.publish();
    }

    protected void publish(final DownloadInfo from_info, DownloadInfo to_info) throws Exception {
        long size;
        final String from_hash = ByteFormatter.encodeString(from_info.getHash());
        final String to_hash = ByteFormatter.encodeString(to_info.getHash());
        final byte[] key_bytes = ("az:rcm:assoc:" + from_hash).getBytes("UTF-8");
        String title = to_info.getTitle();
        if (title.length() > 80) {
            title = title.substring(0, 80);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("d", title);
        map.put("r", new Long(Math.abs(to_info.getRand() % 1000)));
        String tracker = to_info.getTracker();
        if (tracker == null) {
            map.put("h", to_info.getHash());
        } else {
            map.put("t", tracker);
        }
        if (to_info.getLevel() == 0) {
            try {
                Download d = to_info.getRelatedToDownload();
                if (d != null) {
                    Torrent torrent = d.getTorrent();
                    if (torrent != null) {
                        long secs;
                        long hours;
                        long cnet = PlatformTorrentUtils.getContentNetworkID(PluginCoreUtils.unwrap(torrent));
                        if (cnet != -1L) {
                            map.put("c", new Long(cnet));
                        }
                        if ((hours = (secs = torrent.getCreationDate()) / 3600L) > 0L) {
                            map.put("p", new Long(hours));
                        }
                    }
                    int leechers = -1;
                    int seeds = -1;
                    long cache = PluginCoreUtils.unwrap(d).getDownloadState().getLongAttribute("scrapecache");
                    if (cache != -1L) {
                        seeds = (int)(cache >> 32 & 0xFFFFFFL);
                        leechers = (int)(cache & 0xFFFFFFL);
                    }
                    if (leechers > 0) {
                        map.put("l", new Long(leechers));
                    }
                    if (seeds > 0) {
                        map.put("z", new Long(seeds));
                    }
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if ((size = to_info.getSize()) != 0L) {
            map.put("s", new Long(size));
        }
        final byte[] map_bytes = BEncoder.encode(map);
        int max_hits = 30;
        this.dht_plugin.get(key_bytes, "Content relationship read: " + from_hash, (byte)0, 30, 30000L, false, false, new DHTPluginOperationListener(){
            private boolean diversified;
            private int hits;
            private Set<String> entries = new HashSet<String>();

            public void starts(byte[] key) {
            }

            public void diversified() {
                this.diversified = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                try {
                    Map map = BDecoder.decode(value.getValue());
                    String title = new String((byte[])map.get("d"), "UTF-8");
                    String tracker = null;
                    byte[] hash = (byte[])map.get("h");
                    if (hash == null) {
                        tracker = new String((byte[])map.get("t"), "UTF-8");
                    }
                    int rand = ((Long)map.get("r")).intValue();
                    String key = title + " % " + rand;
                    Set<String> set = this.entries;
                    synchronized (set) {
                        if (this.entries.contains(key)) {
                            return;
                        }
                        this.entries.add(key);
                    }
                    Long l_size = (Long)map.get("s");
                    long size = l_size == null ? 0L : l_size;
                    Long cnet = (Long)map.get("c");
                    Long published = (Long)map.get("p");
                    Long leechers = (Long)map.get("l");
                    Long seeds = (Long)map.get("z");
                    int seeds_leechers = leechers == null && seeds == null ? -1 : (leechers == null ? seeds.intValue() << 16 : (seeds == null ? leechers.intValue() & 0xFFFF : seeds.intValue() << 16 | leechers.intValue() & 0xFFFF));
                    RelatedContentManager.this.analyseResponse(new DownloadInfo(from_info.getHash(), hash, title, rand, tracker, 1, false, size, published == null ? 0 : published.intValue(), seeds_leechers, (byte)(cnet == null ? -1L : (long)cnet.byteValue())), null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++this.hits;
            }

            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            public void complete(byte[] key, boolean timeout_occurred) {
                boolean do_it;
                if (this.diversified || this.hits >= 10) {
                    do_it = false;
                } else if (this.hits <= 5) {
                    do_it = true;
                } else {
                    boolean bl = do_it = RandomUtils.nextInt(this.hits - 5 + 1) == 0;
                }
                if (do_it) {
                    try {
                        RelatedContentManager.this.dht_plugin.put(key_bytes, "Content relationship: " + from_hash + " -> " + to_hash, map_bytes, (byte)16, new DHTPluginOperationListener(){

                            public void diversified() {
                            }

                            public void starts(byte[] key) {
                            }

                            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                            }

                            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                            }

                            public void complete(byte[] key, boolean timeout_occurred) {
                                RelatedContentManager.this.publishNext();
                            }
                        });
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        RelatedContentManager.this.publishNext();
                    }
                } else {
                    RelatedContentManager.this.publishNext();
                }
            }
        });
    }

    public void lookupContent(final byte[] hash, final RelatedContentLookupListener listener) throws ContentException {
        if (hash == null) {
            throw new ContentException("hash is null");
        }
        if (!this.initialisation_complete_sem.isReleasedForever() || this.dht_plugin != null && this.dht_plugin.isInitialising()) {
            AsyncDispatcher dispatcher = new AsyncDispatcher();
            dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    try {
                        RelatedContentManager.this.initialisation_complete_sem.reserve();
                        RelatedContentManager.this.lookupContentSupport(hash, 0, true, listener);
                    }
                    catch (ContentException e) {
                        Debug.out(e);
                    }
                }
            });
        } else {
            this.lookupContentSupport(hash, 0, true, listener);
        }
    }

    private void lookupContentSupport(final byte[] from_hash, final int level, final boolean explicit, final RelatedContentLookupListener listener) throws ContentException {
        try {
            if (this.dht_plugin == null) {
                throw new ContentException("DHT plugin unavailable");
            }
            String from_hash_str = ByteFormatter.encodeString(from_hash);
            byte[] key_bytes = ("az:rcm:assoc:" + from_hash_str).getBytes("UTF-8");
            int max_hits = 30;
            this.dht_plugin.get(key_bytes, "Content relationship read: " + from_hash_str, (byte)0, 30, 60000L, false, true, new DHTPluginOperationListener(){
                private Set<String> entries = new HashSet<String>();
                private RelatedContentManagerListener manager_listener = new RelatedContentManagerListener(){
                    private Set<RelatedContent> content_list = new HashSet<RelatedContent>();

                    public void contentFound(RelatedContent[] content) {
                        this.handle(content);
                    }

                    public void contentChanged(RelatedContent[] content) {
                        this.handle(content);
                    }

                    public void contentRemoved(RelatedContent[] content) {
                    }

                    public void contentChanged() {
                    }

                    public void contentReset() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void handle(RelatedContent[] content) {
                        Set<RelatedContent> set = this.content_list;
                        synchronized (set) {
                            if (this.content_list.contains(content)) {
                                return;
                            }
                            for (RelatedContent c : content) {
                                this.content_list.add(c);
                            }
                        }
                        listener.contentFound(content);
                    }
                };

                public void starts(byte[] key) {
                    if (listener != null) {
                        try {
                            listener.lookupStart();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }

                public void diversified() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    try {
                        Map map = BDecoder.decode(value.getValue());
                        String title = new String((byte[])map.get("d"), "UTF-8");
                        String tracker = null;
                        byte[] hash = (byte[])map.get("h");
                        if (hash == null) {
                            tracker = new String((byte[])map.get("t"), "UTF-8");
                        }
                        int rand = ((Long)map.get("r")).intValue();
                        String key = title + " % " + rand;
                        Set<String> set = this.entries;
                        synchronized (set) {
                            if (this.entries.contains(key)) {
                                return;
                            }
                            this.entries.add(key);
                        }
                        Long l_size = (Long)map.get("s");
                        long size = l_size == null ? 0L : l_size;
                        Long cnet = (Long)map.get("c");
                        Long published = (Long)map.get("p");
                        Long leechers = (Long)map.get("l");
                        Long seeds = (Long)map.get("z");
                        int seeds_leechers = leechers == null && seeds == null ? -1 : (leechers == null ? seeds.intValue() << 16 : (seeds == null ? leechers.intValue() & 0xFFFF : seeds.intValue() << 16 | leechers.intValue() & 0xFFFF));
                        RelatedContentManager.this.analyseResponse(new DownloadInfo(from_hash, hash, title, rand, tracker, level + 1, explicit, size, published == null ? 0 : published.intValue(), seeds_leechers, (byte)(cnet == null ? -1L : (long)cnet.byteValue())), listener == null ? null : this.manager_listener);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }

                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                public void complete(byte[] key, boolean timeout_occurred) {
                    if (listener != null) {
                        try {
                            listener.lookupComplete();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            ContentException ce = e instanceof ContentException ? (ContentException)e : new ContentException("Lookup failed", e);
            if (listener != null) {
                try {
                    listener.lookupFailed(ce);
                }
                catch (Throwable f) {
                    Debug.out(f);
                }
            }
            throw ce;
        }
    }

    protected void popuplateSecondaryLookups(ContentCache content_cache) {
        Random rand = new Random();
        this.secondary_lookups.clear();
        List primaries = this.download_info_map.values();
        int primary_count = primaries.size();
        int primaries_to_add = primary_count < 2 ? 0 : (primary_count < 5 ? (rand.nextInt(4) == 0 ? 1 : 0) : (primary_count < 10 ? 1 : 2));
        if (primaries_to_add > 0) {
            HashSet<DownloadInfo> added = new HashSet<DownloadInfo>();
            for (int i = 0; i < primaries_to_add; ++i) {
                DownloadInfo info = (DownloadInfo)primaries.get(rand.nextInt(primaries.size()));
                if (added.contains(info)) continue;
                added.add(info);
                this.secondary_lookups.addLast(new SecondaryLookup(info.getHash(), info.getLevel()));
            }
        }
        Map related_content = content_cache.related_content;
        Iterator it = related_content.values().iterator();
        ArrayList<DownloadInfo> secondary_cache_temp = new ArrayList<DownloadInfo>(related_content.size());
        while (it.hasNext()) {
            DownloadInfo di = (DownloadInfo)it.next();
            if (di.getHash() == null || di.getLevel() >= this.max_search_level) continue;
            secondary_cache_temp.add(di);
        }
        int cache_size = Math.min(secondary_cache_temp.size(), 10 - this.secondary_lookups.size());
        if (cache_size > 0) {
            int i;
            for (i = 0; i < cache_size; ++i) {
                int index = rand.nextInt(secondary_cache_temp.size());
                DownloadInfo x = (DownloadInfo)secondary_cache_temp.get(index);
                secondary_cache_temp.set(index, (DownloadInfo)secondary_cache_temp.get(i));
                secondary_cache_temp.set(i, x);
            }
            for (i = 0; i < cache_size; ++i) {
                DownloadInfo x = (DownloadInfo)secondary_cache_temp.get(i);
                this.secondary_lookups.addLast(new SecondaryLookup(x.getHash(), x.getLevel()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void secondaryLookup() {
        SecondaryLookup sl;
        long now = SystemTime.getMonotonousTime();
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            if (this.secondary_lookup_in_progress) {
                return;
            }
            if (now - this.secondary_lookup_complete_time < 900000L) {
                return;
            }
            if (this.secondary_lookups.size() == 0) {
                ContentCache cc;
                ContentCache contentCache = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
                if (cc == null) {
                    cc = this.loadRelatedContent();
                } else {
                    this.popuplateSecondaryLookups(cc);
                }
            }
            if (this.secondary_lookups.size() == 0) {
                return;
            }
            sl = this.secondary_lookups.removeFirst();
            this.secondary_lookup_in_progress = true;
        }
        try {
            this.lookupContentSupport(sl.getHash(), sl.getLevel(), false, new RelatedContentLookupListener(){

                public void lookupStart() {
                }

                public void contentFound(RelatedContent[] content) {
                }

                public void lookupComplete() {
                    this.next();
                }

                public void lookupFailed(ContentException error) {
                    this.next();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void next() {
                    SecondaryLookup next_sl;
                    RelatedContentManager relatedContentManager = RelatedContentManager.this;
                    synchronized (relatedContentManager) {
                        if (RelatedContentManager.this.secondary_lookups.size() == 0) {
                            RelatedContentManager.this.secondary_lookup_in_progress = false;
                            RelatedContentManager.this.secondary_lookup_complete_time = SystemTime.getMonotonousTime();
                            return;
                        }
                        next_sl = (SecondaryLookup)RelatedContentManager.this.secondary_lookups.removeFirst();
                    }
                    final 8 listener = this;
                    SimpleTimer.addEvent("RCM:SLDelay", SystemTime.getOffsetTime(30000L), new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void perform(TimerEvent event2) {
                            try {
                                RelatedContentManager.this.lookupContentSupport(next_sl.getHash(), next_sl.getLevel(), false, listener);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                                RelatedContentManager relatedContentManager = RelatedContentManager.this;
                                synchronized (relatedContentManager) {
                                    RelatedContentManager.this.secondary_lookup_in_progress = false;
                                    RelatedContentManager.this.secondary_lookup_complete_time = SystemTime.getMonotonousTime();
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
            RelatedContentManager relatedContentManager2 = this;
            synchronized (relatedContentManager2) {
                this.secondary_lookup_in_progress = false;
                this.secondary_lookup_complete_time = now;
            }
        }
    }

    protected void contentChanged(final DownloadInfo info) {
        this.setConfigDirty();
        this.content_change_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    try {
                        l.contentChanged(new RelatedContent[]{info});
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected void contentChanged(boolean is_dirty) {
        if (is_dirty) {
            this.setConfigDirty();
        }
        this.content_change_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    try {
                        l.contentChanged();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RelatedContent[] content) {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache content_cache = this.loadRelatedContent();
            this.delete(content, content_cache, true);
        }
    }

    protected void delete(final RelatedContent[] content, ContentCache content_cache, boolean persistent) {
        if (persistent) {
            this.addPersistentlyDeleted(content);
        }
        Map related_content = content_cache.related_content;
        Iterator it = related_content.values().iterator();
        while (it.hasNext()) {
            DownloadInfo di = (DownloadInfo)it.next();
            for (RelatedContent c : content) {
                if (c != di) continue;
                it.remove();
                if (!di.isUnread()) continue;
                this.decrementUnread();
            }
        }
        ByteArrayHashMapEx related_content_map = content_cache.related_content_map;
        ArrayList<byte[]> delete = new ArrayList<byte[]>();
        block2: for (byte[] key : related_content_map.keys()) {
            ArrayList infos = (ArrayList)related_content_map.get(key);
            for (RelatedContent c : content) {
                if (!infos.remove(c) || infos.size() != 0) continue;
                delete.add(key);
                continue block2;
            }
        }
        for (byte[] key : delete) {
            related_content_map.remove(key);
        }
        this.setConfigDirty();
        this.content_change_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    try {
                        l.contentRemoved(content);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected String getPrivateInfoKey(RelatedContent info) {
        return info.getTitle() + ":" + info.getTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void analyseResponse(DownloadInfo to_info, final RelatedContentManagerListener listener) {
        try {
            RelatedContentManager relatedContentManager = this;
            synchronized (relatedContentManager) {
                String key;
                byte[] target = to_info.getHash();
                if (target != null) {
                    if (this.download_info_map.containsKey(target)) {
                        return;
                    }
                    key = Base32.encode(target);
                } else {
                    key = this.getPrivateInfoKey(to_info);
                    if (this.download_priv_set.contains(key)) {
                        return;
                    }
                }
                if (this.isPersistentlyDeleted(to_info)) {
                    return;
                }
                ContentCache content_cache = this.loadRelatedContent();
                DownloadInfo target_info = null;
                boolean changed_content = false;
                boolean new_content = false;
                target_info = (DownloadInfo)content_cache.related_content.get(key);
                if (target_info == null) {
                    if (this.enoughSpaceFor(content_cache, to_info)) {
                        target_info = to_info;
                        content_cache.related_content.put(key, target_info);
                        byte[] from_hash = to_info.getRelatedToHash();
                        ArrayList<DownloadInfo> links = (ArrayList<DownloadInfo>)content_cache.related_content_map.get(from_hash);
                        if (links == null) {
                            links = new ArrayList<DownloadInfo>(1);
                            content_cache.related_content_map.put(from_hash, links);
                        }
                        links.add(target_info);
                        links.trimToSize();
                        target_info.setPublic(content_cache);
                        if (this.secondary_lookups.size() < 10) {
                            byte[] hash = target_info.getHash();
                            int level = target_info.getLevel();
                            if (hash != null && level < this.max_search_level) {
                                this.secondary_lookups.add(new SecondaryLookup(hash, level));
                            }
                        }
                        new_content = true;
                    }
                } else {
                    changed_content = target_info.addInfo(to_info);
                }
                if (target_info != null) {
                    boolean something_changed;
                    final RelatedContent[] f_target = new RelatedContent[]{target_info};
                    final boolean f_change = changed_content;
                    boolean bl = something_changed = changed_content || new_content;
                    if (something_changed) {
                        this.setConfigDirty();
                    }
                    this.content_change_dispatcher.dispatch(new AERunnable(){

                        public void runSupport() {
                            if (something_changed) {
                                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                                    try {
                                        if (f_change) {
                                            l.contentChanged(f_target);
                                            continue;
                                        }
                                        l.contentFound(f_target);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }
                            if (listener != null) {
                                try {
                                    if (f_change) {
                                        listener.contentChanged(f_target);
                                    } else {
                                        listener.contentFound(f_target);
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected boolean enoughSpaceFor(ContentCache content_cache, DownloadInfo fi) {
        Map related_content = content_cache.related_content;
        if (related_content.size() < this.max_results + this.temporary_space.get()) {
            return true;
        }
        Iterator it = related_content.entrySet().iterator();
        int level = fi.getLevel();
        HashMap<Integer, DownloadInfo> oldest_per_rank = new HashMap<Integer, DownloadInfo>();
        int min_rank = Integer.MAX_VALUE;
        while (it.hasNext()) {
            DownloadInfo oldest;
            int rank;
            int info_level;
            Map.Entry entry = it.next();
            DownloadInfo info = (DownloadInfo)entry.getValue();
            if (info.isExplicit() || (info_level = info.getLevel()) < level) continue;
            if (info_level > level) {
                level = info_level;
                min_rank = Integer.MAX_VALUE;
                oldest_per_rank.clear();
            }
            if ((rank = info.getRank()) < min_rank) {
                min_rank = rank;
            }
            if ((oldest = (DownloadInfo)oldest_per_rank.get(rank)) == null) {
                oldest_per_rank.put(rank, info);
                continue;
            }
            if (info.getLastSeenSecs() >= oldest.getLastSeenSecs()) continue;
            oldest_per_rank.put(rank, info);
        }
        DownloadInfo to_remove = (DownloadInfo)oldest_per_rank.get(min_rank);
        if (to_remove != null) {
            this.delete(new RelatedContent[]{to_remove}, content_cache, false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelatedContent[] getRelatedContent() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache content_cache = this.loadRelatedContent();
            return content_cache.related_content.values().toArray(new DownloadInfo[content_cache.related_content.size()]);
        }
    }

    public void reset() {
        this.reset(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset(boolean reset_perm_dels) {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache cc;
            ContentCache contentCache = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
            if (cc == null) {
                FileUtil.deleteResilientConfigFile(CONFIG_FILE);
            } else {
                cc.related_content = new HashMap();
                cc.related_content_map = new ByteArrayHashMapEx();
            }
            this.download_infos1.clear();
            this.download_infos2.clear();
            List list = this.download_info_map.values();
            this.download_infos1.addAll(list);
            this.download_infos2.addAll(list);
            Collections.shuffle(this.download_infos1);
            this.total_unread.set(0);
            if (reset_perm_dels) {
                this.resetPersistentlyDeleted();
            }
            this.setConfigDirty();
        }
        this.content_change_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    l.contentReset();
                }
            }
        });
    }

    protected List<RelatedContent> matchContent(String term) {
        ArrayList<RelatedContent> result = new ArrayList<RelatedContent>();
        RelatedContent[] content = this.getRelatedContent();
        String[] bits = Constants.PAT_SPLIT_SPACE.split(term.toLowerCase());
        int[] bit_types = new int[bits.length];
        Pattern[] bit_patterns = new Pattern[bits.length];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = bits[i].trim();
            String bit = bits[i];
            if (bit.length() <= 0) continue;
            char c = bit.charAt(0);
            if (c == '+') {
                bit_types[i] = 1;
                bit = bits[i] = bit.substring(1);
            } else if (c == '-') {
                bit_types[i] = 2;
                bit = bits[i] = bit.substring(1);
            }
            if (bit.startsWith("(") && bit.endsWith(")")) {
                bit = bit.substring(1, bit.length() - 1);
                try {
                    bit_patterns[i] = Pattern.compile(bit, 2);
                }
                catch (Throwable e) {}
                continue;
            }
            if (!bit.contains("|")) continue;
            try {
                bit_patterns[i] = Pattern.compile(bit, 2);
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        for (RelatedContent c : content) {
            String title = c.getTitle().toLowerCase();
            boolean match = true;
            boolean at_least_one = false;
            for (int i = 0; i < bits.length; ++i) {
                String bit = bits[i];
                if (bit.length() <= 0) continue;
                boolean hit = bit_patterns[i] == null ? title.contains(bit) : bit_patterns[i].matcher(title).find();
                int type = bit_types[i];
                if (hit) {
                    if (type == 2) {
                        match = false;
                        break;
                    }
                    at_least_one = true;
                    continue;
                }
                if (type == 2) {
                    at_least_one = true;
                    continue;
                }
                match = false;
                break;
            }
            if (!match || !at_least_one) continue;
            result.add(c);
        }
        return result;
    }

    public SearchInstance searchRCM(Map<String, Object> search_parameters, final SearchObserver observer) throws SearchException {
        this.initialisation_complete_sem.reserve();
        final String term = (String)search_parameters.get("s");
        final SearchInstance si = new SearchInstance(){

            public void cancel() {
                Debug.out("Cancelled");
            }
        };
        if (term == null) {
            observer.complete();
        } else {
            new AEThread2("RCM:search", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                public void run() {
                    hashes = new HashSet<String>();
                    try {
                        matches = RelatedContentManager.this.matchContent(term);
                        for (final RelatedContent c : matches) {
                            hash = c.getHash();
                            if (hash == null) continue;
                            hashes.add(Base32.encode(hash));
                            result = new SearchResult(){

                                public Object getProperty(int property_name) {
                                    byte[] hash2;
                                    if (property_name == 1) {
                                        return c.getTitle();
                                    }
                                    if (property_name == 3) {
                                        return c.getSize();
                                    }
                                    if (property_name == 21) {
                                        return hash;
                                    }
                                    if (property_name == 17) {
                                        return new Long(c.getRank() / 4);
                                    }
                                    if (property_name == 5) {
                                        return new Long(c.getSeeds());
                                    }
                                    if (property_name == 4) {
                                        return new Long(c.getLeechers());
                                    }
                                    if (property_name == 6) {
                                        if (c.getContentNetwork() != -1L) {
                                            return new Long(1L);
                                        }
                                        return new Long(0L);
                                    }
                                    if (property_name == 2) {
                                        long date = c.getPublishDate();
                                        if (date <= 0L) {
                                            return null;
                                        }
                                        return new Date(date);
                                    }
                                    if ((property_name == 12 || property_name == 16) && (hash2 = c.getHash()) != null) {
                                        return UrlUtils.getMagnetURI(hash2);
                                    }
                                    return null;
                                }
                            };
                            observer.resultReceived(si, result);
                        }
                        var8_7 = null;
                        try {
                            dhts = RelatedContentManager.access$600(RelatedContentManager.this).getDHTs();
                            addresses = new HashSet<InetSocketAddress>();
                            for (DHT dht : dhts) {
                                for (DHTTransportContact c : contacts = dht.getTransport().getReachableContacts()) {
                                    if (c.getProtocolVersion() < 24) continue;
                                    addresses.add(c.getAddress());
                                }
                            }
                            if (addresses.size() < 50) {
                                for (DHT dht : dhts) {
                                    for (DHTTransportContact c : contacts = dht.getTransport().getRecentContacts()) {
                                        if (c.getProtocolVersion() < 24) continue;
                                        addresses.add(c.getAddress());
                                        if (addresses.size() >= 50) break;
                                    }
                                    if (addresses.size() >= 50) break;
                                }
                            }
                            list = new ArrayList<E>(addresses);
                            Collections.shuffle(list);
                            ddb_contacts = new ArrayList<DistributedDatabaseContact>();
                            for (i = 0; i < Math.min(list.size(), 50); ++i) {
                                try {
                                    ddb_contacts.add(RelatedContentManager.access$700(RelatedContentManager.this).importContact((InetSocketAddress)list.get(i), (byte)24));
                                    continue;
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                            start = SystemTime.getMonotonousTime();
                            max = 25000L;
                            sem = new AESemaphore("RCM:rems");
                            sent = 0;
                            done = new int[]{0};
                            for (i = 0; i < ddb_contacts.size(); ++i) {
                                c = (DistributedDatabaseContact)ddb_contacts.get(i);
                                new AEThread2("RCM:rems", true, hashes, c, done, sem){
                                    final /* synthetic */ Set val$hashes;
                                    final /* synthetic */ DistributedDatabaseContact val$c;
                                    final /* synthetic */ int[] val$done;
                                    final /* synthetic */ AESemaphore val$sem;
                                    {
                                        this.val$hashes = set;
                                        this.val$c = distributedDatabaseContact;
                                        this.val$done = nArray;
                                        this.val$sem = aESemaphore;
                                        super(x0, x1);
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void run() {
                                        try {
                                            RelatedContentManager.this.sendRemoteSearch(si, this.val$hashes, this.val$c, term, observer);
                                            Object var2_1 = null;
                                            int[] nArray = this.val$done;
                                        }
                                        catch (Throwable throwable) {
                                            Object var2_2 = null;
                                            int[] nArray = this.val$done;
                                            synchronized (this.val$done) {
                                                this.val$done[0] = this.val$done[0] + 1;
                                                // ** MonitorExit[var3_4] (shouldn't be in output)
                                                this.val$sem.release();
                                                throw throwable;
                                            }
                                        }
                                        synchronized (this.val$done) {
                                            this.val$done[0] = this.val$done[0] + 1;
                                            // ** MonitorExit[var3_3] (shouldn't be in output)
                                            this.val$sem.release();
                                            return;
                                        }
                                    }
                                }.start();
                                ++sent;
                                var22_45 = done;
                                // MONITORENTER : done
                                if (done[0] >= ddb_contacts.size() / 2) {
                                    start = SystemTime.getMonotonousTime();
                                    max = 5000L;
                                    // MONITOREXIT : var22_45
                                    break;
                                }
                                // MONITOREXIT : var22_45
                                if (i <= 10) continue;
                                try {
                                    Thread.sleep(250L);
                                    continue;
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                            for (i = 0; i < sent && done[0] <= sent * 4 / 5 && (elapsed = SystemTime.getMonotonousTime() - start) < max; ++i) {
                                sem.reserve(max - elapsed);
                            }
                            v0 = null;
                        }
                        catch (Throwable var24_47) {
                            v0 = null;
                        }
                        var25_49 = v0;
                        observer.complete();
                        return;
                    }
                    catch (Throwable var7_51) {
                        block34: {
                            var8_8 = null;
                            ** try [egrp 1[TRYBLOCK] [7 : 122->712)] { 
lbl84:
                            // 1 sources

                            dhts = RelatedContentManager.access$600(RelatedContentManager.this).getDHTs();
                            addresses = new HashSet<InetSocketAddress>();
                            for (DHT dht : dhts) {
                                for (DHTTransportContact c : contacts = dht.getTransport().getReachableContacts()) {
                                    if (c.getProtocolVersion() < 24) continue;
                                    addresses.add(c.getAddress());
                                }
                            }
                            if (addresses.size() < 50) {
                                for (DHT dht : dhts) {
                                    for (DHTTransportContact c : contacts = dht.getTransport().getRecentContacts()) {
                                        if (c.getProtocolVersion() < 24) continue;
                                        addresses.add(c.getAddress());
                                        if (addresses.size() >= 50) break;
                                    }
                                    if (addresses.size() >= 50) break;
                                }
                            }
                            list = new ArrayList<E>(addresses);
                            Collections.shuffle(list);
                            ddb_contacts = new ArrayList<DistributedDatabaseContact>();
                            for (i = 0; i < Math.min(list.size(), 50); ++i) {
                                ** try [egrp 2[TRYBLOCK] [2 : 440->477)] { 
lbl108:
                                // 1 sources

                                ddb_contacts.add(RelatedContentManager.access$700(RelatedContentManager.this).importContact((InetSocketAddress)list.get(i), (byte)24));
                                continue;
lbl111:
                                // 1 sources

                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                            start = SystemTime.getMonotonousTime();
                            max = 25000L;
                            sem = new AESemaphore("RCM:rems");
                            sent = 0;
                            done = new int[]{0};
                            for (i = 0; i < ddb_contacts.size(); ++i) {
                                c = (DistributedDatabaseContact)ddb_contacts.get(i);
                                new /* invalid duplicate definition of identical inner class */.start();
                                ++sent;
                                var22_46 = done;
                                // MONITORENTER : done
                                if (done[0] >= ddb_contacts.size() / 2) {
                                    start = SystemTime.getMonotonousTime();
                                    max = 5000L;
                                    // MONITOREXIT : var22_46
                                    break;
                                }
                                // MONITOREXIT : var22_46
                                if (i <= 10) continue;
                                ** try [egrp 4[TRYBLOCK] [6 : 630->639)] { 
lbl133:
                                // 1 sources

                                Thread.sleep(250L);
                                continue;
lbl135:
                                // 1 sources

                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                            for (i = 0; i < sent && done[0] <= sent * 4 / 5 && (elapsed = SystemTime.getMonotonousTime() - start) < max; ++i) {
                                sem.reserve(max - elapsed);
                            }
                            v1 = null;
                            break block34;
lbl144:
                            // 1 sources

                            catch (Throwable var24_48) {
                                v1 = null;
                            }
                        }
                        var25_50 = v1;
                        observer.complete();
                        throw var7_51;
                    }
                }
            }.start();
        }
        return si;
    }

    protected void sendRemoteSearch(SearchInstance si, Set<String> hashes, DistributedDatabaseContact contact, String term, SearchObserver observer) {
        try {
            HashMap<String, String> request2 = new HashMap<String, String>();
            request2.put("t", term);
            DistributedDatabaseKey key = this.ddb.createKey(BEncoder.encode(request2));
            DistributedDatabaseValue value = contact.read(new DistributedDatabaseProgressListener(){

                public void reportSize(long size) {
                }

                public void reportActivity(String str) {
                }

                public void reportCompleteness(int percent) {
                }
            }, this.transfer_type, key, 10000L);
            if (value == null) {
                return;
            }
            Map reply = BDecoder.decode((byte[])value.getValue(byte[].class));
            List list = (List)reply.get("l");
            for (final Map map : list) {
                String hash_str;
                final String title = ImportExportUtils.importString(map, "n");
                final byte[] hash = (byte[])map.get("h");
                if (hash == null || hashes.contains(hash_str = Base32.encode(hash))) continue;
                hashes.add(hash_str);
                SearchResult result = new SearchResult(){

                    public Object getProperty(int property_name) {
                        try {
                            byte[] hash2;
                            if (property_name == 1) {
                                return title;
                            }
                            if (property_name == 3) {
                                return ImportExportUtils.importLong(map, "s");
                            }
                            if (property_name == 21) {
                                return hash;
                            }
                            if (property_name == 17) {
                                return ImportExportUtils.importLong(map, "r") / 4L;
                            }
                            if (property_name == 6) {
                                long cnet = ImportExportUtils.importLong(map, "c", -1L);
                                if (cnet == -1L) {
                                    return 0L;
                                }
                                return 1L;
                            }
                            if (property_name == 5) {
                                return ImportExportUtils.importLong(map, "z");
                            }
                            if (property_name == 4) {
                                return ImportExportUtils.importLong(map, "l");
                            }
                            if (property_name == 2) {
                                long date = ImportExportUtils.importLong(map, "p", 0L) * 60L * 60L * 1000L;
                                if (date <= 0L) {
                                    return null;
                                }
                                return new Date(date);
                            }
                            if ((property_name == 12 || property_name == 16) && (hash2 = (byte[])map.get("h")) != null) {
                                return UrlUtils.getMagnetURI(hash2);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return null;
                    }
                };
                observer.resultReceived(si, result);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    protected Map<String, Object> receiveRemoteSearch(Map<String, Object> request2) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String term = ImportExportUtils.importString(request2, "t");
            if (term != null) {
                List<RelatedContent> matches = this.matchContent(term);
                if (matches.size() > 30) {
                    Collections.sort(matches, new Comparator<RelatedContent>(){

                        @Override
                        public int compare(RelatedContent o1, RelatedContent o2) {
                            return o2.getRank() - o1.getRank();
                        }
                    });
                }
                ArrayList list = new ArrayList();
                for (int i = 0; i < Math.min(matches.size(), 30); ++i) {
                    RelatedContent c = matches.get(i);
                    HashMap<String, byte[]> map = new HashMap<String, byte[]>();
                    list.add(map);
                    ImportExportUtils.exportString(map, "n", c.getTitle());
                    ImportExportUtils.exportLong(map, "s", c.getSize());
                    ImportExportUtils.exportLong(map, "r", c.getRank());
                    ImportExportUtils.exportLong(map, "d", c.getLastSeenSecs());
                    ImportExportUtils.exportLong(map, "p", c.getPublishDate() / 3600000L);
                    ImportExportUtils.exportLong(map, "l", c.getLeechers());
                    ImportExportUtils.exportLong(map, "z", c.getSeeds());
                    ImportExportUtils.exportLong(map, "c", c.getContentNetwork());
                    byte[] hash = c.getHash();
                    if (hash == null) continue;
                    map.put("h", hash);
                }
                response.put("l", list);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return response;
    }

    @Override
    public DistributedDatabaseValue read(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey ddb_key) throws DistributedDatabaseException {
        Object o_key = ddb_key.getKey();
        try {
            byte[] key = (byte[])o_key;
            Map request2 = BDecoder.decode(key);
            Map<String, Object> result = this.receiveRemoteSearch(request2);
            return this.ddb.createValue(BEncoder.encode(result));
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    @Override
    public void write(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey key, DistributedDatabaseValue value) throws DistributedDatabaseException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConfigDirty() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            this.content_dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ContentCache loadRelatedContent() {
        boolean fire_event = false;
        try {
            ContentCache contentCache;
            RelatedContentManager relatedContentManager = this;
            synchronized (relatedContentManager) {
                ContentCache cc;
                this.last_config_access = SystemTime.getMonotonousTime();
                ContentCache contentCache2 = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
                if (cc == null) {
                    fire_event = true;
                    cc = new ContentCache();
                    this.content_cache = new WeakReference<ContentCache>(cc);
                    try {
                        int new_total_unread = 0;
                        if (FileUtil.resilientConfigFileExists(CONFIG_FILE)) {
                            Map map = FileUtil.readResilientConfigFile(CONFIG_FILE);
                            Map related_content = cc.related_content;
                            ByteArrayHashMapEx related_content_map = cc.related_content_map;
                            Map rcm_map = (Map)map.get("rcm");
                            Object rc_map_stuff = map.get("rc");
                            if (rc_map_stuff != null && rcm_map != null) {
                                String key;
                                HashMap<Integer, DownloadInfo> id_map = new HashMap<Integer, DownloadInfo>();
                                if (rc_map_stuff instanceof Map) {
                                    Map rc_map = (Map)rc_map_stuff;
                                    for (Map.Entry entry : rc_map.entrySet()) {
                                        try {
                                            key = (String)entry.getKey();
                                            Map info_map = (Map)entry.getValue();
                                            DownloadInfo info = this.deserialiseDI(info_map, cc);
                                            if (info.isUnread()) {
                                                ++new_total_unread;
                                            }
                                            related_content.put(key, info);
                                            int id = ((Long)info_map.get("_i")).intValue();
                                            id_map.put(id, info);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                } else {
                                    List rc_map_list = (List)rc_map_stuff;
                                    for (Map map2 : rc_map_list) {
                                        try {
                                            key = new String((byte[])map2.get("_k"), "UTF-8");
                                            DownloadInfo info = this.deserialiseDI(map2, cc);
                                            if (info.isUnread()) {
                                                ++new_total_unread;
                                            }
                                            related_content.put(key, info);
                                            int id = ((Long)map2.get("_i")).intValue();
                                            id_map.put(id, info);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                                if (rcm_map.size() != 0 && id_map.size() != 0) {
                                    for (String key2 : rcm_map.keySet()) {
                                        try {
                                            byte[] byArray = Base32.decode(key2);
                                            int[] ids = ImportExportUtils.importIntArray(rcm_map, key2);
                                            if (ids == null || ids.length == 0) continue;
                                            ArrayList<DownloadInfo> di_list = new ArrayList<DownloadInfo>(ids.length);
                                            for (int id : ids) {
                                                DownloadInfo di = (DownloadInfo)id_map.get(id);
                                                if (di == null) continue;
                                                di.setRelatedToHash(byArray);
                                                di_list.add(di);
                                            }
                                            if (di_list.size() <= 0) continue;
                                            related_content_map.put(byArray, di_list);
                                        }
                                        catch (Throwable throwable) {
                                            Debug.out(throwable);
                                        }
                                    }
                                }
                                Iterator it = related_content.values().iterator();
                                while (it.hasNext()) {
                                    DownloadInfo di = (DownloadInfo)it.next();
                                    if (di.getRelatedToHash() != null) continue;
                                    if (di.isUnread()) {
                                        --new_total_unread;
                                    }
                                    it.remove();
                                }
                                this.popuplateSecondaryLookups(cc);
                            }
                        }
                        if (this.total_unread.get() != new_total_unread) {
                            this.total_unread.set(new_total_unread);
                            COConfigurationManager.setParameter(CONFIG_TOTAL_UNREAD, new_total_unread);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    this.enforceMaxResults(cc, false);
                }
                this.content_cache_ref = cc;
                contentCache = cc;
            }
            Object var23_32 = null;
            if (!fire_event) return contentCache;
            this.contentChanged(false);
            return contentCache;
        }
        catch (Throwable throwable) {
            Object var23_33 = null;
            if (!fire_event) throw throwable;
            this.contentChanged(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveRelatedContent() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache cc;
            COConfigurationManager.setParameter(CONFIG_TOTAL_UNREAD, this.total_unread.get());
            long now = SystemTime.getMonotonousTime();
            ContentCache contentCache = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
            if (!this.content_dirty) {
                if (cc != null && now - this.last_config_access > 60000L) {
                    if (this.content_cache_ref != null) {
                        this.content_discard_ticks = 0;
                    }
                    this.content_cache_ref = null;
                }
                return;
            }
            this.last_config_access = now;
            this.content_dirty = false;
            if (cc != null) {
                if (this.persist) {
                    Map related_content = cc.related_content;
                    ByteArrayHashMapEx related_content_map = cc.related_content_map;
                    if (related_content.size() == 0) {
                        FileUtil.deleteResilientConfigFile(CONFIG_FILE);
                    } else {
                        HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
                        Set rcs = related_content.entrySet();
                        ArrayList<Map<String, Object>> rc_map_list = new ArrayList<Map<String, Object>>(rcs.size());
                        map.put("rc", rc_map_list);
                        int id = 0;
                        HashMap<DownloadInfo, Integer> info_map = new HashMap<DownloadInfo, Integer>();
                        for (Map.Entry entry : rcs) {
                            DownloadInfo info = (DownloadInfo)entry.getValue();
                            Map<String, Object> di_map = this.serialiseDI(info, cc);
                            if (di_map == null) continue;
                            info_map.put(info, id);
                            di_map.put("_i", new Long(id));
                            di_map.put("_k", entry.getKey());
                            if (rc_map_list.add(di_map)) {
                                // empty if block
                            }
                            ++id;
                        }
                        HashMap rcm_map = new HashMap();
                        map.put("rcm", rcm_map);
                        for (byte[] hash : related_content_map.keys()) {
                            DownloadInfo di;
                            Integer index;
                            List dis = (List)related_content_map.get(hash);
                            int[] ids = new int[dis.size()];
                            int pos = 0;
                            Iterator i$ = dis.iterator();
                            while (i$.hasNext() && (index = (Integer)info_map.get(di = (DownloadInfo)i$.next())) != null) {
                                ids[pos++] = index;
                            }
                            if (pos != ids.length) continue;
                            ImportExportUtils.exportIntArray(rcm_map, Base32.encode(hash), ids);
                        }
                        FileUtil.writeResilientConfigFile(CONFIG_FILE, map);
                    }
                } else {
                    this.deleteRelatedContent();
                }
            }
        }
    }

    private void deleteRelatedContent() {
        FileUtil.deleteResilientConfigFile(CONFIG_FILE);
        FileUtil.deleteResilientConfigFile(PERSIST_DEL_FILE);
    }

    public int getNumUnread() {
        return this.total_unread.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllRead() {
        boolean changed = false;
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            DownloadInfo[] content;
            for (DownloadInfo c : content = (DownloadInfo[])this.getRelatedContent()) {
                if (!c.isUnread()) continue;
                changed = true;
                c.setUnreadInternal(false);
            }
            this.total_unread.set(0);
        }
        if (changed) {
            this.contentChanged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache content_cache = this.loadRelatedContent();
            this.addPersistentlyDeleted(content_cache.related_content.values().toArray(new DownloadInfo[content_cache.related_content.size()]));
            this.reset(false);
        }
    }

    protected void incrementUnread() {
        this.total_unread.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementUnread() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            int val = this.total_unread.decrementAndGet();
            if (val < 0) {
                this.total_unread.set(0);
            }
        }
    }

    protected Download getDownload(byte[] hash) {
        try {
            return this.plugin_interface.getDownloadManager().getDownload(hash);
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected byte[] getPermDelKey(RelatedContent info) {
        byte[] bytes = info.getHash();
        if (bytes == null) {
            try {
                bytes = new SHA1Simple().calculateHash(this.getPrivateInfoKey(info).getBytes("ISO-8859-1"));
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
        }
        byte[] key = new byte[8];
        System.arraycopy(bytes, 0, key, 0, 8);
        return key;
    }

    protected List<byte[]> loadPersistentlyDeleted() {
        List entries = null;
        if (FileUtil.resilientConfigFileExists(PERSIST_DEL_FILE)) {
            Map map = FileUtil.readResilientConfigFile(PERSIST_DEL_FILE);
            entries = (List)map.get("entries");
        }
        if (entries == null) {
            entries = new ArrayList(0);
        }
        return entries;
    }

    protected void addPersistentlyDeleted(RelatedContent[] content) {
        block6: {
            if (content.length == 0) {
                return;
            }
            List<byte[]> entries = this.loadPersistentlyDeleted();
            ArrayList<byte[]> new_keys = new ArrayList<byte[]>(content.length);
            for (RelatedContent rc : content) {
                byte[] key = this.getPermDelKey(rc);
                new_keys.add(key);
                entries.add(key);
            }
            HashMap<String, List<byte[]>> map = new HashMap<String, List<byte[]>>();
            map.put("entries", entries);
            FileUtil.writeResilientConfigFile(PERSIST_DEL_FILE, map);
            if (this.persist_del_bloom == null) break block6;
            if (this.persist_del_bloom.getSize() / (this.persist_del_bloom.getEntryCount() + content.length) < 10) {
                this.persist_del_bloom = BloomFilterFactory.createAddOnly(Math.max(1000, this.persist_del_bloom.getSize() * 10 + 1000 + content.length));
                for (byte[] k : entries) {
                    this.persist_del_bloom.add(k);
                }
            } else {
                for (byte[] k : new_keys) {
                    this.persist_del_bloom.add(k);
                }
            }
        }
    }

    protected boolean isPersistentlyDeleted(RelatedContent content) {
        if (this.persist_del_bloom == null) {
            List<byte[]> entries = this.loadPersistentlyDeleted();
            this.persist_del_bloom = BloomFilterFactory.createAddOnly(Math.max(1000, entries.size() * 10 + 1000));
            for (byte[] k : entries) {
                this.persist_del_bloom.add(k);
            }
        }
        byte[] key = this.getPermDelKey(content);
        return this.persist_del_bloom.contains(key);
    }

    protected void resetPersistentlyDeleted() {
        FileUtil.deleteResilientConfigFile(PERSIST_DEL_FILE);
        this.persist_del_bloom = BloomFilterFactory.createAddOnly(1000);
    }

    public void reserveTemporarySpace() {
        this.temporary_space.addAndGet(50);
    }

    public void releaseTemporarySpace() {
        boolean reset_explicit = this.temporary_space.addAndGet(-50) == 0;
        this.enforceMaxResults(reset_explicit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enforceMaxResults(boolean reset_explicit) {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache content_cache = this.loadRelatedContent();
            this.enforceMaxResults(content_cache, reset_explicit);
        }
    }

    protected void enforceMaxResults(ContentCache content_cache, boolean reset_explicit) {
        Map related_content = content_cache.related_content;
        int num_to_remove = related_content.size() - (this.max_results + this.temporary_space.get());
        if (num_to_remove > 0) {
            ArrayList infos = new ArrayList(related_content.values());
            if (reset_explicit) {
                for (DownloadInfo info : infos) {
                    if (!info.isExplicit()) continue;
                    info.setExplicit(false);
                }
            }
            Collections.sort(infos, new Comparator<DownloadInfo>(){

                @Override
                public int compare(DownloadInfo o1, DownloadInfo o2) {
                    int res = o2.getLevel() - o1.getLevel();
                    if (res != 0) {
                        return res;
                    }
                    res = o1.getRank() - o2.getRank();
                    if (res != 0) {
                        return res;
                    }
                    return o1.getLastSeenSecs() - o2.getLastSeenSecs();
                }
            });
            ArrayList to_remove = new ArrayList();
            for (int i = 0; i < Math.min(num_to_remove, infos.size()); ++i) {
                to_remove.add(infos.get(i));
            }
            if (to_remove.size() > 0) {
                this.delete(to_remove.toArray(new RelatedContent[to_remove.size()]), content_cache, false);
            }
        }
    }

    public void addListener(RelatedContentManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RelatedContentManagerListener listener) {
        this.listeners.remove(listener);
    }

    private Map<String, Object> serialiseDI(DownloadInfo info, ContentCache cc) {
        try {
            HashMap<String, Object> info_map = new HashMap<String, Object>();
            info_map.put("h", info.getHash());
            ImportExportUtils.exportString(info_map, "d", info.getTitle());
            ImportExportUtils.exportInt(info_map, "r", info.getRand());
            ImportExportUtils.exportString(info_map, "t", info.getTracker());
            ImportExportUtils.exportLong(info_map, "z", info.getSize());
            ImportExportUtils.exportInt(info_map, "p", (int)(info.getPublishDate() / 3600000L));
            ImportExportUtils.exportInt(info_map, "q", info.getSeeds() << 16 | info.getLeechers() & 0xFFFF);
            ImportExportUtils.exportInt(info_map, "c", (int)info.getContentNetwork());
            if (cc != null) {
                ImportExportUtils.exportBoolean(info_map, "u", info.isUnread());
                ImportExportUtils.exportIntArray(info_map, "l", info.getRandList());
                ImportExportUtils.exportInt(info_map, "s", info.getLastSeenSecs());
                ImportExportUtils.exportInt(info_map, "e", info.getLevel());
            }
            return info_map;
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    private DownloadInfo deserialiseDI(Map<String, Object> info_map, ContentCache cc) {
        try {
            byte[] hash = (byte[])info_map.get("h");
            String title = ImportExportUtils.importString(info_map, "d");
            int rand = ImportExportUtils.importInt(info_map, "r");
            String tracker = ImportExportUtils.importString(info_map, "t");
            long size = ImportExportUtils.importLong(info_map, "z");
            int date = ImportExportUtils.importInt(info_map, "p", 0);
            int seeds_leechers = ImportExportUtils.importInt(info_map, "q", -1);
            byte cnet = (byte)ImportExportUtils.importInt(info_map, "c", -1);
            if (cc == null) {
                return new DownloadInfo(hash, hash, title, rand, tracker, 0, false, size, date, seeds_leechers, cnet);
            }
            boolean unread = ImportExportUtils.importBoolean(info_map, "u");
            int[] rand_list = ImportExportUtils.importIntArray(info_map, "l");
            int last_seen = ImportExportUtils.importInt(info_map, "s");
            int level = ImportExportUtils.importInt(info_map, "e");
            return new DownloadInfo(hash, title, rand, tracker, unread, rand_list, last_seen, level, size, date, seeds_leechers, cnet, cc);
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ByteArrayHashMapEx<T>
    extends ByteArrayHashMap<T> {
        protected ByteArrayHashMapEx() {
        }

        public T getRandomValueExcluding(T excluded) {
            int num = RandomUtils.nextInt(this.size);
            T result = null;
            for (int j = 0; j < this.table.length; ++j) {
                ByteArrayHashMap.Entry e = this.table[j];
                while (e != null) {
                    Object value = e.value;
                    if (value != excluded) {
                        result = (T)value;
                    }
                    if (num <= 0 && result != null) {
                        return result;
                    }
                    --num;
                    e = e.next;
                }
            }
            return result;
        }
    }

    private static class ContentCache {
        private Map<String, DownloadInfo> related_content = new HashMap<String, DownloadInfo>();
        private ByteArrayHashMapEx<ArrayList<DownloadInfo>> related_content_map = new ByteArrayHashMapEx();

        private ContentCache() {
        }
    }

    protected class DownloadInfo
    extends RelatedContent {
        private final int rand;
        private boolean unread;
        private int[] rand_list;
        private int last_seen;
        private int level;
        private boolean explicit;
        private ContentCache cc;

        protected DownloadInfo(byte[] _related_to, byte[] _hash, String _title, int _rand, String _tracker, int _level, boolean _explicit, long _size, int _date, int _seeds_leechers, byte _cnet) {
            super(_related_to, _title, _hash, _tracker, _size, _date, _seeds_leechers, _cnet);
            this.unread = true;
            this.rand = _rand;
            this.level = _level;
            this.explicit = _explicit;
            this.updateLastSeen();
        }

        protected DownloadInfo(byte[] _hash, String _title, int _rand, String _tracker, boolean _unread, int[] _rand_list, int _last_seen, int _level, long _size, int _date, int _seeds_leechers, byte _cnet, ContentCache _cc) {
            super(_title, _hash, _tracker, _size, _date, _seeds_leechers, _cnet);
            this.unread = true;
            this.rand = _rand;
            this.unread = _unread;
            this.rand_list = _rand_list;
            this.last_seen = _last_seen;
            this.level = _level;
            this.cc = _cc;
            if (this.rand_list != null && this.rand_list.length > 100) {
                int[] temp = new int[100];
                System.arraycopy(this.rand_list, 0, temp, 0, 100);
                this.rand_list = temp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean addInfo(DownloadInfo info) {
            boolean result = false;
            DownloadInfo downloadInfo = this;
            synchronized (downloadInfo) {
                int d;
                int sl;
                long cn;
                this.updateLastSeen();
                int r = info.getRand();
                if (this.rand_list == null) {
                    this.rand_list = new int[]{r};
                    result = true;
                } else {
                    boolean match = false;
                    for (int i = 0; i < this.rand_list.length; ++i) {
                        if (this.rand_list[i] != r) continue;
                        match = true;
                        break;
                    }
                    if (!match && this.rand_list.length < 100) {
                        int len = this.rand_list.length;
                        int[] new_rand_list = new int[len + 1];
                        System.arraycopy(this.rand_list, 0, new_rand_list, 0, len);
                        new_rand_list[len] = r;
                        this.rand_list = new_rand_list;
                        result = true;
                    }
                }
                if (info.getLevel() < this.level) {
                    this.level = info.getLevel();
                    result = true;
                }
                if ((cn = info.getContentNetwork()) != -1L && this.getContentNetwork() == -1L) {
                    this.setContentNetwork(cn);
                }
                if ((sl = info.getSeedsLeechers()) != -1 && sl != this.getSeedsLeechers()) {
                    this.setSeedsLeechers(sl);
                    result = true;
                }
                if ((d = info.getDateHours()) > 0 && d != this.getDateHours()) {
                    this.setDateHours(d);
                    result = true;
                }
            }
            return result;
        }

        public int getLevel() {
            return this.level;
        }

        protected boolean isExplicit() {
            return this.explicit;
        }

        protected void setExplicit(boolean b) {
            this.explicit = b;
        }

        protected void updateLastSeen() {
            this.last_seen = (int)(SystemTime.getCurrentTime() / 1000L);
        }

        public int getRank() {
            return this.rand_list == null ? 0 : this.rand_list.length;
        }

        public boolean isUnread() {
            return this.unread;
        }

        protected void setPublic(ContentCache _cc) {
            this.cc = _cc;
            if (this.unread) {
                RelatedContentManager.this.incrementUnread();
            }
            this.rand_list = new int[]{this.rand};
        }

        public int getLastSeenSecs() {
            return this.last_seen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setUnreadInternal(boolean _unread) {
            DownloadInfo downloadInfo = this;
            synchronized (downloadInfo) {
                this.unread = _unread;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setUnread(boolean _unread) {
            boolean changed = false;
            DownloadInfo downloadInfo = this;
            synchronized (downloadInfo) {
                if (this.unread != _unread) {
                    this.unread = _unread;
                    changed = true;
                }
            }
            if (changed) {
                if (_unread) {
                    RelatedContentManager.this.incrementUnread();
                } else {
                    RelatedContentManager.this.decrementUnread();
                }
                RelatedContentManager.this.contentChanged(this);
            }
        }

        protected int getRand() {
            return this.rand;
        }

        protected int[] getRandList() {
            return this.rand_list;
        }

        public Download getRelatedToDownload() {
            try {
                return RelatedContentManager.this.getDownload(this.getRelatedToHash());
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
        }

        public void delete() {
            RelatedContentManager.this.delete(new RelatedContent[]{this});
        }

        public String getString() {
            return super.getString() + ", " + this.rand + ", rl=" + this.rand_list + ", last_seen=" + this.last_seen + ", level=" + this.level;
        }
    }

    protected class RCMSearchXFer
    implements DistributedDatabaseTransferType {
        protected RCMSearchXFer() {
        }
    }

    private static class SecondaryLookup {
        private final byte[] hash;
        private final int level;

        protected SecondaryLookup(byte[] _hash, int _level) {
            this.hash = _hash;
            this.level = _level;
        }

        protected byte[] getHash() {
            return this.hash;
        }

        protected int getLevel() {
            return this.level;
        }
    }
}

