/*
 * Pidgin Authorization Blocker
 * Copyright (C) 2011 Konrad Gräfe
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02111-1301, USA.
 */

#include "authorization-blocker.h"

#ifndef _REQUEST_INFO_HOOK_H
#define _REQUEST_INFO_HOOK_H

#include <request.h>
#include <gtk/gtk.h>

typedef struct
{
        PurpleRequestType type;

        void *user_data;
        GtkWidget *dialog;

        GtkWidget *ok_button;

        size_t cb_count;
        GCallback *cbs;

        union
        {
                struct
                {
                        GtkWidget *entry;

                        gboolean multiline;
                        gchar *hint;

                } input;

                struct
                {
                        PurpleRequestFields *fields;

                } multifield;

                struct
                {
                        gboolean savedialog;
                        gchar *name;

                } file;

        } u;

} PidginRequestData;

void hook_into_request_info_once(const char *msg);

#endif /* _REQUEST_INFO_HOOK_H */
