/*
 * Pidgin Authorization Blocker
 * Copyright (C) 2011 Konrad Gräfe
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02111-1301, USA.
 */

#include "authorization-blocker.h"

#include "request_info_hook.h"

#include <request.h>
#include <debug.h>

static gchar *message;

void *(*request_input_ori)(const char *title, const char *primary,
			const char *secondary, const char *default_value,
			gboolean multiline, gboolean masked, gchar *hint,
			const char *ok_text, GCallback ok_cb,
			const char *cancel_text, GCallback cancel_cb,
			PurpleAccount *account, const char *who,
			PurpleConversation *conv, void *user_data);

static void *request_input_hook_once(const char *title, const char *primary,
				const char *secondary, const char *default_value,
				gboolean multiline, gboolean masked, gchar *hint,
				const char *ok_text, GCallback ok_cb,
				const char *cancel_text, GCallback cancel_cb,
				PurpleAccount *account, const char *who,
				PurpleConversation *conv, void *user_data) {
	PurpleRequestUiOps *ui_ops;
	PidginRequestData *data;

	((PurpleRequestInputCb)ok_cb)(user_data, message);

	g_free(message);

	ui_ops = purple_request_get_ui_ops();
	ui_ops->request_input = request_input_ori;

	/* create PidginRequestData to be freed on clean up \o/ */
	data	    = g_new0(PidginRequestData, 1);
	data->type      = PURPLE_REQUEST_INPUT;
	data->user_data = user_data;

	data->cb_count = 2;
	data->cbs = g_new0(GCallback, 2);

	data->cbs[0] = ok_cb;
	data->cbs[1] = cancel_cb;

	data->dialog = gtk_dialog_new();

	return data;
}


void hook_into_request_info_once(const char *msg) {
	PurpleRequestUiOps *ui_ops;

	purple_debug_info(PLUGIN_STATIC_NAME, "%s\n", msg);

	message = g_strdup(msg);

	ui_ops = purple_request_get_ui_ops();
	request_input_ori = ui_ops->request_input;
	ui_ops->request_input = request_input_hook_once;
	
}

