/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.wizard;

import com.install4j.api.Util;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.util.CustomCardLayout;
import com.install4j.runtime.util.KeyboardUtil;
import com.install4j.runtime.wizard.WizardDialog;
import com.install4j.runtime.wizard.WizardFrame;
import com.install4j.runtime.wizard.WizardScreen;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class WizardBase
extends JPanel {
    private static final int FRAME_WIDTH = 600;
    private static final int FRAME_HEIGHT = 400;
    private static final int LAYOUT_GAP_WIDTH = 10;
    private static final int LAYOUT_GAP_HEIGHT = 0;
    private String title;
    private WizardFrame wizardFrame;
    private WizardDialog wizardDialog;
    private CardLayout cardLayout;
    private JPanel cardPanel;
    private List<WizardScreen> screens = new LinkedList<WizardScreen>();
    private ListIterator<WizardScreen> screenIterator;
    private boolean completed = false;

    public WizardBase(String title) {
        this.title = title;
        this.setupComponent();
    }

    public abstract boolean isSizeClientArea();

    public void showFrame(JFrame parent) {
        this.wizardFrame = new WizardFrame(this);
        this.setVisible(true);
    }

    public void showDialog(Window parent) {
        this.wizardDialog = WizardDialog.create(this, parent);
        this.setVisible(true);
    }

    public Window getWizardWindow() {
        return this.wizardFrame != null ? this.wizardFrame : this.wizardDialog;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean nextScreen() {
        WizardScreen screen;
        do {
            if (this.screenIterator.hasNext()) continue;
            this.finish();
            return false;
        } while (!(screen = this.screenIterator.next()).supportsNext());
        screen.activate();
        return true;
    }

    public boolean previousScreen() {
        WizardScreen screen;
        if (!this.screenIterator.hasPrevious()) {
            return false;
        }
        this.screenIterator.previous();
        do {
            if (this.screenIterator.hasPrevious()) continue;
            return false;
        } while (!(screen = this.screenIterator.previous()).supportsPrevious());
        this.screenIterator.next();
        screen.activate();
        return true;
    }

    protected boolean isQuitOnWindowClose() {
        return true;
    }

    public boolean isFinishOnWindowClose() {
        return false;
    }

    public void finishFromCloseButton() {
    }

    protected boolean setScreen(WizardScreen screen) {
        int index = this.screens.indexOf(screen);
        if (index < 0) {
            return false;
        }
        this.screenIterator = this.screens.listIterator(index);
        this.screenIterator.next();
        screen.activate();
        return true;
    }

    public List<WizardScreen> getScreens() {
        return this.screens;
    }

    public void finish() {
        this.completed = true;
        if (this.getWizardWindow() != null) {
            this.setVisible(false);
        }
    }

    public void activateScreen(WizardScreen screen) {
        this.cardLayout.show(this.cardPanel, screen.getName());
    }

    @Override
    public void setVisible(boolean visible) {
        Window wizardWindow;
        if (visible) {
            this.initVisible();
            this.completed = false;
        }
        if ((wizardWindow = this.getWizardWindow()) != null) {
            if (visible) {
                this.beforeShow(wizardWindow);
            } else {
                this.beforeHide(wizardWindow);
            }
            wizardWindow.setVisible(visible);
            if (!visible) {
                this.afterHide(wizardWindow);
                wizardWindow.dispose();
            }
        } else {
            throw new IllegalStateException();
        }
    }

    protected void initVisible() {
        this.screenIterator = this.screens.listIterator();
        if (this.needsNextScreenOnVisible()) {
            this.nextScreen();
        }
    }

    protected boolean needsNextScreenOnVisible() {
        return true;
    }

    public void cancel() {
        this.completed = true;
        this.setVisible(false);
    }

    protected void beforeShow(Window wizardWindow) {
    }

    protected void beforeHide(Window wizardWindow) {
    }

    protected void afterHide(Window wizardWindow) {
    }

    protected void registerScreen(WizardScreen screen) {
        if (screen != null) {
            this.cardPanel.add((Component)screen, screen.getName());
            this.screens.add(screen);
        }
    }

    protected int getFrameWidth() {
        return 600;
    }

    protected int getFrameHeight() {
        return 400;
    }

    protected void setupComponent() {
        this.setName("wizardPanel");
        this.cardLayout = new CustomCardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.setLayout(new BorderLayout(10, 0));
        this.add((Component)this.cardPanel, "Center");
        KeyboardUtil.addAccelerator(1, this, this, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Util.showPath(Util.getLogFile().getPath());
            }
        }, 76, 3);
    }

    public void prepareWindow(final Window window) {
        this.setTitle(this.getTitle());
        GUIHelper.setIconImages(window);
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                if (WizardBase.this.isQuitOnWindowClose()) {
                    WizardBase.this.cancel();
                } else if (WizardBase.this.isFinishOnWindowClose()) {
                    WizardBase.this.finishFromCloseButton();
                }
            }

            @Override
            public void windowOpened(WindowEvent event) {
                Toolkit.getDefaultToolkit().sync();
                window.toFront();
            }
        });
    }

    private boolean isMacOS() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }
}

