/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.install4j.runtime.launcher.AwtAndFxWindowChecker;
import com.install4j.runtime.launcher.SwtWindowChecker;

public abstract class WindowChecker
extends Thread {
    public static final String PROPNAME_SWT = "install4j.swt";
    private Runnable runnable;

    public static void onFirstWindowShown(Runnable runnable) {
        if (Boolean.getBoolean(PROPNAME_SWT) && WindowChecker.isSwtPresent()) {
            new SwtWindowChecker(runnable).start();
        } else {
            new AwtAndFxWindowChecker(runnable).start();
        }
    }

    private static boolean isSwtPresent() {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected WindowChecker(Runnable runnable) {
        this.runnable = runnable;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        boolean execute = false;
        while (!execute) {
            try {
                WindowChecker.sleep(200L);
                execute = this.checkExecute();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.runnable.run();
    }

    protected abstract boolean checkExecute();
}

