/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.misc.Unsafe;

public class WinGuiHelper {
    private static Method getHwndMethod;
    private static Field peerField;
    private static long overrideFieldOffset;
    public static final Unsafe UNSAFE;

    private static Unsafe initUnsafe() {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static synchronized void setAccessible(AccessibleObject accessibleObject) {
        block6: {
            if (accessibleObject == null) {
                throw new NullPointerException();
            }
            try {
                accessibleObject.setAccessible(true);
            }
            catch (Throwable t) {
                if (UNSAFE == null) break block6;
                try {
                    if (overrideFieldOffset == -1L) {
                        Field overrideField = AccessibleObject.class.getDeclaredField("override");
                        overrideFieldOffset = UNSAFE.objectFieldOffset(overrideField);
                    }
                    UNSAFE.putBoolean(accessibleObject, overrideFieldOffset, true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static synchronized long getHwnd(Window window) throws HeadlessException {
        if (window != null) {
            if (GraphicsEnvironment.isHeadless()) {
                throw new HeadlessException("No native windows when headless");
            }
            try {
                Object componentPeer;
                if (peerField != null) {
                    componentPeer = peerField.get(window);
                } else {
                    try {
                        componentPeer = window.getPeer();
                    }
                    catch (Throwable t) {
                        peerField = Component.class.getDeclaredField("peer");
                        WinGuiHelper.setAccessible(peerField);
                        componentPeer = peerField.get(window);
                    }
                }
                if (componentPeer != null) {
                    if (getHwndMethod == null) {
                        getHwndMethod = componentPeer.getClass().getMethod("getHWnd", new Class[0]);
                        if (getHwndMethod.getReturnType().equals(Long.TYPE)) {
                            WinGuiHelper.setAccessible(getHwndMethod);
                        } else {
                            getHwndMethod = null;
                        }
                    }
                    if (getHwndMethod != null) {
                        return (Long)getHwndMethod.invoke(componentPeer, new Object[0]);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0L;
    }

    static {
        overrideFieldOffset = -1L;
        UNSAFE = WinGuiHelper.initUnsafe();
    }
}

