/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PlistHelper {
    public static Element findValue(Element element, String keyName) throws IOException {
        String currentKey = "";
        for (Element child : XmlHelper.childElements(element)) {
            if (child.getTagName().equals("key")) {
                currentKey = XmlHelper.getTextValue(child);
                continue;
            }
            if (!currentKey.equals(keyName)) continue;
            return child;
        }
        throw new NotFoundException("could not find key: " + keyName);
    }

    public static Element getFirstChild(Element element, String name) throws IOException {
        for (Element child : XmlHelper.childElements(element)) {
            if (!child.getTagName().equals(name)) continue;
            return child;
        }
        throw new NotFoundException("could not find child: " + name);
    }

    public static boolean removeElementWithChild(String plistName, String arrayName, String[] childKeys, String childValue, boolean contained) throws IOException {
        File plistFile = new File(new File(Util.getUserHome(), "Library/Preferences"), plistName + ".plist");
        File xmlFile = PlistHelper.getPlistXmlFile(plistFile);
        Document document = XmlHelper.parseFile(xmlFile);
        if (PlistHelper.removeElementWithChild(PlistHelper.findValue(PlistHelper.getFirstChild(document.getDocumentElement(), "dict"), arrayName), childKeys, childValue, contained)) {
            Logger.getInstance().log(null, "removed child", true);
            XmlHelper.writeFile(xmlFile, document);
            return PlistHelper.storePlistFile(xmlFile, plistFile);
        }
        return false;
    }

    public static void flushCache() {
        try {
            Execution.executeAndWait(new String[]{"killall", "cfprefsd"}, null);
        }
        catch (Throwable e) {
            Logger.getInstance().log(e);
        }
    }

    public static boolean removeElementWithChild(Element arrayElement, String[] childKeys, String childValue, boolean contained) throws IOException {
        for (Element dictElement : XmlHelper.childElements(arrayElement)) {
            try {
                String textValue;
                Element currentElement = dictElement;
                for (int i = 0; currentElement != null && i < childKeys.length; ++i) {
                    currentElement = PlistHelper.findValue(currentElement, childKeys[i]);
                }
                if (currentElement == null || !childValue.equals(textValue = XmlHelper.getTextValue(currentElement)) && (!contained || textValue == null || !textValue.contains(childValue))) continue;
                arrayElement.removeChild(dictElement);
                return true;
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    public static File getPlistXmlFile(File file) throws IOException {
        File tempFile = File.createTempFile("i4j", ".plist");
        tempFile.deleteOnExit();
        FileUtil.copyFile(file, tempFile);
        StringBuffer buffer = new StringBuffer();
        if (Execution.executeAndWait(new String[]{"plutil", "-convert", "xml1", tempFile.getAbsolutePath()}, buffer)) {
            return tempFile;
        }
        tempFile.delete();
        throw new IOException("plutil returned " + buffer.toString());
    }

    public static boolean storePlistFile(File xmlFile, File plistFile) throws IOException {
        try {
            StringBuffer buffer = new StringBuffer();
            if (Execution.executeAndWait(new String[]{"plutil", "-convert", "binary1", xmlFile.getAbsolutePath()}, buffer)) {
                FileUtil.copyFile(xmlFile, plistFile);
                boolean bl = true;
                return bl;
            }
            throw new IOException("plutil returned " + buffer.toString());
        }
        finally {
            xmlFile.delete();
        }
    }

    public static boolean addToPlist(String plistName, String arrayName, Object[][] keysAndValues) {
        Integer ret = LaunchHelper.launchApplication(new LaunchDescriptor(new File("/usr/bin/defaults")).arguments("write", plistName, arrayName, "-array-add", PlistHelper.getDict(keysAndValues)).executionContext(ExecutionContext.UNELEVATED).wait(true));
        return ret != null && ret == 0;
    }

    public static String getDict(Object[][] keysAndValues) {
        if (keysAndValues.length != 2) {
            throw new IllegalArgumentException("array length: " + keysAndValues.length);
        }
        Object[] keys = keysAndValues[0];
        Object[] values = keysAndValues[1];
        if (keys.length != values.length) {
            throw new IllegalArgumentException("keys: " + keys.length + ", values: " + values.length);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<dict>");
        for (int i = 0; i < keys.length; ++i) {
            buffer.append("<key>").append(keys[i]).append("</key>");
            if (values[i] instanceof String) {
                buffer.append("<string>").append(values[i]).append("</string>");
                continue;
            }
            if (values[i] instanceof Boolean) {
                if (((Boolean)values[i]).booleanValue()) {
                    buffer.append("<true/>");
                    continue;
                }
                buffer.append("<false/>");
                continue;
            }
            if (values[i] instanceof Integer) {
                buffer.append("<integer>").append(values[i]).append("</integer>");
                continue;
            }
            if (values[i] instanceof Object[][]) {
                buffer.append(PlistHelper.getDict((Object[][])values[i]));
                continue;
            }
            throw new IllegalArgumentException();
        }
        buffer.append("</dict>");
        return buffer.toString();
    }

    public static class NotFoundException
    extends IOException {
        public NotFoundException(String s) {
            super(s);
        }
    }
}

