/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform;

import com.install4j.api.JVMSelector;
import com.install4j.api.Util;
import com.install4j.runtime.installer.platform.macos.MacosJVMLocator;
import com.install4j.runtime.installer.platform.unix.UnixJVMLocator;
import com.install4j.runtime.installer.platform.win32.WinJVMLocator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;

public class JVMLocator {
    public static JVMLocation[] getJVMLocations(File[] additionalLocations) {
        Collection<JVMLocation> ret = Util.isWindows() ? WinJVMLocator.getJVMLocations(false) : (Util.isMacOS() ? MacosJVMLocator.getJVMLocations() : UnixJVMLocator.getJVMLocations());
        if (additionalLocations != null) {
            for (File additionalLocation : additionalLocations) {
                JVMLocation jvmLocation = JVMLocator.getJVMLocation(additionalLocation);
                if (jvmLocation == null) continue;
                ret.add(jvmLocation);
            }
        }
        return ret.toArray(new JVMLocation[ret.size()]);
    }

    public static JVMLocation getJVMLocation(File javaHome) {
        try {
            String[] jdkFiles;
            String executable;
            if (Util.isWindows()) {
                executable = "bin/java.exe";
                jdkFiles = WinJVMLocator.JDK_FILES;
            } else {
                if (Util.isMacOS()) {
                    return MacosJVMLocator.getJVMLocation(javaHome);
                }
                executable = "bin/java";
                jdkFiles = UnixJVMLocator.JDK_FILES;
            }
            return JVMLocator.checkJVMLocation(javaHome, executable, jdkFiles);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        JVMLocation[] jvmLocations;
        for (JVMLocation jvmLocation : jvmLocations = JVMLocator.getJVMLocations(null)) {
            System.out.println(jvmLocation);
        }
    }

    public static JVMLocation checkJVMLocation(File javaHome, String executable, String[] jdkFiles) throws IOException {
        String versionOutput;
        File javaExe;
        if (javaHome != null && (javaExe = new File(javaHome, executable)).exists() && (versionOutput = JVMLocator.getVersionOutput(javaExe)) != null && (versionOutput.startsWith("openjdk version \"") || versionOutput.startsWith("java version \"")) && versionOutput.endsWith("\"")) {
            JVMLocation jvmLocation = new JVMLocation();
            jvmLocation.setJavaHome(javaHome);
            jvmLocation.setVersion(versionOutput.substring(versionOutput.indexOf(34) + 1, versionOutput.length() - 1));
            jvmLocation.setJDK(JVMLocator.isJDK(javaHome, jdkFiles));
            return jvmLocation;
        }
        return null;
    }

    private static boolean isJDK(File javaHome, String[] jdkFiles) {
        for (String jdkFile : jdkFiles) {
            if (new File(javaHome, jdkFile).exists()) continue;
            return false;
        }
        return true;
    }

    private static String getVersionOutput(File javaExe) throws IOException {
        String versionOutput = null;
        Process process = new ProcessBuilder(javaExe.getAbsolutePath(), "-version").start();
        try {
            Thread.interrupted();
            TimeoutThread timeoutThread = new TimeoutThread(Thread.currentThread());
            timeoutThread.start();
            int retVal = process.waitFor();
            if (retVal == 0) {
                BufferedReader bufReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                versionOutput = bufReader.readLine();
                bufReader.close();
            }
            timeoutThread.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return versionOutput;
    }

    public static class JVMLocation
    implements JVMSelector.JVMLocation {
        private File javaHome;
        private String version;
        private boolean jdk = false;

        public void setJavaHome(File javaHome) {
            this.javaHome = javaHome;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setJDK(boolean jdk) {
            this.jdk = jdk;
        }

        @Override
        public File getJavaHome() {
            return this.javaHome;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public boolean isJDK() {
            return this.jdk;
        }

        public String toString() {
            return this.javaHome + ", version: " + this.version + " (" + (this.jdk ? "JDK" : "JRE") + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JVMLocation)) {
                return false;
            }
            JVMLocation jvmLocation = (JVMLocation)o;
            return !(this.javaHome != null ? !this.javaHome.equals(jvmLocation.javaHome) : jvmLocation.javaHome != null);
        }

        public int hashCode() {
            return this.javaHome != null ? this.javaHome.hashCode() : 0;
        }
    }

    private static class TimeoutThread
    extends Thread {
        private Thread watchedThread;

        public TimeoutThread(Thread watchedThread) {
            super("timeout");
            this.setDaemon(true);
            this.watchedThread = watchedThread;
        }

        @Override
        public void run() {
            try {
                TimeoutThread.sleep(8000L);
                this.watchedThread.interrupt();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

