/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.registry;

import com.install4j.api.context.Context;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.registry.NoRegistry;
import com.install4j.runtime.installer.helper.registry.PreferencesRegistry;
import com.install4j.runtime.installer.helper.registry.RegistryInterface;
import com.install4j.runtime.installer.helper.registry.Win32Registry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class InstallRegistry {
    private static final String REGVAL_PREFIX_INST_DIR = "instdir";
    public static final String REGVAL_PREFIX_ALL_INST_DIR = "allinstdirs";
    private static final String REGVAL_PREFIX_SINGLE_BUNDLE_NAME = "singleBundleName";
    private static final String DELIMITER = ";";
    private static RegistryInterface registry;

    public static boolean isNoPreferences() {
        return Boolean.getBoolean("noPreferences") || ContextImpl.getSingleContextInt() != null && ContextImpl.getSingleContextInt().getBooleanVariable("sys.noPreferences");
    }

    public static void registerApplication(final String applicationId, final File installationDir, final String singleBundleName) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new RunAction(){

            @Override
            protected void run(Context context) {
                InstallRegistry.registerApplicationInt(applicationId, installationDir, singleBundleName);
            }
        });
    }

    private static void registerApplicationInt(String applicationId, File installationDir, String singleBundleName) {
        InstallRegistry.init();
        try {
            installationDir = installationDir.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String singleInstDir = registry.getValue(REGVAL_PREFIX_INST_DIR + applicationId);
        InstallRegistry.unregisterApplication(applicationId, installationDir);
        String allKeyName = REGVAL_PREFIX_ALL_INST_DIR + applicationId;
        String instDirValue = registry.getValue(allKeyName);
        if (instDirValue == null) {
            if (singleInstDir != null && singleInstDir.trim().length() > 0) {
                try {
                    File singleFile = new File(singleInstDir).getCanonicalFile();
                    if (!singleFile.equals(installationDir)) {
                        instDirValue = installationDir.getAbsolutePath() + DELIMITER + singleFile.getAbsolutePath();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (instDirValue == null) {
                instDirValue = installationDir.getAbsolutePath();
            }
        } else {
            instDirValue = installationDir.getAbsolutePath() + DELIMITER + instDirValue;
        }
        registry.setValue(allKeyName, instDirValue);
        registry.setValue(REGVAL_PREFIX_INST_DIR + applicationId, installationDir.getAbsolutePath());
        if (singleBundleName != null) {
            registry.setValue(REGVAL_PREFIX_SINGLE_BUNDLE_NAME + applicationId + "_" + installationDir.getAbsolutePath(), singleBundleName);
        }
    }

    public static void unregisterApplication(String applicationId, File installationDir) {
        InstallRegistry.init();
        try {
            installationDir = installationDir.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        registry.deleteValue(REGVAL_PREFIX_INST_DIR + applicationId);
        String allKeyName = REGVAL_PREFIX_ALL_INST_DIR + applicationId;
        String instDirValue = registry.getValue(allKeyName);
        String newInstDirValue = "";
        if (instDirValue != null) {
            StringTokenizer tokenizer = new StringTokenizer(instDirValue, DELIMITER);
            while (tokenizer.hasMoreTokens()) {
                String value = tokenizer.nextToken();
                try {
                    if (new File(value).getCanonicalFile().equals(installationDir)) continue;
                    newInstDirValue = newInstDirValue + value + DELIMITER;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (newInstDirValue.equals("")) {
            registry.deleteValue(allKeyName);
        } else {
            registry.setValue(allKeyName, newInstDirValue);
        }
        registry.deleteValue(REGVAL_PREFIX_SINGLE_BUNDLE_NAME + applicationId + "_" + installationDir.getAbsolutePath());
    }

    public static String getInstallationDir(String applicationId) {
        String[] allDirs = InstallRegistry.getAllInstallationDirs(applicationId, false);
        if (allDirs.length > 0) {
            return allDirs[0];
        }
        return null;
    }

    public static String[] getAllInstallationDirs(String applicationId, boolean checkOtherBitness) {
        ArrayList<String> ret = new ArrayList<String>();
        HashSet<String> addedDirs = new HashSet<String>();
        InstallRegistry.addAllInstallationDirs(applicationId, ret, addedDirs, false);
        if (checkOtherBitness) {
            InstallRegistry.addAllInstallationDirs(applicationId, ret, addedDirs, true);
        }
        return ret.toArray(new String[ret.size()]);
    }

    private static void addAllInstallationDirs(String applicationId, List<String> ret, Set<String> addedDirs, boolean otherBitness) {
        String instDirs = InstallRegistry.getValue(REGVAL_PREFIX_ALL_INST_DIR + applicationId, otherBitness);
        if (instDirs != null) {
            StringTokenizer tokenizer = new StringTokenizer(instDirs, DELIMITER);
            while (tokenizer.hasMoreTokens()) {
                String value = tokenizer.nextToken();
                if (value == null || value.trim().length() <= 0 || !addedDirs.add(value)) continue;
                ret.add(value);
            }
        } else {
            String value = InstallRegistry.getValue(REGVAL_PREFIX_INST_DIR + applicationId, otherBitness);
            if (value != null && value.trim().length() > 0 && addedDirs.add(value)) {
                ret.add(value);
            }
        }
    }

    public static String getSingleBundleName(String applicationId, String installationDir) {
        try {
            return InstallRegistry.getValue(REGVAL_PREFIX_SINGLE_BUNDLE_NAME + applicationId + "_" + new File(installationDir).getCanonicalFile());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getValue(String valueName) {
        InstallRegistry.init();
        return registry.getValue(valueName);
    }

    public static String getValue(String valueName, boolean otherBitness) {
        InstallRegistry.init();
        if (otherBitness) {
            return registry.getOtherBitnessValue(valueName);
        }
        return registry.getValue(valueName);
    }

    public static void setValue(final String valueName, final String value) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new RunAction(){

            @Override
            protected void run(Context context) {
                InstallRegistry.init();
                registry.deleteValue(valueName);
                registry.setValue(valueName, value);
            }
        });
    }

    private static void init() {
        if (registry == null) {
            registry = InstallerUtil.isWindows() ? new Win32Registry() : (InstallRegistry.isNoPreferences() ? new NoRegistry() : new PreferencesRegistry());
        }
    }
}

