/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.launching;

import com.install4j.runtime.installer.helper.launching.OutputRedirectionMode;
import com.install4j.runtime.installer.helper.launching.Redirection;
import java.io.File;

public class OutputRedirection
extends Redirection {
    private static final String DEV_STDERR = "/dev/stderr";
    private static final String DEV_STDOUT = "/dev/stdout";
    public static final OutputRedirection LEGACY_STDOUT_REDIRECTION = new OutputRedirection(OutputRedirectionMode.FILE, "", new File("/dev/stdout"), false);
    public static final OutputRedirection LEGACY_STDERR_REDIRECTION = new OutputRedirection(OutputRedirectionMode.FILE, "", new File("/dev/stderr"), false);
    public static final OutputRedirection INHERIT_REDIRECTION = new OutputRedirection(OutputRedirectionMode.INHERIT, "", null, false);
    public static final OutputRedirection NO_REDIRECTION = new OutputRedirection(OutputRedirectionMode.NONE, "", null, false);
    private OutputRedirectionMode redirectionMode;
    private String variableName;

    public OutputRedirection(OutputRedirectionMode redirectionMode, String variableName, File file, boolean failOnFileError) {
        super(file, failOnFileError);
        this.redirectionMode = redirectionMode;
        this.variableName = variableName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public OutputRedirectionMode getRedirectionMode() {
        return this.redirectionMode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append((Object)this.redirectionMode);
        if (this.redirectionMode == OutputRedirectionMode.FILE) {
            buffer.append("[file: ").append(this.getFile()).append(", failOnError: ").append(this.isFailOnFileError());
        } else if (this.redirectionMode == OutputRedirectionMode.VARIABLE) {
            buffer.append("[variableName: ").append(this.variableName);
        }
        return buffer.toString();
    }

    public boolean isStdOutFile() {
        return this.redirectionMode == OutputRedirectionMode.FILE && this.getFile() != null && this.getFile().getPath().replace('\\', '/').equals(DEV_STDOUT);
    }

    public boolean isStdErrFile() {
        return this.redirectionMode == OutputRedirectionMode.FILE && this.getFile() != null && this.getFile().getPath().replace('\\', '/').equals(DEV_STDERR);
    }
}

