/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.launching;

import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.launching.InputRedirection;
import com.install4j.runtime.installer.helper.launching.InputRedirectionMode;
import com.install4j.runtime.installer.helper.launching.OutputRedirection;
import com.install4j.runtime.installer.helper.launching.OutputRedirectionMode;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class LaunchDescriptor
implements Serializable {
    private File executable;
    private File workingDirectory;
    private String[] arguments;
    private boolean includeParentEnvironmentVariables = true;
    private Map<String, String> specificEnvironmentVariables;
    private boolean showWindowsConsole = false;
    private boolean keepConsoleWindow = false;
    private boolean useNohup = false;
    private OutputRedirection stdoutRedirection;
    private OutputRedirection stderrRedirection;
    private InputRedirection stdinRedirection;
    private boolean wait = false;
    private boolean waitForStreams = false;
    private int timeout = 0;
    private Process process;
    private boolean receiveProcess = false;
    private boolean suidRoot;
    private ExecutionContext executionContext = ExecutionContext.SAME;

    public LaunchDescriptor(File executable) {
        this.executable = executable;
    }

    public File getExecutable() {
        return this.executable;
    }

    public LaunchDescriptor executable(File executable) {
        this.executable = executable;
        return this;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public LaunchDescriptor workingDirectory(File workingDirectory) {
        this.workingDirectory = this.replaceEmpty(workingDirectory);
        return this;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public LaunchDescriptor arguments(List<String> arguments) {
        if (arguments == null) {
            this.arguments = null;
        } else {
            this.arguments(arguments.toArray(new String[arguments.size()]));
        }
        return this;
    }

    public LaunchDescriptor arguments(String ... arguments) {
        if (arguments != null && (arguments.length == 0 || arguments.length == 1 && (arguments[0] == null || arguments[0].length() == 0))) {
            arguments = null;
        }
        this.arguments = arguments;
        return this;
    }

    public LaunchDescriptor suidRoot(boolean suidRoot) {
        this.suidRoot = suidRoot;
        return this;
    }

    public boolean isSuidRoot() {
        return this.suidRoot;
    }

    public boolean isUseNohup() {
        return this.useNohup;
    }

    public LaunchDescriptor useNohup(boolean useNohup) {
        this.useNohup = useNohup;
        return this;
    }

    public boolean isIncludeParentEnvironmentVariables() {
        return this.includeParentEnvironmentVariables;
    }

    public LaunchDescriptor includeParentEnvironmentVariables(boolean includeParentEnvironmentVariables) {
        this.includeParentEnvironmentVariables = includeParentEnvironmentVariables;
        return this;
    }

    public Map<String, String> getSpecificEnvironmentVariables() {
        return this.specificEnvironmentVariables;
    }

    public LaunchDescriptor specificEnvironmentVariables(Map<String, String> specificEnvironmentVariables) {
        this.specificEnvironmentVariables = specificEnvironmentVariables;
        return this;
    }

    public boolean isShowWindowsConsole() {
        return this.showWindowsConsole;
    }

    public LaunchDescriptor showWindowsConsole(boolean showWindowsConsole) {
        this.showWindowsConsole = showWindowsConsole;
        return this;
    }

    public boolean isKeepConsoleWindow() {
        return this.keepConsoleWindow;
    }

    public LaunchDescriptor keepConsoleWindow(boolean waitForWindowsConsole) {
        this.keepConsoleWindow = waitForWindowsConsole;
        return this;
    }

    public OutputRedirection getUsedStdoutRedirection() {
        if (this.stdoutRedirection != null) {
            if (VersionSpecificHelper.canInheritParentHandles()) {
                if (this.stdoutRedirection.isStdOutFile()) {
                    return OutputRedirection.INHERIT_REDIRECTION;
                }
            } else if (this.stdoutRedirection.getRedirectionMode() == OutputRedirectionMode.INHERIT) {
                if (this.isWait()) {
                    return OutputRedirection.LEGACY_STDOUT_REDIRECTION;
                }
                return OutputRedirection.NO_REDIRECTION;
            }
        }
        return this.stdoutRedirection;
    }

    public LaunchDescriptor stdoutRedirection(OutputRedirection stdoutRedirection) {
        this.stdoutRedirection = stdoutRedirection;
        return this;
    }

    public OutputRedirection getUsedStderrRedirection() {
        if (this.stderrRedirection != null) {
            if (VersionSpecificHelper.canInheritParentHandles()) {
                if (this.stderrRedirection.isStdErrFile()) {
                    return OutputRedirection.INHERIT_REDIRECTION;
                }
            } else if (this.stderrRedirection.getRedirectionMode() == OutputRedirectionMode.INHERIT) {
                if (this.isWait()) {
                    return OutputRedirection.LEGACY_STDOUT_REDIRECTION;
                }
                return OutputRedirection.NO_REDIRECTION;
            }
        }
        return this.stderrRedirection;
    }

    public LaunchDescriptor stderrRedirection(OutputRedirection stderrRedirection) {
        this.stderrRedirection = stderrRedirection;
        return this;
    }

    public InputRedirection getUsedStdinRedirection() {
        if (this.stdinRedirection != null) {
            if (VersionSpecificHelper.canInheritParentHandles()) {
                if (this.stdinRedirection.isStdInFile()) {
                    return InputRedirection.INHERIT_REDIRECTION;
                }
            } else if (this.stdinRedirection.getRedirectionMode() == InputRedirectionMode.INHERIT) {
                if (this.isWait()) {
                    return InputRedirection.LEGACY_STDIN_REDIRECTION;
                }
                return InputRedirection.NO_REDIRECTION;
            }
        }
        return this.stdinRedirection;
    }

    public LaunchDescriptor stdinRedirection(InputRedirection stdinRedirection) {
        this.stdinRedirection = stdinRedirection;
        return this;
    }

    private File replaceEmpty(File file) {
        if (file != null && file.getPath().length() == 0) {
            return null;
        }
        return file;
    }

    public boolean isWait() {
        return this.wait;
    }

    public LaunchDescriptor wait(boolean wait) {
        this.wait = wait;
        return this;
    }

    public boolean isWaitForStreams() {
        return this.waitForStreams;
    }

    public LaunchDescriptor waitForStreams(boolean waitForStreams) {
        this.waitForStreams = waitForStreams;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public LaunchDescriptor timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public boolean isReceiveProcess() {
        return this.receiveProcess;
    }

    public LaunchDescriptor receiveProcess(boolean receiveProcess) {
        this.receiveProcess = receiveProcess;
        return this;
    }

    public String toString() {
        return "LaunchDescriptor{executable=" + this.executable + ", workingDirectory=" + this.workingDirectory + ", arguments=" + (this.arguments == null ? null : Arrays.asList(this.arguments)) + ", suidRoot=" + this.suidRoot + ", includeParentEnvironmentVariables=" + this.includeParentEnvironmentVariables + ", specificEnvironmentVariables=" + this.specificEnvironmentVariables + ", showWindowsConsole=" + this.showWindowsConsole + ", keepConsoleWindow=" + this.keepConsoleWindow + ", useNohup=" + this.useNohup + ", stdoutRedirection=" + this.stdoutRedirection + ", stderrRedirection=" + this.stderrRedirection + ", stdinRedirection=" + this.stdinRedirection + ", wait=" + this.wait + ", process=" + this.process + ", receiveProcess=" + this.receiveProcess + ", executionContext=" + (Object)((Object)this.executionContext) + '}';
    }

    public LaunchDescriptor executionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        return this;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }
}

