/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.content.ProxyConfig;
import com.install4j.runtime.util.NumericTextField;
import com.install4j.runtime.util.StandardDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class ProxyDialog
extends StandardDialog {
    protected static final int RADIO_BUTTON_WIDTH = new JRadioButton((String)"").getPreferredSize().width + 1;
    private JRadioButton rdoConnectionDirect;
    private JRadioButton rdoConnectionProxy;
    private JTextField txtHost;
    private NumericTextField txtPort;
    private JCheckBox chkAuth;
    private JTextField txtAuthUser;
    private JTextField txtAuthPassword;
    private JLabel lblHost;
    private JLabel lblPort;
    private JLabel lblUser;
    private JLabel lblPassword;
    private static final int FRAME_WIDTH = 420;
    private ProxyConfig proxyConfig;
    private boolean passwordOnly;

    public static ProxyDialog create(ProxyConfig proxyConfig, Window parentWindow) {
        if (parentWindow instanceof Frame) {
            return new ProxyDialog(proxyConfig, (Frame)parentWindow);
        }
        return new ProxyDialog(proxyConfig, (Dialog)parentWindow);
    }

    private ProxyDialog(ProxyConfig proxyConfig, Frame parentFrame) {
        super(parentFrame);
        this.init(proxyConfig);
    }

    private ProxyDialog(ProxyConfig proxyConfig, Dialog parentDialog) {
        super(parentDialog);
        this.init(proxyConfig);
    }

    private void init(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
        this.init();
    }

    @Override
    protected int getFrameHeight() {
        return -1;
    }

    @Override
    protected int getFrameWidth() {
        return 420;
    }

    public void setPasswordOnly(boolean passwordOnly) {
        this.passwordOnly = passwordOnly;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.updateFromProxyConfig();
            if (this.passwordOnly) {
                this.chkAuth.setSelected(true);
                this.checkEnabled();
            }
        }
        super.setVisible(visible);
    }

    @Override
    protected void doOk() {
        if (this.checkProxySettings()) {
            this.proxyConfig.setProxySet(this.rdoConnectionProxy.isSelected());
            this.proxyConfig.setAuth(this.chkAuth.isSelected());
            this.proxyConfig.setAuthPassword(this.txtAuthPassword.getText());
            this.proxyConfig.setAuthUser(this.txtAuthUser.getText());
            this.proxyConfig.setPort(this.txtPort.getText());
            this.proxyConfig.setHost(this.txtHost.getText());
            super.doOk();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.rdoConnectionDirect || source == this.rdoConnectionProxy || source == this.chkAuth) {
            this.checkEnabled();
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    protected void setupControls() {
        super.setupControls();
        this.rdoConnectionDirect = new JRadioButton(" " + Messages.getMessages().getString("DirectConnection"), !this.proxyConfig.isProxySet());
        this.rdoConnectionProxy = new JRadioButton(" " + Messages.getMessages().getString("ProxyConnection"), this.proxyConfig.isProxySet());
        ButtonGroup bgrConnection = new ButtonGroup();
        bgrConnection.add(this.rdoConnectionDirect);
        bgrConnection.add(this.rdoConnectionProxy);
        this.txtHost = new JTextField();
        this.txtPort = new NumericTextField("", 5);
        this.chkAuth = new JCheckBox(Messages.getMessages().getString("ProxyAuthentication"));
        this.txtAuthUser = new JTextField(15);
        this.txtAuthPassword = new JPasswordField(15);
        this.lblHost = new JLabel(Messages.getMessages().getString("ProxyHost") + ":");
        this.lblPort = new JLabel(Messages.getMessages().getString("ProxyPort") + ":");
        this.lblUser = new JLabel(Messages.getMessages().getString("UserName") + ":");
        this.lblPassword = new JLabel(Messages.getMessages().getString("Password") + ":");
        this.updateFromProxyConfig();
    }

    @Override
    protected void setupComponent() {
        super.setupComponent();
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        String message = Messages.getMessages().getString("InternetConnection");
        this.setTitle(message + (config != null ? " - " + config.getApplicationName() : ""));
    }

    private void updateFromProxyConfig() {
        this.txtHost.setText(this.proxyConfig.getHost());
        this.txtPort.setText(this.proxyConfig.getPort());
        this.chkAuth.setSelected(this.proxyConfig.isAuth());
        this.txtAuthUser.setText(this.proxyConfig.getAuthUser());
        this.txtAuthPassword.setText(this.proxyConfig.getAuthPassword());
        this.checkEnabled();
    }

    @Override
    protected void setupEventHandlers() {
        super.setupEventHandlers();
        this.rdoConnectionDirect.addActionListener(this);
        this.rdoConnectionProxy.addActionListener(this);
        this.chkAuth.addActionListener(this);
        this.txtPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                int port = 0;
                try {
                    port = Integer.parseInt(ProxyDialog.this.txtPort.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (port < 1 || port > 65536) {
                    GUIHelper.showMessage(ProxyDialog.this.getOwner(), Messages.getMessages().getString("PortValueError"), 0);
                    ProxyDialog.this.txtPort.setText("80");
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                if (ProxyDialog.this.passwordOnly) {
                    if (ProxyDialog.this.txtAuthUser.getText().trim().length() == 0) {
                        ProxyDialog.this.txtAuthUser.requestFocus();
                    } else {
                        ProxyDialog.this.txtAuthPassword.requestFocus();
                    }
                    ProxyDialog.this.passwordOnly = false;
                }
            }
        });
    }

    @Override
    protected void addScreenContent(JPanel panel) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.weightx = 1.0;
        gc.gridwidth = 1;
        gc.fill = 2;
        gc.anchor = 23;
        gc.insets = new Insets(5, 0, 0, 5);
        panel.add((Component)new JLabel(Messages.getMessages().getString("DownloadError")), gc);
        gc.insets = new Insets(0, 0, 0, 5);
        ++gc.gridy;
        panel.add((Component)new JLabel(Messages.getMessages().getString("ConnectionParametersRequest")), gc);
        gc.insets.top = 10;
        ++gc.gridy;
        gc.fill = 0;
        gc.weightx = 0.0;
        panel.add((Component)this.rdoConnectionDirect, gc);
        gc.insets.top = 0;
        ++gc.gridy;
        panel.add((Component)this.rdoConnectionProxy, gc);
        ++gc.gridy;
        gc.insets.top = 3;
        gc.insets.left += RADIO_BUTTON_WIDTH;
        gc.fill = 2;
        gc.weightx = 1.0;
        ++gc.gridy;
        panel.add((Component)this.createProxySettingsPanel(), gc);
    }

    @Override
    protected boolean isFillVertical() {
        return false;
    }

    private JPanel createProxySettingsPanel() {
        JPanel panel = this.createBorderPanel(Messages.getMessages().getString("ProxySettings"), new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 0.0;
        gc.anchor = 21;
        gc.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)this.lblHost, gc);
        gc.gridy = 1;
        panel.add((Component)this.lblPort, gc);
        gc.gridy = 2;
        gc.gridwidth = 2;
        panel.add((Component)this.chkAuth, gc);
        gc.gridwidth = 1;
        gc.insets.left += RADIO_BUTTON_WIDTH;
        gc.gridy = 3;
        panel.add((Component)this.lblUser, gc);
        gc.gridy = 4;
        panel.add((Component)this.lblPassword, gc);
        gc.insets.left -= RADIO_BUTTON_WIDTH;
        gc.gridx = 1;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.fill = 2;
        panel.add((Component)this.txtHost, gc);
        gc.gridy = 1;
        gc.fill = 0;
        panel.add((Component)this.txtPort, gc);
        gc.gridy = 3;
        panel.add((Component)this.txtAuthUser, gc);
        gc.gridy = 4;
        panel.add((Component)this.txtAuthPassword, gc);
        return panel;
    }

    private void checkEnabled() {
        boolean enabled = this.rdoConnectionProxy.isSelected();
        this.txtHost.setEnabled(enabled);
        this.txtPort.setEnabled(enabled);
        this.chkAuth.setEnabled(enabled);
        this.lblHost.setEnabled(enabled);
        this.lblPort.setEnabled(enabled);
        enabled = enabled && this.chkAuth.isSelected();
        this.txtAuthUser.setEnabled(enabled);
        this.lblUser.setEnabled(enabled);
        this.txtAuthPassword.setEnabled(enabled);
        this.lblPassword.setEnabled(enabled);
    }

    private boolean checkProxySettings() {
        return this.rdoConnectionDirect.isSelected() || this.checkTextField(this.txtHost) && (!this.chkAuth.isSelected() || this.checkTextField(this.txtAuthUser) && this.checkTextField(this.txtAuthPassword));
    }
}

