/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.content.ProxyDialog;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import com.install4j.runtime.installer.helper.versionspecific.ProxyHostInfo;
import com.install4j.runtime.util.Base64;
import java.net.URLConnection;
import java.util.Properties;

class ProxyConfig {
    private ProxyDialog proxyDialog;
    private boolean proxySet = false;
    private boolean savedProxySet = false;
    private boolean auth = false;
    private String host = "";
    private String savedHost = "";
    private String port = "";
    private String savedPort = "";
    private String authPassword = "";
    private String authUser = "";
    public static final String PROXY_SET = "proxySet";
    public static final String PROXY_HOST = "proxyHost";
    public static final String PROXY_PORT = "proxyPort";
    public static final String PROXY_AUTH = "proxyAuth";
    public static final String PROXY_AUTH_USER = "proxyAuthUser";
    public static final String PROXY_AUTH_PASSWORD = "proxyAuthPassword";
    public static final String PASSWORD_REQUIRED_VALUE = "i4j_pw_required";
    private static final String SYSPROP_CLEAR_PROXY_CACHE = "install4j.clearProxyCache";
    private static final String SYSPROP_DISABLE_PROXY_CONFIG = "install4j.disableProxyConfig";
    private static final String EXTERNAL_PROXY_SET = System.getProperty("proxySet");
    private boolean passwordRequired = false;

    public ProxyConfig() {
        if (Boolean.getBoolean(SYSPROP_DISABLE_PROXY_CONFIG)) {
            return;
        }
        if (Boolean.getBoolean(SYSPROP_CLEAR_PROXY_CACHE)) {
            this.setProperties();
            this.saveConfig();
            return;
        }
        String val = EXTERNAL_PROXY_SET;
        if (val != null) {
            this.proxySet = Boolean.parseBoolean(val);
        }
        if ((val = InstallRegistry.getValue(PROXY_SET)) != null) {
            this.savedProxySet = Boolean.parseBoolean(val);
        }
        if ((val = System.getProperty(PROXY_HOST)) != null) {
            this.host = val;
        }
        if ((val = InstallRegistry.getValue(PROXY_HOST)) != null) {
            this.savedHost = val;
        }
        if ((val = System.getProperty(PROXY_PORT)) != null) {
            this.port = val;
        }
        if ((val = InstallRegistry.getValue(PROXY_PORT)) != null) {
            this.savedPort = val;
        }
        if ((val = System.getProperty(PROXY_AUTH)) == null) {
            val = InstallRegistry.getValue(PROXY_AUTH);
        }
        if (val != null) {
            this.auth = Boolean.parseBoolean(val);
        }
        if ((val = System.getProperty(PROXY_AUTH_USER)) == null) {
            val = InstallRegistry.getValue(PROXY_AUTH_USER);
        }
        if (val != null) {
            this.authUser = val;
        }
        if ((val = System.getProperty(PROXY_AUTH_PASSWORD)) == null) {
            if (PASSWORD_REQUIRED_VALUE.equals(InstallRegistry.getValue(PROXY_AUTH_PASSWORD))) {
                this.passwordRequired = true;
            }
        } else {
            this.authPassword = val;
        }
        this.setProperties();
    }

    public boolean isPasswordRequired() {
        return this.passwordRequired;
    }

    public boolean isProxySet() {
        return this.proxySet;
    }

    public boolean isAuth() {
        return this.auth;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public void setProxySet(boolean proxySet) {
        this.proxySet = proxySet;
    }

    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public void setAuthUser(String authUser) {
        this.authUser = authUser;
    }

    public boolean isCanceled() {
        return this.proxyDialog != null ? this.proxyDialog.isCanceled() : false;
    }

    public void show(boolean consoleMode, boolean passwordOnly) throws UserCanceledException {
        if (consoleMode) {
            ConsoleImpl console = ConsoleImpl.getInstance();
            VariableResourceBundleWrapper resourceBundle = Messages.getMessages();
            if (passwordOnly) {
                console.println(resourceBundle.getString("ProxyAuthentication"));
                this.authPassword = console.askPassword(resourceBundle.getString("Password"), "");
            } else {
                console.println(resourceBundle.getString("DownloadError"));
                console.println(resourceBundle.getString("ConnectionParametersRequest"));
                this.proxySet = console.askYesNo(resourceBundle.getString("ProxyConnection"), this.proxySet);
                if (this.proxySet) {
                    this.host = console.askString(resourceBundle.getString("ProxyHost"), this.host);
                    this.port = console.askString(resourceBundle.getString("ProxyPort"), this.port);
                    this.auth = console.askYesNo(resourceBundle.getString("ProxyAuthentication"), this.auth);
                    if (this.auth) {
                        this.authUser = console.askString(resourceBundle.getString("UserName"), this.authUser);
                        this.authPassword = console.askPassword(resourceBundle.getString("Password"), "");
                    }
                }
            }
        } else {
            if (this.proxyDialog == null) {
                this.proxyDialog = ProxyDialog.create(this, Util.getParentWindow());
            }
            this.proxyDialog.setPasswordOnly(passwordOnly);
            this.proxyDialog.setVisible(true);
        }
        this.passwordRequired = false;
        this.setProperties();
        this.saveConfig();
    }

    public void setProperties() {
        System.setProperty(PROXY_SET, String.valueOf(this.isProxySet()));
        if (this.isProxySet()) {
            System.setProperty(PROXY_HOST, this.getHost());
            System.setProperty(PROXY_PORT, this.getPort());
        } else {
            Properties properties = System.getProperties();
            properties.remove(PROXY_HOST);
            properties.remove(PROXY_PORT);
        }
    }

    private void saveConfig() {
        InstallRegistry.setValue(PROXY_SET, String.valueOf(this.proxySet));
        InstallRegistry.setValue(PROXY_HOST, this.host);
        InstallRegistry.setValue(PROXY_PORT, this.port);
        this.savedProxySet = this.proxySet;
        this.savedHost = this.host;
        this.savedPort = this.port;
        InstallRegistry.setValue(PROXY_AUTH, String.valueOf(this.auth));
        InstallRegistry.setValue(PROXY_AUTH_USER, this.authUser);
        if (this.auth && this.authPassword.length() > 0) {
            InstallRegistry.setValue(PROXY_AUTH_PASSWORD, PASSWORD_REQUIRED_VALUE);
        } else {
            InstallRegistry.setValue(PROXY_AUTH_PASSWORD, "");
        }
    }

    public void updateConnection(URLConnection connection) {
        if (this.isProxySet() && this.isAuth()) {
            String credentials = this.getAuthUser() + ":" + this.getAuthPassword();
            String encodedCredentials = Base64.encode(credentials.getBytes());
            connection.setRequestProperty("Proxy-Authorization", "Basic " + encodedCredentials);
        }
    }

    public void update(ProxyHostInfo proxyHostInfo) {
        if (EXTERNAL_PROXY_SET != null && EXTERNAL_PROXY_SET.toLowerCase().equals("true")) {
            return;
        }
        if (proxyHostInfo != null) {
            this.host = proxyHostInfo.getHost();
            this.port = String.valueOf(proxyHostInfo.getPort());
            this.proxySet = true;
            this.auth = false;
        } else {
            this.proxySet = false;
        }
        this.setProperties();
    }

    public boolean shouldTrySavedValues() {
        return this.savedProxySet && !this.savedHost.equals(this.host) && !this.savedPort.equals(this.port);
    }

    public void applySavedValues() {
        this.proxySet = this.savedProxySet;
        this.host = this.savedHost;
        this.port = this.savedPort;
        this.setProperties();
    }
}

