/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.ProxyHelper;
import com.install4j.runtime.installer.helper.versionspecific.ProxyHostInfo;
import com.install4j.runtime.util.VersionCheck;
import com.sun.deploy.net.proxy.AbstractAutoProxyHandler;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.net.proxy.WIExplorerAutoProxyHandler;
import com.sun.deploy.net.proxy.WIExplorerProxyConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;

public class DeployProxyHelper {
    public static ProxyHostInfo getProxyHostInfoWindows(URL url) throws Exception {
        WIExplorerProxyConfig proxyConfig = new WIExplorerProxyConfig();
        BrowserProxyInfo browserProxyInfo = proxyConfig.getBrowserProxyInfo();
        if (browserProxyInfo == null) {
            return null;
        }
        int proxyType = browserProxyInfo.getType();
        if (proxyType == 1) {
            String proxy = browserProxyInfo.getHttpHost();
            int port = browserProxyInfo.getHttpPort();
            if (proxy == null || proxy.length() == 0) {
                return null;
            }
            String[] overrides = browserProxyInfo.getOverrides();
            if (url != null && overrides != null) {
                String host = url.getHost().toLowerCase();
                for (String override : overrides) {
                    if ((override = override.toLowerCase()).length() <= 0 || !(override.startsWith("*") ? host.endsWith((override = override.replace('*', ' ').trim()).toLowerCase()) : host.equals(override))) continue;
                    return null;
                }
            }
            return new ProxyHostInfo(proxy, port);
        }
        if (proxyType == 2 && VersionCheck.checkJavaVersionCompatible("1.7", System.getProperty("java.version"))) {
            ProxyInfo[] proxyInfos;
            WIExplorerAutoProxyHandler handler;
            block15: {
                block14: {
                    handler = new WIExplorerAutoProxyHandler();
                    handler.init(browserProxyInfo);
                    try {
                        Method m = AbstractAutoProxyHandler.class.getDeclaredMethod("contructLegacyPACScript", new Class[0]);
                        m.setAccessible(true);
                        m.invoke((Object)handler, new Object[0]);
                    }
                    catch (Exception e) {
                        if (VersionCheck.checkJavaVersionCompatible("1.8", System.getProperty("java.version"))) {
                            Logger.getInstance().log(null, "PAC detection failed. The JRE has changed in an incompatible way [X1].", false);
                        }
                        if (!ProxyHelper.DEBUG_PAC) break block14;
                        Logger.getInstance().log(e);
                    }
                }
                try {
                    Field f = AbstractAutoProxyHandler.class.getDeclaredField("autoProxyScript");
                    f.setAccessible(true);
                    String script = f.get(handler).toString();
                    if (ProxyHelper.DEBUG_PAC) {
                        Logger.getInstance().log(null, "Using PAC script: " + script, true);
                    }
                    if (!script.contains("function dnsDomainIs")) {
                        Logger.getInstance().log(null, "PAC detection failed. The auto-proxy script fixture is corrupted.", false);
                        return null;
                    }
                }
                catch (Exception e) {
                    Logger.getInstance().log(null, "PAC detection failed. The JRE has changed in an incompatible way [X2].", false);
                    if (!ProxyHelper.DEBUG_PAC) break block15;
                    Logger.getInstance().log(e);
                }
            }
            if ((proxyInfos = handler.getProxyInfo(url)) != null && proxyInfos.length > 0) {
                return DeployProxyHelper.convertToProxyHostInfo(proxyInfos[0]);
            }
        }
        return null;
    }

    private static ProxyHostInfo convertToProxyHostInfo(ProxyInfo proxyInfo) {
        if (proxyInfo.isProxyUsed()) {
            return new ProxyHostInfo(proxyInfo.getProxy(), proxyInfo.getPort());
        }
        return null;
    }
}

