/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

class CountingInputStream
extends FilterInputStream {
    private long count = 0L;

    public CountingInputStream(InputStream is) {
        super(is);
    }

    @Override
    public int read() throws IOException {
        int value = this.in.read();
        if (value > -1) {
            ++this.count;
        }
        return value;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        int bytesRead = this.in.read(b, off, len);
        if (bytesRead > 0) {
            this.count += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        this.count += skipped;
        return skipped;
    }

    public long getCount() {
        return this.count;
    }

    public void resetCount() {
        this.count = 0L;
    }
}

