/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.comm.impl;

import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchIntAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchLongAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

class HelperProgressInterface
implements ProgressInterface,
Serializable {
    private transient HelperCommunication helperCommunication = HelperCommunication.getInstance();
    private transient int lastPercentCompleted = -1;
    private transient int lastSecondaryPercentCompleted = -1;
    private transient String lastStatusMessage;
    private transient String lastDetailMessage;

    HelperProgressInterface() {
    }

    @Override
    public void setStatusMessage(final String message) {
        if (!message.equals(this.lastStatusMessage)) {
            this.helperCommunication.executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                @Override
                protected void run(Context context) {
                    context.getProgressInterface().setStatusMessage(message);
                }
            });
            this.lastStatusMessage = message;
        }
    }

    @Override
    public void setDetailMessage(final String message) {
        if (!message.equals(this.lastDetailMessage)) {
            this.helperCommunication.executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                @Override
                protected void run(Context context) {
                    context.getProgressInterface().setDetailMessage(message);
                }
            });
            this.lastDetailMessage = message;
        }
    }

    @Override
    public void setPercentCompleted(final int value) {
        if (this.lastPercentCompleted != value) {
            this.helperCommunication.executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                @Override
                protected void run(Context context) {
                    context.getProgressInterface().setPercentCompleted(value);
                }
            });
            this.lastPercentCompleted = value;
        }
    }

    @Override
    public void setSecondaryPercentCompleted(final int value) {
        if (this.lastSecondaryPercentCompleted != value) {
            this.helperCommunication.executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                @Override
                protected void run(Context context) {
                    context.getProgressInterface().setSecondaryPercentCompleted(value);
                }
            });
            this.lastSecondaryPercentCompleted = value;
        }
    }

    @Override
    public int getPercentCompleted() {
        return this.helperCommunication.fetchInt(ExecutionContext.UNELEVATED, new FetchLongAction(){

            @Override
            protected long fetchValue(Context context) {
                return context.getProgressInterface().getPercentCompleted();
            }
        });
    }

    @Override
    public void setIndeterminateProgress(final boolean indeterminateProgress) {
        this.helperCommunication.executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) {
                context.getProgressInterface().setIndeterminateProgress(indeterminateProgress);
            }
        });
    }

    @Override
    public void showFailure(final String message) {
        this.helperCommunication.executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) {
                context.getProgressInterface().showFailure(message);
            }
        });
    }

    @Override
    public int askOverwrite(final File file) throws UserCanceledException {
        try {
            return this.helperCommunication.fetchIntChecked(ExecutionContext.UNELEVATED, new FetchIntAction(){

                @Override
                protected int fetchValue(Context context) throws UserCanceledException {
                    return context.getProgressInterface().askOverwrite(file);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int askRetry(final File file) throws UserCanceledException {
        try {
            return this.helperCommunication.fetchIntChecked(ExecutionContext.UNELEVATED, new FetchIntAction(){

                @Override
                protected int fetchValue(Context context) throws UserCanceledException {
                    return context.getProgressInterface().askRetry(file);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean askContinue(final File file) throws UserCanceledException {
        try {
            return this.helperCommunication.fetchBooleanChecked(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

                @Override
                protected boolean fetchValue(Context context) throws UserCanceledException {
                    return context.getProgressInterface().askContinue(file);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

