/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.Controller;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.util.StringUtil;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class Application {
    public static void main(String[] args) {
        if (!HelperCommunication.executeAsHelper(args)) {
            InstallerUtil.setInProcess(false);
            if (args.length == 0) {
                System.err.println("Please provide the application id as first argument");
                System.exit(1);
            }
            String applicationId = args[0];
            String[] rest = new String[args.length - 1];
            System.arraycopy(args, 1, rest, 0, args.length - 1);
            InstallerConfig.setCurrentApplicationId(applicationId);
            Application.runApplication(rest, false, null);
        }
    }

    public static void runApplicationInProcess(String applicationId, String[] arguments, boolean dialog, Window parentWindow) {
        FileInstaller.clearFileInstaller();
        InstallerConfig.clearCurrentApplication();
        InstallerConfig.setCurrentApplicationId(applicationId);
        if (arguments == null) {
            arguments = new String[]{};
        }
        ArrayList<String> allArguments = new ArrayList<String>();
        StringUtil.splitupCommandLine(allArguments, InstallerConfig.getCurrentApplication().getArguments());
        allArguments.addAll(Arrays.asList(arguments));
        arguments = allArguments.toArray(new String[allArguments.size()]);
        Application.runApplication(arguments, dialog, parentWindow);
    }

    private static void runApplication(String[] arguments, boolean dialog, Window parentWindow) {
        try {
            ScreenExecutor screenExecutor = Installer.getScreenExecutor(arguments, dialog, parentWindow);
            InstallerConfig config = InstallerConfig.getCurrentInstance();
            File installationDirectory = new File(ResourceHelper.getRuntimeDir(), "..");
            if (Util.isMacOS() && config.getMacSpecificConfig().isSingleBundle()) {
                installationDirectory = new File(installationDirectory, "../../../..");
            }
            try {
                installationDirectory = installationDirectory.getCanonicalFile();
            }
            catch (IOException e) {
                installationDirectory = installationDirectory.getAbsoluteFile();
            }
            config.setInstallationDirectory(installationDirectory);
            new Controller(screenExecutor).start();
        }
        catch (Throwable t) {
            InstallerUtil.reportException(t);
            InstallerUtil.exit(1);
        }
    }
}

