#include <stdlib.h>
#include <string.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
#define YYPREFIX "yy"
#line 22 "parse.y"
#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>
#include <grp.h>
#include <pwd.h>
#include <string.h>
#include <syslog.h>

#include "fdm.h"
#include "deliver.h"
#include "fetch.h"
#include "match.h"

struct strb	*parse_tags;
struct macros	 parse_macros;
struct macro	*parse_last;	/* last command-line argument macro */

u_int		 parse_ruleidx;
u_int		 parse_actionidx;

ARRAY_DECL(, struct rule *) parse_rulestack;
struct rule	*parse_rule;

struct files	 parse_filestack;
struct file	*parse_file;

int		 yyparse(void);

int
parse_conf(const char *path, struct strings *macros)
{
	struct macro	*macro;
	FILE		*f;
	u_int		 i;

	if ((f = fopen(path, "r")) == NULL)
		return (-1);

	ARRAY_INIT(&parse_rulestack);
	parse_rule = NULL;

	ARRAY_INIT(&parse_filestack);
	parse_file = xmalloc(sizeof *parse_file);

	parse_file->f = f;
	parse_file->line = 0;
	parse_file->path = path;

	strb_create(&parse_tags);
	default_tags(&parse_tags, NULL);
	add_tag(&parse_tags, "home", "%s", conf.user_home);

	TAILQ_INIT(&parse_macros);
	parse_last = NULL;
	for (i = 0; i < ARRAY_LENGTH(macros); i++) {
		parse_last = extract_macro(ARRAY_ITEM(macros, i));
		TAILQ_INSERT_TAIL(&parse_macros, parse_last, entry);
	}

	parse_file->line++;
	yyparse();

	if (!ARRAY_EMPTY(&parse_rulestack))
		yyerror("missing }");
	ARRAY_FREE(&parse_rulestack);

	ARRAY_FREE(&parse_filestack);
	xfree(parse_file);

	while (!TAILQ_EMPTY(&parse_macros)) {
		macro = TAILQ_FIRST(&parse_macros);
		TAILQ_REMOVE(&parse_macros, macro, entry);

		if (macro->type == MACRO_STRING)
			xfree(macro->value.str);
		xfree(macro);
	}

	strb_destroy(&parse_tags);

	fclose(f);
	return (0);
}

__dead printflike1 void
yyerror(const char *fmt, ...)
{
	va_list	ap;
	char   *s;

	xasprintf(&s,
	    "%s: %s at line %d", parse_file->path, fmt, parse_file->line);

	va_start(ap, fmt);
	log_vwrite(LOG_CRIT, s, ap);
	va_end(ap);

	exit(1);
}
#line 251 "parse.y"
#ifndef YYSTYPE_DEFINED
#define YYSTYPE_DEFINED
typedef union
{
	long long		 number;
	char			*string;
	int			 flag;
	u_int			 locks;
	struct {
		struct fetch	*fetch;
		void		*data;
	} fetch;
	struct {
		char		*host;
		char		*port;
	} server;
	enum area		 area;
	enum exprop		 exprop;
	struct actitem		*actitem;
	struct actlist		*actlist;
	struct expr		*expr;
	struct expritem		*expritem;
	struct strings		*strings;
	struct replstrs		*replstrs;
	enum fetch_only		 only;
	struct {
		char		*path;
		enum fetch_only	 only;
	} poponly;
	struct {
		int		 flags;
		char		*str;
	} re;
	gid_t			 localgid;
	enum cmp		 cmp;
	struct rule		*rule;
	struct {
		char		*user;
		int		 user_netrc;
		char		*pass;
		int		 pass_netrc;
	} userpass;
	userfunction		 ufn;
	struct userfunctions	*ufns;
} YYSTYPE;
#endif /* YYSTYPE_DEFINED */
#line 161 "parse.c"
#define TOKACCOUNT 257
#define TOKACCOUNTS 258
#define TOKACTION 259
#define TOKACTIONS 260
#define TOKADDHEADER 261
#define TOKADDTOCACHE 262
#define TOKAGE 263
#define TOKALL 264
#define TOKALLOWMANY 265
#define TOKAND 266
#define TOKANYNAME 267
#define TOKANYSIZE 268
#define TOKANYTYPE 269
#define TOKAPPEND 270
#define TOKATTACHMENT 271
#define TOKBODY 272
#define TOKBYTES 273
#define TOKCACHE 274
#define TOKCASE 275
#define TOKCMDUSER 276
#define TOKCOMPRESS 277
#define TOKCONTINUE 278
#define TOKCOUNT 279
#define TOKDAYS 280
#define TOKDEFUSER 281
#define TOKDELTOOBIG 282
#define TOKDISABLED 283
#define TOKDOMAIN 284
#define TOKDOTLOCK 285
#define TOKDROP 286
#define TOKEQ 287
#define TOKEXEC 288
#define TOKEXPIRE 289
#define TOKFCNTL 290
#define TOKFILEGROUP 291
#define TOKFILEUMASK 292
#define TOKFLOCK 293
#define TOKFOLDER 294
#define TOKFOLDERS 295
#define TOKFROM 296
#define TOKGIGABYTES 297
#define TOKGROUP 298
#define TOKGROUPS 299
#define TOKHEADER 300
#define TOKHEADERS 301
#define TOKHOURS 302
#define TOKIGNOREERRORS 303
#define TOKIMAP 304
#define TOKIMAPS 305
#define TOKIMPLACT 306
#define TOKIN 307
#define TOKINCACHE 308
#define TOKINSECURE 309
#define TOKINVALID 310
#define TOKKEEP 311
#define TOKKEY 312
#define TOKKILOBYTES 313
#define TOKLOCKFILE 314
#define TOKLOCKTIMEOUT 315
#define TOKLOCKTYPES 316
#define TOKLOCKWAIT 317
#define TOKLOOKUPORDER 318
#define TOKMAILDIR 319
#define TOKMAILDIRS 320
#define TOKMATCH 321
#define TOKMATCHED 322
#define TOKMAXSIZE 323
#define TOKMBOX 324
#define TOKMBOXES 325
#define TOKMEGABYTES 326
#define TOKMINUTES 327
#define TOKMONTHS 328
#define TOKNE 329
#define TOKNEWONLY 330
#define TOKNNTP 331
#define TOKNNTPS 332
#define TOKNOAPOP 333
#define TOKNOCRAMMD5 334
#define TOKNOCREATE 335
#define TOKNOLOGIN 336
#define TOKNONE 337
#define TOKNORECEIVED 338
#define TOKNOT 339
#define TOKNOUIDL 340
#define TOKNOVERIFY 341
#define TOKOLDONLY 342
#define TOKOR 343
#define TOKPARALLELACCOUNTS 344
#define TOKPASS 345
#define TOKPASSWD 346
#define TOKPIPE 347
#define TOKPOP3 348
#define TOKPOP3S 349
#define TOKPORT 350
#define TOKPROXY 351
#define TOKPURGEAFTER 352
#define TOKQUEUEHIGH 353
#define TOKQUEUELOW 354
#define TOKREMOVEFROMCACHE 355
#define TOKREMOVEHEADER 356
#define TOKREMOVEHEADERS 357
#define TOKRETURNS 358
#define TOKREWRITE 359
#define TOKSECONDS 360
#define TOKSERVER 361
#define TOKSET 362
#define TOKSIZE 363
#define TOKSMTP 364
#define TOKSTARTTLS 365
#define TOKSTDIN 366
#define TOKSTDOUT 367
#define TOKSTRING 368
#define TOKSTRIPCHARACTERS 369
#define TOKTAG 370
#define TOKTAGGED 371
#define TOKTIMEOUT 372
#define TOKTO 373
#define TOKTOTALSIZE 374
#define TOKUNMATCHED 375
#define TOKUSER 376
#define TOKUSERS 377
#define TOKVALUE 378
#define TOKVERIFYCERTS 379
#define TOKWEEKS 380
#define TOKWRITE 381
#define TOKYEARS 382
#define NONE 383
#define NUMBER 384
#define STRING 385
#define STRMACRO 386
#define NUMMACRO 387
#define STRCOMMAND 388
#define NUMCOMMAND 389
#define YYERRCODE 256
const short yylhs[] =
	{                                        -1,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   79,
   79,   80,   80,   81,   81,   82,   82,   83,   83,   84,
   84,   85,   85,   86,   86,   56,   56,   57,   57,   52,
   52,   52,   53,   53,   34,   34,   34,   54,   55,   32,
   32,   32,   32,   32,   33,   33,   33,   33,   33,   33,
   33,   33,   36,   36,   78,   76,   76,   76,   76,   76,
   76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
   76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
   76,   76,   76,   74,   74,   40,   40,   60,   60,   61,
   61,   70,   71,   71,   42,   42,   62,   62,   63,   63,
   65,   65,   30,   30,   30,   31,   31,   31,   29,   29,
   59,   59,   44,   44,   44,   45,   45,   13,   13,   15,
   15,   14,   14,   49,   49,   48,   48,   50,   50,   51,
   51,   18,   18,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    2,
    2,   73,   73,   43,   43,   41,   41,   12,   12,    3,
    3,    3,    3,   35,   35,   46,   46,    5,    5,    6,
    6,    4,    4,   16,   16,   17,   17,   10,   10,    9,
    9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
    9,    9,    9,    9,    9,    9,    8,    8,    7,    7,
   47,   47,   47,   47,   77,   75,   66,   66,   58,   58,
   64,   64,   24,   24,   25,   25,   27,   27,   26,   26,
   28,   28,   19,   19,   20,   20,   37,   37,   21,   21,
   22,   22,   23,   23,   69,   69,   69,   69,   68,   67,
   67,   39,   39,   38,   38,   11,   11,   11,   11,   11,
   11,   11,   11,   72,
};
const short yylen[] =
	{                                         2,
    0,    2,    2,    2,    2,    2,    2,    2,    2,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    2,    1,    2,    0,    1,
    1,    1,    1,    3,    1,    1,    1,    1,    1,    1,
    2,    2,    2,    2,    1,    2,    2,    2,    2,    2,
    2,    2,    2,    0,    3,    3,    3,    3,    2,    3,
    2,    2,    2,    3,    3,    3,    3,    3,    3,    3,
    3,    2,    3,    3,    3,    3,    2,    2,    3,    3,
    3,    3,    3,    3,    3,    2,    1,    2,    1,    2,
    1,    1,    2,    1,    2,    4,    2,    4,    2,    4,
    2,    4,    1,    1,    1,    2,    1,    1,    1,    1,
    0,    2,    0,    2,    4,    2,    1,    1,    0,    1,
    0,    1,    0,    2,    2,    3,    2,    0,    2,    0,
    2,    1,    0,    2,    2,    2,    2,    1,    3,    3,
    9,    4,    1,    3,    4,    4,    1,    1,    1,    2,
    1,    4,    6,    2,    4,    2,    4,    0,    1,    0,
    2,    2,    2,    1,    0,    1,    0,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    2,
    3,    2,   10,    3,    4,    5,    5,    2,    2,    4,
    3,    5,    5,    5,    4,    4,    3,    2,    1,    2,
    4,    6,    3,    1,    1,    3,    0,    1,    0,    2,
    2,    4,    1,    0,    1,    0,    1,    0,    1,    0,
    1,    0,    1,    0,    1,    0,    1,    1,    1,    1,
    1,    1,    1,    1,    4,    0,    2,    2,    4,    1,
    0,    3,    0,    1,    0,    9,    6,   10,    6,    1,
    1,    1,    8,    6,
};
const short yydefred[] =
	{                                      1,
    0,    0,    0,    0,    0,    0,    9,    0,    0,  205,
    2,    3,    4,    5,    6,    7,    8,   31,   32,   30,
   33,    0,    0,    0,    0,    0,  118,    0,    0,    0,
   63,    0,    0,   61,    0,    0,   62,    0,    0,    0,
    0,   59,    0,    0,   78,   77,    0,    0,    0,    0,
    0,    0,    0,   72,    0,    0,    0,  122,    0,   12,
   13,    0,    0,    0,   55,  204,    0,  206,  178,  179,
    0,    0,   14,   15,    0,  180,    0,    0,  174,    0,
  188,  175,    0,    0,    0,  189,    0,  182,    0,  117,
    0,    0,    0,   79,   36,   37,   35,   80,  110,  109,
   81,   83,   74,   73,   58,   60,    0,  105,  103,  104,
  108,  107,    0,   92,   94,    0,   56,    0,   70,   71,
   76,   75,   68,   69,    0,   67,    0,   85,   34,    0,
   10,   11,    0,    0,  177,  148,  231,  232,  149,    0,
    0,    0,   24,   25,    0,    0,  143,    0,  176,    0,
  152,    0,    0,    0,  147,  138,    0,    0,    0,    0,
   53,    0,    0,    0,  198,  191,  168,  169,    0,    0,
    0,    0,    0,    0,  116,    0,    0,    0,    0,    0,
    0,  181,    0,    0,   49,   46,   47,   51,   48,   50,
   52,  106,   93,   41,   44,   42,   43,    0,   20,   21,
   22,   23,  233,  234,    0,  230,  250,    0,    0,    0,
    0,  251,  252,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  151,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  159,  203,    0,    0,  197,
  190,    0,    0,    0,  170,  171,    0,  172,  173,    0,
    0,  185,    0,    0,    0,  161,  163,  162,    0,    0,
    0,  120,  254,    0,    0,    0,    0,   97,    0,   99,
    0,    0,  139,    0,  132,  140,    0,    0,    0,    0,
    0,  144,  153,  150,    0,    0,    0,    0,    0,  115,
    0,    0,  201,  194,  192,  193,    0,  186,    0,    0,
  155,    0,    0,    0,    0,    0,   91,    0,    0,    0,
    0,    0,    0,  126,    0,    0,  142,    0,  238,    0,
   18,   19,    0,    0,  157,   96,    0,    0,    0,    0,
  240,    0,  227,  228,    0,    0,  208,    0,    0,   16,
   17,    0,    0,   98,   90,  100,  125,  124,    0,    0,
  223,    0,    0,  202,  164,    0,    0,    0,    0,    0,
  225,    0,  244,    0,    0,  101,    0,    0,  211,  235,
  213,    0,    0,    0,  249,  247,  242,    0,    0,   89,
    0,    0,    0,  215,    0,  166,    0,  239,  219,    0,
    0,  102,   88,    0,  212,  217,    0,  183,    0,    0,
  221,  253,  141,  246,    0,  248,
};
const short yydgoto[] =
	{                                       1,
  225,  226,  182,  247,  169,  249,   28,   71,   29,   72,
  208,  237,   30,   59,  263,  152,  153,  276,  352,  362,
  209,  154,  211,  372,  385,  390,  397,  402,   98,  112,
  113,  117,  106,  107,  356,   65,  335,  364,  336,  288,
  155,  156,   88,   62,   89,  387,   68,  223,  314,  317,
  280,   21,   22,   90,  307,  273,  282,  323,  255,  381,
  308,  212,  213,  342,  337,  338,  330,  331,  287,  115,
  116,   11,   12,   13,   14,   15,   16,   17,  157,   63,
   91,  343,  339,  214,  215,  158,
};
const short yysindex[] =
	{                                      0,
  716, -256, -256, -256, -306, 3888,    0,    7,   17,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   -3, -211, -236,   -3, -207,    0,  -53, -244, 1267,
    0, -256, -256,    0, -186, -223,    0, -234, -256, -286,
 -232,    0, -260, -286,    0,    0, -286, -256, -299, -286,
 -286, -256, -286,    0, -256, -286, -256,    0, -236,    0,
    0, 3540, -105, -286,    0,    0, -165,    0,    0,    0,
 -244, -306,    0,    0,  -28,    0, -222, -256,    0, -256,
    0,    0,   44, -256, -256,    0, -256,    0, -205,    0,
  -72,   -3,   -3,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -263,    0,    0,    0,
    0,    0, -206,    0,    0, -260,    0, -230,    0,    0,
    0,    0,    0,    0,   -3,    0,   -3,    0,    0, 2759,
    0,    0, -256, -256,    0,    0,    0,    0,    0, -256,
 -256, -256,    0,    0, -256, -226,    0, -256,    0, 3863,
    0, -256, -256, -226,    0,    0,  -13,   -5, -256,   -3,
    0, -162, 3351, -306,    0,    0,    0,    0, -286, -256,
   44, -256,  -55,   44,    0, -181, -286,  -43,   -3,  -40,
 -201,    0, -256,   -3,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -210,    0,    0,
    0,    0,    0,    0, -198,    0,    0, -156, -226, -226,
 -226,    0,    0,   11,   19,  -24, -147,   -3,  -37, -137,
   -3, -256, -134,  -39,    0, 3641,   -3,   -3, -321, -256,
   -3, -256,   -3, -116,   -3,    0,    0, 3771, -162,    0,
    0,   -3, -286,   -3,    0,    0, -286,    0,    0, -286,
 -256,    0, -265, -256, -176,    0,    0,    0, -100, -256,
 -256,    0,    0, -321, -321, -321, -256,    0, -256,    0,
 -256,   -3,    0, -256,    0,    0, -256, -167, -256, -189,
 -256,    0,    0,    0, -256, -256, -150,   32,   38,    0,
   -3, 3732,    0,    0,    0,    0,   -3,    0,   -3,  145,
    0, -188, -188, -276, -150, -130,    0,   42,   47,   -3,
   -3,   -3, -151,    0,   -3, -256,    0,   -3,    0, -154,
    0,    0, -149, -256,    0,    0, -162, -286, -256, -150,
    0, -276,    0,    0,  -80, -138,    0, -276,   23,    0,
    0,  -78,   27,    0,    0,    0,    0,    0,   -3, -256,
    0, -129,   -3,    0,    0,  160, -133, -276, -138, -256,
    0, -149,    0, -149, -256,    0, -256, -256,    0,    0,
    0, -128, -265, -256,    0,    0,    0, -131, -129,    0,
   56, -149,   64,    0, -158,    0,  172,    0,    0, -158,
 -128,    0,    0,  -95,    0,    0,  -95,    0,  -95, -158,
    0,    0,    0,    0,  -95,    0,};
const short yyrindex[] =
	{                                      0,
    0,    0,    0,    0, 3746,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    1, 3078, 3620,   81,  278,    0,  -89, -121,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 3159,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  -73, 3746,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -112,    0,
    0,  602,  830,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1183,    0,    0,    0,
    0,    0, 1453,    0,    0, 1951,    0, 1571,    0,    0,
    0,    0,    0,    0, 2986,    0, 2991,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 3465,
    0, 3029,    0, 3746,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  -86, -143,
    0,    0,    0,  -49,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -145,    0,    0,
    0,    0,    0,    0, -142,    0,    0, 3045,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1411, 1502,    0,
 1617,    0, 1114, 1708,    0,    0, 1799, 1890,  429,    0,
 2005,    0, 2096,    0,   68,    0,    0,    0, 3029,    0,
    0,  492,    0,  721,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  395,  779, -120,    0,    0,    0,    0,
    0, 2187,    0,    0,    0,    0,    0,  177,    0, 2278,
    0,    0,    0,    0,    0,    0,  543,    0,    0,    0,
   72,    0,    0,    0,    0,    0,  826,    0, -140,    0,
    0,  893,    0, 2838, 1007,    0,    0,    0,    0, 2393,
 2484, 2575,    0,    0, 1229,    0,    0, 2666,    0,  315,
    0,    0,  772,    0,    0,    0, 3029,  176,    0, 1068,
    0,  487,    0,    0,    0, 2973,    0, 2935,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 2781,    0,
    0,  886,  658,    0,    0,    0,    0, 2349, 2694,    0,
    0, 1544,    0, 2011,    0,    0,    0,    0,    0,    0,
    0, 1000,  180,    0,    0,    0,    0, 2399, 1623,    0,
    0, 1918,    0,    0, 1320,    0,    0,    0,    0, 2306,
 2978,    0,    0, 2737,    0,    0, 2872,    0, 2737, 2306,
    0,    0,    0,    0, 2737,    0,};
const short yygindex[] =
	{                                      0,
  -50,  -11,    0,    0,  -62,    0,    0,    0,  -56,  154,
    0, -212,    0,    0,    0,  198,    0,    0, -302, -115,
    0,  100,    0, -132, -152,    0, -331, -272,    0,  128,
    0, -136,  -33,  -21,    0,    0, -282, -113,  -84, -110,
  179,    0,    0,   16, -245,    0,    0, -118,    0,    0,
    0,  186, 3414, 3163,    9,    0,    0,    0,    0, -119,
  -19,    0,    0,    0,    0,  -79,    0,  -51, -106,  137,
    0,    0,    0,    0,    0,    0,    0,    0,  187,    0,
    0,    0,  -14,    0,    0,    0,
};
#define YYTABLESIZE 4267
const short yytable[] =
	{                                      57,
   38,  199,   57,   57,  167,   57,  168,  298,  290,   78,
  160,  151,   26,   99,  102,  165,  185,  159,   57,  126,
  177,   69,  118,  285,  301,  119,  293,  122,  123,  124,
  161,  167,   27,  168,  128,  229,  184,  121,  186,   57,
  252,   38,  194,   67,  170,  171,  172,  105,  234,  200,
  183,  103,  108,  333,  286,  363,  173,  109,  399,  378,
  110,  379,  256,  187,  188,  334,  195,   55,  405,   66,
  257,   58,  259,  154,  130,  363,  104,   56,  108,  394,
   39,   64,  196,  109,   95,  114,  110,   96,  176,   97,
  264,  265,  266,  131,  132,  197,  189,   95,   70,  258,
   96,  181,   97,  167,  111,  168,  294,  240,  243,  230,
  248,  250,  239,  296,  354,  236,  190,  232,  191,   18,
   19,  289,   20,   38,  403,   38,  404,  386,   18,   19,
  251,   20,  406,  267,  222,  241,  260,  199,  199,   60,
   61,  269,  217,  321,  322,  365,  160,  160,  261,  368,
  220,  174,  101,  160,  262,  118,  325,  304,  305,  306,
   95,  279,  326,   96,  274,   97,  344,  340,  341,  113,
  113,  346,  184,  184,  277,  284,  127,  236,  236,  184,
  392,  300,  313,  316,  328,  200,  200,  329,  395,   94,
  350,  351,   87,  360,  361,  367,   86,   95,   18,   19,
   96,   20,   97,  373,  371,   39,  396,  384,  389,  154,
  154,  374,  398,  401,  111,  231,  154,  112,  229,  165,
  167,  118,  268,  270,  164,  295,  292,   87,  118,  210,
  160,  245,   95,   18,   19,   96,   20,   97,  400,  275,
  192,  284,  129,  376,  375,  162,  391,  359,  383,  309,
  358,  332,  193,  163,  199,  199,  184,   38,    0,   38,
   38,   38,   38,  160,  160,    0,   38,    0,   18,   19,
   38,   20,  324,  246,   38,    0,    0,   54,   38,   18,
   19,  166,   20,   38,   18,   19,   38,   20,   38,  184,
  184,  347,    0,  154,   38,   38,   38,    0,   38,   38,
    0,  127,  200,  200,   38,   38,  355,   38,    0,   38,
    0,   38,   18,   19,  237,   20,  345,  345,    0,   38,
   38,   38,   60,   61,   38,   38,  154,  154,    0,  253,
   38,   38,   38,   38,   38,  254,   38,   39,  281,   39,
   38,   38,   38,   38,    0,   38,    0,   38,   38,   38,
   38,    0,    0,  271,   39,   38,   38,   38,    0,   38,
   18,   19,   38,   20,   38,   38,   38,   38,  377,   39,
   38,   18,   19,   38,   20,  382,   38,   38,    0,   18,
   19,   38,   20,   38,    0,   38,   38,   38,   38,   39,
    0,   39,   39,    0,  236,   18,   19,    0,   20,    0,
    0,   39,   54,   18,   19,    0,   20,   18,   19,    0,
   20,   18,   19,   39,   20,    0,   18,   19,    0,   20,
   39,   39,   18,   19,    0,   20,   18,   19,  236,   20,
    0,   18,   19,  127,   20,  127,  127,  127,  127,  237,
   18,   19,   39,   20,    0,   39,  127,    0,   18,   19,
  127,   20,   87,   87,  127,   87,   86,   86,    0,   86,
    0,    0,  127,   39,  127,   39,   39,   39,   39,    0,
  127,  127,  127,    0,  127,  127,    0,    0,    0,    0,
  127,  127,    0,    0,    0,  127,  243,  127,    0,    0,
    0,    0,    0,    0,    0,  127,    0,  127,    0,    0,
  127,    0,    0,    0,    0,    0,  127,    0,    0,  127,
  127,    0,  127,    0,    0,    0,  127,  127,  127,  236,
    0,  127,    0,  127,    0,    0,    0,    0,    0,    0,
    0,  127,  127,  127,   54,  127,   54,    0,  127,    0,
  127,  127,  209,  127,    0,    0,  127,    0,    0,  127,
    0,   54,  127,  236,    0,    0,    0,  127,    0,  127,
    0,    0,  127,  127,    0,    0,    0,    0,    0,    0,
    0,  237,    0,  237,  237,  237,  237,    0,    0,    0,
    0,    0,    0,    0,  237,    0,    0,    0,  237,    0,
    0,    0,  237,    0,    0,    0,    0,    0,   54,    0,
  237,   65,  237,    0,    0,    0,    0,    0,  237,  237,
    0,  243,  237,  237,  196,    0,    0,    0,  237,  237,
    0,    0,    0,  237,    0,  237,    0,    0,    0,    0,
    0,    0,    0,  237,    0,  237,    0,    0,  237,   54,
    0,    0,    0,    0,  237,    0,    0,  237,  237,    0,
  237,  236,    0,  236,  237,  237,  237,  210,    0,    0,
   54,  237,    0,   54,   54,    0,    0,  209,  236,  237,
  237,  237,    0,  237,    0,    0,  237,    0,  237,  237,
    0,  237,    0,    0,  237,  236,    0,  236,  236,  236,
  236,    0,    0,    0,    0,  237,    0,  237,  236,    0,
  237,  237,  236,  236,    0,  236,  236,    0,    0,    0,
    0,    0,    0,    0,  236,  236,  236,    0,    0,    0,
    0,    0,  236,  236,  236,    0,   65,  236,    0,    0,
    0,    0,  236,  236,  236,  236,  236,  236,    0,  236,
    0,    0,    0,  243,    0,  243,    0,  236,    0,  236,
  196,  196,  236,    0,    0,    0,  236,  196,    0,  236,
  243,    0,  236,    0,  236,    0,    0,    0,    0,  236,
    0,  224,    0,    0,    0,  236,    0,  236,  236,    0,
  236,  236,  210,  236,  236,  236,    0,  236,    0,    0,
  236,    0,  236,  236,    0,  236,    0,  243,  236,  209,
    0,  209,  209,  209,  209,    0,    0,  243,    0,  236,
    0,  236,  209,    0,  236,  236,  209,    0,    0,  243,
  209,    0,    0,    0,    0,    0,    0,    0,  209,   64,
  209,    0,    0,    0,  196,    0,    0,    0,    0,    0,
   10,    0,    0,  195,    0,    0,  209,  209,  243,    0,
    0,  209,    0,  209,    0,    0,    0,    0,   65,    0,
   65,  209,    0,  209,    0,    0,  209,  196,  196,  243,
    0,    0,  243,  243,    0,   65,  209,    0,  209,    0,
    0,    0,    0,  209,    0,  214,    0,    0,    0,  209,
    0,    0,  241,    0,    0,    0,  224,  209,  209,  209,
    0,  209,    0,  236,  209,    0,  209,  209,    0,  209,
    0,    0,  209,    0,  210,    0,  210,  210,  210,  210,
    0,    0,   65,  209,    0,  209,    0,  210,  209,  209,
    0,  210,    0,    0,    0,  210,    0,    0,    0,    0,
    0,    0,    0,  210,    0,  210,    0,    0,  187,    0,
    0,    0,    0,    0,   64,    0,    0,    0,    0,    0,
    0,  210,  210,   65,    0,    0,  210,    0,  210,    0,
    0,    0,    2,    0,    3,    0,  210,    0,  210,  195,
  195,  210,    0,    0,   65,    0,  195,   65,   65,    4,
    0,  210,    0,  210,    0,    0,    0,    0,  210,  216,
    0,    0,    0,    0,  210,    0,  207,    0,    0,    0,
  214,    0,  210,  210,  210,    0,  210,  241,    0,  210,
    0,  210,  210,    0,  210,    0,    0,  210,  224,    0,
  224,  224,  224,  224,    0,  236,    5,  236,  210,    0,
  210,  224,    0,  210,  210,  224,    0,    0,    0,  224,
    0,    0,  236,    0,    0,    0,    0,  224,    0,  224,
    0,    0,    0,  195,    0,    0,    0,  207,    0,    0,
    0,    0,  236,  236,    0,  224,  224,    6,    0,    0,
  224,    0,  224,    0,  187,  187,   64,  236,   64,  236,
  224,  187,  224,    0,    0,  224,  195,  195,    7,  236,
    0,    8,    9,   64,    0,  224,    0,  224,  236,    0,
    0,    0,  236,  130,  236,    0,    0,    0,  224,  236,
  236,    0,    0,    0,  216,    0,  224,  224,  224,    0,
  224,  207,    0,  224,    0,  224,  224,    0,  224,    0,
  236,  224,  214,  236,  214,  214,  214,  214,    0,  241,
   64,  241,  224,    0,  224,  214,    0,  224,  224,  214,
    0,  236,    0,  214,  236,  236,  241,    0,  187,    0,
    0,  214,    0,  214,    0,    0,    0,    0,    0,    0,
    0,    0,   45,    0,    0,    0,  241,  241,    0,  214,
  214,   64,  207,    0,  214,    0,  214,    0,    0,    0,
    0,  187,  187,  241,  214,    0,  214,    0,    0,  214,
    0,    0,   64,  241,    0,   64,   64,    0,    0,    0,
    0,  214,  241,    0,    0,    0,    0,    0,  131,    0,
    0,    0,  214,    0,  241,    0,    0,    0,  130,    0,
  214,  214,  214,    0,  214,    0,    0,  214,    0,  214,
  214,    0,  214,    0,  241,  214,  216,    0,  216,  216,
  216,  216,    0,  207,    0,  207,  214,    0,  214,  216,
    0,  214,  214,  216,    0,  241,    0,  216,  241,  241,
  207,    0,    0,    0,    0,  216,    0,  216,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  216,  216,   45,    0,   45,  216,    0,
  216,    0,    0,    0,    0,  207,    0,  207,  216,  218,
  216,    0,    0,  216,  207,    0,  207,  207,    0,    0,
    0,    0,    0,    0,    0,    0,  207,    0,    0,    0,
  207,  207,  207,    0,    0,    0,  216,  207,  207,    0,
    0,    0,    0,  131,  216,  216,  216,    0,  216,    0,
    0,  216,    0,  216,  216,    0,  216,    0,  207,  216,
  130,  207,  130,  130,  130,  130,    0,    0,  207,    0,
  216,    0,  216,  130,    0,  216,  216,  130,  207,  207,
    0,  130,  207,  207,    0,    0,    0,  207,    0,  130,
    0,  130,    0,    0,    0,    0,    0,    0,    0,  207,
  137,    0,    0,    0,    0,    0,    0,  130,  130,    0,
    0,    0,    0,    0,  130,    0,    0,    0,    0,  207,
    0,    0,  130,    0,  130,    0,    0,  130,    0,   45,
    0,   45,   45,    0,  218,    0,    0,    0,   45,    0,
  207,    0,   57,  207,  207,    0,   45,    0,    0,    0,
  130,    0,    0,    0,    0,    0,    0,    0,  130,  130,
  130,    0,  130,    0,    0,  130,    0,  130,    0,    0,
  130,    0,    0,  130,    0,  131,  130,  131,  131,  131,
  131,    0,    0,    0,  130,    0,  130,    0,  131,  130,
  130,  133,  131,   45,    0,    0,  131,    0,    0,    0,
    0,    0,    0,    0,  131,    0,  131,    0,    0,    0,
    0,    0,    0,   73,   74,   45,    0,    0,    0,   75,
   76,    0,  131,  131,    0,  137,    0,   77,    0,  131,
    0,   78,    0,  224,   45,    0,    0,  131,    0,  131,
    0,    0,  131,    0,   79,    0,    0,    0,   45,   45,
    0,    0,    0,    0,    0,   45,    0,    0,   45,   45,
   40,    0,    0,    0,   80,  131,  218,   57,  218,  218,
  218,  218,    0,  131,  131,  131,    0,  131,   81,  218,
  131,    0,  131,  218,    0,  131,    0,  218,  131,    0,
    0,  131,    0,    0,    0,  218,    0,  218,    0,  131,
    0,  131,    0,   82,  131,  131,  135,    0,    0,    0,
    0,    0,  214,  218,  218,    0,  133,    0,  218,   83,
  218,    0,    0,    0,   84,    0,    0,   85,  218,    0,
  218,   86,    0,  218,    0,    0,    0,    0,    0,    0,
    0,   18,   19,    0,   20,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  218,  137,  224,  137,
  137,  137,  137,    0,  218,  218,  218,    0,  218,    0,
  137,  218,    0,  218,  137,    0,  218,    0,  137,  218,
    0,    0,    0,   40,    0,   40,  137,    0,  137,    0,
  218,    0,  218,    0,    0,  218,  218,   29,    0,   57,
    0,   57,    0,    0,  137,  137,    0,    0,    0,    0,
    0,  137,    0,    0,    0,    0,   57,    0,    0,  137,
    0,  137,    0,    0,  137,    0,    0,    0,    0,    0,
    0,  135,    0,    0,    0,    0,    0,  214,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  137,  133,    0,
  133,  133,  133,  133,    0,  137,  137,  137,    0,  137,
    0,  133,  137,   57,  137,  133,    0,  137,    0,  133,
  137,    0,    0,    0,    0,    0,    0,  133,    0,  133,
    0,  137,    0,  137,    0,    0,  137,  137,  134,    0,
  224,    0,  224,    0,    0,  133,  133,    0,    0,    0,
    0,    0,  133,    0,   57,    0,    0,  224,    0,    0,
  133,    0,  133,    0,    0,  133,    0,   40,    0,   40,
   40,    0,   29,    0,    0,   57,   40,    0,   57,   57,
    0,    0,    0,    0,   40,    0,    0,    0,  133,    0,
    0,    0,  224,    0,  224,    0,  133,  133,  133,    0,
  133,    0,    0,  133,  224,  133,    0,    0,  133,    0,
    0,  133,    0,  135,    0,  135,  135,  135,  135,  214,
    0,  214,  133,  224,  133,    0,  135,  133,  133,  136,
  135,   40,    0,    0,  135,    0,  214,    0,    0,    0,
    0,    0,  135,    0,  135,  224,    0,    0,  224,    0,
    0,    0,    0,   40,    0,    0,    0,  224,    0,    0,
  135,  135,    0,  134,    0,    0,  224,  135,    0,  224,
  224,  214,   40,  214,    0,  135,    0,  135,    0,    0,
  135,    0,    0,  214,    0,    0,   40,   40,    0,    0,
   82,    0,    0,   40,    0,    0,   40,   40,  214,    0,
    0,    0,    0,  135,   29,    0,   29,   29,   29,   29,
    0,  135,  135,  135,    0,  135,    0,   29,  135,    0,
  135,   29,    0,  135,  214,   29,  135,  214,    0,    0,
    0,    0,    0,   29,    0,   29,    0,  135,    0,  135,
    0,    0,  135,  135,  156,  214,    0,    0,  214,  214,
  224,   29,   29,    0,  136,    0,    0,    0,   29,    0,
    0,    0,    0,    0,    0,    0,   29,    0,   29,    0,
    0,   29,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  224,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   29,  134,    0,  134,  134,  134,
  134,    0,   29,   29,   29,    0,   29,    0,  134,   29,
    0,   29,  134,    0,   29,   82,  134,   29,    0,    0,
    0,    0,    0,    0,  134,    0,  134,    0,   29,    0,
   29,    0,    0,   29,   29,   95,    0,    0,    0,    0,
    0,    0,  134,  134,    0,    0,    0,    0,    0,  134,
    0,    0,    0,    0,    0,    0,    0,  134,    0,  134,
    0,    0,  134,    0,    0,    0,    0,    0,    0,  156,
    0,    0,    0,    0,    0,  224,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  134,  136,    0,  136,  136,
  136,  136,    0,  134,  134,  134,    0,  134,    0,  136,
  134,    0,  134,  136,    0,  134,    0,  136,  134,    0,
    0,    0,    0,    0,  224,  136,  224,  136,    0,  134,
    0,  134,    0,    0,  134,  134,   27,    0,    0,    0,
    0,  224,    0,  136,  136,    0,    0,    0,    0,    0,
  136,    0,    0,    0,    0,    0,    0,   82,  136,   82,
  136,    0,    0,  136,    0,    0,    0,    0,    0,    0,
   95,    0,    0,    0,   82,    0,  224,    0,  224,    0,
    0,    0,    0,    0,    0,    0,  136,    0,  224,    0,
    0,    0,    0,    0,  136,  136,  136,    0,  136,    0,
    0,  136,    0,  136,    0,    0,  136,    0,    0,  136,
    0,  156,    0,  156,  156,  156,  156,  224,    0,  224,
  136,   82,  136,    0,  156,  136,  136,  128,  156,  224,
    0,    0,  156,    0,  224,    0,    0,    0,    0,    0,
  156,    0,  156,    0,    0,    0,    0,    0,    0,    0,
  224,    0,    0,  224,  224,  218,    0,    0,  156,  156,
    0,   27,   82,    0,    0,  156,    0,    0,    0,  224,
    0,  224,    0,  156,    0,  156,    0,    0,  156,    0,
    0,  224,    0,   82,    0,    0,   82,   82,    0,    0,
    0,    0,    0,    0,  224,    0,  224,    0,  245,    0,
    0,  156,   95,    0,   95,   95,   95,   95,    0,  156,
  156,  156,    0,  156,    0,   95,  156,    0,  156,   95,
    0,  156,  224,   95,  156,  224,    0,    0,    0,    0,
    0,   95,    0,   95,    0,  156,    0,  156,    0,    0,
  156,  156,   26,  224,    0,    0,  224,  224,  220,   95,
   95,    0,  128,    0,    0,    0,   95,    0,    0,    0,
    0,    0,    0,    0,   95,    0,   95,    0,    0,   95,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  218,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   95,   27,    0,   27,   27,   27,   27,    0,
   95,   95,   95,    0,   95,    0,   27,   95,    0,   95,
   27,    0,   95,    0,   27,   95,    0,    0,    0,    0,
    0,    0,   27,  245,   27,    0,   95,    0,   95,    0,
    0,   95,   95,  145,    0,    0,    0,    0,    0,    0,
   27,   27,    0,    0,    0,    0,    0,   27,    0,    0,
    0,    0,    0,    0,    0,   27,    0,   27,    0,    0,
   27,    0,    0,    0,    0,    0,    0,   26,    0,    0,
    0,    0,    0,  220,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   27,  128,    0,  128,  128,  128,  128,
    0,   27,   27,   27,    0,   27,    0,  128,   27,    0,
   27,  128,    0,   27,    0,  128,   27,    0,    0,    0,
    0,    0,  218,  128,  218,  128,    0,   27,    0,   27,
    0,    0,   27,   27,  146,    0,    0,    0,    0,  218,
    0,  128,  128,    0,    0,    0,    0,    0,  128,    0,
    0,    0,    0,    0,    0,    0,  128,    0,  128,    0,
    0,  128,    0,    0,    0,  245,    0,  245,  145,    0,
    0,    0,    0,    0,  218,    0,  218,    0,    0,    0,
    0,    0,  245,    0,  128,    0,  218,    0,    0,    0,
    0,    0,  128,  128,  128,    0,  128,    0,    0,  128,
    0,  128,    0,    0,  128,    0,    0,  128,    0,   26,
    0,   26,   26,   26,   26,  220,    0,  220,  128,  245,
  128,    0,   26,  128,  128,   28,   26,  218,    0,  245,
   26,    0,  220,    0,    0,    0,    0,    0,   26,    0,
   26,    0,    0,    0,    0,    0,    0,    0,  218,    0,
    0,  218,  218,  226,    0,    0,   26,   26,    0,  146,
    0,    0,    0,   26,    0,    0,    0,  220,    0,  220,
  245,   26,    0,   26,    0,    0,   26,    0,    0,  220,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  245,    0,    0,  245,  245,  222,    0,    0,   26,
  145,    0,  145,  145,  145,  145,    0,   26,   26,   26,
    0,   26,    0,  145,   26,    0,   26,  145,    0,   26,
  220,  145,   26,  220,    0,    0,    0,    0,    0,  145,
    0,  145,    0,   26,    0,   26,    0,    0,   26,   26,
  129,  220,    0,    0,  220,  220,    0,  145,  145,    0,
   28,    0,    0,    0,  145,    0,    0,    0,    0,    0,
    0,    0,  145,    0,  145,    0,    0,  145,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  226,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  145,  146,    0,  146,  146,  146,  146,  243,  145,  145,
  145,    0,  145,    0,  146,  145,    0,  145,  146,    0,
  145,    0,  146,  145,    0,    0,    0,    0,    0,    0,
  146,  222,  146,    0,  145,    0,  145,    0,    0,  145,
  145,  222,    0,    0,    0,    0,    0,    0,  146,  146,
    0,    0,    0,    0,    0,  146,    0,    0,    0,    0,
    0,    0,    0,  146,    0,  146,    0,    0,  146,    0,
    0,    0,    0,    0,    0,  129,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  146,   28,    0,   28,   28,   28,   28,    0,  146,
  146,  146,    0,  146,  245,   28,  146,    0,  146,   28,
    0,  146,    0,   28,  146,    0,    0,    0,    0,    0,
  226,   28,  226,   28,    0,  146,    0,  146,    0,    0,
  146,  146,  243,    0,    0,    0,    0,  226,    0,   28,
   28,    0,  226,    0,    0,    0,   28,  216,    0,    0,
    0,    0,    0,    0,   28,   66,   28,    0,    0,   28,
   84,    0,    0,  222,    0,  222,  222,    0,    0,    0,
    0,    0,    0,    0,  226,    0,    0,    0,    0,    0,
  222,    0,   28,    0,  226,    0,    0,    0,    0,    0,
   28,   28,   28,    0,   28,    0,    0,   28,  158,   28,
    0,    0,   28,    0,    0,   28,    0,  129,    0,  129,
  129,  129,  129,    0,  121,    0,   28,  222,   28,    0,
  129,   28,   28,    0,  129,  226,    0,  222,  129,  245,
    0,    0,  198,  138,    0,    0,  129,    0,  129,    0,
    0,    0,    0,    0,    0,    0,  226,  199,  200,  226,
  226,    0,  201,  202,  129,  129,    0,    0,    0,  203,
  204,  129,    0,    0,  243,    0,  243,  226,  222,  129,
    0,  129,  216,    0,  129,    0,  205,  206,    0,    0,
   66,  243,    0,    0,    0,   84,    0,    0,    0,  222,
    0,    0,  222,  222,  207,    0,    0,  129,  222,    0,
  222,  222,  222,  222,    0,  129,  129,  129,    0,  129,
    0,  222,  129,    0,  129,  222,  243,  129,  243,  222,
  129,    0,    0,  158,    0,    0,    0,  222,  243,  222,
    0,  129,    0,  129,   23,   24,  129,  129,    0,  121,
  243,    0,    0,    0,    0,  222,  222,  243,  243,    0,
    0,    0,  222,    0,    0,    0,    0,    0,    0,    0,
  222,  245,  222,  245,    0,  222,    0,  100,    0,  243,
    0,    0,  243,    0,    0,    0,    0,    0,  245,    0,
  120,    0,    0,    0,    0,    0,    0,    0,  222,    0,
  243,    0,    0,  243,  243,    0,  222,  222,  222,  226,
  222,  226,    0,  222,  216,  222,  216,    0,  222,    0,
  175,  222,   66,  245,   66,  245,  226,   84,    0,   84,
    0,  216,  222,    0,  222,  245,    0,  222,  222,   66,
    0,    0,    0,    0,   84,    0,    0,    0,  245,    0,
  245,    0,    0,    0,    0,  245,    0,    0,    0,    0,
    0,  226,    0,  226,    0,  158,  216,  158,  216,    0,
    0,    0,    0,  226,    0,    0,  245,    0,  216,  245,
    0,  121,  158,  121,    0,    0,   66,    0,    0,    0,
    0,   84,  226,  226,    0,    0,    0,  245,  121,    0,
  245,  245,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  226,    0,    0,  226,    0,  216,
    0,    0,  216,    0,    0,    0,    0,   66,    0,  158,
    0,    0,   84,    0,    0,  226,    0,    0,  226,  226,
  216,    0,    0,  216,  216,  121,    0,    0,   66,    0,
    0,   66,   66,   84,    0,    0,   84,   84,    0,    0,
    0,  123,  123,    0,  278,    0,    0,    0,    0,    0,
  158,    0,    0,    0,    0,    0,  123,  123,    0,    0,
    0,  123,  123,    0,    0,    0,  121,    0,  123,  123,
    0,  158,    0,    0,  158,  158,    0,   25,    0,    0,
    0,    0,  302,  303,    0,  123,  123,  121,    0,    0,
  121,  121,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  123,    0,   92,   93,  319,  320,    0,
    0,    0,   25,  123,  123,    0,    0,    0,    0,    0,
    0,    0,  113,  113,    0,  125,    0,    0,  127,    0,
    0,    0,    0,  238,    0,  348,  160,  113,  113,    0,
    0,    0,  113,  113,    0,    0,    0,    0,    0,  113,
  113,  357,    0,   25,    0,    0,    0,  178,  179,    0,
  180,  366,    0,    0,  184,  369,  113,  113,    0,    0,
    0,    0,  370,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  113,    0,    0,  380,    0,    0,
  380,    0,    0,    0,    0,    0,  388,    0,    0,    0,
    0,    0,    0,  393,    0,  393,  216,   25,    0,    0,
    0,    0,    0,  218,  219,   25,    0,    0,  221,    0,
    0,  224,    0,    0,    0,  227,  228,    0,    0,    0,
  231,  233,  235,    0,    0,    0,  231,    0,    0,    0,
    0,    0,    0,  242,    0,  244,    0,  114,    0,    0,
    0,    0,    0,    0,    0,    0,  235,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  131,
  132,  133,  134,    0,    0,    0,    0,    0,    0,    0,
  135,    0,    0,    0,    0,    0,    0,   25,   25,  272,
    0,    0,    0,    0,    0,    0,  136,    0,   79,    0,
    0,    0,    0,  235,    0,  235,    0,  291,    0,    0,
    0,  235,    0,    0,  137,  138,    0,    0,    0,    0,
    0,  139,  150,    0,  297,    0,    0,  299,    0,  140,
    0,    0,  291,    0,  141,    0,    0,    0,    0,    0,
   25,    0,   25,    0,  310,    0,    0,  311,    0,    0,
  312,    0,  315,    0,  318,    0,    0,   82,    0,    0,
    0,  291,  291,    0,    0,  142,  143,  144,    0,  145,
    0,    0,    0,    0,  146,    0,    0,  147,    0,    0,
  148,   25,   25,  114,  114,  114,  114,    0,    0,  349,
    0,  149,    0,    0,  114,   18,   19,  353,   20,    0,
    0,    0,  113,    0,    0,    0,    0,    0,    0,    0,
  114,    0,  114,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  283,    0,    0,  114,  114,
    0,    0,    0,   25,    0,  114,    0,    0,    0,    0,
   25,    0,    0,  114,  114,    0,    0,    0,  114,  114,
    0,    0,    0,    0,    0,  114,  114,    0,  131,  132,
  133,  134,    0,    0,    0,    0,    0,    0,    0,  135,
    0,  114,  114,  114,    0,    0,    0,    0,    0,  114,
  114,  114,    0,  114,    0,  136,    0,   79,  114,    0,
  114,  114,    0,    0,  114,    0,    0,    0,    0,    0,
    0,    0,    0,  137,  138,  114,    0,    0,    0,    0,
  139,    0,    0,    0,    0,    0,  327,    0,  140,    0,
    0,    0,    0,  141,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  113,  113,
  113,  113,    0,    0,    0,    0,   82,    0,    0,  113,
    0,    0,    0,    0,  142,  143,  144,    0,  145,  131,
  132,  133,  134,  146,    0,  113,  147,  113,    0,  148,
  135,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  149,    0,    0,  113,  113,    0,  136,    0,   79,    0,
  113,    0,    0,    0,    0,    0,    0,    0,  113,    0,
    0,    0,    0,  113,  137,  138,    0,    0,    0,    0,
    0,  139,    0,    0,    0,    0,    0,    0,    0,  140,
    0,    0,    0,    0,  141,    0,  113,    0,    0,    0,
    0,    0,    0,    0,  113,  113,  113,    0,  113,    0,
    0,    0,    0,  113,    0,    0,  113,   82,    0,  113,
  131,  132,  133,  134,    0,  142,  143,  144,    0,  145,
  113,  135,  119,  119,  146,    0,    0,  147,  119,  119,
  148,    0,    0,    0,    0,    0,  119,  136,    0,   79,
  119,  149,    0,    0,    0,    0,    0,    0,    0,  131,
  132,  133,  134,  119,    0,  137,  138,    0,    0,    0,
  135,    0,  139,    0,    0,    0,    0,    0,    0,    0,
  140,    0,    0,  119,    0,  141,  136,    0,   79,    0,
    0,    0,    0,    0,    0,    0,    0,  119,    0,    0,
    0,    0,    0,    0,  137,  138,    0,    0,   82,    0,
    0,  139,    0,    0,    0,    0,  142,  143,  144,  140,
  145,    0,  119,    0,  141,  146,    0,    0,  147,    0,
    0,  148,    0,    0,    0,    0,    0,    0,  119,    0,
    0,    0,  149,  119,    0,    0,  119,   82,    0,    0,
  119,  131,  132,  133,  134,  142,  143,  144,    0,  145,
  119,  119,  135,  119,  146,    0,    0,  147,    0,    0,
  148,    0,    0,    0,    0,    0,    0,    0,  136,    0,
   79,  149,   31,    0,    0,   18,   19,    0,   20,    0,
    0,    0,    0,   32,    0,    0,  137,  138,   33,   34,
    0,    0,    0,  139,    0,    0,    0,    0,   35,   36,
    0,  140,    0,    0,    0,    0,  141,    0,    0,    0,
   37,    0,    0,   38,    0,    0,    0,    0,    0,    0,
    0,   39,   40,   41,   42,   43,    0,    0,    0,   82,
   44,    0,    0,    0,    0,    0,    0,  142,  143,  144,
    0,  145,   45,    0,    0,   46,  146,    0,    0,  147,
    0,   47,  148,    0,    0,    0,    0,    0,   48,   49,
   50,   51,    0,  149,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   52,    0,    0,   53,
    0,    0,    0,    0,    0,    0,   54,
};
const short yycheck[] =
	{                                      43,
    0,  123,   43,   43,   60,   43,   62,  253,  125,  275,
  123,   62,    4,   35,   36,   72,  280,  123,   43,   53,
   83,  266,   44,  345,  125,   47,  239,   49,   50,   51,
   64,   60,  339,   62,   56,  154,  123,  337,  302,   43,
  177,   41,  273,   28,  267,  268,  269,   39,  159,  123,
  123,  286,  285,  330,  376,  338,  279,  290,  390,  362,
  293,  364,  264,  327,  328,  342,  297,   61,  400,  123,
  272,  283,  183,  123,   59,  358,  311,   61,  285,  382,
    0,  289,  313,  290,  384,  346,  293,  387,   80,  389,
  209,  210,  211,  259,  260,  326,  360,  384,  343,  301,
  387,  307,  389,   60,  337,   62,  243,  164,  171,  123,
  173,  174,  163,  250,  327,  278,  380,  123,  382,  385,
  386,  232,  388,  123,  397,  125,  399,  373,  385,  386,
  312,  388,  405,  123,  361,  169,  347,  259,  260,  376,
  377,  123,  134,  294,  295,  123,  259,  260,  347,  123,
  142,  374,  376,  266,  311,  177,  125,  264,  265,  266,
  384,  296,  125,  387,  312,  389,  125,  298,  299,  259,
  260,  125,  259,  260,  312,  226,    0,  298,  299,  266,
  125,  358,  350,  373,   40,  259,  260,  376,  125,  376,
  345,  341,  125,  274,  333,  274,  125,  384,  385,  386,
  387,  388,  389,   44,  334,  125,  365,  336,  340,  259,
  260,  345,   41,  309,  358,  361,  266,  358,  361,   44,
   41,  243,  214,  215,   71,  247,  238,   30,  250,  130,
  343,  287,  384,  385,  386,  387,  388,  389,  391,  277,
  113,  292,   57,  359,  358,   67,  379,  332,  368,  269,
  330,  303,  116,   67,  376,  377,  343,  257,   -1,  259,
  260,  261,  262,  376,  377,   -1,  266,   -1,  385,  386,
  270,  388,  287,  329,  274,   -1,   -1,    0,  278,  385,
  386,  310,  388,  283,  385,  386,  286,  388,  288,  376,
  377,  313,   -1,  343,  294,  295,  296,   -1,  298,  299,
   -1,  125,  376,  377,  304,  305,  328,  307,   -1,  309,
   -1,  311,  385,  386,    0,  388,  308,  309,   -1,  319,
  320,  321,  376,  377,  324,  325,  376,  377,   -1,  373,
  330,  331,  332,  333,  334,  376,  336,  257,  378,  259,
  340,  341,  342,  343,   -1,  345,   -1,  347,  348,  349,
  350,   -1,   -1,  378,  274,  355,  356,  357,   -1,  359,
  385,  386,  362,  388,  364,  365,  366,  367,  360,  289,
  370,  385,  386,  373,  388,  367,  376,  377,   -1,  385,
  386,  381,  388,  383,   -1,  385,  386,  387,  388,  309,
   -1,  311,  312,   -1,    0,  385,  386,   -1,  388,   -1,
   -1,  321,  125,  385,  386,   -1,  388,  385,  386,   -1,
  388,  385,  386,  333,  388,   -1,  385,  386,   -1,  388,
  340,  341,  385,  386,   -1,  388,  385,  386,    0,  388,
   -1,  385,  386,  257,  388,  259,  260,  261,  262,  125,
  385,  386,  362,  388,   -1,  365,  270,   -1,  385,  386,
  274,  388,  385,  386,  278,  388,  385,  386,   -1,  388,
   -1,   -1,  286,  383,  288,  385,  386,  387,  388,   -1,
  294,  295,  296,   -1,  298,  299,   -1,   -1,   -1,   -1,
  304,  305,   -1,   -1,   -1,  309,    0,  311,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  319,   -1,  321,   -1,   -1,
  324,   -1,   -1,   -1,   -1,   -1,  330,   -1,   -1,  333,
  334,   -1,  336,   -1,   -1,   -1,  340,  341,  342,  125,
   -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  355,  356,  357,  257,  359,  259,   -1,  362,   -1,
  364,  365,    0,  367,   -1,   -1,  370,   -1,   -1,  373,
   -1,  274,  376,  125,   -1,   -1,   -1,  381,   -1,  383,
   -1,   -1,  386,  387,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  257,   -1,  259,  260,  261,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  270,   -1,   -1,   -1,  274,   -1,
   -1,   -1,  278,   -1,   -1,   -1,   -1,   -1,  321,   -1,
  286,    0,  288,   -1,   -1,   -1,   -1,   -1,  294,  295,
   -1,  125,  298,  299,  123,   -1,   -1,   -1,  304,  305,
   -1,   -1,   -1,  309,   -1,  311,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  319,   -1,  321,   -1,   -1,  324,  362,
   -1,   -1,   -1,   -1,  330,   -1,   -1,  333,  334,   -1,
  336,  257,   -1,  259,  340,  341,  342,    0,   -1,   -1,
  383,  347,   -1,  386,  387,   -1,   -1,  125,  274,  355,
  356,  357,   -1,  359,   -1,   -1,  362,   -1,  364,  365,
   -1,  367,   -1,   -1,  370,  257,   -1,  259,  260,  261,
  262,   -1,   -1,   -1,   -1,  381,   -1,  383,  270,   -1,
  386,  387,  274,  309,   -1,  311,  278,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  286,  321,  288,   -1,   -1,   -1,
   -1,   -1,  294,  295,  330,   -1,  125,  333,   -1,   -1,
   -1,   -1,  304,  305,  340,  341,  342,  309,   -1,  311,
   -1,   -1,   -1,  257,   -1,  259,   -1,  319,   -1,  321,
  259,  260,  324,   -1,   -1,   -1,  362,  266,   -1,  365,
  274,   -1,  334,   -1,  336,   -1,   -1,   -1,   -1,  341,
   -1,    0,   -1,   -1,   -1,  347,   -1,  383,    0,   -1,
  386,  387,  125,  355,  356,  357,   -1,  359,   -1,   -1,
  362,   -1,  364,  365,   -1,  367,   -1,  311,  370,  257,
   -1,  259,  260,  261,  262,   -1,   -1,  321,   -1,  381,
   -1,  383,  270,   -1,  386,  387,  274,   -1,   -1,  333,
  278,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  286,    0,
  288,   -1,   -1,   -1,  343,   -1,   -1,   -1,   -1,   -1,
  125,   -1,   -1,  123,   -1,   -1,  304,  305,  362,   -1,
   -1,  309,   -1,  311,   -1,   -1,   -1,   -1,  257,   -1,
  259,  319,   -1,  321,   -1,   -1,  324,  376,  377,  383,
   -1,   -1,  386,  387,   -1,  274,  334,   -1,  336,   -1,
   -1,   -1,   -1,  341,   -1,    0,   -1,   -1,   -1,  347,
   -1,   -1,    0,   -1,   -1,   -1,  125,  355,  356,  357,
   -1,  359,   -1,  125,  362,   -1,  364,  365,   -1,  367,
   -1,   -1,  370,   -1,  257,   -1,  259,  260,  261,  262,
   -1,   -1,  321,  381,   -1,  383,   -1,  270,  386,  387,
   -1,  274,   -1,   -1,   -1,  278,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  286,   -1,  288,   -1,   -1,  123,   -1,
   -1,   -1,   -1,   -1,  125,   -1,   -1,   -1,   -1,   -1,
   -1,  304,  305,  362,   -1,   -1,  309,   -1,  311,   -1,
   -1,   -1,  257,   -1,  259,   -1,  319,   -1,  321,  259,
  260,  324,   -1,   -1,  383,   -1,  266,  386,  387,  274,
   -1,  334,   -1,  336,   -1,   -1,   -1,   -1,  341,    0,
   -1,   -1,   -1,   -1,  347,   -1,    0,   -1,   -1,   -1,
  125,   -1,  355,  356,  357,   -1,  359,  125,   -1,  362,
   -1,  364,  365,   -1,  367,   -1,   -1,  370,  257,   -1,
  259,  260,  261,  262,   -1,  257,  321,  259,  381,   -1,
  383,  270,   -1,  386,  387,  274,   -1,   -1,   -1,  278,
   -1,   -1,  274,   -1,   -1,   -1,   -1,  286,   -1,  288,
   -1,   -1,   -1,  343,   -1,   -1,   -1,    0,   -1,   -1,
   -1,   -1,  294,  295,   -1,  304,  305,  362,   -1,   -1,
  309,   -1,  311,   -1,  259,  260,  257,  309,  259,  311,
  319,  266,  321,   -1,   -1,  324,  376,  377,  383,  321,
   -1,  386,  387,  274,   -1,  334,   -1,  336,  330,   -1,
   -1,   -1,  334,    0,  336,   -1,   -1,   -1,  347,  341,
  342,   -1,   -1,   -1,  125,   -1,  355,  356,  357,   -1,
  359,  125,   -1,  362,   -1,  364,  365,   -1,  367,   -1,
  362,  370,  257,  365,  259,  260,  261,  262,   -1,  257,
  321,  259,  381,   -1,  383,  270,   -1,  386,  387,  274,
   -1,  383,   -1,  278,  386,  387,  274,   -1,  343,   -1,
   -1,  286,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,    0,   -1,   -1,   -1,  294,  295,   -1,  304,
  305,  362,  125,   -1,  309,   -1,  311,   -1,   -1,   -1,
   -1,  376,  377,  311,  319,   -1,  321,   -1,   -1,  324,
   -1,   -1,  383,  321,   -1,  386,  387,   -1,   -1,   -1,
   -1,  336,  330,   -1,   -1,   -1,   -1,   -1,    0,   -1,
   -1,   -1,  347,   -1,  342,   -1,   -1,   -1,  125,   -1,
  355,  356,  357,   -1,  359,   -1,   -1,  362,   -1,  364,
  365,   -1,  367,   -1,  362,  370,  257,   -1,  259,  260,
  261,  262,   -1,  257,   -1,  259,  381,   -1,  383,  270,
   -1,  386,  387,  274,   -1,  383,   -1,  278,  386,  387,
  274,   -1,   -1,   -1,   -1,  286,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  304,  305,  123,   -1,  125,  309,   -1,
  311,   -1,   -1,   -1,   -1,  309,   -1,  311,  319,    0,
  321,   -1,   -1,  324,  257,   -1,  259,  321,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  330,   -1,   -1,   -1,
  334,  274,  336,   -1,   -1,   -1,  347,  341,  342,   -1,
   -1,   -1,   -1,  125,  355,  356,  357,   -1,  359,   -1,
   -1,  362,   -1,  364,  365,   -1,  367,   -1,  362,  370,
  257,  365,  259,  260,  261,  262,   -1,   -1,  311,   -1,
  381,   -1,  383,  270,   -1,  386,  387,  274,  321,  383,
   -1,  278,  386,  387,   -1,   -1,   -1,  330,   -1,  286,
   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  342,
    0,   -1,   -1,   -1,   -1,   -1,   -1,  304,  305,   -1,
   -1,   -1,   -1,   -1,  311,   -1,   -1,   -1,   -1,  362,
   -1,   -1,  319,   -1,  321,   -1,   -1,  324,   -1,  257,
   -1,  259,  260,   -1,  125,   -1,   -1,   -1,  266,   -1,
  383,   -1,    0,  386,  387,   -1,  274,   -1,   -1,   -1,
  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  355,  356,
  357,   -1,  359,   -1,   -1,  362,   -1,  364,   -1,   -1,
  367,   -1,   -1,  370,   -1,  257,  373,  259,  260,  261,
  262,   -1,   -1,   -1,  381,   -1,  383,   -1,  270,  386,
  387,    0,  274,  321,   -1,   -1,  278,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  286,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  257,  258,  343,   -1,   -1,   -1,  263,
  264,   -1,  304,  305,   -1,  125,   -1,  271,   -1,  311,
   -1,  275,   -1,    0,  362,   -1,   -1,  319,   -1,  321,
   -1,   -1,  324,   -1,  288,   -1,   -1,   -1,  376,  377,
   -1,   -1,   -1,   -1,   -1,  383,   -1,   -1,  386,  387,
    0,   -1,   -1,   -1,  308,  347,  257,  125,  259,  260,
  261,  262,   -1,  355,  356,  357,   -1,  359,  322,  270,
  362,   -1,  364,  274,   -1,  367,   -1,  278,  370,   -1,
   -1,  373,   -1,   -1,   -1,  286,   -1,  288,   -1,  381,
   -1,  383,   -1,  347,  386,  387,    0,   -1,   -1,   -1,
   -1,   -1,    0,  304,  305,   -1,  125,   -1,  309,  363,
  311,   -1,   -1,   -1,  368,   -1,   -1,  371,  319,   -1,
  321,  375,   -1,  324,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  385,  386,   -1,  388,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  347,  257,  125,  259,
  260,  261,  262,   -1,  355,  356,  357,   -1,  359,   -1,
  270,  362,   -1,  364,  274,   -1,  367,   -1,  278,  370,
   -1,   -1,   -1,  123,   -1,  125,  286,   -1,  288,   -1,
  381,   -1,  383,   -1,   -1,  386,  387,    0,   -1,  257,
   -1,  259,   -1,   -1,  304,  305,   -1,   -1,   -1,   -1,
   -1,  311,   -1,   -1,   -1,   -1,  274,   -1,   -1,  319,
   -1,  321,   -1,   -1,  324,   -1,   -1,   -1,   -1,   -1,
   -1,  125,   -1,   -1,   -1,   -1,   -1,  125,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,  257,   -1,
  259,  260,  261,  262,   -1,  355,  356,  357,   -1,  359,
   -1,  270,  362,  321,  364,  274,   -1,  367,   -1,  278,
  370,   -1,   -1,   -1,   -1,   -1,   -1,  286,   -1,  288,
   -1,  381,   -1,  383,   -1,   -1,  386,  387,    0,   -1,
  257,   -1,  259,   -1,   -1,  304,  305,   -1,   -1,   -1,
   -1,   -1,  311,   -1,  362,   -1,   -1,  274,   -1,   -1,
  319,   -1,  321,   -1,   -1,  324,   -1,  257,   -1,  259,
  260,   -1,  125,   -1,   -1,  383,  266,   -1,  386,  387,
   -1,   -1,   -1,   -1,  274,   -1,   -1,   -1,  347,   -1,
   -1,   -1,  309,   -1,  311,   -1,  355,  356,  357,   -1,
  359,   -1,   -1,  362,  321,  364,   -1,   -1,  367,   -1,
   -1,  370,   -1,  257,   -1,  259,  260,  261,  262,  257,
   -1,  259,  381,  340,  383,   -1,  270,  386,  387,    0,
  274,  321,   -1,   -1,  278,   -1,  274,   -1,   -1,   -1,
   -1,   -1,  286,   -1,  288,  362,   -1,   -1,  365,   -1,
   -1,   -1,   -1,  343,   -1,   -1,   -1,    0,   -1,   -1,
  304,  305,   -1,  125,   -1,   -1,  383,  311,   -1,  386,
  387,  309,  362,  311,   -1,  319,   -1,  321,   -1,   -1,
  324,   -1,   -1,  321,   -1,   -1,  376,  377,   -1,   -1,
    0,   -1,   -1,  383,   -1,   -1,  386,  387,  336,   -1,
   -1,   -1,   -1,  347,  257,   -1,  259,  260,  261,  262,
   -1,  355,  356,  357,   -1,  359,   -1,  270,  362,   -1,
  364,  274,   -1,  367,  362,  278,  370,  365,   -1,   -1,
   -1,   -1,   -1,  286,   -1,  288,   -1,  381,   -1,  383,
   -1,   -1,  386,  387,    0,  383,   -1,   -1,  386,  387,
    0,  304,  305,   -1,  125,   -1,   -1,   -1,  311,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  319,   -1,  321,   -1,
   -1,  324,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  347,  257,   -1,  259,  260,  261,
  262,   -1,  355,  356,  357,   -1,  359,   -1,  270,  362,
   -1,  364,  274,   -1,  367,  125,  278,  370,   -1,   -1,
   -1,   -1,   -1,   -1,  286,   -1,  288,   -1,  381,   -1,
  383,   -1,   -1,  386,  387,    0,   -1,   -1,   -1,   -1,
   -1,   -1,  304,  305,   -1,   -1,   -1,   -1,   -1,  311,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,   -1,  321,
   -1,   -1,  324,   -1,   -1,   -1,   -1,   -1,   -1,  125,
   -1,   -1,   -1,   -1,   -1,  125,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  347,  257,   -1,  259,  260,
  261,  262,   -1,  355,  356,  357,   -1,  359,   -1,  270,
  362,   -1,  364,  274,   -1,  367,   -1,  278,  370,   -1,
   -1,   -1,   -1,   -1,  257,  286,  259,  288,   -1,  381,
   -1,  383,   -1,   -1,  386,  387,    0,   -1,   -1,   -1,
   -1,  274,   -1,  304,  305,   -1,   -1,   -1,   -1,   -1,
  311,   -1,   -1,   -1,   -1,   -1,   -1,  257,  319,  259,
  321,   -1,   -1,  324,   -1,   -1,   -1,   -1,   -1,   -1,
  125,   -1,   -1,   -1,  274,   -1,  309,   -1,  311,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  347,   -1,  321,   -1,
   -1,   -1,   -1,   -1,  355,  356,  357,   -1,  359,   -1,
   -1,  362,   -1,  364,   -1,   -1,  367,   -1,   -1,  370,
   -1,  257,   -1,  259,  260,  261,  262,  257,   -1,  259,
  381,  321,  383,   -1,  270,  386,  387,    0,  274,  362,
   -1,   -1,  278,   -1,  274,   -1,   -1,   -1,   -1,   -1,
  286,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  383,   -1,   -1,  386,  387,    0,   -1,   -1,  304,  305,
   -1,  125,  362,   -1,   -1,  311,   -1,   -1,   -1,  309,
   -1,  311,   -1,  319,   -1,  321,   -1,   -1,  324,   -1,
   -1,  321,   -1,  383,   -1,   -1,  386,  387,   -1,   -1,
   -1,   -1,   -1,   -1,  334,   -1,  336,   -1,    0,   -1,
   -1,  347,  257,   -1,  259,  260,  261,  262,   -1,  355,
  356,  357,   -1,  359,   -1,  270,  362,   -1,  364,  274,
   -1,  367,  362,  278,  370,  365,   -1,   -1,   -1,   -1,
   -1,  286,   -1,  288,   -1,  381,   -1,  383,   -1,   -1,
  386,  387,    0,  383,   -1,   -1,  386,  387,    0,  304,
  305,   -1,  125,   -1,   -1,   -1,  311,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  319,   -1,  321,   -1,   -1,  324,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  347,  257,   -1,  259,  260,  261,  262,   -1,
  355,  356,  357,   -1,  359,   -1,  270,  362,   -1,  364,
  274,   -1,  367,   -1,  278,  370,   -1,   -1,   -1,   -1,
   -1,   -1,  286,  125,  288,   -1,  381,   -1,  383,   -1,
   -1,  386,  387,    0,   -1,   -1,   -1,   -1,   -1,   -1,
  304,  305,   -1,   -1,   -1,   -1,   -1,  311,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  319,   -1,  321,   -1,   -1,
  324,   -1,   -1,   -1,   -1,   -1,   -1,  125,   -1,   -1,
   -1,   -1,   -1,  125,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  347,  257,   -1,  259,  260,  261,  262,
   -1,  355,  356,  357,   -1,  359,   -1,  270,  362,   -1,
  364,  274,   -1,  367,   -1,  278,  370,   -1,   -1,   -1,
   -1,   -1,  257,  286,  259,  288,   -1,  381,   -1,  383,
   -1,   -1,  386,  387,    0,   -1,   -1,   -1,   -1,  274,
   -1,  304,  305,   -1,   -1,   -1,   -1,   -1,  311,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  319,   -1,  321,   -1,
   -1,  324,   -1,   -1,   -1,  257,   -1,  259,  125,   -1,
   -1,   -1,   -1,   -1,  309,   -1,  311,   -1,   -1,   -1,
   -1,   -1,  274,   -1,  347,   -1,  321,   -1,   -1,   -1,
   -1,   -1,  355,  356,  357,   -1,  359,   -1,   -1,  362,
   -1,  364,   -1,   -1,  367,   -1,   -1,  370,   -1,  257,
   -1,  259,  260,  261,  262,  257,   -1,  259,  381,  311,
  383,   -1,  270,  386,  387,    0,  274,  362,   -1,  321,
  278,   -1,  274,   -1,   -1,   -1,   -1,   -1,  286,   -1,
  288,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  383,   -1,
   -1,  386,  387,    0,   -1,   -1,  304,  305,   -1,  125,
   -1,   -1,   -1,  311,   -1,   -1,   -1,  309,   -1,  311,
  362,  319,   -1,  321,   -1,   -1,  324,   -1,   -1,  321,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  383,   -1,   -1,  386,  387,    0,   -1,   -1,  347,
  257,   -1,  259,  260,  261,  262,   -1,  355,  356,  357,
   -1,  359,   -1,  270,  362,   -1,  364,  274,   -1,  367,
  362,  278,  370,  365,   -1,   -1,   -1,   -1,   -1,  286,
   -1,  288,   -1,  381,   -1,  383,   -1,   -1,  386,  387,
    0,  383,   -1,   -1,  386,  387,   -1,  304,  305,   -1,
  125,   -1,   -1,   -1,  311,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  319,   -1,  321,   -1,   -1,  324,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  125,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  347,  257,   -1,  259,  260,  261,  262,    0,  355,  356,
  357,   -1,  359,   -1,  270,  362,   -1,  364,  274,   -1,
  367,   -1,  278,  370,   -1,   -1,   -1,   -1,   -1,   -1,
  286,  125,  288,   -1,  381,   -1,  383,   -1,   -1,  386,
  387,    0,   -1,   -1,   -1,   -1,   -1,   -1,  304,  305,
   -1,   -1,   -1,   -1,   -1,  311,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  319,   -1,  321,   -1,   -1,  324,   -1,
   -1,   -1,   -1,   -1,   -1,  125,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  347,  257,   -1,  259,  260,  261,  262,   -1,  355,
  356,  357,   -1,  359,    0,  270,  362,   -1,  364,  274,
   -1,  367,   -1,  278,  370,   -1,   -1,   -1,   -1,   -1,
  257,  286,  259,  288,   -1,  381,   -1,  383,   -1,   -1,
  386,  387,  125,   -1,   -1,   -1,   -1,  274,   -1,  304,
  305,   -1,    0,   -1,   -1,   -1,  311,    0,   -1,   -1,
   -1,   -1,   -1,   -1,  319,    0,  321,   -1,   -1,  324,
    0,   -1,   -1,  257,   -1,  259,  125,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  311,   -1,   -1,   -1,   -1,   -1,
  274,   -1,  347,   -1,  321,   -1,   -1,   -1,   -1,   -1,
  355,  356,  357,   -1,  359,   -1,   -1,  362,    0,  364,
   -1,   -1,  367,   -1,   -1,  370,   -1,  257,   -1,  259,
  260,  261,  262,   -1,    0,   -1,  381,  311,  383,   -1,
  270,  386,  387,   -1,  274,  362,   -1,  321,  278,  125,
   -1,   -1,  304,  305,   -1,   -1,  286,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  383,  319,  320,  386,
  387,   -1,  324,  325,  304,  305,   -1,   -1,   -1,  331,
  332,  311,   -1,   -1,  257,   -1,  259,  125,  362,  319,
   -1,  321,  125,   -1,  324,   -1,  348,  349,   -1,   -1,
  125,  274,   -1,   -1,   -1,  125,   -1,   -1,   -1,  383,
   -1,   -1,  386,  387,  366,   -1,   -1,  347,  257,   -1,
  259,  260,  261,  262,   -1,  355,  356,  357,   -1,  359,
   -1,  270,  362,   -1,  364,  274,  309,  367,  311,  278,
  370,   -1,   -1,  125,   -1,   -1,   -1,  286,  321,  288,
   -1,  381,   -1,  383,    2,    3,  386,  387,   -1,  125,
  333,   -1,   -1,   -1,   -1,  304,  305,  340,  341,   -1,
   -1,   -1,  311,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  319,  257,  321,  259,   -1,  324,   -1,   35,   -1,  362,
   -1,   -1,  365,   -1,   -1,   -1,   -1,   -1,  274,   -1,
   48,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,   -1,
  383,   -1,   -1,  386,  387,   -1,  355,  356,  357,  257,
  359,  259,   -1,  362,  257,  364,  259,   -1,  367,   -1,
   78,  370,  257,  309,  259,  311,  274,  257,   -1,  259,
   -1,  274,  381,   -1,  383,  321,   -1,  386,  387,  274,
   -1,   -1,   -1,   -1,  274,   -1,   -1,   -1,  334,   -1,
  336,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,
   -1,  309,   -1,  311,   -1,  257,  309,  259,  311,   -1,
   -1,   -1,   -1,  321,   -1,   -1,  362,   -1,  321,  365,
   -1,  257,  274,  259,   -1,   -1,  321,   -1,   -1,   -1,
   -1,  321,  340,  341,   -1,   -1,   -1,  383,  274,   -1,
  386,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  362,   -1,   -1,  365,   -1,  362,
   -1,   -1,  365,   -1,   -1,   -1,   -1,  362,   -1,  321,
   -1,   -1,  362,   -1,   -1,  383,   -1,   -1,  386,  387,
  383,   -1,   -1,  386,  387,  321,   -1,   -1,  383,   -1,
   -1,  386,  387,  383,   -1,   -1,  386,  387,   -1,   -1,
   -1,  304,  305,   -1,  222,   -1,   -1,   -1,   -1,   -1,
  362,   -1,   -1,   -1,   -1,   -1,  319,  320,   -1,   -1,
   -1,  324,  325,   -1,   -1,   -1,  362,   -1,  331,  332,
   -1,  383,   -1,   -1,  386,  387,   -1,    4,   -1,   -1,
   -1,   -1,  260,  261,   -1,  348,  349,  383,   -1,   -1,
  386,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  366,   -1,   32,   33,  285,  286,   -1,
   -1,   -1,   39,  376,  377,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  304,  305,   -1,   52,   -1,   -1,   55,   -1,
   -1,   -1,   -1,  123,   -1,  313,   63,  319,  320,   -1,
   -1,   -1,  324,  325,   -1,   -1,   -1,   -1,   -1,  331,
  332,  329,   -1,   80,   -1,   -1,   -1,   84,   85,   -1,
   87,  339,   -1,   -1,   91,  343,  348,  349,   -1,   -1,
   -1,   -1,  350,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  366,   -1,   -1,  365,   -1,   -1,
  368,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,
   -1,   -1,   -1,  381,   -1,  383,  133,  134,   -1,   -1,
   -1,   -1,   -1,  140,  141,  142,   -1,   -1,  145,   -1,
   -1,  148,   -1,   -1,   -1,  152,  153,   -1,   -1,   -1,
  157,  158,  159,   -1,   -1,   -1,  163,   -1,   -1,   -1,
   -1,   -1,   -1,  170,   -1,  172,   -1,  123,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  183,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  259,
  260,  261,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  270,   -1,   -1,   -1,   -1,   -1,   -1,  214,  215,  216,
   -1,   -1,   -1,   -1,   -1,   -1,  286,   -1,  288,   -1,
   -1,   -1,   -1,  230,   -1,  232,   -1,  234,   -1,   -1,
   -1,  238,   -1,   -1,  304,  305,   -1,   -1,   -1,   -1,
   -1,  311,  123,   -1,  251,   -1,   -1,  254,   -1,  319,
   -1,   -1,  259,   -1,  324,   -1,   -1,   -1,   -1,   -1,
  267,   -1,  269,   -1,  271,   -1,   -1,  274,   -1,   -1,
  277,   -1,  279,   -1,  281,   -1,   -1,  347,   -1,   -1,
   -1,  288,  289,   -1,   -1,  355,  356,  357,   -1,  359,
   -1,   -1,   -1,   -1,  364,   -1,   -1,  367,   -1,   -1,
  370,  308,  309,  259,  260,  261,  262,   -1,   -1,  316,
   -1,  381,   -1,   -1,  270,  385,  386,  324,  388,   -1,
   -1,   -1,  123,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  286,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  125,   -1,   -1,  304,  305,
   -1,   -1,   -1,  360,   -1,  311,   -1,   -1,   -1,   -1,
  367,   -1,   -1,  319,  320,   -1,   -1,   -1,  324,  325,
   -1,   -1,   -1,   -1,   -1,  331,  332,   -1,  259,  260,
  261,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  270,
   -1,  347,  348,  349,   -1,   -1,   -1,   -1,   -1,  355,
  356,  357,   -1,  359,   -1,  286,   -1,  288,  364,   -1,
  366,  367,   -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  304,  305,  381,   -1,   -1,   -1,   -1,
  311,   -1,   -1,   -1,   -1,   -1,  125,   -1,  319,   -1,
   -1,   -1,   -1,  324,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  259,  260,
  261,  262,   -1,   -1,   -1,   -1,  347,   -1,   -1,  270,
   -1,   -1,   -1,   -1,  355,  356,  357,   -1,  359,  259,
  260,  261,  262,  364,   -1,  286,  367,  288,   -1,  370,
  270,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  381,   -1,   -1,  304,  305,   -1,  286,   -1,  288,   -1,
  311,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,   -1,
   -1,   -1,   -1,  324,  304,  305,   -1,   -1,   -1,   -1,
   -1,  311,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,
   -1,   -1,   -1,   -1,  324,   -1,  347,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  355,  356,  357,   -1,  359,   -1,
   -1,   -1,   -1,  364,   -1,   -1,  367,  347,   -1,  370,
  259,  260,  261,  262,   -1,  355,  356,  357,   -1,  359,
  381,  270,  257,  258,  364,   -1,   -1,  367,  263,  264,
  370,   -1,   -1,   -1,   -1,   -1,  271,  286,   -1,  288,
  275,  381,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  259,
  260,  261,  262,  288,   -1,  304,  305,   -1,   -1,   -1,
  270,   -1,  311,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  319,   -1,   -1,  308,   -1,  324,  286,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  322,   -1,   -1,
   -1,   -1,   -1,   -1,  304,  305,   -1,   -1,  347,   -1,
   -1,  311,   -1,   -1,   -1,   -1,  355,  356,  357,  319,
  359,   -1,  347,   -1,  324,  364,   -1,   -1,  367,   -1,
   -1,  370,   -1,   -1,   -1,   -1,   -1,   -1,  363,   -1,
   -1,   -1,  381,  368,   -1,   -1,  371,  347,   -1,   -1,
  375,  259,  260,  261,  262,  355,  356,  357,   -1,  359,
  385,  386,  270,  388,  364,   -1,   -1,  367,   -1,   -1,
  370,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  286,   -1,
  288,  381,  265,   -1,   -1,  385,  386,   -1,  388,   -1,
   -1,   -1,   -1,  276,   -1,   -1,  304,  305,  281,  282,
   -1,   -1,   -1,  311,   -1,   -1,   -1,   -1,  291,  292,
   -1,  319,   -1,   -1,   -1,   -1,  324,   -1,   -1,   -1,
  303,   -1,   -1,  306,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  314,  315,  316,  317,  318,   -1,   -1,   -1,  347,
  323,   -1,   -1,   -1,   -1,   -1,   -1,  355,  356,  357,
   -1,  359,  335,   -1,   -1,  338,  364,   -1,   -1,  367,
   -1,  344,  370,   -1,   -1,   -1,   -1,   -1,  351,  352,
  353,  354,   -1,  381,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  369,   -1,   -1,  372,
   -1,   -1,   -1,   -1,   -1,   -1,  379,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 389
#if YYDEBUG
const char * const yyname[] =
	{
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'('","')'",0,"'+'","','",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'<'","'='",
"'>'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'",0,"'}'",0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,"TOKACCOUNT","TOKACCOUNTS","TOKACTION","TOKACTIONS","TOKADDHEADER",
"TOKADDTOCACHE","TOKAGE","TOKALL","TOKALLOWMANY","TOKAND","TOKANYNAME",
"TOKANYSIZE","TOKANYTYPE","TOKAPPEND","TOKATTACHMENT","TOKBODY","TOKBYTES",
"TOKCACHE","TOKCASE","TOKCMDUSER","TOKCOMPRESS","TOKCONTINUE","TOKCOUNT",
"TOKDAYS","TOKDEFUSER","TOKDELTOOBIG","TOKDISABLED","TOKDOMAIN","TOKDOTLOCK",
"TOKDROP","TOKEQ","TOKEXEC","TOKEXPIRE","TOKFCNTL","TOKFILEGROUP",
"TOKFILEUMASK","TOKFLOCK","TOKFOLDER","TOKFOLDERS","TOKFROM","TOKGIGABYTES",
"TOKGROUP","TOKGROUPS","TOKHEADER","TOKHEADERS","TOKHOURS","TOKIGNOREERRORS",
"TOKIMAP","TOKIMAPS","TOKIMPLACT","TOKIN","TOKINCACHE","TOKINSECURE",
"TOKINVALID","TOKKEEP","TOKKEY","TOKKILOBYTES","TOKLOCKFILE","TOKLOCKTIMEOUT",
"TOKLOCKTYPES","TOKLOCKWAIT","TOKLOOKUPORDER","TOKMAILDIR","TOKMAILDIRS",
"TOKMATCH","TOKMATCHED","TOKMAXSIZE","TOKMBOX","TOKMBOXES","TOKMEGABYTES",
"TOKMINUTES","TOKMONTHS","TOKNE","TOKNEWONLY","TOKNNTP","TOKNNTPS","TOKNOAPOP",
"TOKNOCRAMMD5","TOKNOCREATE","TOKNOLOGIN","TOKNONE","TOKNORECEIVED","TOKNOT",
"TOKNOUIDL","TOKNOVERIFY","TOKOLDONLY","TOKOR","TOKPARALLELACCOUNTS","TOKPASS",
"TOKPASSWD","TOKPIPE","TOKPOP3","TOKPOP3S","TOKPORT","TOKPROXY","TOKPURGEAFTER",
"TOKQUEUEHIGH","TOKQUEUELOW","TOKREMOVEFROMCACHE","TOKREMOVEHEADER",
"TOKREMOVEHEADERS","TOKRETURNS","TOKREWRITE","TOKSECONDS","TOKSERVER","TOKSET",
"TOKSIZE","TOKSMTP","TOKSTARTTLS","TOKSTDIN","TOKSTDOUT","TOKSTRING",
"TOKSTRIPCHARACTERS","TOKTAG","TOKTAGGED","TOKTIMEOUT","TOKTO","TOKTOTALSIZE",
"TOKUNMATCHED","TOKUSER","TOKUSERS","TOKVALUE","TOKVERIFYCERTS","TOKWEEKS",
"TOKWRITE","TOKYEARS","NONE","NUMBER","STRING","STRMACRO","NUMMACRO",
"STRCOMMAND","NUMCOMMAND",
};
const char * const yyrule[] =
	{"$accept : cmds",
"cmds :",
"cmds : cmds account",
"cmds : cmds defaction",
"cmds : cmds defmacro",
"cmds : cmds rule",
"cmds : cmds set",
"cmds : cmds close",
"cmds : cmds cache",
"cmds : cmds NONE",
"actionp : TOKACTION",
"actionp : TOKACTIONS",
"userp : TOKUSER",
"userp : TOKUSERS",
"accountp : TOKACCOUNT",
"accountp : TOKACCOUNTS",
"groupp : TOKGROUP",
"groupp : TOKGROUPS",
"folderp : TOKFOLDER",
"folderp : TOKFOLDERS",
"maildirp : TOKMAILDIR",
"maildirp : TOKMAILDIRS",
"mboxp : TOKMBOX",
"mboxp : TOKMBOXES",
"rmheaderp : TOKREMOVEHEADER",
"rmheaderp : TOKREMOVEHEADERS",
"val : TOKVALUE strv",
"val : strv",
"optval : TOKVALUE strv",
"optval :",
"xstrv : STRCOMMAND",
"xstrv : STRING",
"xstrv : STRMACRO",
"strv : xstrv",
"strv : strv '+' xstrv",
"numv : NUMCOMMAND",
"numv : NUMBER",
"numv : NUMMACRO",
"replstrv : strv",
"replpathv : strv",
"size : numv",
"size : numv TOKBYTES",
"size : numv TOKKILOBYTES",
"size : numv TOKMEGABYTES",
"size : numv TOKGIGABYTES",
"time : numv",
"time : numv TOKHOURS",
"time : numv TOKMINUTES",
"time : numv TOKSECONDS",
"time : numv TOKDAYS",
"time : numv TOKWEEKS",
"time : numv TOKMONTHS",
"time : numv TOKYEARS",
"expire : TOKEXPIRE time",
"expire :",
"cache : TOKCACHE replpathv expire",
"set : TOKSET TOKMAXSIZE size",
"set : TOKSET TOKLOCKTYPES locklist",
"set : TOKSET TOKLOCKFILE replpathv",
"set : TOKSET TOKLOCKWAIT",
"set : TOKSET TOKLOCKTIMEOUT time",
"set : TOKSET TOKDELTOOBIG",
"set : TOKSET TOKIGNOREERRORS",
"set : TOKSET TOKALLOWMANY",
"set : TOKSET TOKDEFUSER strv",
"set : TOKSET TOKCMDUSER strv",
"set : TOKSET TOKSTRIPCHARACTERS strv",
"set : TOKSET TOKTIMEOUT time",
"set : TOKSET TOKQUEUEHIGH numv",
"set : TOKSET TOKQUEUELOW numv",
"set : TOKSET TOKPARALLELACCOUNTS numv",
"set : TOKSET TOKPROXY replstrv",
"set : TOKSET TOKVERIFYCERTS",
"set : TOKSET TOKIMPLACT TOKKEEP",
"set : TOKSET TOKIMPLACT TOKDROP",
"set : TOKSET TOKPURGEAFTER numv",
"set : TOKSET TOKPURGEAFTER TOKNONE",
"set : TOKSET TOKNORECEIVED",
"set : TOKSET TOKNOCREATE",
"set : TOKSET TOKFILEGROUP TOKUSER",
"set : TOKSET TOKFILEGROUP localgid",
"set : TOKSET TOKFILEUMASK TOKUSER",
"set : TOKSET TOKLOOKUPORDER ufnlist",
"set : TOKSET TOKFILEUMASK numv",
"defmacro : STRMACRO '=' strv",
"defmacro : NUMMACRO '=' numv",
"replstrslist : replstrslist strv",
"replstrslist : strv",
"stringslist : stringslist replstrv",
"stringslist : replstrv",
"pathslist : pathslist replpathv",
"pathslist : replpathv",
"ufn : TOKPASSWD",
"ufnlist : ufnlist ufn",
"ufnlist : ufn",
"rmheaders : rmheaderp strv",
"rmheaders : rmheaderp '{' replstrslist '}'",
"maildirs : maildirp replpathv",
"maildirs : maildirp '{' pathslist '}'",
"mboxes : mboxp replpathv",
"mboxes : mboxp '{' pathslist '}'",
"folders : folderp replstrv",
"folders : folderp '{' stringslist '}'",
"lock : TOKFCNTL",
"lock : TOKFLOCK",
"lock : TOKDOTLOCK",
"locklist : locklist lock",
"locklist : lock",
"locklist : TOKNONE",
"localgid : replstrv",
"localgid : numv",
"user :",
"user : TOKUSER strv",
"users :",
"users : userp strv",
"users : userp '{' replstrslist '}'",
"casere : TOKCASE replstrv",
"casere : replstrv",
"not : TOKNOT",
"not :",
"keep : TOKKEEP",
"keep :",
"disabled : TOKDISABLED",
"disabled :",
"port : TOKPORT replstrv",
"port : TOKPORT numv",
"server : TOKSERVER replstrv port",
"server : TOKSERVER replstrv",
"to :",
"to : TOKTO strv",
"from :",
"from : TOKFROM strv",
"compress : TOKCOMPRESS",
"compress :",
"actitem : execpipe strv",
"actitem : TOKREWRITE strv",
"actitem : writeappend strv",
"actitem : TOKMAILDIR strv",
"actitem : rmheaders",
"actitem : TOKADDHEADER strv val",
"actitem : TOKMBOX strv compress",
"actitem : imaptype server userpassnetrc folder1 verify nocrammd5 nologin starttls insecure",
"actitem : TOKSMTP server from to",
"actitem : TOKSTDOUT",
"actitem : TOKTAG strv optval",
"actitem : TOKADDTOCACHE replpathv TOKKEY strv",
"actitem : TOKREMOVEFROMCACHE replpathv TOKKEY strv",
"actitem : actions",
"actitem : TOKDROP",
"actitem : TOKKEEP",
"actlist : actlist actitem",
"actlist : actitem",
"defaction : TOKACTION replstrv users actitem",
"defaction : TOKACTION replstrv users '{' actlist '}'",
"accounts : accountp strv",
"accounts : accountp '{' replstrslist '}'",
"actions : actionp strv",
"actions : actionp '{' replstrslist '}'",
"cont :",
"cont : TOKCONTINUE",
"area :",
"area : TOKIN TOKALL",
"area : TOKIN TOKHEADERS",
"area : TOKIN TOKBODY",
"retrc : numv",
"retrc :",
"retre : casere",
"retre :",
"ltgt : '<'",
"ltgt : '>'",
"eqne : TOKEQ",
"eqne : TOKNE",
"cmp : ltgt",
"cmp : eqne",
"execpipe : TOKEXEC",
"execpipe : TOKPIPE",
"writeappend : TOKWRITE",
"writeappend : TOKAPPEND",
"exprop : TOKAND",
"exprop : TOKOR",
"expritem : not TOKALL",
"expritem : not casere area",
"expritem : not accounts",
"expritem : not execpipe strv user TOKRETURNS '(' retrc ',' retre ')'",
"expritem : not TOKTAGGED strv",
"expritem : not TOKSIZE ltgt size",
"expritem : not TOKSTRING strv TOKTO casere",
"expritem : not TOKINCACHE replpathv TOKKEY strv",
"expritem : not TOKMATCHED",
"expritem : not TOKUNMATCHED",
"expritem : not TOKAGE ltgt time",
"expritem : not TOKAGE TOKINVALID",
"expritem : not TOKATTACHMENT TOKCOUNT cmp numv",
"expritem : not TOKATTACHMENT TOKTOTALSIZE ltgt size",
"expritem : not TOKATTACHMENT TOKANYSIZE ltgt size",
"expritem : not TOKATTACHMENT TOKANYTYPE strv",
"expritem : not TOKATTACHMENT TOKANYNAME strv",
"exprlist : exprlist exprop expritem",
"exprlist : exprop expritem",
"expr : expritem",
"expr : expritem exprlist",
"perform : users actionp actitem cont",
"perform : users actionp '{' actlist '}' cont",
"perform : users actions cont",
"perform : '{'",
"close : '}'",
"rule : TOKMATCH expr perform",
"folderlist :",
"folderlist : folders",
"folder1 :",
"folder1 : folderp strv",
"groups : groupp replstrv",
"groups : groupp '{' stringslist '}'",
"nocrammd5 : TOKNOCRAMMD5",
"nocrammd5 :",
"nologin : TOKNOLOGIN",
"nologin :",
"starttls : TOKSTARTTLS",
"starttls :",
"uidl : TOKNOUIDL",
"uidl :",
"insecure : TOKINSECURE",
"insecure :",
"verify : TOKNOVERIFY",
"verify :",
"apop : TOKNOAPOP",
"apop :",
"only : TOKNEWONLY",
"only : TOKOLDONLY",
"poptype : TOKPOP3",
"poptype : TOKPOP3S",
"imaptype : TOKIMAP",
"imaptype : TOKIMAPS",
"nntptype : TOKNNTP",
"nntptype : TOKNNTPS",
"userpassnetrc : TOKUSER replstrv TOKPASS replstrv",
"userpassnetrc :",
"userpassnetrc : TOKUSER replstrv",
"userpassnetrc : TOKPASS replstrv",
"userpassreqd : TOKUSER replstrv TOKPASS replstrv",
"userpass : userpassreqd",
"userpass :",
"poponly : only TOKCACHE replpathv",
"poponly :",
"imaponly : only",
"imaponly :",
"fetchtype : poptype server userpassnetrc poponly apop verify uidl starttls insecure",
"fetchtype : TOKPOP3 TOKPIPE replstrv userpassreqd poponly apop",
"fetchtype : imaptype server userpassnetrc folderlist imaponly verify nocrammd5 nologin starttls insecure",
"fetchtype : TOKIMAP TOKPIPE replstrv userpass folderlist imaponly",
"fetchtype : TOKSTDIN",
"fetchtype : maildirs",
"fetchtype : mboxes",
"fetchtype : nntptype server userpassnetrc groups TOKCACHE replpathv verify insecure",
"account : TOKACCOUNT replstrv disabled users fetchtype keep",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
/* LINTUSED */
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
unsigned int yystacksize;
int yyparse(void);
#line 2419 "parse.y"

/* Programs */
#line 1687 "parse.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(void)
{
    unsigned int newsize;
    long sslen;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    sslen = yyssp - yyss;
#ifdef SIZE_MAX
#define YY_SIZE_MAX SIZE_MAX
#else
#define YY_SIZE_MAX 0xffffffffU
#endif
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newss)
        goto bail;
    newss = yyss ? (short *)realloc(yyss, newsize * sizeof *newss) :
      (short *)malloc(newsize * sizeof *newss); /* overflow check above */
    if (newss == NULL)
        goto bail;
    yyss = newss;
    yyssp = newss + sslen;
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newvs)
        goto bail;
    newvs = yyvs ? (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs) :
      (YYSTYPE *)malloc(newsize * sizeof *newvs); /* overflow check above */
    if (newvs == NULL)
        goto bail;
    yyvs = newvs;
    yyvsp = newvs + sslen;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
bail:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return -1;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse(void)
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif /* YYDEBUG */

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yyvsp[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 26:
#line 360 "parse.y"
{
	     yyval.string = yyvsp[0].string;
     }
break;
case 27:
#line 364 "parse.y"
{
	     yyval.string = yyvsp[0].string;
     }
break;
case 28:
#line 369 "parse.y"
{
		yyval.string = yyvsp[0].string;
	}
break;
case 29:
#line 373 "parse.y"
{
		yyval.string = NULL;
	}
break;
case 30:
#line 378 "parse.y"
{
	       yyval.string = run_command(yyvsp[0].string, parse_file->path);
	       xfree(yyvsp[0].string);
       }
break;
case 31:
#line 383 "parse.y"
{
	       yyval.string = yyvsp[0].string;
       }
break;
case 32:
#line 387 "parse.y"
{
	       struct macro	*macro;

	       if (strlen(yyvsp[0].string) > MAXNAMESIZE)
		       yyerror("macro name too long: %s", yyvsp[0].string);

	       if ((macro = find_macro(yyvsp[0].string)) == NULL)
		       yyerror("undefined macro: %s", yyvsp[0].string);
	       if (macro->type != MACRO_STRING)
		       yyerror("string macro expected: %s", yyvsp[0].string);

	       yyval.string = xstrdup(macro->value.str);

	       xfree(yyvsp[0].string);
       }
break;
case 33:
#line 404 "parse.y"
{
	      yyval.string = yyvsp[0].string;
      }
break;
case 34:
#line 408 "parse.y"
{
	      size_t	size;

	      size = strlen(yyvsp[-2].string) + strlen(yyvsp[0].string) + 1;
	      yyval.string = xrealloc(yyvsp[-2].string, 1, size);
	      strlcat(yyval.string, yyvsp[0].string, size);
	      xfree(yyvsp[0].string);
      }
break;
case 35:
#line 418 "parse.y"
{
	      const char	*errstr;
	      char		*s;

	      s = run_command(yyvsp[0].string, parse_file->path);

	      yyval.number = strtonum(s, 0, LLONG_MAX, &errstr);
	      if (errstr != NULL)
		      yyerror("number is %s", errstr);

	      xfree(s);

	      xfree(yyvsp[0].string);
      }
break;
case 36:
#line 433 "parse.y"
{
	      yyval.number = yyvsp[0].number;
      }
break;
case 37:
#line 437 "parse.y"
{
	      struct macro	*macro;

	      if (strlen(yyvsp[0].string) > MAXNAMESIZE)
		      yyerror("macro name too long: %s", yyvsp[0].string);

	      if ((macro = find_macro(yyvsp[0].string)) == NULL)
		      yyerror("undefined macro: %s", yyvsp[0].string);
	      if (macro->type != MACRO_NUMBER)
		      yyerror("number macro expected: %s", yyvsp[0].string);

	      yyval.number = macro->value.num;

	      xfree(yyvsp[0].string);
      }
break;
case 38:
#line 454 "parse.y"
{
		  struct replstr	rs;

		  rs.str = yyvsp[0].string;
		  yyval.string = replacestr(&rs, parse_tags, NULL, NULL);
		  xfree(yyvsp[0].string);
	  }
break;
case 39:
#line 463 "parse.y"
{
		  struct replpath	rp;

		  rp.str = yyvsp[0].string;
		  yyval.string = replacepath(&rp, parse_tags, NULL, NULL, conf.user_home);
		  xfree(yyvsp[0].string);
	   }
break;
case 40:
#line 472 "parse.y"
{
	      yyval.number = yyvsp[0].number;
      }
break;
case 41:
#line 476 "parse.y"
{
	      yyval.number = yyvsp[-1].number;
      }
break;
case 42:
#line 480 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / 1024)
		      yyerror("size is too big");
	      yyval.number = yyvsp[-1].number * 1024;
      }
break;
case 43:
#line 486 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / (1024 * 1024))
		      yyerror("size is too big");
	      yyval.number = yyvsp[-1].number * (1024 * 1024);
      }
break;
case 44:
#line 492 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / (1024 * 1024 * 1024))
		      yyerror("size is too big");
	      yyval.number = yyvsp[-1].number * (1024 * 1024 * 1024);
      }
break;
case 45:
#line 499 "parse.y"
{
	      yyval.number = yyvsp[0].number;
      }
break;
case 46:
#line 503 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_HOUR)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_HOUR;
      }
break;
case 47:
#line 509 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_MINUTE)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_MINUTE;
      }
break;
case 48:
#line 515 "parse.y"
{
	      yyval.number = yyvsp[-1].number;
      }
break;
case 49:
#line 519 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_DAY)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_DAY;
      }
break;
case 50:
#line 525 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_WEEK)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_WEEK;
      }
break;
case 51:
#line 531 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_MONTH)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_MONTH;
      }
break;
case 52:
#line 537 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_YEAR)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_YEAR;
      }
break;
case 53:
#line 544 "parse.y"
{
#if UINT64_MAX < LLONG_MAX
		if (yyvsp[0].number > UINT64_MAX)
			yyerror("time too long");
#endif

		yyval.number = yyvsp[0].number;
	}
break;
case 54:
#line 553 "parse.y"
{
		yyval.number = -1;
	}
break;
case 55:
#line 558 "parse.y"
{
	       struct cache	*cache;

	       TAILQ_FOREACH(cache, &conf.caches, entry) {
		       if (strcmp(cache->path, yyvsp[-1].string) == 0)
			       yyerror("duplicate cache path");
	       }

	       cache = xcalloc(1, sizeof *cache);
	       cache->path = yyvsp[-1].string;
	       cache->expire = yyvsp[0].number;

	       TAILQ_INSERT_TAIL(&conf.caches, cache, entry);

	       log_debug2("added cache \"%s\": expire %lld", cache->path, yyvsp[0].number);
       }
break;
case 56:
#line 576 "parse.y"
{
	     if (yyvsp[0].number == 0)
		     yyerror("zero maximum size");
	     if (yyvsp[0].number > MAXMAILSIZE)
		     yyerror("maximum size too large: %lld", yyvsp[0].number);
	     conf.max_size = yyvsp[0].number;
     }
break;
case 57:
#line 584 "parse.y"
{
	     if (yyvsp[0].locks & LOCK_FCNTL && yyvsp[0].locks & LOCK_FLOCK)
		     yyerror("fcntl and flock locking cannot be used together");
	     conf.lock_types = yyvsp[0].locks;
     }
break;
case 58:
#line 590 "parse.y"
{
	     if (conf.lock_file != NULL)
		     xfree(conf.lock_file);
	     conf.lock_file = yyvsp[0].string;
     }
break;
case 59:
#line 596 "parse.y"
{
	     conf.lock_wait = 1;
     }
break;
case 60:
#line 600 "parse.y"
{
	     conf.lock_timeout = yyvsp[0].number;
     }
break;
case 61:
#line 604 "parse.y"
{
	     conf.del_big = 1;
     }
break;
case 62:
#line 608 "parse.y"
{
	     conf.ignore_errors = 1;
     }
break;
case 63:
#line 612 "parse.y"
{
	     conf.allow_many = 1;
     }
break;
case 64:
#line 616 "parse.y"
{
	     if (conf.def_user == NULL)
		     conf.def_user = yyvsp[0].string;
     }
break;
case 65:
#line 621 "parse.y"
{
	     if (conf.cmd_user == NULL)
		     conf.cmd_user = yyvsp[0].string;
     }
break;
case 66:
#line 626 "parse.y"
{
	     xfree(conf.strip_chars);
	     conf.strip_chars = yyvsp[0].string;
     }
break;
case 67:
#line 631 "parse.y"
{
	     if (yyvsp[0].number == 0)
		     yyerror("zero timeout");
	     if (yyvsp[0].number > INT_MAX / 1000)
		     yyerror("timeout too long: %lld", yyvsp[0].number);
	     conf.timeout = yyvsp[0].number * 1000;
     }
break;
case 68:
#line 639 "parse.y"
{
	     if (yyvsp[0].number == 0)
		     yyerror("zero queue-high");
	     if (yyvsp[0].number > MAXQUEUEVALUE)
		     yyerror("queue-high too big: %lld", yyvsp[0].number);
	     if (conf.queue_low != -1 && yyvsp[0].number <= conf.queue_low)
		     yyerror("queue-high must be larger than queue-low");
	     conf.queue_high = yyvsp[0].number;
     }
break;
case 69:
#line 649 "parse.y"
{
	     if (yyvsp[0].number > MAXQUEUEVALUE)
		     yyerror("queue-low too big: %lld", yyvsp[0].number);
	     if (conf.queue_high == -1)
		     yyerror("queue-high not specified");
	     if (yyvsp[0].number >= conf.queue_high)
		     yyerror("queue-low must be smaller than queue-high");
	     conf.queue_low = yyvsp[0].number;
     }
break;
case 70:
#line 659 "parse.y"
{
	     if (yyvsp[0].number > INT_MAX)
		     yyerror("parallel-accounts too big: %lld", yyvsp[0].number);
	     if (yyvsp[0].number == 0)
		     yyerror("parallel-accounts cannot be zero");
	     conf.max_accts = yyvsp[0].number;
     }
break;
case 71:
#line 667 "parse.y"
{
	     if (conf.proxy != NULL) {
		     xfree(conf.proxy->server.host);
		     xfree(conf.proxy->server.port);
		     if (conf.proxy->user != NULL)
			     xfree(conf.proxy->user);
		     if (conf.proxy->pass != NULL)
			     xfree(conf.proxy->pass);
	     }
	     if ((conf.proxy = getproxy(yyvsp[0].string)) == NULL)
		     yyerror("invalid proxy");
	     xfree(yyvsp[0].string);
     }
break;
case 72:
#line 681 "parse.y"
{
	     conf.verify_certs = 1;
     }
break;
case 73:
#line 685 "parse.y"
{
	     conf.impl_act = DECISION_KEEP;
     }
break;
case 74:
#line 689 "parse.y"
{
	     conf.impl_act = DECISION_DROP;
     }
break;
case 75:
#line 693 "parse.y"
{
	     if (yyvsp[0].number == 0)
		     yyerror("invalid purge-after value: 0");
	     if (yyvsp[0].number > UINT_MAX)
		     yyerror("purge-after value too large: %lld", yyvsp[0].number);

	     conf.purge_after = yyvsp[0].number;
     }
break;
case 76:
#line 702 "parse.y"
{
	     conf.purge_after = 0;
     }
break;
case 77:
#line 706 "parse.y"
{
	     conf.no_received = 1;
     }
break;
case 78:
#line 710 "parse.y"
{
	     conf.no_create = 1;
     }
break;
case 79:
#line 714 "parse.y"
{
	     conf.file_group = -1;
     }
break;
case 80:
#line 718 "parse.y"
{
	     conf.file_group = yyvsp[0].localgid;
     }
break;
case 81:
#line 722 "parse.y"
{
	     conf.file_umask = umask(0);
	     umask(conf.file_umask);
     }
break;
case 82:
#line 727 "parse.y"
{
	     ARRAY_FREEALL(conf.user_order);
	     conf.user_order = yyvsp[0].ufns;
     }
break;
case 83:
#line 732 "parse.y"
{
	     char	s[8];
	     u_int	n;

	     /*
	      * We can't differentiate umasks in octal from normal numbers
	      * (requiring a leading zero a la C would be nice, but it would
	      * potentially break existing configs), so we need to fiddle to
	      * convert.
	      */
	     memset(s, 0, sizeof s);
	     xsnprintf(s, sizeof s, "%03lld", yyvsp[0].number);
	     if (s[3] != '\0' || s[0] < '0' || s[0] > '7' ||
		 s[1] < 0 || s[1] > '7' || s[2] < '0' || s[2] > '7')
		     yyerror("invalid umask: %s", s);
	     if (sscanf(s, "%o", &n) != 1)
		     yyerror("invalid umask: %s", s);
	     conf.file_umask = n;
     }
break;
case 84:
#line 753 "parse.y"
{
		  struct macro	*macro;

		  if (strlen(yyvsp[-2].string) > MAXNAMESIZE)
			  yyerror("macro name too long: %s", yyvsp[-2].string);

		  macro = xmalloc(sizeof *macro);
		  strlcpy(macro->name, yyvsp[-2].string, sizeof macro->name);
		  macro->type = MACRO_STRING;
		  macro->value.str = yyvsp[0].string;

		  if (parse_last == NULL)
			  TAILQ_INSERT_HEAD(&parse_macros, macro, entry);
		  else {
			  TAILQ_INSERT_AFTER(
			      &parse_macros, parse_last, macro, entry);
		  }

		  log_debug3("added macro \"%s\": \"%s\"", macro->name,
		      macro->value.str);
		  xfree(yyvsp[-2].string);
	  }
break;
case 85:
#line 776 "parse.y"
{
		  struct macro	*macro;

		  if (strlen(yyvsp[-2].string) > MAXNAMESIZE)
			  yyerror("macro name too long: %s", yyvsp[-2].string);

		  macro = xmalloc(sizeof *macro);
		  strlcpy(macro->name, yyvsp[-2].string, sizeof macro->name);
		  macro->type = MACRO_NUMBER;
		  macro->value.num = yyvsp[0].number;

		  if (parse_last == NULL)
			  TAILQ_INSERT_HEAD(&parse_macros, macro, entry);
		  else {
			  TAILQ_INSERT_AFTER(
			      &parse_macros, parse_last, macro, entry);
		  }

		  log_debug3("added macro \"%s\": %lld", macro->name,
		      macro->value.num);
		  xfree(yyvsp[-2].string);
	  }
break;
case 86:
#line 800 "parse.y"
{
		      if (*yyvsp[0].string == '\0')
			      yyerror("empty string in list");

		      yyval.replstrs = yyvsp[-1].replstrs;
		      ARRAY_EXPAND(yyval.replstrs, 1);
		      ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
	      }
break;
case 87:
#line 809 "parse.y"
{
		      if (*yyvsp[0].string == '\0')
			     yyerror("empty string in list");

		      yyval.replstrs = xmalloc(sizeof *yyval.replstrs);
		      ARRAY_INIT(yyval.replstrs);
		      ARRAY_EXPAND(yyval.replstrs, 1);
		      ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
	      }
break;
case 88:
#line 820 "parse.y"
{
		     if (*yyvsp[0].string == '\0')
			     yyerror("empty string in list");

		     yyval.strings = yyvsp[-1].strings;
		     ARRAY_ADD(yyval.strings, yyvsp[0].string);
	     }
break;
case 89:
#line 828 "parse.y"
{
		     if (*yyvsp[0].string == '\0')
			     yyerror("empty string in list");

		     yyval.strings = xmalloc(sizeof *yyval.strings);
		     ARRAY_INIT(yyval.strings);
		     ARRAY_ADD(yyval.strings, yyvsp[0].string);
	     }
break;
case 90:
#line 838 "parse.y"
{
		   if (*yyvsp[0].string == '\0')
			   yyerror("invalid path");

		   yyval.strings = yyvsp[-1].strings;
		   ARRAY_ADD(yyval.strings, yyvsp[0].string);
	   }
break;
case 91:
#line 846 "parse.y"
{
		   if (*yyvsp[0].string == '\0')
			   yyerror("invalid path");

		   yyval.strings = xmalloc(sizeof *yyval.strings);
		   ARRAY_INIT(yyval.strings);
		   ARRAY_ADD(yyval.strings, yyvsp[0].string);
	   }
break;
case 92:
#line 856 "parse.y"
{
	     yyval.ufn = &passwd_lookup;
     }
break;
case 93:
#line 861 "parse.y"
{
		 yyval.ufns = yyvsp[-1].ufns;
		 ARRAY_ADD(yyval.ufns, yyvsp[0].ufn);
	 }
break;
case 94:
#line 866 "parse.y"
{
		 yyval.ufns = xmalloc(sizeof *yyval.ufns);
		 ARRAY_INIT(yyval.ufns);
		 ARRAY_ADD(yyval.ufns, yyvsp[0].ufn);
	 }
break;
case 95:
#line 873 "parse.y"
{
		   if (*yyvsp[0].string == '\0')
			   yyerror("invalid header");

		   yyval.replstrs = xmalloc(sizeof *yyval.replstrs);
		   ARRAY_INIT(yyval.replstrs);
		   ARRAY_EXPAND(yyval.replstrs, 1);
		   ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
	   }
break;
case 96:
#line 883 "parse.y"
{
		   yyval.replstrs = yyvsp[-1].replstrs;
	   }
break;
case 97:
#line 888 "parse.y"
{
		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid path");

		  yyval.strings = xmalloc(sizeof *yyval.strings);
		  ARRAY_INIT(yyval.strings);
		  ARRAY_ADD(yyval.strings, yyvsp[0].string);
	  }
break;
case 98:
#line 897 "parse.y"
{
		  yyval.strings = yyvsp[-1].strings;
	  }
break;
case 99:
#line 902 "parse.y"
{
		if (*yyvsp[0].string == '\0')
			yyerror("invalid path");

		yyval.strings = xmalloc(sizeof *yyval.strings);
		ARRAY_INIT(yyval.strings);
		ARRAY_ADD(yyval.strings, yyvsp[0].string);
	}
break;
case 100:
#line 911 "parse.y"
{
		yyval.strings = yyvsp[-1].strings;
	}
break;
case 101:
#line 916 "parse.y"
{
		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid folder");

		 yyval.strings = xmalloc(sizeof *yyval.strings);
		 ARRAY_INIT(yyval.strings);
		 ARRAY_ADD(yyval.strings, yyvsp[0].string);
	 }
break;
case 102:
#line 925 "parse.y"
{
		 yyval.strings = yyvsp[-1].strings;
	 }
break;
case 103:
#line 930 "parse.y"
{
	      yyval.locks = LOCK_FCNTL;
      }
break;
case 104:
#line 934 "parse.y"
{
	      yyval.locks = LOCK_FLOCK;
      }
break;
case 105:
#line 938 "parse.y"
{
	      yyval.locks = LOCK_DOTLOCK;
      }
break;
case 106:
#line 943 "parse.y"
{
		  yyval.locks = yyvsp[-1].locks | yyvsp[0].locks;
	  }
break;
case 107:
#line 947 "parse.y"
{
		  yyval.locks = yyvsp[0].locks;
	  }
break;
case 108:
#line 951 "parse.y"
{
		  yyval.locks = 0;
	  }
break;
case 109:
#line 956 "parse.y"
{
		  struct group	*gr;

		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid group");

		  gr = getgrnam(yyvsp[0].string);
		  if (gr == NULL)
			  yyerror("unknown group: %s", yyvsp[0].string);
		  yyval.localgid = gr->gr_gid;
		  endgrent();

		  xfree(yyvsp[0].string);
	  }
break;
case 110:
#line 971 "parse.y"
{
		  struct group	*gr;

		  if (yyvsp[0].number > GID_MAX)
			  yyerror("invalid gid: %llu", yyvsp[0].number);
		  gr = getgrgid(yyvsp[0].number);
		  if (gr == NULL)
			  yyerror("unknown gid: %llu", yyvsp[0].number);
		  yyval.localgid = gr->gr_gid;
		  endgrent();
	  }
break;
case 111:
#line 984 "parse.y"
{
	      yyval.string = NULL;
      }
break;
case 112:
#line 988 "parse.y"
{
	      yyval.string = yyvsp[0].string;
      }
break;
case 113:
#line 993 "parse.y"
{
	       yyval.replstrs = NULL;
       }
break;
case 114:
#line 997 "parse.y"
{
	       yyval.replstrs = xmalloc(sizeof *yyval.replstrs);
	       ARRAY_INIT(yyval.replstrs);
	       ARRAY_EXPAND(yyval.replstrs, 1);
	       ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
       }
break;
case 115:
#line 1004 "parse.y"
{
	       yyval.replstrs = yyvsp[-1].replstrs;
       }
break;
case 116:
#line 1009 "parse.y"
{
		/* match case */
		yyval.re.flags = 0;
		yyval.re.str = yyvsp[0].string;
	}
break;
case 117:
#line 1015 "parse.y"
{
		/* ignore case */
		yyval.re.flags = RE_IGNCASE;
		yyval.re.str = yyvsp[0].string;
	}
break;
case 118:
#line 1022 "parse.y"
{
	      yyval.flag = 1;
      }
break;
case 119:
#line 1026 "parse.y"
{
	      yyval.flag = 0;
      }
break;
case 120:
#line 1031 "parse.y"
{
	      yyval.flag = 1;
      }
break;
case 121:
#line 1035 "parse.y"
{
	      yyval.flag = 0;
      }
break;
case 122:
#line 1040 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 123:
#line 1044 "parse.y"
{
		  yyval.flag = 0;
	  }
break;
case 124:
#line 1049 "parse.y"
{
	      if (*yyvsp[0].string == '\0')
		      yyerror("invalid port");

	      yyval.string = yyvsp[0].string;
      }
break;
case 125:
#line 1056 "parse.y"
{
	      if (yyvsp[0].number == 0 || yyvsp[0].number > 65535)
		      yyerror("invalid port");

	      xasprintf(&yyval.string, "%lld", yyvsp[0].number);
      }
break;
case 126:
#line 1064 "parse.y"
{
		if (*yyvsp[-1].string == '\0')
			yyerror("invalid host");

		yyval.server.host = yyvsp[-1].string;
		yyval.server.port = yyvsp[0].string;
	}
break;
case 127:
#line 1072 "parse.y"
{
		if (*yyvsp[0].string == '\0')
			yyerror("invalid host");

		yyval.server.host = yyvsp[0].string;
		yyval.server.port = NULL;
	}
break;
case 128:
#line 1081 "parse.y"
{
	    yyval.string = NULL;
    }
break;
case 129:
#line 1085 "parse.y"
{
	    yyval.string = yyvsp[0].string;
    }
break;
case 130:
#line 1090 "parse.y"
{
	      yyval.string = NULL;
      }
break;
case 131:
#line 1094 "parse.y"
{
	      yyval.string = yyvsp[0].string;
      }
break;
case 132:
#line 1099 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 133:
#line 1103 "parse.y"
{
		  yyval.flag = 0;
	  }
break;
case 134:
#line 1108 "parse.y"
{
		 struct deliver_pipe_data	*data;

		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid command");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_pipe;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->pipe = yyvsp[-1].flag;
		 data->cmd.str = yyvsp[0].string;
	 }
break;
case 135:
#line 1124 "parse.y"
{
		 struct deliver_rewrite_data	*data;

		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid command");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_rewrite;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->cmd.str = yyvsp[0].string;
	 }
break;
case 136:
#line 1139 "parse.y"
{
		 struct deliver_write_data	*data;

		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid path");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_write;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->append = yyvsp[-1].flag;
		 data->path.str = yyvsp[0].string;
	 }
break;
case 137:
#line 1155 "parse.y"
{
		 struct deliver_maildir_data	*data;

		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid path");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_maildir;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->path.str = yyvsp[0].string;
	 }
break;
case 138:
#line 1170 "parse.y"
{
		 struct deliver_remove_header_data *data;

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_remove_header;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->hdrs = yyvsp[0].replstrs;
	 }
break;
case 139:
#line 1182 "parse.y"
{
		 struct deliver_add_header_data	*data;

		 if (*yyvsp[-1].string == '\0')
			 yyerror("invalid header");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_add_header;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->hdr.str = yyvsp[-1].string;
		 data->value.str = yyvsp[0].string;
	 }
break;
case 140:
#line 1198 "parse.y"
{
		 struct deliver_mbox_data	*data;

		 if (*yyvsp[-1].string == '\0')
			 yyerror("invalid path");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_mbox;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->path.str = yyvsp[-1].string;
		 data->compress = yyvsp[0].flag;
	 }
break;
case 141:
#line 1215 "parse.y"
{
		 struct deliver_imap_data	*data;

		 if (yyvsp[-8].flag && yyvsp[-1].flag)
			 yyerror("use either imaps or set starttls");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_imap;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 if (yyvsp[-6].userpass.user_netrc && yyvsp[-6].userpass.pass_netrc)
			 find_netrc(yyvsp[-7].server.host, &data->user, &data->pass);
		 else {
			 if (yyvsp[-6].userpass.user_netrc)
				 find_netrc(yyvsp[-7].server.host, &data->user, NULL);
			 else
				 data->user = yyvsp[-6].userpass.user;
			 if (yyvsp[-6].userpass.pass_netrc)
				 find_netrc(yyvsp[-7].server.host, NULL, &data->pass);
			 else
				 data->pass = yyvsp[-6].userpass.pass;
		 }

		 data->folder.str = yyvsp[-5].string;
		 data->server.ssl = yyvsp[-8].flag;
		 data->server.verify = yyvsp[-4].flag;
		 data->server.host = yyvsp[-7].server.host;
		 if (yyvsp[-7].server.port != NULL)
			 data->server.port = yyvsp[-7].server.port;
		 else if (yyvsp[-8].flag)
			 data->server.port = xstrdup("imaps");
		 else
			 data->server.port = xstrdup("imap");
		 data->server.ai = NULL;
		 data->nocrammd5 = yyvsp[-3].flag;
		 data->nologin = yyvsp[-2].flag;
		 data->starttls = yyvsp[-1].flag;
		 data->server.insecure = yyvsp[0].flag;
	 }
break;
case 142:
#line 1257 "parse.y"
{
		 struct deliver_smtp_data	*data;

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_smtp;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->server.host = yyvsp[-2].server.host;
		 if (yyvsp[-2].server.port != NULL)
			 data->server.port = yyvsp[-2].server.port;
		 else
			 data->server.port = xstrdup("smtp");
		 data->server.ai = NULL;
		 data->from.str = yyvsp[-1].string;
		 data->to.str = yyvsp[0].string;
	 }
break;
case 143:
#line 1276 "parse.y"
{
		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_stdout;
	 }
break;
case 144:
#line 1281 "parse.y"
{
		 struct deliver_tag_data	*data;

		 if (*yyvsp[-1].string == '\0')
			 yyerror("invalid tag");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_tag;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->key.str = yyvsp[-1].string;
		 data->value.str = yyvsp[0].string;
	 }
break;
case 145:
#line 1297 "parse.y"
{
		 struct deliver_add_to_cache_data	*data;

		 if (*yyvsp[-2].string == '\0')
			 yyerror("invalid path");
		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid key");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_add_to_cache;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->key.str = yyvsp[0].string;
		 data->path = yyvsp[-2].string;
	 }
break;
case 146:
#line 1315 "parse.y"
{
		 struct deliver_remove_from_cache_data	*data;

		 if (*yyvsp[-2].string == '\0')
			 yyerror("invalid path");
		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid key");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_remove_from_cache;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->key.str = yyvsp[0].string;
		 data->path = yyvsp[-2].string;
	 }
break;
case 147:
#line 1333 "parse.y"
{
		 struct deliver_action_data	*data;

		 /*
		  * This is a special-case, handled when the list of delivery
		  * targets is resolved rather than by calling a deliver
		  * function, so the deliver pointer is NULL.
		  */
		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = NULL;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->actions = yyvsp[0].replstrs;
	 }
break;
case 148:
#line 1350 "parse.y"
{
		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_drop;
	 }
break;
case 149:
#line 1355 "parse.y"
{
		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_keep;
	 }
break;
case 150:
#line 1361 "parse.y"
{
		 yyval.actlist = yyvsp[-1].actlist;

		 TAILQ_INSERT_TAIL(yyval.actlist, yyvsp[0].actitem, entry);
		 yyvsp[0].actitem->idx = parse_actionidx++;
	 }
break;
case 151:
#line 1368 "parse.y"
{
		 yyval.actlist = xmalloc(sizeof *yyval.actlist);
		 TAILQ_INIT(yyval.actlist);

		 TAILQ_INSERT_HEAD(yyval.actlist, yyvsp[0].actitem, entry);
		 yyvsp[0].actitem->idx = 0;

		 parse_actionidx = 1;
	 }
break;
case 152:
#line 1379 "parse.y"
{
		   struct action	*t;

		   if (strlen(yyvsp[-2].string) >= MAXNAMESIZE)
			   yyerror("action name too long: %s", yyvsp[-2].string);
		   if (*yyvsp[-2].string == '\0')
			   yyerror("invalid action name");
		   if (find_action(yyvsp[-2].string) != NULL)
			   yyerror("duplicate action: %s", yyvsp[-2].string);

		   t = xmalloc(sizeof *t);
		   strlcpy(t->name, yyvsp[-2].string, sizeof t->name);

		   t->list = xmalloc(sizeof *t->list);
		   TAILQ_INIT(t->list);
		   TAILQ_INSERT_HEAD(t->list, yyvsp[0].actitem, entry);
		   yyvsp[0].actitem->idx = 0;

		   t->users = yyvsp[-1].replstrs;
		   TAILQ_INSERT_TAIL(&conf.actions, t, entry);

		   print_action(t);

		   xfree(yyvsp[-2].string);
	   }
break;
case 153:
#line 1405 "parse.y"
{
		   struct action	*t;

		   if (strlen(yyvsp[-4].string) >= MAXNAMESIZE)
			   yyerror("action name too long: %s", yyvsp[-4].string);
		   if (*yyvsp[-4].string == '\0')
			   yyerror("invalid action name");
		   if (find_action(yyvsp[-4].string) != NULL)
			   yyerror("duplicate action: %s", yyvsp[-4].string);

		   t = xmalloc(sizeof *t);
		   strlcpy(t->name, yyvsp[-4].string, sizeof t->name);

		   t->list = yyvsp[-1].actlist;

		   t->users = yyvsp[-3].replstrs;
		   TAILQ_INSERT_TAIL(&conf.actions, t, entry);

		   print_action(t);

		   xfree(yyvsp[-4].string);
	   }
break;
case 154:
#line 1429 "parse.y"
{
		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid account name");
		  if (!have_accounts(yyvsp[0].string))
			  yyerror("no matching accounts: %s", yyvsp[0].string);

		  yyval.replstrs = xmalloc(sizeof *yyval.replstrs);
		  ARRAY_INIT(yyval.replstrs);
		  ARRAY_EXPAND(yyval.replstrs, 1);
		  ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
	  }
break;
case 155:
#line 1441 "parse.y"
{
		  yyval.replstrs = yyvsp[-1].replstrs;
	  }
break;
case 156:
#line 1446 "parse.y"
{
		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid action name");

		 yyval.replstrs = xmalloc(sizeof *yyval.replstrs);
		 ARRAY_INIT(yyval.replstrs);
		 ARRAY_EXPAND(yyval.replstrs, 1);
		 ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
	 }
break;
case 157:
#line 1456 "parse.y"
{
		 yyval.replstrs = yyvsp[-1].replstrs;
	 }
break;
case 158:
#line 1461 "parse.y"
{
	      yyval.flag = 0;
      }
break;
case 159:
#line 1465 "parse.y"
{
	      yyval.flag = 1;
      }
break;
case 160:
#line 1470 "parse.y"
{
	      yyval.area = AREA_ANY;
      }
break;
case 161:
#line 1474 "parse.y"
{
	      yyval.area = AREA_ANY;
      }
break;
case 162:
#line 1478 "parse.y"
{
	      yyval.area = AREA_HEADERS;
      }
break;
case 163:
#line 1482 "parse.y"
{
	      yyval.area = AREA_BODY;
      }
break;
case 164:
#line 1487 "parse.y"
{
	       if (yyvsp[0].number < 0 || yyvsp[0].number > 255)
		       yyerror("invalid return code");

	       yyval.number = yyvsp[0].number;
       }
break;
case 165:
#line 1494 "parse.y"
{
	       yyval.number = -1;
       }
break;
case 166:
#line 1499 "parse.y"
{
	       yyval.re = yyvsp[0].re;
       }
break;
case 167:
#line 1503 "parse.y"
{
	       yyval.re.str = NULL;
       }
break;
case 168:
#line 1508 "parse.y"
{
	     yyval.cmp = CMP_LT;
     }
break;
case 169:
#line 1512 "parse.y"
{
	     yyval.cmp = CMP_GT;
     }
break;
case 170:
#line 1517 "parse.y"
{
	      yyval.cmp = CMP_EQ;
      }
break;
case 171:
#line 1521 "parse.y"
{
	      yyval.cmp = CMP_NE;
      }
break;
case 172:
#line 1526 "parse.y"
{
	     yyval.cmp = yyvsp[0].cmp;
     }
break;
case 173:
#line 1530 "parse.y"
{
	     yyval.cmp = yyvsp[0].cmp;
     }
break;
case 174:
#line 1535 "parse.y"
{
		  yyval.flag = 0;
	  }
break;
case 175:
#line 1539 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 176:
#line 1544 "parse.y"
{
		     yyval.flag = 0;
	     }
break;
case 177:
#line 1548 "parse.y"
{
		     yyval.flag = 1;
	     }
break;
case 178:
#line 1553 "parse.y"
{
		yyval.exprop = OP_AND;
	}
break;
case 179:
#line 1557 "parse.y"
{
		yyval.exprop = OP_OR;
	}
break;
case 180:
#line 1562 "parse.y"
{
		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);
		  yyval.expritem->match = &match_all;
		  yyval.expritem->inverted = yyvsp[-1].flag;
	  }
break;
case 181:
#line 1568 "parse.y"
{
		  struct match_regexp_data	*data;
		  char				*cause;

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);
		  yyval.expritem->match = &match_regexp;
		  yyval.expritem->inverted = yyvsp[-2].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->area = yyvsp[0].area;

		  if (re_compile(&data->re, yyvsp[-1].re.str, yyvsp[-1].re.flags, &cause) != 0)
			  yyerror("%s", cause);
		  xfree(yyvsp[-1].re.str);
	  }
break;
case 182:
#line 1586 "parse.y"
{
		  struct match_account_data	*data;

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);
		  yyval.expritem->match = &match_account;
		  yyval.expritem->inverted = yyvsp[-1].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->accounts = yyvsp[0].replstrs;
	  }
break;
case 183:
#line 1599 "parse.y"
{
		  struct match_command_data	*data;
		  char				*cause;

		  if (*yyvsp[-7].string == '\0' || (yyvsp[-7].string[0] == '|' && yyvsp[-7].string[1] == '\0'))
			  yyerror("invalid command");
		  if (yyvsp[-3].number == -1 && yyvsp[-1].re.str == NULL)
			  yyerror("return code or regexp must be specified");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);
		  yyval.expritem->match = &match_command;
		  yyval.expritem->inverted = yyvsp[-9].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->user.str = yyvsp[-6].string;
		  data->pipe = yyvsp[-8].flag;
		  data->cmd.str = yyvsp[-7].string;

		  data->ret = yyvsp[-3].number;

		  if (yyvsp[-1].re.str != NULL) {
			  if (re_compile(
			      &data->re, yyvsp[-1].re.str, yyvsp[-1].re.flags, &cause) != 0)
				  yyerror("%s", cause);
			  xfree(yyvsp[-1].re.str);
		  }

	  }
break;
case 184:
#line 1630 "parse.y"
{
		  struct match_tagged_data	*data;

		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid tag");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_tagged;
		  yyval.expritem->inverted = yyvsp[-2].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->tag.str = yyvsp[0].string;
	  }
break;
case 185:
#line 1647 "parse.y"
{
		  struct match_size_data	*data;

#if SIZE_MAX < LLONG_MAX
		  if (yyvsp[0].number > SIZE_MAX)
			  yyerror("size too large");
#endif

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_size;
		  yyval.expritem->inverted = yyvsp[-3].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->size = yyvsp[0].number;
		  data->cmp = yyvsp[-1].cmp;
	  }
break;
case 186:
#line 1667 "parse.y"
{
		  struct match_string_data	*data;
		  char				*cause;

		  if (*yyvsp[-2].string == '\0')
			  yyerror("invalid string");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_string;
		  yyval.expritem->inverted = yyvsp[-4].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->str.str = yyvsp[-2].string;
		  if (re_compile(
		      &data->re, yyvsp[0].re.str, yyvsp[0].re.flags|RE_NOSUBST, &cause) != 0)
			  yyerror("%s", cause);
		  xfree(yyvsp[0].re.str);
	  }
break;
case 187:
#line 1689 "parse.y"
{
		  struct match_in_cache_data	*data;

		  if (*yyvsp[-2].string == '\0')
			  yyerror("invalid path");
		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid key");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_in_cache;
		  yyval.expritem->inverted = yyvsp[-4].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->key.str = yyvsp[0].string;
		  data->path = yyvsp[-2].string;
	  }
break;
case 188:
#line 1709 "parse.y"
{
		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_matched;
		  yyval.expritem->inverted = yyvsp[-1].flag;
	  }
break;
case 189:
#line 1716 "parse.y"
{
		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_unmatched;
		  yyval.expritem->inverted = yyvsp[-1].flag;
	  }
break;
case 190:
#line 1723 "parse.y"
{
		  struct match_age_data	*data;

		  if (yyvsp[0].number == 0)
			  yyerror("invalid time");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_age;
		  yyval.expritem->inverted = yyvsp[-3].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->time = yyvsp[0].number;
		  data->cmp = yyvsp[-1].cmp;
	  }
break;
case 191:
#line 1741 "parse.y"
{
		  struct match_age_data	*data;

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_age;
		  yyval.expritem->inverted = yyvsp[-2].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->time = -1;
	  }
break;
case 192:
#line 1755 "parse.y"
{
		  struct match_attachment_data	*data;

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_attachment;
		  yyval.expritem->inverted = yyvsp[-4].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->op = ATTACHOP_COUNT;
		  data->cmp = yyvsp[-1].cmp;
		  data->value.num = yyvsp[0].number;
	  }
break;
case 193:
#line 1771 "parse.y"
{
		  struct match_attachment_data	*data;

#if SIZE_MAX < LLONG_MAX
		  if (yyvsp[0].number > SIZE_MAX)
			  yyerror("size too large");
#endif

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_attachment;
		  yyval.expritem->inverted = yyvsp[-4].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->op = ATTACHOP_TOTALSIZE;
		  data->cmp = yyvsp[-1].cmp;
		  data->value.size = yyvsp[0].number;
	  }
break;
case 194:
#line 1792 "parse.y"
{
		  struct match_attachment_data	*data;

#if SIZE_MAX < LLONG_MAX
		  if (yyvsp[0].number > SIZE_MAX)
			  yyerror("size too large");
#endif

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_attachment;
		  yyval.expritem->inverted = yyvsp[-4].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->op = ATTACHOP_ANYSIZE;
		  data->cmp = yyvsp[-1].cmp;
		  data->value.size = yyvsp[0].number;
	  }
break;
case 195:
#line 1813 "parse.y"
{
		  struct match_attachment_data	*data;

		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid string");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_attachment;
		  yyval.expritem->inverted = yyvsp[-3].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->op = ATTACHOP_ANYTYPE;
		  data->value.str.str = yyvsp[0].string;
	  }
break;
case 196:
#line 1831 "parse.y"
{
		  struct match_attachment_data	*data;

		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid string");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_attachment;
		  yyval.expritem->inverted = yyvsp[-3].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->op = ATTACHOP_ANYNAME;
		  data->value.str.str = yyvsp[0].string;
	  }
break;
case 197:
#line 1850 "parse.y"
{
		  yyval.expr = yyvsp[-2].expr;

		  yyvsp[0].expritem->op = yyvsp[-1].exprop;
		  TAILQ_INSERT_TAIL(yyval.expr, yyvsp[0].expritem, entry);
	  }
break;
case 198:
#line 1857 "parse.y"
{
		  yyval.expr = xmalloc(sizeof *yyval.expr);
		  TAILQ_INIT(yyval.expr);

		  yyvsp[0].expritem->op = yyvsp[-1].exprop;
		  TAILQ_INSERT_HEAD(yyval.expr, yyvsp[0].expritem, entry);
	  }
break;
case 199:
#line 1866 "parse.y"
{
	      yyval.expr = xmalloc(sizeof *yyval.expr);
	      TAILQ_INIT(yyval.expr);

	      TAILQ_INSERT_HEAD(yyval.expr, yyvsp[0].expritem, entry);
      }
break;
case 200:
#line 1873 "parse.y"
{
	      yyval.expr = yyvsp[0].expr;

	      TAILQ_INSERT_HEAD(yyval.expr, yyvsp[-1].expritem, entry);
      }
break;
case 201:
#line 1880 "parse.y"
{
		 struct action	*t;

		 yyval.rule = xcalloc(1, sizeof *yyval.rule);
		 yyval.rule->idx = parse_ruleidx++;
		 yyval.rule->actions = NULL;
		 TAILQ_INIT(&yyval.rule->rules);
		 yyval.rule->stop = !yyvsp[0].flag;
		 yyval.rule->users = yyvsp[-3].replstrs;

		 t = yyval.rule->lambda = xcalloc(1, sizeof *yyval.rule->lambda);
		 xsnprintf(t->name, sizeof t->name, "<rule %u>", yyval.rule->idx);
		 t->users = NULL;
		 t->list = xmalloc(sizeof *t->list);
		 TAILQ_INIT(t->list);
		 TAILQ_INSERT_HEAD(t->list, yyvsp[-1].actitem, entry);
		 yyvsp[-1].actitem->idx = 0;

		 if (parse_rule == NULL)
			 TAILQ_INSERT_TAIL(&conf.rules, yyval.rule, entry);
		 else
			 TAILQ_INSERT_TAIL(&parse_rule->rules, yyval.rule, entry);
	 }
break;
case 202:
#line 1904 "parse.y"
{
		 struct action	*t;

		 yyval.rule = xcalloc(1, sizeof *yyval.rule);
		 yyval.rule->idx = parse_ruleidx++;
		 yyval.rule->actions = NULL;
		 TAILQ_INIT(&yyval.rule->rules);
		 yyval.rule->stop = !yyvsp[0].flag;
		 yyval.rule->users = yyvsp[-5].replstrs;

		 t = yyval.rule->lambda = xcalloc(1, sizeof *yyval.rule->lambda);
		 xsnprintf(t->name, sizeof t->name, "<rule %u>", yyval.rule->idx);
		 t->users = NULL;
		 t->list = yyvsp[-2].actlist;

		 if (parse_rule == NULL)
			 TAILQ_INSERT_TAIL(&conf.rules, yyval.rule, entry);
		 else
			 TAILQ_INSERT_TAIL(&parse_rule->rules, yyval.rule, entry);
	 }
break;
case 203:
#line 1925 "parse.y"
{
		 yyval.rule = xcalloc(1, sizeof *yyval.rule);
		 yyval.rule->idx = parse_ruleidx++;
		 yyval.rule->lambda = NULL;
		 yyval.rule->actions = yyvsp[-1].replstrs;
		 TAILQ_INIT(&yyval.rule->rules);
		 yyval.rule->stop = !yyvsp[0].flag;
		 yyval.rule->users = yyvsp[-2].replstrs;

		 if (parse_rule == NULL)
			 TAILQ_INSERT_TAIL(&conf.rules, yyval.rule, entry);
		 else
			 TAILQ_INSERT_TAIL(&parse_rule->rules, yyval.rule, entry);
	 }
break;
case 204:
#line 1940 "parse.y"
{
		 yyval.rule = xcalloc(1, sizeof *yyval.rule);
		 yyval.rule->idx = parse_ruleidx++;
		 yyval.rule->lambda = NULL;
		 yyval.rule->actions = NULL;
		 TAILQ_INIT(&yyval.rule->rules);
		 yyval.rule->stop = 0;
		 yyval.rule->users = NULL;

		 if (parse_rule == NULL)
			 TAILQ_INSERT_TAIL(&conf.rules, yyval.rule, entry);
		 else
			 TAILQ_INSERT_TAIL(&parse_rule->rules, yyval.rule, entry);

		 ARRAY_ADD(&parse_rulestack, parse_rule);
		 parse_rule = yyval.rule;
	 }
break;
case 205:
#line 1959 "parse.y"
{
	       if (parse_rule == NULL)
		       yyerror("missing {");

	       parse_rule = ARRAY_LAST(&parse_rulestack);
	       ARRAY_TRUNC(&parse_rulestack, 1);
       }
break;
case 206:
#line 1968 "parse.y"
{
	      yyvsp[0].rule->expr = yyvsp[-1].expr;
	      print_rule(yyvsp[0].rule);
      }
break;
case 207:
#line 1974 "parse.y"
{
		    yyval.strings = xmalloc(sizeof *yyval.strings);
		    ARRAY_INIT(yyval.strings);
		    ARRAY_ADD(yyval.strings, xstrdup("INBOX"));
	    }
break;
case 208:
#line 1980 "parse.y"
{
		    yyval.strings = yyvsp[0].strings;
	    }
break;
case 209:
#line 1985 "parse.y"
{
		 yyval.string = xstrdup("INBOX");
	 }
break;
case 210:
#line 1989 "parse.y"
{
		 yyval.string = yyvsp[0].string;
	 }
break;
case 211:
#line 1995 "parse.y"
{
		if (*yyvsp[0].string == '\0')
			yyerror("invalid group");

		yyval.strings = xmalloc(sizeof *yyval.strings);
		ARRAY_INIT(yyval.strings);
		ARRAY_ADD(yyval.strings, yyvsp[0].string);
	}
break;
case 212:
#line 2004 "parse.y"
{
		yyval.strings = yyvsp[-1].strings;
	}
break;
case 213:
#line 2009 "parse.y"
{
		   yyval.flag = 1;
	   }
break;
case 214:
#line 2013 "parse.y"
{
		   yyval.flag = 0;
	   }
break;
case 215:
#line 2018 "parse.y"
{
		 yyval.flag = 1;
	 }
break;
case 216:
#line 2022 "parse.y"
{
		 yyval.flag = 0;
	 }
break;
case 217:
#line 2027 "parse.y"
{
		yyval.flag = 1;
	}
break;
case 218:
#line 2031 "parse.y"
{
		yyval.flag = 0;
	}
break;
case 219:
#line 2037 "parse.y"
{
		yyval.flag = 0;
	}
break;
case 220:
#line 2041 "parse.y"
{
		yyval.flag = 1;
	}
break;
case 221:
#line 2046 "parse.y"
{
		yyval.flag = 1;
	}
break;
case 222:
#line 2050 "parse.y"
{
		yyval.flag = 0;
	}
break;
case 223:
#line 2055 "parse.y"
{
		yyval.flag = 0;
	}
break;
case 224:
#line 2059 "parse.y"
{
		yyval.flag = 1;
	}
break;
case 225:
#line 2064 "parse.y"
{
	      yyval.flag = 0;
      }
break;
case 226:
#line 2068 "parse.y"
{
	      yyval.flag = 1;
      }
break;
case 227:
#line 2073 "parse.y"
{
	      yyval.only = FETCH_ONLY_NEW;
      }
break;
case 228:
#line 2077 "parse.y"
{
	      yyval.only = FETCH_ONLY_OLD;
      }
break;
case 229:
#line 2082 "parse.y"
{
		 yyval.flag = 0;
	 }
break;
case 230:
#line 2086 "parse.y"
{
		 yyval.flag = 1;
	 }
break;
case 231:
#line 2091 "parse.y"
{
		  yyval.flag = 0;
	  }
break;
case 232:
#line 2095 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 233:
#line 2100 "parse.y"
{
		  yyval.flag = 0;
	  }
break;
case 234:
#line 2104 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 235:
#line 2109 "parse.y"
{
		       if (*yyvsp[-2].string == '\0')
			       yyerror("invalid user");
		       if (*yyvsp[0].string == '\0')
			       yyerror("invalid pass");

		       yyval.userpass.user = yyvsp[-2].string;
		       yyval.userpass.user_netrc = 0;
		       yyval.userpass.pass = yyvsp[0].string;
		       yyval.userpass.pass_netrc = 0;
	       }
break;
case 236:
#line 2121 "parse.y"
{
		       yyval.userpass.user = NULL;
		       yyval.userpass.user_netrc = 1;
		       yyval.userpass.pass = NULL;
		       yyval.userpass.pass_netrc = 1;
	       }
break;
case 237:
#line 2128 "parse.y"
{
		       if (*yyvsp[0].string == '\0')
			       yyerror("invalid user");

		       yyval.userpass.user = yyvsp[0].string;
		       yyval.userpass.user_netrc = 0;
		       yyval.userpass.pass = NULL;
		       yyval.userpass.pass_netrc = 1;
	       }
break;
case 238:
#line 2138 "parse.y"
{
		       if (*yyvsp[0].string == '\0')
			       yyerror("invalid pass");

		       yyval.userpass.user = NULL;
		       yyval.userpass.user_netrc = 1;
		       yyval.userpass.pass = yyvsp[0].string;
		       yyval.userpass.pass_netrc = 0;
	       }
break;
case 239:
#line 2149 "parse.y"
{
		      if (*yyvsp[-2].string == '\0')
			      yyerror("invalid user");
		      if (*yyvsp[0].string == '\0')
			      yyerror("invalid pass");

		      yyval.userpass.user = yyvsp[-2].string;
		      yyval.userpass.user_netrc = 0;
		      yyval.userpass.pass = yyvsp[0].string;
		      yyval.userpass.pass_netrc = 0;
	      }
break;
case 240:
#line 2162 "parse.y"
{
		  yyval.userpass.user = yyvsp[0].userpass.user;
		  yyval.userpass.user_netrc = yyvsp[0].userpass.user_netrc;
		  yyval.userpass.pass = yyvsp[0].userpass.pass;
		  yyval.userpass.pass_netrc = yyvsp[0].userpass.pass_netrc;
	  }
break;
case 241:
#line 2169 "parse.y"
{
		  yyval.userpass.user = NULL;
		  yyval.userpass.user_netrc = 0;
		  yyval.userpass.pass = NULL;
		  yyval.userpass.pass_netrc = 0;
	  }
break;
case 242:
#line 2177 "parse.y"
{
		 yyval.poponly.path = yyvsp[0].string;
		 yyval.poponly.only = yyvsp[-2].only;
	 }
break;
case 243:
#line 2182 "parse.y"
{
		 yyval.poponly.path = NULL;
		 yyval.poponly.only = FETCH_ONLY_ALL;
	 }
break;
case 244:
#line 2188 "parse.y"
{
		  yyval.only = yyvsp[0].only;
	  }
break;
case 245:
#line 2192 "parse.y"
{
		  yyval.only = FETCH_ONLY_ALL;
	  }
break;
case 246:
#line 2198 "parse.y"
{
		   struct fetch_pop3_data	*data;

		   if (yyvsp[-8].flag && yyvsp[-1].flag)
			   yyerror("use either pop3s or set starttls");

		   yyval.fetch.fetch = &fetch_pop3;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;

		   if (yyvsp[-6].userpass.user_netrc && yyvsp[-6].userpass.pass_netrc)
			  find_netrc(yyvsp[-7].server.host, &data->user, &data->pass);
		   else {
			   if (yyvsp[-6].userpass.user_netrc)
				   find_netrc(yyvsp[-7].server.host, &data->user, NULL);
			   else
				   data->user = yyvsp[-6].userpass.user;
			   if (yyvsp[-6].userpass.pass_netrc)
				   find_netrc(yyvsp[-7].server.host, NULL, &data->pass);
			   else
				   data->pass = yyvsp[-6].userpass.pass;
		   }

		   data->server.ssl = yyvsp[-8].flag;
		   data->server.verify = yyvsp[-3].flag;
		   data->server.host = yyvsp[-7].server.host;
		   if (yyvsp[-7].server.port != NULL)
			   data->server.port = yyvsp[-7].server.port;
		   else if (yyvsp[-8].flag)
			   data->server.port = xstrdup("pop3s");
		   else
			   data->server.port = xstrdup("pop3");
		   data->server.ai = NULL;
		   data->apop = yyvsp[-4].flag;
		   data->uidl = yyvsp[-2].flag;
		   data->starttls = yyvsp[-1].flag;
		   data->server.insecure = yyvsp[0].flag;

		   data->path = yyvsp[-5].poponly.path;
		   data->only = yyvsp[-5].poponly.only;
	   }
break;
case 247:
#line 2240 "parse.y"
{
		   struct fetch_pop3_data	*data;

		   yyval.fetch.fetch = &fetch_pop3pipe;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;
		   data->user = yyvsp[-2].userpass.user;
		   data->pass = yyvsp[-2].userpass.pass;
		   data->pipecmd = yyvsp[-3].string;
		   if (data->pipecmd == NULL || *data->pipecmd == '\0')
			   yyerror("invalid pipe command");
		   data->apop = yyvsp[0].flag;
		   data->path = yyvsp[-1].poponly.path;
		   data->only = yyvsp[-1].poponly.only;
	   }
break;
case 248:
#line 2257 "parse.y"
{
		   struct fetch_imap_data	*data;

		   if (yyvsp[-9].flag && yyvsp[-1].flag)
			   yyerror("use either imaps or set starttls");

		   yyval.fetch.fetch = &fetch_imap;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;

		   if (yyvsp[-7].userpass.user_netrc && yyvsp[-7].userpass.pass_netrc)
			   find_netrc(yyvsp[-8].server.host, &data->user, &data->pass);
		   else {
			   if (yyvsp[-7].userpass.user_netrc)
				   find_netrc(yyvsp[-8].server.host, &data->user, NULL);
			   else
				   data->user = yyvsp[-7].userpass.user;
			   if (yyvsp[-7].userpass.pass_netrc)
				   find_netrc(yyvsp[-8].server.host, NULL, &data->pass);
			   else
				   data->pass = yyvsp[-7].userpass.pass;
		   }

		   data->folders = yyvsp[-6].strings;
		   data->server.ssl = yyvsp[-9].flag;
		   data->server.verify = yyvsp[-4].flag;
		   data->server.host = yyvsp[-8].server.host;
		   if (yyvsp[-8].server.port != NULL)
			   data->server.port = yyvsp[-8].server.port;
		   else if (yyvsp[-9].flag)
			   data->server.port = xstrdup("imaps");
		   else
			   data->server.port = xstrdup("imap");
		   data->server.ai = NULL;
		   data->only = yyvsp[-5].only;
		   data->nocrammd5 = yyvsp[-3].flag;
		   data->nologin = yyvsp[-2].flag;
		   data->starttls = yyvsp[-1].flag;
		   data->server.insecure = yyvsp[0].flag;
	   }
break;
case 249:
#line 2298 "parse.y"
{
		   struct fetch_imap_data	*data;

		   yyval.fetch.fetch = &fetch_imappipe;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;
		   data->user = yyvsp[-2].userpass.user;
		   data->pass = yyvsp[-2].userpass.pass;
		   data->folders = yyvsp[-1].strings;
		   data->pipecmd = yyvsp[-3].string;
		   if (data->pipecmd == NULL || *data->pipecmd == '\0')
			   yyerror("invalid pipe command");
		   data->only = yyvsp[0].only;
	   }
break;
case 250:
#line 2313 "parse.y"
{
		   yyval.fetch.fetch = &fetch_stdin;
	   }
break;
case 251:
#line 2317 "parse.y"
{
		   struct fetch_maildir_data	*data;

		   yyval.fetch.fetch = &fetch_maildir;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;
		   data->maildirs = yyvsp[0].strings;
	   }
break;
case 252:
#line 2326 "parse.y"
{
		   struct fetch_mbox_data	*data;

		   yyval.fetch.fetch = &fetch_mbox;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;
		   data->mboxes = yyvsp[0].strings;
	   }
break;
case 253:
#line 2336 "parse.y"
{
		   struct fetch_nntp_data	*data;
		   char				*cause;

		   if (*yyvsp[-2].string == '\0')
			   yyerror("invalid cache");

		   yyval.fetch.fetch = &fetch_nntp;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;

		   if (yyvsp[-5].userpass.user_netrc && yyvsp[-5].userpass.pass_netrc) {
			   if (find_netrc1(yyvsp[-6].server.host,
			       &data->user, &data->pass, &cause) != 0) {
				   log_debug2("%s", cause);
				   xfree(cause);
				   data->user = NULL;
				   data->pass = NULL;
			   }

		   } else {
			   if (yyvsp[-5].userpass.user_netrc)
				   find_netrc(yyvsp[-6].server.host, &data->user, NULL);
			   else
				   data->user = yyvsp[-5].userpass.user;
			   if (yyvsp[-5].userpass.pass_netrc)
				   find_netrc(yyvsp[-6].server.host, NULL, &data->pass);
			   else
				   data->pass = yyvsp[-5].userpass.pass;
		   }

		   data->names = yyvsp[-4].strings;
		   data->path = yyvsp[-2].string;
		   if (data->path == NULL || *data->path == '\0')
			   yyerror("invalid cache");

		   data->server.ssl = yyvsp[-7].flag;
		   data->server.verify = yyvsp[-1].flag;
		   data->server.insecure = yyvsp[0].flag;
		   data->server.host = yyvsp[-6].server.host;
		   if (yyvsp[-6].server.port != NULL)
			   data->server.port = yyvsp[-6].server.port;
		   else if (yyvsp[-7].flag)
			   data->server.port = xstrdup("nntps");
		   else
			   data->server.port = xstrdup("nntp");
		   data->server.ai = NULL;
	   }
break;
case 254:
#line 2386 "parse.y"
{
		 struct account		*a;
		 char			*su, desc[DESCBUFSIZE];

		 if (strlen(yyvsp[-4].string) >= MAXNAMESIZE)
			 yyerror("account name too long: %s", yyvsp[-4].string);
		 if (*yyvsp[-4].string == '\0')
			 yyerror("invalid account name");
		 if (find_account(yyvsp[-4].string) != NULL)
			 yyerror("duplicate account: %s", yyvsp[-4].string);

		 a = xcalloc(1, sizeof *a);
		 strlcpy(a->name, yyvsp[-4].string, sizeof a->name);
		 a->keep = yyvsp[0].flag;
		 a->disabled = yyvsp[-3].flag;
		 a->users = yyvsp[-2].replstrs;
		 a->fetch = yyvsp[-1].fetch.fetch;
		 a->data = yyvsp[-1].fetch.data;
		 TAILQ_INSERT_TAIL(&conf.accounts, a, entry);

		 if (a->users != NULL)
			 su = fmt_replstrs(" users=", a->users);
		 else
			 su = xstrdup("");
		 a->fetch->desc(a, desc, sizeof desc);
		 log_debug2("added account \"%s\":%s fetch=%s", a->name, su,
		     desc);
		 xfree(su);

		 xfree(yyvsp[-4].string);
	 }
break;
#line 4314 "parse.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (1);
yyaccept:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (0);
}
