/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui.tray;

import davmail.BundleMessage;
import davmail.ui.tray.AwtGatewayTray;
import davmail.ui.tray.DavGatewayTray;
import davmail.ui.tray.OSXHandler;
import davmail.ui.tray.OSXTrayInterface;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Icon;
import org.apache.log4j.Level;

public class OSXAwtGatewayTray
extends AwtGatewayTray
implements OSXTrayInterface {
    protected static final String OSX_TRAY_ACTIVE_PNG = "osxtray2.png";
    protected static final String OSX_TRAY_PNG = "osxtray.png";
    protected static final String OSX_TRAY_INACTIVE_PNG = "osxtrayinactive.png";

    @Override
    protected void loadIcons() {
        image = DavGatewayTray.adjustTrayIcon(DavGatewayTray.loadImage(OSX_TRAY_PNG));
        activeImage = DavGatewayTray.adjustTrayIcon(DavGatewayTray.loadImage(OSX_TRAY_ACTIVE_PNG));
        inactiveImage = DavGatewayTray.adjustTrayIcon(DavGatewayTray.loadImage(OSX_TRAY_INACTIVE_PNG));
        frameIcons = new ArrayList();
        frameIcons.add(DavGatewayTray.loadImage("tray128.png"));
        frameIcons.add(DavGatewayTray.loadImage("tray.png"));
    }

    @Override
    protected void createAndShowGUI() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        super.createAndShowGUI();
        trayIcon.removeActionListener(this.settingsListener);
        try {
            new OSXHandler(this);
        }
        catch (Exception e) {
            DavGatewayTray.error(new BundleMessage("LOG_ERROR_LOADING_OSXADAPTER", new Object[0]), e);
        }
    }

    @Override
    public void displayMessage(String message, Level level) {
        super.displayMessage(message, level);
    }

    protected Image getImageForIcon(Icon icon) {
        BufferedImage bufferedimage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics g = bufferedimage.getGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return bufferedimage;
    }
}

