/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui.tray;

import davmail.BundleMessage;
import davmail.DavGateway;
import davmail.Settings;
import davmail.ui.AboutFrame;
import davmail.ui.SettingsFrame;
import davmail.ui.tray.DavGatewayTray;
import davmail.ui.tray.DavGatewayTrayInterface;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Level;

public class FrameGatewayTray
implements DavGatewayTrayInterface {
    static JFrame mainFrame;
    static AboutFrame aboutFrame;
    static SettingsFrame settingsFrame;
    private static JEditorPane errorArea;
    private static JLabel errorLabel;
    private static JEditorPane messageArea;
    private static ArrayList<Image> frameIcons;
    private static Image image;
    private static Image activeImage;
    private static Image inactiveImage;
    private boolean isActive = true;

    protected FrameGatewayTray() {
    }

    @Override
    public List<Image> getFrameIcons() {
        return frameIcons;
    }

    @Override
    public void switchIcon() {
        this.isActive = true;
        SwingUtilities.invokeLater(() -> {
            Image currentImage = mainFrame.getIconImage();
            if (currentImage != null && currentImage.equals(image)) {
                mainFrame.setIconImage(activeImage);
            } else {
                mainFrame.setIconImage(image);
            }
        });
    }

    @Override
    public void resetIcon() {
        SwingUtilities.invokeLater(() -> mainFrame.setIconImage(image));
    }

    @Override
    public void inactiveIcon() {
        this.isActive = false;
        SwingUtilities.invokeLater(() -> mainFrame.setIconImage(inactiveImage));
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void displayMessage(String message, Level level) {
        SwingUtilities.invokeLater(() -> {
            if (errorArea != null && messageArea != null) {
                if (level.equals((Object)Level.INFO)) {
                    errorLabel.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
                    errorArea.setText(message);
                } else if (level.equals((Object)Level.WARN)) {
                    errorLabel.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
                    errorArea.setText(message);
                } else if (level.equals((Object)Level.ERROR)) {
                    errorLabel.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
                    errorArea.setText(message);
                }
                messageArea.setText(message);
            }
        });
    }

    public void about() {
        SwingUtilities.invokeLater(() -> {
            aboutFrame.update();
            aboutFrame.setVisible(true);
            aboutFrame.toFront();
            aboutFrame.requestFocus();
        });
    }

    public void preferences() {
        SwingUtilities.invokeLater(() -> {
            settingsFrame.reload();
            settingsFrame.setVisible(true);
            settingsFrame.toFront();
            settingsFrame.repaint();
            settingsFrame.requestFocus();
        });
    }

    @Override
    public void init() {
        SwingUtilities.invokeLater(this::createAndShowGUI);
    }

    @Override
    public void dispose() {
        settingsFrame.dispose();
        aboutFrame.dispose();
    }

    protected void buildMenu() {
        JMenu menu = new JMenu(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]));
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(menu);
        mainFrame.setJMenuBar(menuBar);
        ActionListener aboutListener = e -> this.about();
        JMenuItem aboutItem = new JMenuItem(BundleMessage.format("UI_ABOUT", new Object[0]));
        aboutItem.addActionListener(aboutListener);
        menu.add(aboutItem);
        ActionListener settingsListener = e -> this.preferences();
        JMenuItem defaultItem = new JMenuItem(BundleMessage.format("UI_SETTINGS", new Object[0]));
        defaultItem.addActionListener(settingsListener);
        menu.add(defaultItem);
        JMenuItem logItem = new JMenuItem(BundleMessage.format("UI_SHOW_LOGS", new Object[0]));
        logItem.addActionListener(e -> DavGatewayTray.showLogs());
        menu.add(logItem);
        ActionListener exitListener = e -> {
            try {
                DavGateway.stop();
            }
            catch (Exception exc) {
                DavGatewayTray.error(exc);
            }
            System.exit(0);
        };
        JMenuItem exitItem = new JMenuItem(BundleMessage.format("UI_EXIT", new Object[0]));
        exitItem.addActionListener(exitListener);
        menu.add(exitItem);
    }

    protected void createAndShowGUI() {
        if (Settings.isLinux() && System.getProperty("swing.defaultlaf") == null) {
            System.setProperty("swing.defaultlaf", UIManager.getCrossPlatformLookAndFeelClassName());
        } else {
            System.setProperty("swing.defaultlaf", UIManager.getSystemLookAndFeelClassName());
        }
        String imageName = "tray.png";
        String activeImageName = "tray2.png";
        String inactiveImageName = "trayinactive.png";
        if (Settings.isLinux()) {
            imageName = "tray128.png";
            activeImageName = "tray128active.png";
            inactiveImageName = "tray128inactive.png";
        }
        image = DavGatewayTray.loadImage(imageName);
        activeImage = DavGatewayTray.loadImage(activeImageName);
        inactiveImage = DavGatewayTray.loadImage(inactiveImageName);
        frameIcons = new ArrayList();
        frameIcons.add(image);
        frameIcons.add(DavGatewayTray.loadImage("tray128.png"));
        mainFrame = new JFrame();
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setTitle(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]));
        mainFrame.setIconImages(frameIcons);
        JPanel errorPanel = new JPanel();
        errorPanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_LAST_MESSAGE", new Object[0])));
        errorPanel.setLayout(new BoxLayout(errorPanel, 0));
        errorArea = new JTextPane();
        errorArea.setEditable(false);
        errorArea.setBackground(mainFrame.getBackground());
        errorLabel = new JLabel();
        errorPanel.add(errorLabel);
        errorPanel.add(errorArea);
        JPanel messagePanel = new JPanel();
        messagePanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_LAST_LOG", new Object[0])));
        messagePanel.setLayout(new BoxLayout(messagePanel, 0));
        messageArea = new JTextPane();
        messageArea.setText(BundleMessage.format("LOG_STARTING_DAVMAIL", new Object[0]));
        messageArea.setEditable(false);
        messageArea.setBackground(mainFrame.getBackground());
        messagePanel.add(messageArea);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(errorPanel);
        mainPanel.add(messagePanel);
        mainFrame.add(mainPanel);
        aboutFrame = new AboutFrame();
        settingsFrame = new SettingsFrame();
        this.buildMenu();
        mainFrame.setMinimumSize(new Dimension(400, 250));
        mainFrame.pack();
        if (FrameGatewayTray.mainFrame.getSize().width < 400 || FrameGatewayTray.mainFrame.getSize().height < 180) {
            mainFrame.setSize(Math.max(FrameGatewayTray.mainFrame.getSize().width, 400), Math.max(FrameGatewayTray.mainFrame.getSize().height, 180));
        }
        mainFrame.setLocation(FrameGatewayTray.mainFrame.getToolkit().getScreenSize().width / 2 - FrameGatewayTray.mainFrame.getSize().width / 2, FrameGatewayTray.mainFrame.getToolkit().getScreenSize().height / 2 - FrameGatewayTray.mainFrame.getSize().height / 2);
        mainFrame.setVisible(true);
        if (Settings.isFirstStart()) {
            settingsFrame.setVisible(true);
            settingsFrame.toFront();
            settingsFrame.repaint();
            settingsFrame.requestFocus();
        }
    }
}

