/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import java.io.IOException;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthChallengeParser;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.util.EncodingUtil;

public class NTLMv2Scheme
implements AuthScheme {
    private static final int UNINITIATED = 0;
    private static final int INITIATED = 1;
    private static final int TYPE1_MSG_GENERATED = 2;
    private static final int TYPE2_MSG_RECEIVED = 3;
    private static final int TYPE3_MSG_GENERATED = 4;
    private static final int FAILED = Integer.MAX_VALUE;
    private Type2Message type2Message;
    private int state;

    public void processChallenge(String challenge) throws MalformedChallengeException {
        String authScheme = AuthChallengeParser.extractScheme((String)challenge);
        if (!authScheme.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid NTLM challenge: " + challenge);
        }
        int spaceIndex = challenge.indexOf(32);
        if (spaceIndex != -1) {
            try {
                this.type2Message = new Type2Message(Base64.decodeBase64(EncodingUtil.getBytes((String)challenge.substring(spaceIndex).trim(), (String)"ASCII")));
            }
            catch (IOException e) {
                throw new MalformedChallengeException("Invalid NTLM challenge: " + challenge, (Throwable)e);
            }
            this.state = 3;
        } else {
            this.type2Message = null;
            this.state = this.state == 0 ? 1 : Integer.MAX_VALUE;
        }
    }

    public String getSchemeName() {
        return "ntlm";
    }

    public String getParameter(String s) {
        return null;
    }

    public String getRealm() {
        return null;
    }

    @Deprecated
    public String getID() {
        throw new UnsupportedOperationException();
    }

    public boolean isConnectionBased() {
        return true;
    }

    public boolean isComplete() {
        return this.state == 4 || this.state == Integer.MAX_VALUE;
    }

    @Deprecated
    public String authenticate(Credentials credentials, String method, String uri) {
        throw new UnsupportedOperationException();
    }

    public String authenticate(Credentials credentials, HttpMethod httpMethod) throws AuthenticationException {
        String response;
        NTCredentials ntcredentials;
        if (this.state == 0) {
            throw new IllegalStateException("NTLM authentication process has not been initiated");
        }
        try {
            ntcredentials = (NTCredentials)credentials;
        }
        catch (ClassCastException e) {
            throw new InvalidCredentialsException("Credentials cannot be used for NTLM authentication: " + credentials.getClass().getName());
        }
        if (this.state == 1 || this.state == Integer.MAX_VALUE) {
            int flags = -1610042873;
            Type1Message type1Message = new Type1Message(flags, ntcredentials.getDomain(), ntcredentials.getHost());
            response = EncodingUtil.getAsciiString((byte[])Base64.encodeBase64(type1Message.toByteArray()));
            this.state = 2;
        } else {
            int flags = 557569;
            Type3Message type3Message = new Type3Message(this.type2Message, ntcredentials.getPassword(), ntcredentials.getDomain(), ntcredentials.getUserName(), ntcredentials.getHost(), flags);
            response = EncodingUtil.getAsciiString((byte[])Base64.encodeBase64(type3Message.toByteArray()));
            this.state = 4;
        }
        return "NTLM " + response;
    }
}

