/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.httpclient.cookie.RFC2109Spec;

public class DavMailCookieSpec
extends RFC2109Spec {
    public void validate(String host, int port, String path, boolean secure, Cookie cookie) throws MalformedCookieException {
        String cookieName = cookie.getName();
        if (cookieName != null && cookieName.indexOf(32) >= 0) {
            cookie.setName(cookieName.replaceAll(" ", ""));
        } else {
            cookieName = null;
        }
        String cookiePath = cookie.getPath();
        if (cookiePath != null && !path.startsWith(cookiePath)) {
            cookie.setPath(path);
        } else {
            cookiePath = null;
        }
        int dotIndex = -1;
        if (host.endsWith(cookie.getDomain())) {
            String hostWithoutDomain = host.substring(0, host.length() - cookie.getDomain().length());
            dotIndex = hostWithoutDomain.indexOf(46);
        }
        if (".login.microsoftonline.com".equals(cookie.getDomain())) {
            cookie.setDomain(host);
        }
        if (dotIndex != -1) {
            super.validate(host.substring(dotIndex + 1), port, path, secure, cookie);
        } else {
            super.validate(host, port, path, secure, cookie);
        }
        if (cookieName != null) {
            cookie.setName(cookieName);
        }
        if (cookiePath != null) {
            cookie.setPath(cookiePath);
        }
    }
}

