/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.auth;

import davmail.Settings;
import davmail.http.HttpClientAdapter;
import davmail.http.request.RestRequest;
import davmail.util.IOUtil;
import davmail.util.StringEncryptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class O365Token {
    protected final String RESOURCE_URL = "https://outlook.office365.com/";
    protected static final Logger LOGGER = Logger.getLogger(O365Token.class);
    private String clientId;
    private String tokenUrl;
    private String redirectUri;
    private String username;
    private String refreshToken;
    private String accessToken;
    private long expiresOn;

    public O365Token(String tenantId, String clientId, String redirectUri) {
        this.clientId = clientId;
        this.redirectUri = redirectUri;
        this.tokenUrl = "https://login.microsoftonline.com/" + tenantId + "/oauth2/token";
    }

    public O365Token(String tenantId, String clientId, String redirectUri, String code) throws IOException {
        this.clientId = clientId;
        this.redirectUri = redirectUri;
        this.tokenUrl = "https://login.microsoftonline.com/" + tenantId + "/oauth2/token";
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("grant_type", "authorization_code"));
        parameters.add(new BasicNameValuePair("code", code));
        parameters.add(new BasicNameValuePair("redirect_uri", redirectUri));
        parameters.add(new BasicNameValuePair("client_id", clientId));
        RestRequest tokenRequest = new RestRequest(this.tokenUrl, (HttpEntity)new UrlEncodedFormEntity(parameters, Consts.UTF_8));
        this.executeRequest(tokenRequest);
    }

    public String getUsername() {
        return this.username;
    }

    public void setJsonToken(JSONObject jsonToken) throws IOException {
        try {
            JSONObject tokenBody;
            if (jsonToken.opt("error") != null) {
                throw new IOException(jsonToken.optString("error") + " " + jsonToken.optString("error_description"));
            }
            this.accessToken = jsonToken.getString("access_token");
            this.refreshToken = jsonToken.getString("refresh_token");
            this.expiresOn = jsonToken.getLong("expires_on") * 1000L;
            LOGGER.debug((Object)("Access token expires " + new Date(this.expiresOn)));
            String idToken = jsonToken.optString("id_token");
            if (idToken != null && idToken.contains(".")) {
                String decodedJwt = IOUtil.decodeBase64AsString(idToken.substring(idToken.indexOf("."), idToken.lastIndexOf(".")));
                try {
                    tokenBody = new JSONObject(decodedJwt);
                    LOGGER.debug((Object)("Token: " + tokenBody));
                    this.username = tokenBody.getString("unique_name");
                }
                catch (JSONException e) {
                    LOGGER.warn((Object)("Invalid id_token " + e.getMessage()), (Throwable)e);
                }
            }
            if (this.username == null) {
                String decodedBearer = IOUtil.decodeBase64AsString(this.accessToken.substring(this.accessToken.indexOf(46) + 1, this.accessToken.lastIndexOf(46)) + "==");
                tokenBody = new JSONObject(decodedBearer);
                LOGGER.debug((Object)("Token: " + tokenBody));
                this.username = tokenBody.getString("unique_name");
            }
        }
        catch (JSONException e) {
            throw new IOException("Exception parsing token", e);
        }
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getAccessToken() throws IOException {
        if (System.currentTimeMillis() > this.expiresOn - 60000L) {
            LOGGER.debug((Object)"Access token expires soon, trying to refresh it");
            this.refreshToken();
        }
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        this.expiresOn = System.currentTimeMillis() + 3600000L;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void refreshToken() throws IOException {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("grant_type", "refresh_token"));
        parameters.add(new BasicNameValuePair("refresh_token", this.refreshToken));
        parameters.add(new BasicNameValuePair("redirect_uri", this.redirectUri));
        parameters.add(new BasicNameValuePair("client_id", this.clientId));
        parameters.add(new BasicNameValuePair("resource", "https://outlook.office365.com/"));
        RestRequest tokenRequest = new RestRequest(this.tokenUrl, (HttpEntity)new UrlEncodedFormEntity(parameters, Consts.UTF_8));
        this.executeRequest(tokenRequest);
    }

    private void executeRequest(RestRequest tokenMethod) throws IOException {
        try (HttpClientAdapter httpClientAdapter = new HttpClientAdapter("https://outlook.office365.com/");
             CloseableHttpResponse response = httpClientAdapter.execute((HttpRequestBase)tokenMethod);){
            this.setJsonToken(tokenMethod.handleResponse((HttpResponse)response));
        }
    }

    static O365Token build(String tenantId, String clientId, String redirectUri, String code, String password) throws IOException {
        O365Token token = new O365Token(tenantId, clientId, redirectUri, code);
        if (Settings.getBooleanProperty("davmail.oauth.persistToken", true)) {
            try {
                Settings.storeRefreshToken(O365Token.encryptToken(token.getRefreshToken(), password), token.getUsername());
            }
            catch (IOException e) {
                LOGGER.warn((Object)("Unable to store refreshToken: " + e.getMessage()));
            }
        }
        return token;
    }

    static O365Token load(String tenantId, String clientId, String redirectUri, String username, String password) {
        String encryptedRefreshToken;
        O365Token token = null;
        if (Settings.getBooleanProperty("davmail.oauth.persistToken", true) && (encryptedRefreshToken = Settings.loadRefreshToken(username)) != null) {
            try {
                String refreshToken = O365Token.decryptToken(encryptedRefreshToken, password);
                LOGGER.debug((Object)("Loaded stored token for " + username));
                O365Token localToken = new O365Token(tenantId, clientId, redirectUri);
                localToken.setRefreshToken(refreshToken);
                localToken.refreshToken();
                LOGGER.debug((Object)("Authenticated user " + localToken.getUsername() + " from stored token"));
                token = localToken;
            }
            catch (IOException e) {
                LOGGER.warn((Object)("refresh token failed " + e.getMessage()));
            }
        }
        return token;
    }

    private static String decryptToken(String encryptedRefreshToken, String password) throws IOException {
        return new StringEncryptor(password).decryptString(encryptedRefreshToken);
    }

    private static String encryptToken(String refreshToken, String password) throws IOException {
        return new StringEncryptor(password).encryptString(refreshToken);
    }
}

