# -*- coding: ascii -*-

###########################################################################
# clive, video extraction utility
# Copyright (C) 2007-2008 Toni Gundogdu
#
# This file is part of clive.
#
# clive is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# clive is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with clive.  If not, see <http://www.gnu.org/licenses/>.
###########################################################################

## Error classes

__all__ = ['CliveError']

## The main error class used within the program
class CliveError(Exception):
    ## Constructor
    def __init__(self, errmsg=''):
        self._errmsg = errmsg
    ## Computes the "informal" string representation of the object
    def __str__(self):
        return self._errmsg

## The "No media" exception class used by ytube hq fallback
class CliveNoMediaError(Exception):
    ## Computes the "informal" string representation of the object
    def __str__(self):
        return 'error: no media (http/415)'

