/*
 * This file is part of libbluray
 * Copyright (C) 2010  William Hahne
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 */

package impl.org.dvb.lang;

import java.net.URL;

import jail.org.dvb.lang.DVBClassLoader;

public class DVBClassLoaderImpl extends DVBClassLoader {
    public DVBClassLoaderImpl(URL[] urls) {
        super(urls);
    }

    public DVBClassLoaderImpl(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            String cname = name.replace('/', '.');
            if (cname.startsWith("[")) {
                int b = cname.lastIndexOf('[') + 2;
                if ((b > 1) && (b < cname.length())) {
                    cname = cname.substring(b);
                }
            }
            int i = cname.lastIndexOf('.');
            if (i != -1)
                sm.checkPackageAccess(name.substring(0, i));
        }
        return super.loadClass(name, resolve);
    }
}
