/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2019 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package blues;

import java.security.ProtectionDomain;

public class ClientClassLoader extends AccessibleClassLoader {

    protected Class findClass(String name) throws ClassNotFoundException {
        Blob data = Server.requestFindClass(name);
        if (data == null)
            throw new ClassNotFoundException(name);
        if (data.data == null)
            throw new ClassNotFoundException(name);

        byte[] classData = data.data;

        if (data.args[0] != 0) {
            classData = Server.deflate(data.data, data.args[0], data.args[1]);
            if (classData == null)
                throw new ClassNotFoundException(name);
        }

        ProtectionDomain pd = null;

        if (data.getString(0) != null) {
            classData = transform(data.getString(0), classData);
            if (classData == null)
                throw new ClassNotFoundException(name);
        } else {
            pd = getDomain();
        }

        Class r = defineClass(name, classData, 0, classData.length,pd);
        Log.log(Log.LOG_CLASSLOAD, "ClientClassLoader.defineClass(",name,")=",r==null?"<null>":r.toString());
        return r;
    }

    private byte[] transform(String name, byte[] data) {
        ClassCodeTransformer transform = blues.Jail.getTransformer(name);
        if (transform == null) {
            return null;
        }
        return transform.transform(data);
    }

    private static ProtectionDomain getDomain() {
        Class c = ClientClassLoader.class;
        return c.getProtectionDomain();
    }
}
