/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2019 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package blues;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

public class ClassInfo implements Externalizable {

    public static final int PUBLIC = 0x0001;
    public static final int PROTECTED = 0x0004;
    public static final int STATIC = 0x0008;
    public static final int FINAL = 0x0010;
    public static final int TRAP = 0x100;
    public static final int TRAP_READ = TRAP;
    public static final int TRAP_WRITE = 0x200;
    public static final int TRAP_INIT = 0x100;
    public static final int TRAP_SPECIAL = 0x200;
    // public static final int DENY = 0x400;

    public String name;
    public String superName;
    public String comment;
    public int flags;
    public HashMap<String, Integer> items;
    transient ClassInfo superInfo = null;

    public ClassInfo() {
        items = new HashMap<String, Integer>();
    }

    public ClassInfo(String aname, int itemsCount) {
        name = aname;
        if (itemsCount != 0) {
            items = new HashMap<String, Integer>((itemsCount * 120) / 100, 1);
        }
    }

    public int find(String name) {
        if (null == items)
            return 0;
        Integer value = items.get(name);
        return (value == null) ? 0 : value.intValue();
    }

    public static int find(ClassInfo classInfo, String name) {
        if (null == classInfo)
            return 0;
        return classInfo.find(name);
    }

    public void add(String name, int value) {
        Integer vp = items.get(name);
        items.put(name, new Integer(value | vp.intValue()));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        short itemsCount = (items == null) ? 0 : (short) items.size();
        out.writeUTF(name);
        if (!name.equals("java/lang/Object")) {
        	out.writeUTF(superName);
        }
        out.writeInt(flags);
        out.writeShort(itemsCount);
        if (0 != itemsCount) {
            Iterator<Entry<String, Integer>> it = items.entrySet().iterator();
            while (it.hasNext()) {
                Entry<String, Integer> entry = it.next();
                out.writeUTF(entry.getKey());
                out.writeInt(entry.getValue());
            }
        }
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        name = in.readUTF();
        if (!name.equals("java/lang/Object")) {
            superName = in.readUTF();
        }
        comment = null;
        flags = in.readInt();
        int itemsCount = in.readUnsignedShort();
        String name;
        int i, value;
        if (itemsCount != 0) {
            items = new HashMap<String, Integer>((itemsCount * 120) / 100, 1);
            for (i = 0; i < itemsCount; i++) {
                name = in.readUTF();
                value = in.readInt();
                items.put(name, value);
            }
        }
    }
}
