/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.crypto;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import net.sf.portecle.FPortecle;
import net.sf.portecle.NetUtil;
import net.sf.portecle.crypto.CryptoException;
import net.sf.portecle.crypto.NameUtil;
import net.sf.portecle.crypto.SignatureType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public final class X509CertUtil {
    private static final String PKCS7_ENCODING = "PKCS7";
    private static final String PKIPATH_ENCODING = "PkiPath";
    private static final String OPENSSL_PEM_ENCODING = "OpenSSL_PEM";
    static final String X509_CERT_TYPE = "X.509";

    private X509CertUtil() {
    }

    public static X509Certificate[] loadCertificates(URL uRL, Collection<Exception> collection) throws IOException {
        URL uRL2 = NetUtil.download(uRL);
        X509Certificate[] x509CertificateArray = null;
        for (String string : new String[]{PKCS7_ENCODING, PKIPATH_ENCODING, null, OPENSSL_PEM_ENCODING}) {
            try {
                x509CertificateArray = X509CertUtil.loadCertificates(uRL2, string);
                break;
            }
            catch (Exception exception) {
                collection.add(exception);
            }
        }
        return x509CertificateArray;
    }

    private static X509Certificate[] loadCertificates(URL uRL, String string) throws CryptoException {
        Collection<? extends Certificate> collection;
        block29: {
            try (InputStream inputStream = NetUtil.openGetStream(uRL);){
                Object object;
                if (OPENSSL_PEM_ENCODING.equals(string)) {
                    object = new PEMParser(new InputStreamReader(inputStream));
                    Throwable throwable = null;
                    try {
                        collection = new ArrayList<Certificate>();
                        CertificateFactory certificateFactory = CertificateFactory.getInstance(X509_CERT_TYPE);
                        while (true) {
                            Object object2;
                            if ((object2 = ((PEMParser)object).readObject()) == null) {
                                break block29;
                            }
                            if (!(object2 instanceof X509CertificateHolder)) continue;
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((X509CertificateHolder)object2).getEncoded());
                            collection.add(certificateFactory.generateCertificate(byteArrayInputStream));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    ((BufferedReader)object).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((BufferedReader)object).close();
                            }
                        }
                    }
                }
                object = CertificateFactory.getInstance(X509_CERT_TYPE);
                collection = string != null ? ((CertificateFactory)object).generateCertPath(inputStream, string).getCertificates() : ((CertificateFactory)object).generateCertificates(inputStream);
            }
            catch (Exception exception) {
                throw new CryptoException(FPortecle.RB.getString("NoLoadCertificate.exception.message"), exception);
            }
        }
        return collection.toArray(new X509Certificate[collection.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509CRL loadCRL(URL uRL) throws CryptoException, IOException {
        try (InputStream inputStream = NetUtil.openGetStream(uRL);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance(X509_CERT_TYPE);
            X509CRL x509CRL = (X509CRL)certificateFactory.generateCRL(inputStream);
            return x509CRL;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(FPortecle.RB.getString("NoLoadCrl.exception.message"), generalSecurityException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PKCS10CertificationRequest loadCSR(URL uRL) throws CryptoException, IOException {
        try (PEMParser pEMParser = new PEMParser(new InputStreamReader(NetUtil.openGetStream(uRL)));){
            PKCS10CertificationRequest pKCS10CertificationRequest = (PKCS10CertificationRequest)pEMParser.readObject();
            ContentVerifierProvider contentVerifierProvider = new JcaContentVerifierProviderBuilder().build(pKCS10CertificationRequest.getSubjectPublicKeyInfo());
            if (!pKCS10CertificationRequest.isSignatureValid(contentVerifierProvider)) {
                throw new CryptoException(FPortecle.RB.getString("NoVerifyCsr.exception.message"));
            }
            PKCS10CertificationRequest pKCS10CertificationRequest2 = pKCS10CertificationRequest;
            return pKCS10CertificationRequest2;
        }
        catch (ClassCastException | OperatorCreationException | PKCSException exception) {
            throw new CryptoException(FPortecle.RB.getString("NoLoadCsr.exception.message"), exception);
        }
    }

    public static X509Certificate[] convertCertificates(Certificate[] certificateArray) throws CryptoException {
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            x509CertificateArray[i] = X509CertUtil.convertCertificate(certificateArray[i]);
        }
        return x509CertificateArray;
    }

    public static X509Certificate convertCertificate(Certificate certificate) throws CryptoException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(X509_CERT_TYPE);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certificate.getEncoded());
            return (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (CertificateException certificateException) {
            throw new CryptoException(FPortecle.RB.getString("NoConvertCertificate.exception.message"), certificateException);
        }
    }

    public static X509Certificate[] orderX509CertChain(X509Certificate[] x509CertificateArray) {
        int n;
        int n2 = 0;
        X509Certificate[] x509CertificateArray2 = (X509Certificate[])x509CertificateArray.clone();
        X509Certificate[] x509CertificateArray3 = new X509Certificate[x509CertificateArray.length];
        X509Certificate x509Certificate = null;
        for (X509Certificate x509Certificate2 : x509CertificateArray2) {
            if (!x509Certificate2.getIssuerDN().equals(x509Certificate2.getSubjectDN())) continue;
            x509CertificateArray3[n2] = x509Certificate = x509Certificate2;
            ++n2;
        }
        if (x509Certificate == null) {
            return x509CertificateArray;
        }
        block1: do {
            n = 0;
            for (X509Certificate x509Certificate3 : x509CertificateArray2) {
                if (!x509Certificate3.getIssuerDN().equals(x509Certificate.getSubjectDN()) || x509Certificate3 == x509Certificate) continue;
                x509CertificateArray3[n2] = x509Certificate = x509Certificate3;
                ++n2;
                n = 1;
                continue block1;
            }
        } while (n != 0);
        x509CertificateArray2 = new X509Certificate[n2];
        System.arraycopy(x509CertificateArray3, 0, x509CertificateArray2, 0, n2);
        x509CertificateArray3 = new X509Certificate[n2];
        for (n = 0; n < n2; ++n) {
            x509CertificateArray3[n] = x509CertificateArray2[x509CertificateArray2.length - 1 - n];
        }
        return x509CertificateArray3;
    }

    public static byte[] getCertEncodedDer(X509Certificate x509Certificate) throws CryptoException {
        try {
            return x509Certificate.getEncoded();
        }
        catch (CertificateException certificateException) {
            throw new CryptoException(FPortecle.RB.getString("NoDerEncode.exception.message"), certificateException);
        }
    }

    public static byte[] getCertEncodedPkcs7(X509Certificate x509Certificate) throws CryptoException {
        return X509CertUtil.getCertsEncodedPkcs7(new X509Certificate[]{x509Certificate});
    }

    public static byte[] getCertsEncodedPkcs7(X509Certificate[] x509CertificateArray) throws CryptoException {
        return X509CertUtil.getCertsEncoded(x509CertificateArray, PKCS7_ENCODING, "NoPkcs7Encode.exception.message");
    }

    public static byte[] getCertEncodedPkiPath(X509Certificate x509Certificate) throws CryptoException {
        return X509CertUtil.getCertsEncodedPkiPath(new X509Certificate[]{x509Certificate});
    }

    public static byte[] getCertsEncodedPkiPath(X509Certificate[] x509CertificateArray) throws CryptoException {
        return X509CertUtil.getCertsEncoded(x509CertificateArray, PKIPATH_ENCODING, "NoPkiPathEncode.exception.message");
    }

    private static byte[] getCertsEncoded(X509Certificate[] x509CertificateArray, String string, String string2) throws CryptoException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(X509_CERT_TYPE);
            return certificateFactory.generateCertPath(Arrays.asList(x509CertificateArray)).getEncoded(string);
        }
        catch (CertificateException certificateException) {
            throw new CryptoException(FPortecle.RB.getString(string2), certificateException);
        }
    }

    public static X509Certificate generateCert(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, String string8, PublicKey publicKey, PrivateKey privateKey, SignatureType signatureType) throws CryptoException {
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        if (string7 != null) {
            x500NameBuilder.addRDN(BCStyle.E, string7);
        }
        if (string6 != null) {
            x500NameBuilder.addRDN(BCStyle.C, string6);
        }
        if (string5 != null) {
            x500NameBuilder.addRDN(BCStyle.ST, string5);
        }
        if (string4 != null) {
            x500NameBuilder.addRDN(BCStyle.L, string4);
        }
        if (string3 != null) {
            x500NameBuilder.addRDN(BCStyle.O, string3);
        }
        if (string2 != null) {
            x500NameBuilder.addRDN(BCStyle.OU, string2);
        }
        if (string != null) {
            x500NameBuilder.addRDN(BCStyle.CN, string);
        }
        BigInteger bigInteger = X509CertUtil.generateX509SerialNumber();
        Date date = new Date(System.currentTimeMillis());
        Date date2 = new Date(date.getTime() + (long)n * 24L * 60L * 60L * 1000L);
        JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder(x500NameBuilder.build(), bigInteger, date, date2, x500NameBuilder.build(), publicKey);
        try {
            Object object;
            if (string8 != null) {
                object = new GeneralNames(new GeneralName[]{new GeneralName(2, string8)});
                jcaX509v3CertificateBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)object);
            }
            object = new JcaContentSignerBuilder(signatureType.name()).build(privateKey);
            X509CertificateHolder x509CertificateHolder = jcaX509v3CertificateBuilder.build((ContentSigner)object);
            return new JcaX509CertificateConverter().getCertificate(x509CertificateHolder);
        }
        catch (IOException | CertificateException | OperatorCreationException exception) {
            throw new CryptoException(FPortecle.RB.getString("CertificateGenFailed.exception.message"), exception);
        }
    }

    public static X509Certificate renewCert(X509Certificate x509Certificate, int n, PublicKey publicKey, PrivateKey privateKey) throws CryptoException {
        BigInteger bigInteger = X509CertUtil.generateX509SerialNumber();
        Date date = new Date();
        Date date2 = x509Certificate.getNotAfter();
        if (date2 == null || date2.before(date)) {
            date2 = date;
        }
        Date date3 = new Date(date2.getTime() + (long)n * 24L * 60L * 60L * 1000L);
        JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder(x509Certificate.getIssuerX500Principal(), bigInteger, date, date3, x509Certificate.getSubjectX500Principal(), publicKey);
        try {
            Set<String> set = x509Certificate.getCriticalExtensionOIDs();
            if (set != null) {
                for (String object2 : set) {
                    jcaX509v3CertificateBuilder.copyAndAddExtension(new ASN1ObjectIdentifier(object2), true, x509Certificate);
                }
            }
            if ((set = x509Certificate.getNonCriticalExtensionOIDs()) != null) {
                for (String string : set) {
                    jcaX509v3CertificateBuilder.copyAndAddExtension(new ASN1ObjectIdentifier(string), false, x509Certificate);
                }
            }
            ContentSigner contentSigner = new JcaContentSignerBuilder(x509Certificate.getSigAlgName()).build(privateKey);
            X509CertificateHolder x509CertificateHolder = jcaX509v3CertificateBuilder.build(contentSigner);
            return new JcaX509CertificateConverter().getCertificate(x509CertificateHolder);
        }
        catch (CertificateException | OperatorCreationException exception) {
            throw new CryptoException(FPortecle.RB.getString("CertificateGenFailed.exception.message"), exception);
        }
    }

    private static BigInteger generateX509SerialNumber() {
        return new BigInteger(Long.toString(System.currentTimeMillis() / 1000L));
    }

    public static PKCS10CertificationRequest generatePKCS10CSR(X509Certificate x509Certificate, PrivateKey privateKey) throws CryptoException {
        X500Name x500Name = new X500Name(x509Certificate.getSubjectDN().toString());
        JcaPKCS10CertificationRequestBuilder jcaPKCS10CertificationRequestBuilder = new JcaPKCS10CertificationRequestBuilder(x500Name, x509Certificate.getPublicKey());
        JcaContentSignerBuilder jcaContentSignerBuilder = new JcaContentSignerBuilder(x509Certificate.getSigAlgName());
        try {
            ContentVerifierProvider contentVerifierProvider = new JcaContentVerifierProviderBuilder().build(x509Certificate);
            PKCS10CertificationRequest pKCS10CertificationRequest = jcaPKCS10CertificationRequestBuilder.build(jcaContentSignerBuilder.build(privateKey));
            if (!pKCS10CertificationRequest.isSignatureValid(contentVerifierProvider)) {
                throw new CryptoException(FPortecle.RB.getString("NoVerifyGenCsr.exception.message"));
            }
            return pKCS10CertificationRequest;
        }
        catch (OperatorCreationException | PKCSException exception) {
            throw new CryptoException(FPortecle.RB.getString("NoGenerateCsr.exception.message"), exception);
        }
    }

    private static boolean verifyCertificate(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws CryptoException {
        try {
            x509Certificate.verify(x509Certificate2.getPublicKey());
        }
        catch (InvalidKeyException | SignatureException generalSecurityException) {
            return false;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(FPortecle.RB.getString("NoVerifyCertificate.exception.message"), generalSecurityException);
        }
        return true;
    }

    public static X509Certificate[] establishTrust(KeyStore[] keyStoreArray, X509Certificate x509Certificate) throws CryptoException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (KeyStore keyStore : keyStoreArray) {
            arrayList.addAll(X509CertUtil.extractCertificates(keyStore));
        }
        return X509CertUtil.establishTrust(arrayList, x509Certificate);
    }

    private static X509Certificate[] establishTrust(List<X509Certificate> list, X509Certificate x509Certificate) throws CryptoException {
        for (X509Certificate x509Certificate2 : list) {
            if (!x509Certificate.getIssuerDN().equals(x509Certificate2.getSubjectDN()) || !X509CertUtil.verifyCertificate(x509Certificate, x509Certificate2)) continue;
            if (x509Certificate2.getSubjectDN().equals(x509Certificate2.getIssuerDN())) {
                return new X509Certificate[]{x509Certificate, x509Certificate2};
            }
            X509Certificate[] x509CertificateArray = X509CertUtil.establishTrust(list, x509Certificate2);
            if (x509CertificateArray == null) continue;
            X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length + 1];
            x509CertificateArray2[0] = x509Certificate;
            System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 1, x509CertificateArray.length);
            return x509CertificateArray2;
        }
        return null;
    }

    private static Collection<X509Certificate> extractCertificates(KeyStore keyStore) throws CryptoException {
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!keyStore.isCertificateEntry(string)) continue;
                arrayList.add(X509CertUtil.convertCertificate(keyStore.getCertificate(string)));
            }
            return arrayList;
        }
        catch (KeyStoreException keyStoreException) {
            throw new CryptoException(FPortecle.RB.getString("NoExtractCertificates.exception.message"), keyStoreException);
        }
    }

    public static String matchCertificate(KeyStore keyStore, X509Certificate x509Certificate) throws CryptoException {
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                X509Certificate x509Certificate2;
                String string = enumeration.nextElement();
                if (!keyStore.isCertificateEntry(string) || !x509Certificate.equals(x509Certificate2 = X509CertUtil.convertCertificate(keyStore.getCertificate(string)))) continue;
                return string;
            }
            return null;
        }
        catch (KeyStoreException keyStoreException) {
            throw new CryptoException(FPortecle.RB.getString("NoMatchCertificate.exception.message"), keyStoreException);
        }
    }

    public static String getCertificateAlias(X509Certificate x509Certificate) {
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
        String string = NameUtil.getCommonName(x500Principal);
        if (string == null) {
            return "";
        }
        String string2 = NameUtil.getCommonName(x500Principal2);
        if (x500Principal.equals(x500Principal2) || string2 == null) {
            return string;
        }
        return MessageFormat.format("{0} ({1})", string, string2);
    }
}

