/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.crypto;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public enum KeyStoreType {
    JKS(null, "JKS", true, true, new String[]{"jks"}),
    PKCS12(null, "PKCS #12", false, false, new String[]{"p12", "pfx"}),
    JCEKS(null, "JCEKS", true, true, new String[]{"jceks"}),
    CaseExactJKS(null, "JKS (case sensitive)", true, true, new String[]{"jks"}),
    BKS(null, "BKS", true, true, new String[]{"bks"}),
    BKS_V1("BKS-V1", "BKS-V1", true, true, new String[]{"bks"}),
    UBER(null, "UBER", true, true, new String[]{"ubr"}),
    BCFKS(null, "BCFKS", true, true, new String[]{"bcfks"}),
    GKR(null, "GKR", true, true, new String[]{"gkr"}),
    PKCS11(null, "PKCS #11", false, true, new String[0]);

    private final String typeName;
    private final String prettyName;
    private final boolean entryCreationDateUseful;
    private final boolean entryPasswordSupported;
    private final Set<String> filenameExtensions;

    private KeyStoreType(String string2, String string3, boolean bl, boolean bl2, String[] stringArray) {
        this.typeName = string2 == null ? this.name() : string2;
        this.prettyName = string3;
        this.entryCreationDateUseful = bl;
        this.entryPasswordSupported = bl2;
        switch (stringArray.length) {
            case 0: {
                this.filenameExtensions = Collections.emptySet();
                break;
            }
            case 1: {
                this.filenameExtensions = Collections.singleton(stringArray[0]);
                break;
            }
            default: {
                LinkedHashSet linkedHashSet = new LinkedHashSet(stringArray.length);
                Collections.addAll(linkedHashSet, stringArray);
                this.filenameExtensions = Collections.unmodifiableSet(linkedHashSet);
            }
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isEntryCreationDateUseful() {
        return this.entryCreationDateUseful;
    }

    public boolean isEntryPasswordSupported() {
        return this.entryPasswordSupported;
    }

    public Set<String> getFilenameExtensions() {
        return this.filenameExtensions;
    }

    public String toString() {
        return this.prettyName;
    }

    public static KeyStoreType valueOfType(String string) {
        return KeyStoreType.valueOf(string.replaceAll("-", "_"));
    }

    public static Set<String> getKeyStoreFilenameExtensions() {
        HashSet<String> hashSet = new HashSet<String>();
        for (KeyStoreType keyStoreType : KeyStoreType.values()) {
            hashSet.addAll(keyStoreType.getFilenameExtensions());
        }
        return hashSet;
    }
}

