/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/

#include "mdictextbrowser.h"
// #include "mdicbutton.h"

// #include <QtGui/QApplication>
// #include <QtGui/QIcon>
// #include <QVBoxLayout>

// #include <QtCore/QDebug>

const QString MDicTextBrowser::baseStyle("QTextBrowser {border: 1px solid rgb(150,150,150);\
border-radius:5px; color:%1; background-color:%2}");

QString MDicTextBrowser::style;

MDicTextBrowser::MDicTextBrowser(QWidget* parent) :
        QTextBrowser(parent)
{
    init();
    setOpenLinks(false);
}

void MDicTextBrowser::setUiStyle()
{
    setStyleSheet(style);
}

QString MDicTextBrowser::getColorString(const QColor& color)
{
    return "rgb(" + QString::number(color.red()) + ',' + QString::number(color.green()) + ',' +
    QString::number(color.blue()) + ')';
}

void MDicTextBrowser::setStyleColors(const QColor& foreground, const QColor& background)
{
    style = baseStyle.arg( getColorString(foreground) ).arg(getColorString(background) );
}

void MDicTextBrowser::setHeight()
{
    document()->setTextWidth(width() + 3);
    int h = document()->size().toSize().height() + 10;
    setMinimumHeight(h);
    setMaximumHeight(h);
}

void MDicTextBrowser::init()
{
    connect(this, SIGNAL(textChanged()), this, SLOT(setHeight()));
    setSizePolicy(QSizePolicy::Preferred,QSizePolicy::Fixed);
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setUiStyle();
}

void MDicTextBrowser::resizeEvent(QResizeEvent* e)
{
    setHeight();
    QTextBrowser::resizeEvent(e);
}

MDicTextBrowser::~MDicTextBrowser()
{
}

#include "mdictextbrowser.moc"
