/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/


#ifndef MDICCOMBOBOX_H
#define MDICCOMBOBOX_H

#define REC_PATH ":/"

#include <QtGui/QComboBox>

class MDicComboBoxPrivate;
class MDicButton;

class MDicComboBox : public QComboBox
{
    Q_OBJECT

public:
    MDicComboBox(QWidget* parent = 0);
    ~MDicComboBox();
    void setClearButtonShown(bool show);
    void updateButtonsGeometry();
    void setCurrentText(const QString&);
    void removeItem(const QString &item);
    void clearButtonClicked();
    void setFocus();

signals:
//     void textChanged();
    void returnPressed();

public slots:
    void selectAll();
    void settingsChanged();

protected slots:

    virtual void mousePressEvent(QMouseEvent* e);
    virtual void mouseReleaseEvent(QMouseEvent* e);
    virtual void resizeEvent(QResizeEvent* e);
    void sltTextChanged(QString Text);

private:
    void addItem( const QString &item );
    void init();

    friend class MDicComboBoxPrivate;
    MDicComboBoxPrivate *const d;

};

#endif // MDICCOMBOBOX_H
