/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/

#ifndef MDICBUTTON_H
#define MDICBUTTON_H

#include <QtGui/QWidget>
#include <QtGui/QPixmap>
#include <QtGui/QPainter>
#include <QtGui/QPaintEvent>



class MDicButton : public QWidget
{
    Q_OBJECT

public:
    MDicButton(QWidget *parent)
            : QWidget(parent) {
    }

    void setPixmap(const QPixmap& p) {
        m_pixmap = p;
    }

    QPixmap pixmap() {
        return m_pixmap;
    }

protected:
    void paintEvent(QPaintEvent *event) {
        Q_UNUSED(event)


        QPainter p(this);
        p.setOpacity(1);
        p.drawPixmap((width() - m_pixmap.width()) / 2,
                     (height() - m_pixmap.height()) / 2,
                     m_pixmap);

    }


private:
    QPixmap m_pixmap;

};

#endif
