/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/


#ifndef DICWIDGET_H
#define DICWIDGET_H

#define REC_PATH ":/"

#include <QtGui/QWidget>
#include <QUrl>

class QScrollArea;
class MDicTextBrowser;
class QVBoxLayout;


class DicWidget : public QWidget
{
    Q_OBJECT

public:
    DicWidget(QWidget* parent = 0);

    ~DicWidget();

    void appendMean(const QString&, const QString&);
    void setupUI();
    void clear();
    void moveScrollUp();

signals:
    void anchorClicked(const QUrl &url);
private:

    QVBoxLayout *mainLayout;
//     QHBoxLayout *titleBarLayout;

private:
    QList<MDicTextBrowser*> meanWidgets;
    QScrollArea *scrollArea;

};

#endif // DICWIDGET_H
