/*
    This file is part of MDic Dictionary

    Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com>
    Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, see http://www.gnu.org/licenses/

*/

#include "gtranslate.h"
#include <QUrl>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QDebug>

GTranslate::GTranslate(QObject* parent)
{

}

GTranslate::~GTranslate()
{

}

DictInfo GTranslate::dictInfo(const DictCore::Dictionary& dict)
{
    DictInfo info;
    info.setAuthor("Google");
    info.setDestinationLanguage(dict.name().split("->").last());
    info.setSourceLanguage(dict.name().split("->").first());
    info.setName(dict.name());
    return info;
}

QList< Translation > GTranslate::translate(const DictCore::Dictionary& dict, const QString& word)
{
    QList<Translation> list;
//     qDebug()<<"GTranslate::translate";
    QStringList langpair = dict.code().split('|');
    if(langpair.length() != 2){
        qCritical()<<"Dict code is not valid!";
        return list;
    }
    QUrl url ( "http://translate.google.com/");
    url.addQueryItem("hl", "en");
    url.addQueryItem("layout", "2");
    url.addQueryItem("eotf", "1");
    url.addQueryItem("sl", langpair[0]);
    url.addQueryItem("tl", langpair[1]);
    url.addQueryItem("q", word);
//     url.addQueryItem("langpair", dict.code());
//     url.addQueryItem("text", word);

//     qDebug()<<url;
    QNetworkRequest req(url);
    QNetworkAccessManager *net = new QNetworkAccessManager();
    QEventLoop loop;
    QNetworkReply *reply = net->get(req);

    connect( reply, SIGNAL( finished() ), &loop, SLOT( quit() ) );

    loop.exec();
    if( reply->error() ){
        qCritical()<<"Error on fetching Google Translator result: "<<reply->errorString();
        return list;
    }
    QString data = QString::fromUtf8( reply->readAll() );


//  kDebug( 14308 ) << "Google response:"<< endl << data;

//  QRegExp re( "<textarea name=q rows=5 cols=45 wrap=PHYSICAL>(.*)</textarea>" );
    QRegExp re( "<textarea name=utrans (.*)</textarea>");

    re.setMinimal( true );
    re.indexIn( data );
    QString firstRes = re.cap(0);
    re.setPattern(">(.*)</");
    re.indexIn(firstRes);
    QString result = re.cap( 1 );
//     qDebug()<<"GTranslate::translate: " << re.capturedTexts();
    if( result.isEmpty() || result == word )
        return list;

    Translation tr(word, dict.name(), result);
    list<<tr;
    return list;
}

#include "gtranslate.moc"
