/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/

#ifndef DBUSADAPTOR_H
#define DBUSADAPTOR_H

#include <QDBusAbstractAdaptor>

class QApplication;
class MainWindow;

/**
 * The DBusAdaptor class represents and QStarDict D-Bus interface.
 */
class DBusAdaptor: public QDBusAbstractAdaptor
{
Q_OBJECT
Q_CLASSINFO("D-Bus Interface", "org.mdic.dbus")
/**
    * The main window visible property.
    */
Q_PROPERTY(int mainWindowVisible READ mainWindowVisible WRITE setMainWindowVisible)

/**
    The selection scanner.
*/
Q_PROPERTY(int selectionScannerEnable READ selectionScannerEnable WRITE setSelectionScannerEnable)

public:
    /**
        * Construct a DBusAdaptor.
        */
    DBusAdaptor(QApplication *application);

    bool isFirstService();
    void setMainWindow( MainWindow *mainWindow );

    /**
        * Return true if main window is visible, otherwise return
        * false.
        */
    bool mainWindowVisible() const;

    /**
        * Set visible state of main window.
        */
    void setMainWindowVisible(bool visible);

    bool selectionScannerEnable() const;

    void setSelectionScannerEnable(bool enable);

public slots:

    void toggleMainWindowVisible();
    void toggleSelectionScannerEnable();

    /**
        * Show desired output with translation of text. e.g. system tray message or libnotify or mainwin
        */
    void showTranslation(const QString &text);

    /**
        * Return a translation of text in plain text format.
        */
    QString translate(const QString &text);

private:
    MainWindow *m_mainWindow;
    bool registrationSuccessed;
};

#endif // DBUSADAPTOR_H

// vim: tabstop=4 softtabstop=4 shiftwidth=4 expandtab cindent textwidth=120 formatoptions=tc

