/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/

#include "speechconfig.h"
#include "ui_speechconfigbase.h"
#include "settings.h"
#include <QDebug>
#include <QProcess>
#include <QMessageBox>

class SpeechConfigWidget::Private
{
public:
    Private()
    {}
    Ui_SpeechConfigBase ui;
};

SpeechConfigWidget::SpeechConfigWidget(QWidget* parent, Qt::WindowFlags f)
        : QWidget(parent, f), d(new Private)
{
    d->ui.setupUi(this);


    connect(d->ui.sldAmplitude, SIGNAL(valueChanged(int)),
            d->ui.lblAmplitude, SLOT(setNum(int)));
    connect(d->ui.sldPitch, SIGNAL(valueChanged(int)),
            d->ui.lblPitch, SLOT(setNum(int)) );
    connect(d->ui.sldSpeed, SIGNAL(valueChanged(int)),
            d->ui.lblSpeed, SLOT(setNum(int)) );
    connect(d->ui.comboLang, SIGNAL(currentIndexChanged(int)), SLOT(slotCurrentLanguageChanged(int)));
    connect(d->ui.comboSystem, SIGNAL(currentIndexChanged(int)), SLOT(slotCurrentSpeechSystemChanged(int)));
    connect(d->ui.btnDefSpeed, SIGNAL(clicked(bool)), this, SLOT(slotSetDefaultSpeed()));
    connect(d->ui.btnDefAmplitude, SIGNAL(clicked(bool)), this, SLOT(slotSetDefaultAmplitude()));
    connect(d->ui.btnDefPitch, SIGNAL(clicked(bool)), this, SLOT(slotSetDefaultPitch()));
    load();
    slotCurrentSpeechSystemChanged(d->ui.comboSystem->currentIndex());
}

SpeechConfigWidget::~SpeechConfigWidget()
{
    delete d;
}

void SpeechConfigWidget::load()
{
    if( !Settings::self()->noEspeak ) {
        QMap<QString, QString>::const_iterator it, endIt = Settings::self()->espeakLangsMap.constEnd();
        for( it = Settings::self()->espeakLangsMap.constBegin(); it != endIt; ++it ){
            d->ui.comboLang->addItem(it.key(), it.value());
        }
    }
    d->ui.comboSystem->setCurrentIndex(Settings::self()->spchSysIdx);
    d->ui.comboVoice->setCurrentIndex((Settings::self()->spchVoice == 'f') ? 1 : 0);
    d->ui.comboLang->setCurrentIndex( d->ui.comboLang->findData(Settings::self()->inLang_espeak) );
    d->ui.sldSpeed->setValue(Settings::self()->spchSpeed);
    d->ui.sldAmplitude->setValue(Settings::self()->spchAmplitude);
    d->ui.sldPitch->setValue(Settings::self()->spchPitch);
    d->ui.txtFestivalSwitches->setText(Settings::self()->festivalSwitches);
}

void SpeechConfigWidget::save()
{
    Settings::self()->spchSysIdx = d->ui.comboSystem->currentIndex();
    Settings::self()->spchVoice = (d->ui.comboVoice->currentIndex() == 1) ? 'f' : 'm';
    Settings::self()->inLang_espeak = d->ui.comboLang->itemData(d->ui.comboLang->currentIndex()).toString();
    Settings::self()->spchSpeed = d->ui.sldSpeed->value();
    Settings::self()->spchAmplitude = d->ui.sldAmplitude->value();
    Settings::self()->spchPitch = d->ui.sldPitch->value();
    Settings::self()->festivalSwitches = d->ui.txtFestivalSwitches->text();
    Settings::self()->setSpeechCmd();
}

void SpeechConfigWidget::slotCurrentLanguageChanged(int index)
{
    if (QVariant(d->ui.comboLang->itemData(index)).toString().contains("en"))
        d->ui.comboVoice->setEnabled(true);
    else
        d->ui.comboVoice->setEnabled(false);
}

void SpeechConfigWidget::slotCurrentSpeechSystemChanged(int newIdx)
{
    if (newIdx == 1) {
        d->ui.groupESpeak->hide();
        d->ui.groupFestival->show();
    } else {
        d->ui.groupFestival->hide();
        d->ui.groupESpeak->show();
    }
    Settings::self()->spchSysIdx = newIdx;
}

void SpeechConfigWidget::slotSetDefaultAmplitude()
{
    d->ui.sldAmplitude->setValue(100);
}

void SpeechConfigWidget::slotSetDefaultPitch()
{
    d->ui.sldPitch->setValue(50);
}

void SpeechConfigWidget::slotSetDefaultSpeed()
{
    d->ui.sldSpeed->setValue(170);
}

#include "speechconfig.moc"
